unit UnitMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdAntiFreezeBase, IdAntiFreeze, IdUDPServer, IdBaseComponent,
  IdComponent, IdUDPBase, IdUDPClient, StdCtrls, Buttons, IdSocketHandle,
  IdStack, ComCtrls, MMSystem, Menus, UnitOptions, ShellApi, ExtCtrls;

const
  MSG_IconCallback = WM_APP + 100;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    AntiFreeze: TIdAntiFreeze;
    UDPServer: TIdUDPServer;
    Timer: TTimer;
    StatusBar: TStatusBar;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    ListBoxUsers: TListBox;
    RichEditIn: TRichEdit;
    RichEditOut: TRichEdit;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PopupMenu2: TPopupMenu;
    Beenden: TMenuItem;
    N1: TMenuItem;
    NachrichtenEmpfangen: TMenuItem;
    N2: TMenuItem;
    Optionen: TMenuItem;
    AnzeigenVerstecken: TMenuItem;
    Panel2: TPanel;
    BitBtnSend: TBitBtn;
    procedure UDPServerUDPRead(Sender: TObject; AData: TStream;
      ABinding: TIdSocketHandle);
    procedure FormCreate(Sender: TObject);
    procedure BitBtnSendClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure BitBtnOptionsClick(Sender: TObject);
    procedure AnzeigenClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure OptionenClick(Sender: TObject);
    procedure NachrichtenEmpfangenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ShowIcon (I: TIcon; Id: Integer; Hint: String);
    procedure HideIcon (Id: Integer);
    procedure FormShow(Sender: TObject);
    procedure BeendenClick(Sender: TObject);
  private
    Port: Integer;
    function Extract(AString, Delimiter: String; Count: Integer): String;
    procedure WMIconCallback(var Msg: TMessage); message MSG_IconCallback;
    procedure WMSysCommand(var Message: TWMSysCommand); message WM_SysCommand;

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.UDPServerUDPRead(Sender: TObject; AData: TStream;
  ABinding: TIdSocketHandle);
var DataStringStream: TStringStream;
    s, status, Msg, User, What: string;
begin
  DataStringStream := TStringStream.Create('');
  try
    DataStringStream.CopyFrom(AData, AData.Size);
    s := DataStringStream.DataString;
    Status := '';

    { Announcements }

    if Pos ('announce#', s) > 0 then begin
      What := Extract (s, '#', 3);
      What := LowerCase (What);
      if What = 'online' then begin
        User := UpperCase (Extract (s, '#', 2));
        if ListBoxUsers.Items.IndexOf (User) = -1 then begin
          ListBoxUsers.Items.Add(User);
          Status := Status + User + ' online';
          UDPServer.Broadcast ('announce#' + UDPServer.LocalName + '#online#' + GStack.LocalAddress, Port);
        end;
      end;
      if What = 'offline' then begin
        User := UpperCase (Extract (s, '#', 2));
        Status := Status + User + ' offline';
        if ListBoxUsers.Items.IndexOf (User) <> -1 then ListBoxUsers.Items.Delete(ListBoxUsers.Items.IndexOf(User));
      end;
    end;

    { Messages }

    if (Pos ('message#', s) > 0) and (Form1.NachrichtenEmpfangen.Checked) then begin
      User := UpperCase(Extract (s, '#', 2));
      Msg := Extract (s, '#', 3);
      Status := Status + ' Nachricht von ' + User;
      RichEditIn.Lines.Add (User + ': ' + Msg);
      RichEditIn.Perform(EM_LineScroll, 0 , RichEditIn.Lines.Count - 1);
      if Form2.CheckBoxAutoShow.Checked then begin
        Show;
        BringToFront;
      end;
      if Form2.CheckBoxPlayWav.Checked and FileExists (Form2.EditWavFile.Text) then
        SndPlaySound(PChar(Form2.EditWavFile.Text), SND_ASYNC);
    end;

    { Timeout }

    if Pos ('reset#', s) > 0 then begin
      User := Extract (s, '#', 2);
      ListBoxUsers.Clear;
      UDPServer.Broadcast ('announce#' + UDPServer.LocalName + '#online#' + GStack.LocalAddress, Port);
      Status := Status + ' Reset von ' + User;
    end;

  finally
    DataStringStream.Free;
  end;

  if (Length (Status) > 0) then StatusBar.Panels[1].Text := Status;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Port := 6666;
  UDPServer.DefaultPort := Port;
  UDPServer.Active := true;
  UDPServer.Broadcast ('announce#' + UDPServer.LocalName + '#online#' + GStack.LocalAddress, Port);
  StatusBar.Panels[0].Text := 'Computername: ' + UpperCase (UDPServer.LocalName) + ' - IP: ' + GStack.LocalAddress + ' - Port: ' + IntToStr(Port);
end;

function TForm1.Extract(AString, Delimiter: String; Count: Integer): String;
var p,i: Integer;
    s: string;
begin
   s := AString;
   i := 1;
   p := Pos (Delimiter, s);
   while (p > 0) and (i <> Count) do begin
     Delete (s, 1, p);
     p := Pos (Delimiter, s);
     inc(i);
   end;
   p := Pos (Delimiter, s);
   Delete (s, p, length(s)-p + 1);
   Result := s;
end;

procedure TForm1.BitBtnSendClick(Sender: TObject);
var i: Integer;
begin
  if Length(RichEditOut.Text) > 0 then begin
    for i := 0 to ListBoxUsers.Count - 1 do begin
      if ListBoxUsers.Selected[i] then begin
        UDPServer.Send (GStack.ResolveHost(LowerCase(ListBoxUsers.Items[i])), Port, 'message#'+ UDPServer.LocalName + '#' + RichEditOut.Text);
        RichEditIn.Lines.Add(UpperCase (UDPServer.LocalName) + ': ' + RichEditOut.Text);
        RichEditOut.Clear;
      end;
    end;
  end;
  RichEditOut.SetFocus;
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
  UDPServer.Broadcast ('reset#' + UDPServer.LocalName, Port);
end;

procedure TForm1.BitBtnOptionsClick(Sender: TObject);
begin
  Form2.ShowModal;
end;

procedure TForm1.WMIconCallback(var Msg: TMessage);
var Point: TPoint;
begin
 case Msg.LParam of
    WM_LBUTTONDBLCLK:
      begin
        NachrichtenEmpfangen.Checked := not NachrichtenEmpfangen.Checked;  
      end;
    WM_LBUTTONUP:
      begin
        Visible := not Visible;
        if Visible then BringToFront;
      end;
    WM_RBUTTONUP:
      begin
        SetForegroundWindow(Handle);
        GetCursorPos(Point);
        PopupMenu2.Popup(Point.x, Point.y);
      end;
 end;
end;

procedure TForm1.ShowIcon(I: TIcon; Id: Integer; Hint: String);
var d: TNotifyIconData;
begin
  d.cbSize := SizeOf(d);
  d.Wnd := Handle;
  d.uID := Id;
  d.uCallbackMessage := MSG_IconCallback;
  d.hIcon := I.Handle;
  strcopy (d.szTip, PChar(Hint));
  d.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
  Shell_NotifyIcon(NIM_ADD, @d);
end;

procedure TForm1.HideIcon (Id: Integer);
var d: TNotifyIconData;
begin
  d.cbSize := SizeOf(d);
  d.Wnd := Handle;
  d.uID := Id;
  Shell_NotifyIcon(NIM_DELETE, @d);
end;

procedure TForm1.WMSysCommand(var Message: TWMSysCommand);
begin
  if Message.CmdType and $FFF0 = SC_MINIMIZE then
    Hide
  else
    inherited;
end;

procedure TForm1.AnzeigenClick(Sender: TObject);
begin
  Visible := not Visible;
  BringToFront;
  SetFocus;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := MessageDlg ('Wirklich beenden?', mtConfirmation, [mbYes, mbNo], 0) = mryes;
end;

procedure TForm1.OptionenClick(Sender: TObject);
begin
  SetWindowPos(Handle, HWND_NOTOPMOST, Left, Top, Width,Height, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
  Form2.ShowModal;
  SetWindowPos(Handle, HWND_TOPMOST, Left,Top, Width,Height, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TForm1.NachrichtenEmpfangenClick(Sender: TObject);
begin
  NachrichtenEmpfangen.Checked := not NachrichtenEmpfangen.Checked;
  Form2.CheckBoxAcceptMessages.Checked := NachrichtenEmpfangen.Checked;
  HideIcon (0);
  if NachrichtenEmpfangen.Checked then
    ShowIcon (Application.Icon, 0, 'Nachrichtenempfang aktiv')
  else
    ShowIcon (Application.Icon, 0, 'Nachrichtenempfang deaktiviert');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  HideIcon (0);
  UDPServer.Broadcast ('announce#' + UDPServer.LocalName + '#offline#'+GStack.LocalAddress, Port);
  UDPServer.Active := false;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  SetWindowPos(Handle, HWND_TOPMOST, Left,Top, Width,Height, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE);
end;

procedure TForm1.BeendenClick(Sender: TObject);
begin
  Application.Terminate;
end;

end.
