package samples;

public class Quicksort {
	static int[] feld;
	static final int maxIndex=100;

	static void feldFuellen() {
		for (int i=0; i<=maxIndex; i++) {
			feld[i] = (int)Math.round(Math.random()*900.0 + 100); 
		}
	} 

	static void feldAusgabe() {
		System.out.println("Das Feld enthaelt die folgenden Elemente: ");
		for (int i=0; i<=maxIndex; i++) {
			System.out.print(feld[i]);
			System.out.print(" ");
		}
		System.out.println();
	}

	static void vertausche (int a, int b) {
		int ablage = feld[a];
		feld[a] = feld[b];
		feld[b] = ablage;
	}

	static void quicksort(int links, int rechts) {
		int nachlinks = rechts; // Laufindex, der vom rechten Ende nach links laeuft
		int nachrechts = links; // Laufindex, der vom linken Ende nach rechts laeuft
		if (nachrechts < nachlinks) { // Pivotelement bestimmen
			int pivot = feld[(nachrechts + nachlinks)/2];

			while (nachrechts <= nachlinks) {    // Links erstes Element suchen, das
				// groesser oder gleich dem Pivotelement ist
				while ((nachrechts < rechts) && (feld[nachrechts] < pivot))
					nachrechts++;

				// Rechts erstes Element suchen, das
				// kleiner oder gleich dem Pivotelement ist
				while ((nachlinks > links) && (feld[nachlinks] > pivot))
					nachlinks--;

				// Wenn nicht aneinander vorbei gelaufen, Inhalte vertauschen
				if (nachrechts <= nachlinks) {
					vertausche(nachrechts, nachlinks);
                    nachrechts++;
                    nachlinks--;
				}
			} 

         // Linken Teil sortieren
         if (nachlinks > links) quicksort (links, nachlinks);

         // Rechten Teil sortieren
         if (nachrechts < rechts) quicksort (nachrechts, rechts);
       }
}

	public static void main(String[] arg) {
		feld = new int[maxIndex+1];
		System.out.println("Quicksort-Demo: ");
		feldFuellen();
		feldAusgabe();
		quicksort(0, maxIndex);
		feldAusgabe();
	}
}
