package samples;

public class BinSuche {
	static int[] feld;
	static final int maxIndex=100;

	static void feldFuellen() {
		for (int i=0; i<=maxIndex; i++)
			feld[i] = (int)Math.round(Math.random()*9000.0 + 1000);
	}

	static void feldAusgabe() {
		System.out.println("Das Feld enthaelt die folgenden Elemente: ");
		for (int i=0; i<=maxIndex; i++) System.out.print(feld[i] + " ");
		System.out.println();
	}

	static void vertausche (int a, int b) {
		int ablage = feld[a];
		feld[a] = feld[b];
		feld[b] = ablage;
	}

	static void minsort() {
		int minpos;
		for (int i=0; i<=maxIndex; i++) {
			minpos = i;
			for (int k=i+1; k<=maxIndex; k++) {
				if (feld[k]<feld[minpos]) { 
					minpos = k; 
				}
			} 
			if (minpos>i) { vertausche(i, minpos); }
		}
	}

	static int binaereSuche(int zahl) {
		int low = 0;
		int mitte;
		int high = maxIndex;
		while (low <= high) {
			mitte = (low + high) / 2;
			if (feld[mitte]==zahl) { 
				return mitte; 
			} else {
				if (feld[mitte] < zahl) {
					low = mitte + 1; 
				} else {
					high = mitte - 1; 
				}
            }
		}
		return -1; // nicht gefunden
	}

	public static void main(String[] arg) {
		feld = new int[maxIndex+1];
		int suchzahl = 1234;
		System.out.println("Binaere Suche: ");
		feldFuellen();
		System.out.println("Erst mal sortieren: ");
		minsort();
		System.out.println("Beginn der Suche:");
		int pos = binaereSuche(suchzahl);
		if (pos>=0) {
			System.out.println("Zahl " + suchzahl + " steht an Stelle " + pos );
         	System.out.println("Zur Kontrolle: feld[" + pos + "] = " + feld[pos]);
        } else System.out.println(suchzahl + " wurde nicht gefunden.");
	} 
}
