header {
package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;
import java.util.*;
}

/** Java 1.5 AST Recognizer Grammar
 *
 * JavaTreeWriter.java - This class implements all the 
 * functionality to write the AST back to valid (and pretty) 
 * java code using the PrintWriter "dest".
 *
 * @author: (see java.g preamble) && Dominik Schindler
 *
 * This grammar is in the PUBLIC DOMAIN
 */
 
class JavaTreeWriter extends TreeParser;

options {
	importVocab = Java;
	k = 1;
}

{	// methods for logging
	private final String logCString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logC";
	private final String logBString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logB";
	private final String logPString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logP";
	private final String enterSwitch = "de.fau.cs.swe.sa.conditionCoverage.Logger._enterSwitch";
	private final String leaveSwitch = "de.fau.cs.swe.sa.conditionCoverage.Logger._leftSwitch";
	private final String startExpression = "de.fau.cs.swe.sa.conditionCoverage.Logger._startExpression";
	private final String endExpression = "de.fau.cs.swe.sa.conditionCoverage.Logger._endExpression";
	private final String handleException = "de.fau.cs.swe.sa.conditionCoverage.Logger._handleException";
	private final String catchException = "de.fau.cs.swe.sa.conditionCoverage.Logger._catchException";
	private final String enterMethod = "de.fau.cs.swe.sa.conditionCoverage.Logger._enterMethod";
	private final String leaveMethod = "de.fau.cs.swe.sa.conditionCoverage.Logger._leftMethod";
	
	//
	private boolean autoFlush = true;
	
	// used for pretty printing
	private int level = 0;
	
	// store the current row for the symbol table
	private int row = 1;
	
	// is logging on or off?
	private boolean isLogging = false;
	
	// dont print an EOS = ";" 	
	boolean noEos = false;
	
	// 
	private String methodID = "0";
	
	//
	private boolean isCtorCall = false;
	
	// for writing the output file
	private PrintWriter dest = new PrintWriter(System.out, true); 
	
	// for writing the symbol table
	private PrintWriter symbolTable = new PrintWriter(System.out, true);
	
	// parentheses arround an elist (= list of expressions)
	private boolean Paren = false;
	//
	private ClassHierarchie ch = null;
	
	// constructors
	public JavaTreeWriter( OutputStream os ) {
		this();		
		dest = new PrintWriter( os, autoFlush );
	}
	//
//	public JavaTreeWriter( OutputStream os ) { // , ClassHierarchie ch, Hashtable variables, Hashtable methods ) {
//		this();		
//		this.ch = ch;
//		this.variableDecls = variables;
//		this.methodDecls = methods;
//		dest = new PrintWriter( os, autoFlush );
//	}
	
	// set the output for the symbol table
	public void setSymbolTable(OutputStream os) {
		symbolTable = new PrintWriter(os, autoFlush);
	}
	
	// === internal helper functions ===
	
	// end of statement
	private void eos() { 
		dest.print(";");
	}
	
	// print newline to dest
	private void newline() {
		dest.println();
		for (int i = 0; i < level; i++) {
			dest.print("\t");
			dest.flush();
		}
		row++;
	}
	
	// print count newlines to dest
	private void newline(int count) {
		for (int i = 0; i < count; i++)
			dest.println();
		for (int i = 0; i < level; i++) {
			dest.print("\t");
			dest.flush();
		}
		row += count;
	}
	// print s to dest
	private void pprint(String s) {
		dest.print(s);
		dest.flush(); // remove later!
	}
	// increase level 
	private void incLevel() {
		level++;
		newline();
	}	
	// decrease level
	private void decLevel() {
		if (level > 0) level--;
		newline();
	}
	
	// writes the symbol table
	private void writeSTable(String id, int row, String type_, String exp, String notes) {
		symbolTable.println(
			id + "\t" + 
			String.valueOf(row) + "\t" +
			type_ + "\t" +		  						  	
			exp + "\t" + 
			notes);
		symbolTable.flush();		
	}
	
}

compilationUnit
	:	(packageDefinition)?
			{	
				// add the logging functionality to class
				// newline();
				// write header of symbol table
				//symbolTable.println("ID\tRow\tType\tExpression\tNotes");
			}
		(importDefinition)*
		(typeDefinition)*
	;

packageDefinition
	:	#( 	PACKAGE_DEF
			annotations
				{
					pprint("package "); 
				}
		   	identifier
	   			{
	   				eos(); 
	   				newline();
	   			}
	    )
	;

importDefinition
	:	#( 	im:IMPORT
				{
					pprint(im.getText() + " "); 
				} 
		   	identifierStar
	   			{
	   				eos(); 
	   				newline();
	   			} 
	     )
	|	#( sim:STATIC_IMPORT identifierStar )
	;

typeDefinition
	:	#( 	CLASS_DEF
			id4:IDENT
			name:IDENT
			type:IDENT
				{
      				writeSTable(id4.getText(), row, type.getText(), name.getText(), "");
					newline(); 
				}
		   	modifiers 	
		   		{	
		   			pprint("class ");
		   		}
		   	id:IDENT	
		   		{
		   			pprint(id.getText() + " "); 
		   		}
		   (typeParameters)? 
		   extendsClause
		   implementsClause
		   		{
		   		//	pprint("{");
		   		// 	incLevel(); 
		   		}
		   objBlock
		   		{
		   		//	decLevel(); 
     				writeSTable(id4.getText(), row, "kl", name.getText(), "");
		   		//  	pprint("}");
		   		//  	newline();
		   		}
		)
	|	#(	INTERFACE_DEF
				{
					newline(); 
				}
			modifiers
		   		{	
		   			pprint("interface ");
		   		}			
			id2:IDENT
		   		{
		   			pprint(id2.getText() + " "); 
		   		}
			(typeParameters)?
			extendsClause
		   		{
		   			pprint("{");
		   		 	incLevel(); 
		   		}
			interfaceBlock
		   		{
		   			decLevel();  
		   		  	pprint("}");
		   		  	newline();
		   		}
		)
	|	#(	ENUM_DEF
			modifiers
		   		{	
		   			pprint("enum ");
		   		}			
			id3:IDENT
		   		{
		   			pprint(id3.getText() + " "); 
		   		}
			implementsClause
		   		{
		   			pprint("{ ");
//		   		 	incLevel(); 
		   		}
			enumBlock
		   		{
//		   			decLevel();  
		   		  	pprint(" }");
		   		  	newline();
		   		}
		)
	|	#(	ANNOTATION_DEF modifiers IDENT annotationBlock )
	;

typeParameters
	{ int i = 0; }
	:	#(TYPE_PARAMETERS 
			(typeParameter
				{	
					// to handle the trailing comma correctly
					if (i > 0) pprint(", "); 
					i++;
				}
			)+
		)
	;

typeParameter
	:	#(TYPE_PARAMETER IDENT (typeUpperBounds)?)
	;

typeUpperBounds
	:	#(TYPE_UPPER_BOUNDS (classOrInterfaceType)+)
	;

typeSpec returns [String result = ""]
	:	#(TYPE typeSpecArray)
	;

typeSpecArray
	:	#( 	ARRAY_DECLARATOR 
	       	typeSpecArray
	       		{
	       			pprint("[]" + " "); 
	       		}
	    )
	|	type
	;

type returns [String result = ""]
	:	classOrInterfaceType
	|	builtInType
	;

classOrInterfaceType
	:	id:IDENT
			{
				pprint(id.getText() + " ");
			}
		(typeArguments)?
	|	#( 	dot:DOT 
			classOrInterfaceType 
			ide:IDENT
		   		{
		   			pprint(dot.getText() + ide + " ");
		   		}
		)
	;

typeArguments returns [String result = ""]
	:	#(	TYPE_ARGUMENTS
			(typeArgument)+
	)
	;

typeArgument
	:	#(	TYPE_ARGUMENT
			(	typeSpec
			|	wildcardType
			)
		)
	;

wildcardType
	:	#(	WILDCARD_TYPE
			(typeArgumentBounds)?
	)
	;

typeArgumentBounds
	:	#(TYPE_UPPER_BOUNDS (classOrInterfaceType)+)
	|	#(TYPE_LOWER_BOUNDS (classOrInterfaceType)+)
	;

builtInType
	:	vo:"void"
			{
				pprint(vo.getText() + " "); 
			}
	|	bo:"boolean"
			{
				pprint(bo.getText() + " "); 
			}
	|	by:"byte"
			{
				pprint(by.getText() + " "); 
			}
	|	ch:"char"
			{	
				pprint(ch.getText() + " "); 
			}
	|	sh:"short"	
			{
				pprint(sh.getText() + " "); 
			}
	|	in:"int"
			{
				pprint(in.getText() + " "); 
			}
	|	fl:"float"
			{ 
				pprint(fl.getText() + " "); 
			}
	|	lo:"long"
			{ 
				pprint(lo.getText() + " "); 
			}
	|	dou:"double"
			{
				pprint(dou.getText() + " "); 
			}
	;

modifiers
	:	#( MODIFIERS (modifier)*)
	;

modifier
	:	pr:"private"	
			{
				pprint(pr.getText() + " "); 
			}
	|	pu:"public"
			{ 
				pprint(pu.getText() + " "); 
			}
	|	pro:"protected"
			{ 
				pprint(pro.getText() + " "); 
			}
	|	st:"static"
			{ 
				pprint(st.getText() + " "); 
			}		
	|	tr:"transient"		
			{
				pprint(tr.getText() + " "); 
			}
	|	fi:"final"
			{ 
				pprint(fi.getText() + " "); 
			}
	|	ab:"abstract"
			{ 
				pprint(ab.getText() + " "); 
			}
	|	na:"native"		
			{
				pprint(na.getText() + " "); 
			}
	|	th:"threadsafe"
			{
				pprint(th.getText() + " "); 
			}
	|	sy:"synchronized"
			{ 
				pprint(sy.getText() + " "); 
			}
	|	co:"const"
			{
				pprint(co.getText() + " "); 
			}
	|	vo:"volatile"	
			{
				pprint(vo.getText() + " "); 
			}	
	|	str:"strictfp"
			{ 
				pprint(str.getText() + " "); 
			}
	|	annotation
	;

annotations
	:	#(ANNOTATIONS (annotation)* )
	;

annotation
	:	#(ANNOTATION identifier (annotationMemberValueInitializer | (anntotationMemberValuePair)+)? )
	;

annotationMemberValueInitializer
	:	conditionalExpr | annotation | annotationMemberializer
	;

anntotationMemberValuePair
	:	#(ANNOTATION_MEMBER_VALUE_PAIR IDENT annotationMemberValueInitializer)
	;

annotationMemberializer
	:	#(ANNOTATION_ARRAY_INIT (annotationMemberArrayValueInitializer)* )
	;

annotationMemberArrayValueInitializer
	:	conditionalExpr | annotation
	;

extendsClause
	:	#(	EXTENDS_CLAUSE
			(		{
						pprint("extends ");
					}
				classOrInterfaceType
			)*
		)
	;

implementsClause
{
	int i = 0;
}
	:	#(	IMPLEMENTS_CLAUSE
			(	
				{	
					// to handle the trailing comma correctly
					if (i == 0) pprint("implements "); 
					if (i > 0) pprint(", "); 
					i++;
				}
				classOrInterfaceType
			)* 
		)
	;


interfaceBlock
	:	#(	OBJBLOCK
			(	methodDecl
					{
						eos();
						newline();
					}
			|	variableDef
					{
						eos();
						newline();
					}
			|	typeDefinition
			)*
			
		)
	;

objBlock
	:	#(	OBJBLOCK
				{
					pprint("{");
					incLevel();
				}
			(	(	{
						newline();
					}
					ctorDef
			
				)
			|	(	{
						newline();
					}
					methodDef
				)
			|	variableDef	
					{
						eos();
						newline();
					}
			|	typeDefinition
			|	#(STATIC_INIT slist[null])
			|	#(INSTANCE_INIT slist[null])
			)*
		)
				{
					pprint("}");
					decLevel();
				}
	;

annotationBlock
	:	#(	OBJBLOCK
			(	annotationFieldDecl
			|	variableDef
			|	typeDefinition
			)*
		)
	;

enumBlock
	{ int i = 0; }
	:	#(	OBJBLOCK
			(
				{	
					// to handle the trailing comma correctly
					if (i > 0) pprint(", "); 
					i++;
				}
				enumConstantDef
			)*
			(	ctorDef
			|	methodDef
			|	variableDef
			|	typeDefinition
			|	#(STATIC_INIT slist[null])
			|	#(INSTANCE_INIT slist[null])
			)*
		)
	;

ctorDef
{
	String s = "";
}
	:	#(	CTOR_DEF
			id:IDENT
			name:IDENT
			type:IDENT
			ctor:IDENT
			modifiers
			(typeParameters)?
			s = methodHead
			 	{
   		   			pprint("{");
	   	   			incLevel();
					methodID = id.getText();

	   		   		if ( ctor.getText().equals("n") ) {
						pprint(enterMethod + "( " + id.getText() + " );");
		   	   			newline();
		      			pprint("try {");
		      			incLevel();
						writeSTable(id.getText(), row, type.getText(), name.getText(), "");
					}
     			}
	      	(slist[id.getText()])?
		      	{	
		      		decLevel(); 
		      		pprint("} finally {");
		      		incLevel();
		      		pprint(handleException + "( " + row + " );");
		      		newline();
		      		pprint(leaveMethod + "( " + id.getText() + " );");
		      		decLevel();
		      		pprint("}");
		      		decLevel();
		      	  	pprint("}");
		      	  	newline();
				}
	)
	;

methodDecl
	:	#(	METHOD_DEF 
	      	modifiers
	      	(typeParameters)?
	      	typeSpec
	     	methodHead
	    )
	;

methodDef
{
	String methodName = "";
}
	:	#(	METHOD_DEF
			id:IDENT
			name:IDENT
			type:IDENT
			ctor:IDENT
	      	modifiers 
	      	(typeParameters)? 
	      	typeSpec 
	      	methodName = methodHead
	      	{	
	      		pprint("{");
	      		incLevel();
	      		pprint(enterMethod + "( " + id.getText() + " );");
	      		newline();
      			writeSTable(id.getText(), row, type.getText(), name.getText(), "");
	      		pprint("try {");
	      		incLevel();
	      	}
	      	(slist[null])?
	      	{	
	      		decLevel(); 
	      		pprint("} finally {");
	      		incLevel();
	      		pprint(handleException + "( " + row + " );");
	      		newline();
	      		pprint(leaveMethod + "( " + id.getText() + " );");
	      		decLevel();
	      		pprint("}");
	      		decLevel();
	      	  	pprint("}");
	      	  	newline();
			}
	    )

	;

variableDef
	:	#(	VARIABLE_DEF
	      	modifiers
	      	typeSpec
	      	variableDeclarator
	      	varInitializer
	    )
	;

parameterDef
	:	#(	PARAMETER_DEF
		  	modifiers
		  	typeSpec
		  	id:IDENT
		  		{
		  			pprint(id.getText()); 
		  		}
		)
	;

variableLengthParameterDef
	:	#(VARIABLE_PARAMETER_DEF modifiers typeSpec IDENT )
	;

annotationFieldDecl
	:	#(ANNOTATION_FIELD_DEF modifiers typeSpec IDENT (annotationMemberValueInitializer)?)
	;

enumConstantDef
	:	#(ENUM_CONSTANT_DEF
			annotations
			id:IDENT
		  		{
		  			pprint(id.getText()); 
		  		}				
			(elist)?
			(enumConstantBlock)?
		)
	;

enumConstantBlock
	:	#(	OBJBLOCK
			(	methodDef
			|	variableDef
			|	typeDefinition
			|	#(INSTANCE_INIT slist[null])
			)*
		)
	;

objectinitializer
	:	#(INSTANCE_INIT slist[null])
	;

variableDeclarator
	:	id:IDENT
			{
				pprint(id.getText() + " "); 
			}
	|	lb:LBRACK
			{
				pprint(lb.getText());
			}
		variableDeclarator
			{
				pprint("]"); 
			}
	;

varInitializer
	:	#(	ASSIGN
				{
					pprint("= "); 
				}
		  initializer
		)
	|
	;

initializer
	:	expression
	|	(	{
				pprint("{ ");
			}
		arrayInitializer
			{
				pprint(" }");
			}
		)
	;

arrayInitializer
	{ int i = 0; }
	:	#(ARRAY_INIT
			(	{	// to handle the trailing comma correctly
					if (i > 0) pprint(", "); 
					i++;
				}
				initializer
			)*
		)
	;

methodHead returns [String result = ""]
{
	int i = 0; 
}
	:	id:IDENT
			{
				result = id.getText();
				pprint(result); 
			}
		 #( PARAMETERS
		 		{
		 			pprint("( "); 
		 		}
		    		(		{	// to handle the trailing comma correctly
								if (i > 0) pprint(", "); 
								i++;
							}
						parameterDef
		    		)*
		    	{
		    		pprint(" ) ");
		    	}
		 ) 
		 (throwsClause)?
	;

throwsClause
{
	int i = 0; 
}
	:	#( th:"throws"
				{
					pprint(th.getText() + " "); 
				}
	     	(	{	// to handle the trailing comma correctly
					if (i > 0) pprint(", "); 
					i++;
				}
	       		classOrInterfaceType
			)* 
	    )
	;
	
identifier
	:	ide:IDENT
			{
				dest.print(ide.getText()); 
			}
	|	#( dot:DOT
		   identifier
		   		{
		   			dest.print(dot.getText());
		   		}
		   ide_:IDENT
		   		{
		   			dest.print(ide_.getText());
		   		}
		)
	;

identifierStar
	:	id:IDENT
			{
				pprint(id.getText()); 
			}
	|	#( dot:DOT 
		   identifier
		   		{
		   			pprint(dot.getText()); 
		   		}
		   ( st:STAR
		   		{
		   			pprint(st.getText()); 
		   		}	
		   | id_:IDENT
		   		{
		   			pprint(id_.getText()); 
		   		}
		   ) 
		)
	;

slist[String id] returns[boolean handled = false]
	:	#( SLIST 
			(stat)* 
		)
	;

stat
{
	isCtorCall = false;
}
	:	typeDefinition
			{
				eos(); 
				newline();
			}
	|	variableDef
			{
				eos();
				newline();
			}
	|	expression
			{	
				if ( !noEos ) {
					eos();
					noEos = false;
				}
				newline();
				if ( isCtorCall ) { 					
					pprint(enterMethod + "( " + methodID + " );");
	   	   			newline();
	      			pprint("try {");
	      			incLevel();
				}
			}
	|	#(	LABELED_STAT
			id2:IDENT
				{ 
					pprint(id2.getText() + ": ");
				}
			stat
		)
	|	#(	if_:"if"
				{	
					pprint(if_.getText()+ " ( "); 
					isLogging = true;
				}
		  	expression
				{	
					isLogging = false;
					pprint(" ) { "); 
				 	incLevel();
				}
		  	stat
				{	
					decLevel();
				  	pprint("} "); 
				}
		  	(	// optional else clause
		  		{	
		  			pprint("else { ");
		  			incLevel();
           		}
           		stat
		   		{	
		   			decLevel();
		   			pprint("} ");
           		}           
		  	)?
		  	{
		  		newline(); 
		  	}
		)
	|	#(	fo:"for"
				{
					pprint(fo.getText() + " ( "); 
				}
				(
					#(FOR_INIT ((variableDef)+ | elist)?)
						{
							pprint("; "); 
						}
					#(FOR_CONDITION (expression)?)
						{
							pprint("; "); 
						}
					#(FOR_ITERATOR (elist)?)
				|
					#(FOR_EACH_CLAUSE parameterDef expression)
				)
				{ 	
					pprint(" ) {");
					incLevel();
				}
			stat
				{ 	
					decLevel();
					pprint("}");
				}
			{ 
				newline(); 
			}
		)
	|	#(	wh:"while"
				{ 	
					pprint(wh.getText() + " ( "); 
					isLogging = true;
				}		 
			expression
				{	
					isLogging = false;
					pprint(" ) { "); 
				 	incLevel();
				}
			stat
				{	
					decLevel();
				  	pprint("} "); 
				}
			{
				newline(); 
			}
		)
	|	#(	do_:"do"
				{ 	
					pprint(do_.getText() + " {");  
				 	incLevel();
				}
			stat
				{	
					decLevel();
					pprint("} while ( "); 
					isLogging = true;
				}
			expression
				{	
					isLogging = false;
					pprint(" );"); 
				}
			{ 
				newline(); 
			}
		)
	|	#(	br:"break"
				{
					pprint(br.getText() + " "); 
				}
			(id:IDENT
				{
					pprint(id.getText()); 
				}
			)?
		  	{
		  		eos(); 
		  	}
		)
	|	#(	con:"continue"
			{
				pprint(con.getText() + " "); 
			}
			(	con_id:IDENT
					{
						pprint(con_id.getText()); 
					}
			)? 
			{
				eos();
			}
		)
	|	#(	re:"return"
				{
					pprint(re.getText() + " ");
				}
	      	(expression)?
	      	{
	      		eos();
	      	}      				
	    )
	|	#(	sw:"switch"
				{
					pprint(sw.getText() + " ( " + enterSwitch + " ( ");
				}
			ids:IDENT // get id from instr AST
	      	expression
	      		{ 	
	      			pprint(", " + ids.getText() + " ) ) { "); 
					incLevel();
				}
			expr:IDENT // get expression from instr AST
			type_:IDENT // get type from instr AST
				{ 	
					// write the symbol table
					writeSTable(ids.getText(), row, type_.getText(), expr.getText(), "");
				}
	      	(caseGroup[expr.getText()])*
    	 	{	
    	 		decLevel();
				pprint("} ");
				newline();
				pprint(leaveSwitch + "( " + ids.getText() + " );");
				newline(2);
		 	}
	    )
	|	#(	th:"throw"
				{
					pprint(th.getText() + " ");
				}
			expression
				{
					eos();
				}
		)
	|	#("synchronized" expression stat)
	|	tryBlock
	|	slist[null] // nested SLIST
	|	#("assert" expression (expression)?)
	|	EMPTY_STAT
	;

caseGroup[String ids]
{
	String str_exp = "";	
	Vector v = new Vector();
}
	:	#(	CASE_GROUP 
			(#(	ca:"case"
					{	
						pprint(ca.getText() + " "); 
					}
				str_exp = expression
					{
						pprint(": "); 
						v.add(str_exp);
					}
			  	)
			| 	de:"default"
					{
						pprint(de.getText() + ": ");
						v.add(de.getText());
					}
			)+ 
				{ 	
					incLevel();
//					newline();
				}
			id:IDENT // get id from instr AST
			exp:IDENT // get expression from instr AST
			type_:IDENT // get type from instr AST
				{ 	
					// write the symbol table
					writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
		  			// print the logging function
					for ( int i = 0; i < v.size(); i++ ) {
						String s = ( String ) v.get(i);

						if ( s.trim().equals( "default" ) ) {
							pprint(logCString + "( " + id.getText() + " );");
						} else {
							pprint(logCString + "( " + ids + " == " + s + ", " + id.getText() + " );");
							newline();
						}
					}
					newline(); 
				}
			slist[null]
				{
					decLevel();
				}
		)
	;

tryBlock
	:	#(	tr:"try"
				{	pprint(tr.getText() + " { ");
				  	incLevel();
				}
		  	slist[null]
		  		{ 	decLevel();
		  			pprint("} ");
				}
		  	(handler)*
		  		{ 
		  			//newline(); 
		  		}
		  (	#(	"finally"
		  			{
		  				pprint("finally {");
		  				incLevel();
		  			}
		  		slist[null]
		  			{
		  				decLevel();
		  				pprint("} ");	
		  				newline();	  				
		  			}
		  	)
		  )?
		)
	;

handler
	:	#(	ca:"catch"
				{	pprint(ca.getText() + " ( "); }
		  	parameterDef
		  		{	pprint(" ) { ");
		  			incLevel();
		  		}		  	
		  	slist[null]
		  		{	decLevel();
		  		  	pprint("} ");
		  		  	newline();
		  		}		  				
		)
	;

elist returns [String result = ""]
	{ int i = 0; }
	:	#( 	ELIST
				{
					if (Paren) pprint("( ");	
				}
			(		{	// to handle the trailing comma correctly
						if (i > 0) pprint(", "); 
						i++;
					}
				expression
			)* 
				{
					if (Paren) pprint(" )");	
					Paren = false;
				}
		)
	;

expression returns [String result = ""]
	:	#(	exp:EXPR
			result = expr 
		)
	| 	#(	LOGB
				{	// if the "logB"-token is matched, insert the logB function
					pprint(catchException + " ( ");
				}
		  	id:IDENT		
		    	{ 
		    		 pprint(startExpression + "( " + id.getText() + " ), " + logBString + "( ");
		    	}
		  	expression	
		   		{ 
		   			pprint(", "); 
		   			pprint(id.getText() + " ), " + endExpression + "( " + id + " ) )"); 
		   		}
    	  	exp2:IDENT		
    	  	type_:IDENT
		  		{ 	// write the symbol table
					writeSTable(id.getText(), row, type_.getText(), exp2.getText(), "");
		  		}  
		)

	;

expr returns [String result = ""]
{
	String str_left = "";
	String str_right = "";
}
	:	result = conditionalExpr
	| 	#(	LOGB
				{	// if the "logB"-token is matched, insert the logB function
		    		 pprint(logBString + "( ");
		    	}
		  	id:IDENT		
		  	expr
		   		{ 
		   			pprint(", "); 
		   			pprint(id.getText() + " )"); 
		   		}
    	  	exp:IDENT		
    	  	type_:IDENT
		  		{ 	// write the symbol table
		  			writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
		  		}  
		)
	|	#(	as:ASSIGN
				{
					// support 
					if (isLogging) pprint("( ");
				}
		  	str_left = expr
		  		{ 
		  			pprint(" " + as.getText() + " "); 
		  		}
		  	str_right = expr
				{
					if (isLogging) pprint(" )");
					result = str_left + " " + as.getText() + " " + str_right;
				}
		)			// binary operators...
	|	#(	pl:PLUS_ASSIGN
		  	str_left = expr
		  		{ 
		  			pprint(" " + pl.getText() + " "); 
		  		}
		  	str_right = expr
		  		{
					result = str_left + " " + pl.getText() + " " + str_right;
		  		}
		)
	|	#(	mi:MINUS_ASSIGN
		  	str_left = expr
		  		{ 
		  			pprint(" " + mi.getText() + " "); 
		  		}
		  	str_right = expr
		  		{
					result = str_left + " " + mi.getText() + " " + str_right;
		  		}
		)
	|	#(	sa:STAR_ASSIGN 
			str_left = expr 
		  		{ 
		  			pprint(" " + sa.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + as.getText() + " " + str_right;
				}
		)
	|	#(	di:DIV_ASSIGN 
			str_left = expr 
		  		{ 
		  			pprint(" " + di.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + di.getText() + " " + str_right;
				}
		)
	|	#(	mo:MOD_ASSIGN 
			str_left = expr 
		  		{ 
		  			pprint(" " + mo.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + mo.getText() + " " + str_right;
				}
		)
	|	#(	sr:SR_ASSIGN
			str_left = expr 
		  		{ 
		  			pprint(" " + sr.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + sr.getText() + " " + str_right;
				}
		)
	|	#(	bsr:BSR_ASSIGN 
			str_left = expr 
		  		{ 
		  			pprint(" " + bsr.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + bsr.getText() + " " + str_right;
				}
		)
	|	#(	sl:SL_ASSIGN
			str_left = expr 
		  		{ 
		  			pprint(" " + sl.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + sl.getText() + " " + str_right;
				}
		)
	|	#(	band:BAND_ASSIGN
			str_left = expr 
		  		{ 
		  			pprint(" " + band.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + band.getText() + " " + str_right;
				}
		)
	|	#(	bxor:BXOR_ASSIGN 
			str_left = expr 
		  		{ 
		  			pprint(" " + bxor.getText() + " "); 
		  		}
			str_right = expr
				{
					result = str_left + " " + bxor.getText() + " " + str_right;
				}
		)
	|	#(	bor:BOR_ASSIGN 
			str_left = expr
		  		{ 	
		  			pprint(" " + bor.getText() + " "); 
		  		}
			str_right = expr	
				{
					result = str_left + " " + bor.getText() + " " + str_right;
				}
		)
	;

conditionalExpr returns [String result = ""]
{
	String str_right = "";
	String str_left = "";
	String str_middle = "";
	
}
	:	#(	que:QUESTION
				{	// if the "logB"-token is matched, insert the logB function
					pprint(" ( " + catchException + " ( "); }
			id:IDENT // get id from instr AST
				{
					pprint(startExpression + "( " + id.getText() + " ), " + logBString + "( ");				
				}
			str_left = expr
		   		{ 
		   			pprint(", "); 
		   			pprint(id.getText() + " ), " + endExpression + "( " + id + " ) ) )"); 
		   		}
			exp:IDENT // get expression from instr AST
			type_:IDENT // get type from instr AST
				{ 	
					// write the symbol table
					writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
					pprint(que.getText() + " ( ");
				}
			str_middle = expr
				{ 
					pprint(" ) : ( "); 
				}
			str_right = expr
				{ 	
					pprint(" ) "); 
					result = str_left + " " + que.getText() + " " + str_middle + " : " + str_right;
				}
		)	// trinary operator
	|	#(	lor:LOR
				{ 	
					pprint("( "); 
				}
			str_left = expr
	      		{ 
	      			pprint(" " + lor.getText() + " "); 
	      		}
			str_right = expr
	      		{ 	
	      			pprint(") "); 
					result = str_left + " " + lor.getText() + " " + str_right;
	      		}
	    )
	|	#(	land:LAND
				{ 
					pprint("( "); 
				}
		    str_left = expr
		    	{ 
		    		pprint(" " + land.getText() + " "); 
		    	}
			str_right = expr
	      		{ 
	      			pprint(") "); 
					result = str_left + " " + land.getText() + " " + str_right;
	      		}
	    )
	|	#(	bo:BOR
			str_left = expr
			  	{ 
			  		pprint(" " + bo.getText() + " "); 
			  	}
			str_right = expr
				{
					result = str_left + " " + bo.getText() + " " + str_right;
				}
		)
	|	#(	bx:BXOR
			str_left = expr
			  	{ 
			  		pprint(" " + bx.getText() + " ");
			  	}
			str_right = expr
				{
					result = str_left + " " + bx.getText() + " " + str_right;
				}
		)
	|	#(	ba:BAND
			str_left = expr
			  	{ 
			  		pprint(" " + ba.getText() + " "); 
			  	}
			str_right = expr
				{
					result = str_left + " " + ba.getText() + " " + str_right;
				}
		)
	|	#(	neq:NOT_EQUAL
			str_left = expr
			  	{ 
			  		pprint(" " + neq.getText() + " "); 
			  	}
			str_right = expr
				{
					result = str_left + " " + neq.getText() + " " + str_right;
				}
		)
	|	#(	eq:EQUAL
		  	str_left = expr
			  	{ 
			  		pprint(" " + eq.getText() + " "); 
			  	}
			str_right = expr
				{
					result = str_left + " " + eq.getText() + " " + str_right;
				}
		)
	|	#(	lt:LT
			str_left = expr
				{ 
					pprint(" " + lt.getText() + " "); 
				}
			str_right = expr
				{
					result = str_left + " " + lt.getText() + " " + str_right;
				}
		)
	|	#(	gt:GT		
		    str_left = expr
			    { 
			    	pprint(" " + gt.getText() + " "); 
			    }
		    str_right = expr
		    	{
					result = str_left + " " + gt.getText() + " " + str_right;
		    	}
	    )
	|	#(	le:LE
			str_left = expr
			    { 
			    	pprint(" " + le.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + le.getText() + " " + str_right;
				}
		)
	|	#(	ge:GE
			str_left = expr
			    { 
			    	pprint(" " + ge.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + ge.getText() + " " + str_right;
				}
		)
	|	#(	sl:SL
			str_left = expr
			    { 
			    	pprint(" " + sl.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + sl.getText() + " " + str_right;
				}
		)
	|	#(	sr:SR
			str_left = expr
			    { 
			    	pprint(" " + sr.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + sr.getText() + " " + str_right;
				}
		)
	|	#(	bsr:BSR
			str_left = expr
			    { 
			    	pprint(" " + bsr.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + bsr.getText() + " " + str_right;
				}
		)
	|	#(	pl:PLUS
			str_left = expr 
			    { 
			    	pprint(" " + pl.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + pl.getText() + " " + str_right;
				}
		)
	|	#(	mi:MINUS
			str_left = expr
			    { 
			    	pprint(" " + mi.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + mi.getText() + " " + str_right;
				}
		)
	|	#(	di:DIV
			str_left = expr
			    { 
			    	pprint(" " + di.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + di.getText() + " " + str_right;
				}
		)
	|	#(	mo:MOD
			str_left = expr
			    { 
			    	pprint(" " + mo.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + mo.getText() + " " + str_right;
				}
		)
	|	#(	st:STAR
			str_left = expr
			    { 
			    	pprint(" " + st.getText() + " "); 
			    }
			str_right = expr
				{
					result = str_left + " " + st.getText() + " " + str_right;
				}
		)
	|	#(	in:INC
				{ 
					pprint(in.getText()); 
				}
			str_right = expr
				{
					result = in.getText() + " " + str_right;
				}
		)
	|	#(	de:DEC
				{ 
					pprint(de.getText()); 
				}
			str_right = expr
				{
					result = de.getText() + " " + str_right;
				}
		)
	|	#(	poi:POST_INC
			str_left = expr
				{ 
					pprint(poi.getText()); 
					result = str_left + " " + poi.getText();
				}
		)
	|	#(	pod:POST_DEC
			str_left = expr
				{ 
					pprint(pod.getText()); 
					result = str_left + " " + pod.getText();
				}
		)
	|	#(	bnot:BNOT
				{ 
					pprint(bnot.getText()); 
				}
	      	str_right = expr
	      		{
					result = bnot.getText() + " " + str_right;
	      		}
	    )
	|	#(	lnot:LNOT
				{ 
					pprint(lnot.getText()); 
				}
	     	str_right = expr
	     		{
					result = lnot.getText() + " " + str_right;
	     		}
	    )
	|	#(	io:"instanceof"
	      	str_left = expr
	      		{ 
	      			pprint(" " + io.getText() + " "); 
	      		}
	      	str_right = expr
	      		{
					result = str_left + " " + io.getText() + " " + str_right;
	      		}
	    )
	|	#(	um:UNARY_MINUS
	      		{ pprint(um.getText()); }
			expr
		)
	|	#(	up:UNARY_PLUS
	      		{ pprint(up.getText()); }
			expr
		)
	|	result = primaryExpression
	;

primaryExpression returns [String result = ""]
{ 	
	String str_expr = "";
	String str_pe = "";
	String str_ta = ""; 
	String str_elist = "";
	String str_temp = "";
	String ref_variable = "";
	String ref_variable_id = "";
	boolean firstIf = true;
}
	:	id:IDENT
			{ 
				pprint(id.getText()); 
				result = id.getText();
			}
	|	#(	do_:DOT	
			(	str_expr = expr
				(	id_:IDENT
						{	
							pprint(do_.getText());
						  	pprint(id_.getText()); 
							result = str_expr + do_.getText() + id_.getText();						  	
						}
				|	result = arrayIndex
				|	thi:"this"
						{ 
							pprint("." + thi.getText()); 
							result = str_expr + do_.getText() + thi.getText();
						}
				|	cla:"class"
						{ 
							pprint("." + cla.getText()); 
							result = str_expr + do_.getText() + cla.getText();
						}
				|	str_temp = newExpression
						{
							result = str_expr + do_.getText() + str_temp;
						}
				|	sup:"super" 
						{ 
							Paren = true;
							pprint("." + sup.getText()); 
							isCtorCall = true;
							result = str_expr + do_.getText() + sup.getText();
						}
				|	(typeArguments)? // for generic methods calls
				)
			|	#(ARRAY_DECLARATOR typeSpecArray)
			|	builtInType ("class")?
			)
		)
	|	result = arrayIndex
	|	#(	METHOD_CALL
	      	str_pe = primaryExpression
	      	(
	      		str_ta = typeArguments
	      		
	      	)?
	      		{ 	
	      			// print parentheses around the expression (method arguments)
	      			pprint("( "); 
	      			Paren = false;
	      		}
	      	str_elist = elist	
	      		{ 
	      			result = str_pe + "(" + str_elist + ")";
	      			pprint(" )");
	      			noEos = false;
	      		}    
	      	( 	id2: IDENT
				expr: IDENT
				type: IDENT	      		  	
	      		{
					if (!noEos) pprint(";");
					newline();

					if ( type.getText().equals( "v" ) ) {
						ref_variable = expr.getText();
						ref_variable_id = id2.getText();
	     				writeSTable(ref_variable_id, row, "v", ref_variable, "");
					}

					if ( ref_variable.length() > 0 && type.getText().equals( "i") ) {
						if ( !firstIf ) pprint("else ");
						firstIf = false;
						pprint ( "if ( " + ref_variable + " instanceof " + expr.getText() + " ) {" );
						incLevel();
						pprint ( logPString + "( " + ref_variable_id + ", " + id2.getText() + " );" ) ;
	     				writeSTable(id2.getText(), row, "i", expr.getText(), "");
						decLevel();
						pprint ("}");
						newline();
					}

	      			System.out.println ( id2.getText() + ":" + expr.getText() + ":" + type.getText() );
	      			
					noEos = true;
	      			
	      		}
	      	)*	    
	    )
	|	ctorCall
	|	#(	TYPECAST
					{ 
						pprint("( ");
					}
				str_ta = typeSpec
					{
						pprint(")");
					}
				str_expr = expr
					{
						result = "( " + str_ta +" ) " + str_expr;
					}
		)
	|	newExpression
	|	result = constant
	|	su:"super"
			{ 
				pprint(su.getText()); 
				result = su.getText();
			}
	|	tr:"true"	
			{ 
				pprint(tr.getText()); 
				result = tr.getText();
			}
	|	fa:"false"	
			{ 
				pprint(fa.getText());
				result = fa.getText(); 
			}
	|	th:"this"
			{
				pprint(th.getText()); 
				result = th.getText();
			}
	|	nu:"null"
			{
				pprint(nu.getText());
				result = nu.getText();			
			}
	|	typeSpec // type name used with instanceof
	;

ctorCall
	:	#( 	CTOR_CALL 
				{
					pprint("this( ");
					Paren = false;
				}	
			elist 
				{
					pprint(" )");
					Paren = false;
					isCtorCall = true;
	      		}	
		)
	|	#( SUPER_CTOR_CALL
			(	{
					pprint("super (");
					Paren = false;
				}	
				elist
				{
					pprint(" )");
					Paren = false;
					isCtorCall = true;
				}	
			|	primaryExpression 
				elist
			)
		 )
	;

arrayIndex returns [String result = ""]
{ 
	String str_exp1 = ""; 
	String str_exp2 = "";
}
	:	#(	INDEX_OP
			str_exp1 = expr
				{ 	// print brackets around the expression
					pprint("[");
				}
			str_exp2 = expression
		)
		{ 
			pprint("]");
			result = str_exp1 + "[" + str_exp2 + "]"; 
		}
	;

constant returns [String result = ""]
	:	nu:NUM_INT			
			{ 
				pprint(nu.getText()); 
				result = nu.getText();
			}
	|	ch:CHAR_LITERAL		
			{ 
				pprint(ch.getText()); 
				result = ch.getText();
			}
	|	st:STRING_LITERAL	
			{ 
				pprint(st.getText()); 
				result = st.getText();
			}
	|	fl:NUM_FLOAT		
			{ 
				pprint(fl.getText()); 
				result = fl.getText();
			}
	|	dou:NUM_DOUBLE		
			{ 
				pprint(dou.getText()); 
				result = dou.getText();
			}
	|	lo:NUM_LONG			
			{
				pprint(lo.getText());
				result = lo.getText();
			}
	;

newExpression returns [String result = ""]
{
	String str_ta = "";
	String str_type = "";
}
	:	#(	ne:"new"
				{
					pprint(ne.getText() + " "); 
					result = ne.getText() + " ";
				}
	      	(
	      		str_ta = typeArguments
	      			{
	      				result = result + str_ta;
	      			}
	      	)?
	      	str_type = type
	      		{
	      			result = result + " " + str_type;	      		
	      		}
			(	newArrayDeclarator	
				(arrayInitializer)?
			|		{ 
						pprint("( "); 
						Paren = false;
					}
					elist	
					{ 
						pprint(" )"); 
					}
				(objBlock)?
			)
		)

	;

newArrayDeclarator
	:	#( ARRAY_DECLARATOR
			(newArrayDeclarator)?
				{
					pprint("[ ");
				}
			(expression)? 
				{
					pprint(" ]");
				}
		)
	;
