header {

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;
import java.util.*;
}


/** Java 1.5 AST Recognizer Grammar
 *
 * JavaTreeInstrumenter.java - This class instruments the AST returned by
 * the JavaRecognizer and returns the instrumented AST.
 *
 * @author: (see java.g preamble) && Dominik Schindler
 *
 * This grammar is in the PUBLIC DOMAIN, the additional
 * code is copyright by Dominik Schindler
 */
 
class JavaTreeInstrumenter extends TreeParser;

options {
	importVocab = Java;
	buildAST = true; // build second AST to instrument
}

{	// 2 HashMaps to store local variables and methods and their types
	private Hashtable variableDecls = null;
	private Hashtable methodDecls = null;
	
	// ArrayList to store import definitions
	private Vector imports = null;

	// current position in the symbol table
	private long symbolCount = 0;

	//
	private boolean autoFlush = true;

	// is logging on or off?
	private boolean isLogging = false;

	// store old state for resetLogging()
	private boolean isLoggingOld = false;
	
	//
	private boolean isCtorCall = false;
	
	//
	private ClassHierarchie ch = null;
	
	//
	public JavaTreeInstrumenter( ClassHierarchie ch ) {
		this();
		this.ch = ch;
	}
	
	public JavaTreeInstrumenter( ClassHierarchie ch, Hashtable variables, Hashtable methods, Vector imports ) {
		this( ch );
		this.variableDecls = variables;
		this.methodDecls = methods;
		this.imports = imports;
	}
	
	public JavaTreeInstrumenter( Hashtable variables, Hashtable methods, Vector imports ) {
		this();
		this.variableDecls = variables;
		this.methodDecls = methods;
		this.imports = imports;
	}
	
	// === instrumenter functions ===
	// returns the instrumented AST and assings the current expression "exp"
	private AST instrTrinaryExpression(AST root, AST child1, AST child2, AST child3, String exp ) {
		symbolCount++;
		return #(root, [IDENT, String.valueOf(symbolCount)], child1, [IDENT, exp], [IDENT, "b"], child2, child3);
	}

	private AST instrBinaryExpression(AST root, AST child1, AST child2, String exp, String type) {
		if (isLogging) {
			symbolCount++;
			return #([LOGB, "LOGB"], [IDENT, String.valueOf(symbolCount)], #(root, child1, child2), [IDENT, exp], [IDENT, type]);	
		} else {
			return #(root, child1, child2);	
		}
	}

	// instrument unary conditional expression like !(...)
	private AST instrUnaryExpression(AST root, AST child, String exp) {
		if (isLogging) {
			symbolCount++;
			return #([LOGB, "LOGB"], [IDENT, String.valueOf(symbolCount)], [IDENT, exp], [IDENT, exp], [IDENT, "c"], #(root, child));	
		} else {
			return #(root, child);
		}
	}

	// instrument primary expression like variables, ...	
	private AST instrPrimaryExpression(AST root, AST child, String ident) {
		if (isLogging) { // if logging is on & variable type = boolean
			symbolCount++;
			return #([LOGB, "LOGB"], [IDENT, String.valueOf(symbolCount)], #(root, child), [IDENT, ident], [IDENT, "p"]);
		} else {
			return #(root, child);
		}
	}
	
	// instrument branch/decition expression
	private AST instrDecitionExpression(AST root, AST child, String exp) {
		if (isLogging) {
			symbolCount++;
			return #([LOGB, "LOGB"], [IDENT, String.valueOf(symbolCount)], #(root, child), [IDENT, exp], [IDENT, "b"]);	
		} else {
			return #(root, child);
		}
	}
	
	// instrument switch/case expressions
	private AST instrCaseExpression(AST root, AST child1, AST child2, String exp) {
		symbolCount++;
		return #(root, child1, [IDENT, String.valueOf(symbolCount)], [IDENT, exp], [IDENT, "s"], child2);
	}
	
	// instrument methods, constructors, ...
	private AST instrMethod(AST root, AST child1, AST child2, AST child3, AST child4, AST child5, String methodName, String type, String ctor) {
		symbolCount++;
		return #(root, [IDENT, String.valueOf(symbolCount)], [IDENT, methodName], [IDENT, type], [IDENT, ctor], child1, child2, child3, child4, child5);
	}

	// instrument classes and interfaces
	private AST instrClasses(AST root, AST child1, AST child2, AST child3, AST child4, AST child5, AST child6, String className, String type) {
		symbolCount++;
		return #(root, [IDENT, String.valueOf(symbolCount)], [IDENT, className], [IDENT, type], child1, child2, child3, child4, child5, child6);
	}

	// helper functions	
	//
	private String getType( String s ) {
		return ( String ) variableDecls.get( s );
	}
	
	private Vector getClasses( String s ) {
		if ( s == null ) return null;
		if ( ch == null ) return null;
		
		Vector temp;

		for ( int i = 0; i < imports.size(); i++ ) {
			String t = ( String ) imports.get( i );
			
			if ( t.endsWith( "*" ) ) {
				String u = t.substring( 0, t.indexOf( "*" ) ) + s;
				ExtendedClass e = ch.getExtendedClass( u );
				if ( e != null ) {
					temp = new Vector( e.getSubClasses() );
					temp.add( e );
					return temp;
				}
			} else if ( t.endsWith( "." + s ) ) {
				ExtendedClass e = ch.getExtendedClass( t );
				if ( e != null ) {
					temp = new Vector( e.getSubClasses() );
					temp.add( e );
					return temp;
				}
			} 
		}	

		ExtendedClass e = ch.getExtendedClass( s );
		if ( e != null ) {
			temp = new Vector( e.getSubClasses() );
			temp.add( e );
			return temp;
		}

		return null;
	}
	
	// true, if the variable or method name is of type boolean (local or external 
	// by reflection)
	private boolean checkBoolean(String ident) {
	
		if ( variableDecls == null || methodDecls == null ) return false;
		
		if ( ident.trim().length() == 0 ) return false;
		
		//System.out.println( "check: " + ident );
	
		String s = ( String ) variableDecls.get( ident );
		if (s != null && s.equals( "boolean" ) ) {
			// local variable
			return true;
		} else if ( ch != null ) { 
			// use class hierachie if not local
			String c = ( String )  variableDecls.get( ident );
			//System.out.println(c);
			return false;
		} 
		
		// search method in variable-decls		
		int p = ident.indexOf( "(" );
		if ( p < 1 ) return false;
		ident = ident.substring( 0, p );
		ident.trim();

       	System.out.println( "method decls" );
		
		System.out.println( methodDecls );
		
		s = ( String ) methodDecls.get( ident );

		// System.out.println( ident + ":" + s );

		if (s != null && s.equals( "boolean" ) ) {
			// local variable
			return true;
		} else if ( ch != null ) { 
			// use class hierarchie if not local
			String c = (String) methodDecls.get( ident );
			System.out.println(c);
			return false;
		} 
		
		
		return false;
	}

	private void setLogging() {
		isLoggingOld = isLogging;
		isLogging = true;
	}
	
	private void unsetLogging() {
		isLoggingOld = isLogging;
		isLogging = false;
	}
	
	private void resetLogging() {
		isLogging = isLoggingOld;	
	}
	
	// public methods
	public long getSymbolCount() {
		return symbolCount;
	}
	
	public void setSymbolCount(long value) {
		symbolCount = value;
	}

}

compilationUnit
	:	(packageDefinition)?
		(importDefinition)*
		(typeDefinition)*
	;

packageDefinition
	:	#( PACKAGE_DEF annotations identifier )
	;

importDefinition
{
	String str_ids = "";
}
	:	#( 	IMPORT
			identifierStar 
		)
	|	#( STATIC_IMPORT identifierStar )
	;

typeDefinition
	:	!#(	cd:CLASS_DEF
			mo:modifiers
			id:IDENT
			(tp:typeParameters)?
			ec:extendsClause
			ic:implementsClause
			ob:objBlock 
				{
					## = instrClasses(#cd, #mo, #id, #tp, #ec, #ic, #ob, id.getText(), "ke"); 
				}
		)
	|	#(	INTERFACE_DEF
			modifiers
			IDENT
			(typeParameters)?
			extendsClause
			interfaceBlock 
		)
	|	#(ENUM_DEF modifiers IDENT implementsClause enumBlock )
	|	#(ANNOTATION_DEF modifiers IDENT annotationBlock )
	;

typeParameters
	:	#(TYPE_PARAMETERS (typeParameter)+)
	;

typeParameter
	:	#(TYPE_PARAMETER IDENT (typeUpperBounds)?)
	;

typeUpperBounds
	:	#(TYPE_UPPER_BOUNDS (classOrInterfaceType)+)
	;

typeSpec returns [String result = ""]
	:	#(	TYPE
			result = typeSpecArray
		)
	;

typeSpecArray returns [String result = ""]
	:	#( 	ARRAY_DECLARATOR
			result = typeSpecArray
				{
					result += "[]";
				}
		)
	|	result = type
	;

type returns [String result = ""]
	:	result = classOrInterfaceType
	|	result = builtInType
	;

classOrInterfaceType returns [String result = ""]
{
	String s = ""; 
}
	:	id:IDENT
			{
				result = id.getText(); 
			}
		(typeArguments)?
	|	#( 	dot:DOT
			s = classOrInterfaceType
			ide:IDENT
			{
				result = s + dot.getText() + ide;
			}
		)
	;

typeArguments returns [String result = ""]
{
	String str_ta = ""; 
}
	:	#(	TYPE_ARGUMENTS 
			(	str_ta = typeArgument
				{
					result += str_ta + " ";
				}
			)+
		)
	;

typeArgument returns [String result = ""]
	:	#(	TYPE_ARGUMENT
			(	typeSpec
			|	wildcardType
			)
		)
	;

wildcardType
	:	#(WILDCARD_TYPE (typeArgumentBounds)?)
	;

typeArgumentBounds
	:	#(TYPE_UPPER_BOUNDS (classOrInterfaceType)+)
	|	#(TYPE_LOWER_BOUNDS (classOrInterfaceType)+)
	;

builtInType returns [String result = ""]
	:	vo:"void"
			{
				result = vo.getText();
			}
	|	bo:"boolean"
			{
				result = bo.getText();
			}
	|	by:"byte"
			{
				result = by.getText();
			}
	|	ch:"char"
			{
				result = ch.getText();
			}
	|	sh:"short"
			{
				result = sh.getText();
			}
	|	in:"int"
			{
				result = in.getText();
			}
	|	fl:"float"
			{
				result = fl.getText();
			}
	|	lo:"long"
			{
				result = lo.getText();
			}
	|	dou:"double"
			{	
				result = dou.getText();
			}
	;

modifiers returns [String result = ""]
	:	#(MODIFIERS (modifier)* )
	;

modifier
	:	"private"
	|	"public"
	|	"protected"
	|	"static"
	|	"transient"
	|	"final"
	|	"abstract"
	|	"native"
	|	"threadsafe"
	|	"synchronized"
	|	"const"
	|	"volatile"
	|	"strictfp"
	|	annotation
	;

annotations
	:	#(ANNOTATIONS (annotation)* )
	;

annotation
	:	#(ANNOTATION identifier (annotationMemberValueInitializer | (anntotationMemberValuePair)+)? )
	;

annotationMemberValueInitializer
	:	conditionalExpr | annotation | annotationMemberArrayInitializer
	;

anntotationMemberValuePair
	:	#(ANNOTATION_MEMBER_VALUE_PAIR IDENT annotationMemberValueInitializer)
	;

annotationMemberArrayInitializer
	:	#(ANNOTATION_ARRAY_INIT (annotationMemberArrayValueInitializer)* )
	;

annotationMemberArrayValueInitializer
	:	conditionalExpr | annotation
	;

extendsClause
	:	#(EXTENDS_CLAUSE (classOrInterfaceType)* )
	;

implementsClause
	:	#(IMPLEMENTS_CLAUSE (classOrInterfaceType)* )
	;


interfaceBlock
	:	#(	OBJBLOCK
			(	methodDecl
			|	variableDef
			|	typeDefinition
			)*
		)
	;

objBlock
	:	#(	OBJBLOCK
			(	ctorDef
			|	methodDef
			|	variableDef
			|	typeDefinition
			|	#(STATIC_INIT slist)
			|	#(INSTANCE_INIT slist)
			)*
		)
	;

annotationBlock
	:	#(	OBJBLOCK
			(	annotationFieldDecl
			|	variableDef
			|	typeDefinition
			)*
		)
	;

enumBlock
	:	#(	OBJBLOCK
			(
				enumConstantDef
			)*
			(	ctorDef
			|	methodDef
			|	variableDef
			|	typeDefinition
			|	#(STATIC_INIT slist)
			|	#(INSTANCE_INIT slist)
			)*
		)
	;

ctorDef
{
	String str_mh = "";
}
	:	!#(	cd:CTOR_DEF
			mo:modifiers
			(tp:typeParameters)?
			str_mh = mh:methodHead
			(sl:slist)?
				{
					## = instrMethod(#cd, #mo, #tp, #mh, #sl, null, str_mh, "o", ( isCtorCall ) ? "y" : "n" );
				}
		)
	;

methodDecl
	:	#(	METHOD_DEF
			modifiers
			(typeParameters)?
			typeSpec
			methodHead
		)
	;

methodDef
{
	String str_type = ""; // store type name and method name
	String str_mh = "";
}
	:	!#(	md:METHOD_DEF
			mo:modifiers
			(tp:typeParameters)?
			str_type = ts:typeSpec
			str_mh = mh:methodHead
			(sl:slist)?
				{
					## = instrMethod(#md, #mo, #tp, #ts, #mh, #sl, str_mh, "m", "n");
				}
		)
	;

variableDef
	:	#(	VARIABLE_DEF
			modifiers
			typeSpec
			variableDeclarator
			varInitializer
		)
	;

parameterDef returns [String result = ""]
{
	String str_mo = "";
	String str_ts = "";
}
	:	#(	PARAMETER_DEF
			modifiers
			str_ts=typeSpec
			id:IDENT
				{
					result += str_ts + " " + id.getText();
				}
		)
	;

variableLengthParameterDef
	:	#(VARIABLE_PARAMETER_DEF modifiers typeSpec IDENT )
	;

annotationFieldDecl
	:	#(ANNOTATION_FIELD_DEF modifiers typeSpec IDENT (annotationMemberValueInitializer)?)
	;

enumConstantDef
	:	#(ENUM_CONSTANT_DEF annotations IDENT (elist)? (enumConstantBlock)?)
	;

enumConstantBlock
	:	#(	OBJBLOCK
			(	methodDef
			|	variableDef
			|	typeDefinition
			|	#(INSTANCE_INIT slist)
			)*
		)
	;

objectinitializer
	:	#(INSTANCE_INIT slist)
	;

variableDeclarator returns [String result = ""]
	:	id:IDENT
			{
				result = id.getText(); 
			}
	|	LBRACK variableDeclarator
	;

varInitializer
	:	#(ASSIGN initializer)
	|
	;

initializer
	:	expression
	|	arrayInitializer
	;

arrayInitializer
	:	#(ARRAY_INIT (initializer)*)
	;

methodHead returns [String result = ""]
{
	String str_pd = "";
	int i = 0;
}
	:	id:IDENT
			{
				result = id.getText(); 
			}
		 #( PARAMETERS
		 		{
		 			result += " ( "; 
		 		}
		    		(		{	// to handle the trailing comma correctly
								if (i > 0) result += ", "; 
								i++;
							}
						str_pd = parameterDef
							{
								result += str_pd;
							}
		    		)*
		    	{
		    		result += " ) ";
		    	}
		 )
		 (	throwsClause)?
	;

throwsClause
	:	#( "throws" (classOrInterfaceType)* )
	;

identifier returns [String result = ""]
{
	String str_id = "";
}
	:	id:IDENT
			{
				result = id.getText(); 
			}
	|	#( 	do_:DOT
			str_id = identifier
			id2:IDENT
				{
					result = str_id + do_.getText() + id2.getText();
				}
		)
	;

identifierStar returns [String result = ""]
{
	String str_id = ""; 
}
	:	id:IDENT
			{
				result = id.getText(); 
			}
	|	#( 	do_:DOT
			str_id = identifier
				(	st:STAR
						{
							result = str_id + do_.getText() + st.getText(); 
						}
				|	id2:IDENT
						{	
							result = str_id + do_.getText() + id2.getText();
						}
				)
		)
	;

slist
{
	isCtorCall = false;
}
	:	#( SLIST (stat)* )
	;

stat 
{ 
	String str_exp = ""; 
}
	:	typeDefinition
	|	variableDef
	|	expression
	|	#(	LABELED_STAT
			IDENT
			stat
		)
	|	#(	"if" 
				{	// set loging since expressions are boolean
					setLogging(); 
				}
			expression
				{
					unsetLogging();
				}
			stat			
				{
					unsetLogging();
				}
			(stat)? 
		)
	|	#(	"for"
			(
				#(FOR_INIT ((variableDef)+ | elist)?)
				#(FOR_CONDITION
					(	{	
							// set loging since expressions are boolean
							setLogging(); 
						}
						expression
					)?
					{
						unsetLogging(); 
					}
				)
				#(FOR_ITERATOR (elist)?)
			|
				#(FOR_EACH_CLAUSE parameterDef expression)
			)
			stat
		)
	|	#(	"while"
				{	// set loging since expressions are boolean
					setLogging(); 
				}
			expression
				{	// set loging since expressions are boolean 
					unsetLogging(); 
				}
			stat
		)
	|	#(	"do"
			stat
				{ 	// set loging since expressions are boolean
					setLogging(); 
				}
			expression)
				{
					unsetLogging();
				}
	|	#(	"break" (IDENT)? )
	|	#(	"continue" (IDENT)? )
	|	#(	"return" (expression)? )
	|	#(	"switch"
				{
					symbolCount++;
					astFactory.addASTChild(currentAST, #([IDENT, String.valueOf(symbolCount)]));
				}
			str_exp = expression
				{
					astFactory.addASTChild(currentAST, #([IDENT, str_exp]));
					astFactory.addASTChild(currentAST, #([IDENT, "w"]));
				}
			(caseGroup[str_exp])*
		)
	|	#(	"throw" expression)
	|	#(	"synchronized" expression stat)
	|	tryBlock
	|	slist // nested SLIST
	|	#(	"assert" expression (expression)?)
	|	EMPTY_STAT
	;

caseGroup [String s]
{	
	String str_exp = ""; 
	String t = "";
}
	:	#(	cg:CASE_GROUP
			
			(#(		ca:"case"
					t = exp:expression
						{
							str_exp += "case: " + t + " ";
						}
  			  )
			  | 	de:"default"
						{
							str_exp = "case default";
						}
			)+
				{
					// instrumentating case group
					symbolCount++;
					astFactory.addASTChild(currentAST, #([IDENT, String.valueOf(symbolCount)]));
					astFactory.addASTChild(currentAST, #([IDENT, str_exp]));
					astFactory.addASTChild(currentAST, #([IDENT, "s"]));
				}
			sl:slist
		)
	;

tryBlock
	:	#( "try" slist (handler)* (#("finally" slist))? )
	;

handler
	:	#( "catch" parameterDef slist )
	;

elist returns [String result = ""]
	{ String str_expr = ""; }
	:	#( 	ELIST 
				{
					unsetLogging(); 
				}
			(
				str_expr = expression
					{
						result += str_expr + ", ";
					}
			)* 
			{ 	
				if (result.length() > 2) // remove the trailing comma
					result = result.substring(0, result.length() - 2); 
				resetLogging();	
			}
		)
	;

expression returns [String result = ""]
	:	!#(	exp1:EXPR
			result = exp2:expr
				{	
					// overall boolean expressions are descition expressions 
					## = instrDecitionExpression(#exp1, #exp2, result); 
				}
		)
	;

expr returns [String result = ""]
	:	result = conditionalExpr
	|	#(	ASSIGN	
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					unsetLogging(); 
				}
		)			// binary operators...
	|	#(	PLUS_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	MINUS_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	STAR_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	DIV_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging();
				}
		)
	|	#(	MOD_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	SR_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	BSR_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	SL_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{ 
					resetLogging(); 
				}
		)
	|	#(	BAND_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	BXOR_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{
					resetLogging(); 
				}
		)
	|	#(	BOR_ASSIGN
				{ 	
					// disable logging since the expressions are not boolean	
					unsetLogging(); 
				}
			expr
			expr
				{ 
					resetLogging(); 
				}
		)
	;

conditionalExpr returns [String result = ""]
{ 	
	String str_right = "";
	String str_left = ""; 
	String str_middle = "";
}
	:	!#(	que:QUESTION
				 {
					setLogging();
				 }
			str_left = que_left:expr
				 {
				 	unsetLogging();
				 } 
			str_middle = que_middle:expr
				 {
				 	unsetLogging();
				 } 
			str_right = que_right:expr
				{ 	
					result = str_left + " " + que.getText() + " " + str_middle + " : " + str_right ; 
					## = instrTrinaryExpression(#que, #que_left, #que_middle, #que_right, result);
				}
		)	// trinary operator
	|	!#(	lor:LOR
			str_left = lor_left:expr
			str_right = lor_right:expr
				{ 	
					result = str_left + " " + lor.getText() + " " + str_right;
					## = instrBinaryExpression(#lor, #lor_left, #lor_right, result, "c");
				}
		)
	|	!#( land:LAND
			str_left = land_left:expr
			str_right = land_right:expr
				{ 	
					result = str_left + " " + land.getText() + " " + str_right;
					## = instrBinaryExpression(#land, #land_left, #land_right, result, "c");
				}
		)
	|	#(	bo:BOR
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + bo.getText() + " " + str_right;
				}
		)
	|	#(	bx:BXOR
			str_left = expr
			str_right = expr
			{ result = str_left + " " + bx.getText() + " " + str_right; }
		)
	|	#(	ba:BAND
			str_left = expr
			str_right = expr
			{ result = str_left + " " + ba.getText() + " " + str_right; }
		)
	|	!#(	n_equal:NOT_EQUAL 
			str_left = n_equal_left:expr 
			str_right = n_equal_right:expr
				{ 	
					setLogging();
					result = str_left + " " + n_equal.getText() + " " + str_right;
					## = instrBinaryExpression(#n_equal, #n_equal_left, #n_equal_right, result, "a");
				}
		)
	|	!#(	equal:EQUAL 
			str_left = equal_left:expr 
			str_right = equal_right:expr
				{ 	
					setLogging();
					result = "( " + str_left + " " + equal.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#equal, #equal_left, #equal_right, result, "a");
				}
		)
	|	!#(	lt:LT
				{ 
					// disable logging since the expressions are not boolean	
					unsetLogging();
				}	
			str_left = lt_left:expr str_right = lt_right:expr
				{ 	
					setLogging();				
					result = "( " + str_left + " " + lt.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#lt, #lt_left, #lt_right, result, "a");
				}
		)
	|	!#(	gt:GT 
				{ 
					// disable logging since the expressions are not boolean	
					unsetLogging();
				}	
			str_left = gt_left:expr str_right = gt_right:expr
				{ 		
					setLogging();				
					result = "( " + str_left + " " + gt.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#gt, #gt_left, #gt_right, result, "a");
				}
		)
	|	!#(	le:LE 
				{ 
					// disable logging since the expressions are not boolean	
					unsetLogging();
				}	
			str_left = le_left:expr str_right = le_right:expr
				{ 		
					setLogging();				
					result = "( " + str_left + " " + le.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#le, #le_left, #le_right, result, "a");
				}
		)
	|	!#(	ge:GE
				{ 
					// disable logging since the expressions are not boolean	
					unsetLogging();
				}	
			str_left = ge_left:expr str_right = ge_right:expr
				{ 		
					setLogging();				
					result = "( " + str_left + " " + ge.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#ge, #ge_left, #ge_right, result, "a");
				}
		)
	|	#(	sl_:SL
				{
					unsetLogging();
				}
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + sl_.getText() + " " + str_right; 
					resetLogging();
				}
		)	
	|	#(	sr_:SR
				{
					unsetLogging();
				}
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + sr_.getText() + " " + str_right;
					resetLogging();
				}
		)
	|	#(	bsr_:BSR
				{
					unsetLogging();
				}
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + bsr_.getText() + " " + str_right; 
					resetLogging();
				}
		)
	|	#(	pl:PLUS
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + pl.getText() + " " + str_right; 
				}
		)
	|	#(	mi:MINUS
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + mi.getText() + " " + str_right;
				}
		)
	|	#(	di:DIV
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + di.getText() + " " + str_right;
				}
		)
	|	#(	mo:MOD
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + mo.getText() + " " + str_right; 
				}
		)
	|	#(	st:STAR
			str_left = expr
			str_right = expr
				{
					result = str_left + " " + st.getText() + " " + str_right; 
				}
		)
	|	#(	in:INC
			str_right = expr
				{
					result = in.getText() + str_right; 
				}
		)
	|	#(	de:DEC
			str_right = expr
				{
					result = de.getText() + str_right; 
				}
		)
	|	#(	poi:POST_INC
			str_left = expr
				{
					result = str_left + poi.getText(); 
				}
		)
	|	#(	pod:POST_DEC
			str_left = expr
				{
					result = str_left + pod.getText(); 
				}
		)
	|	#(	bn:BNOT expr)
	|	!#(	lnot:LNOT str_right = lnot_right:expr
				{ 	
					result = "( " + lnot.getText() + str_right + " )";
					## = instrUnaryExpression(#lnot, #lnot_right, result);
				}
		)
	|	!#(	io:"instanceof"
				{ 
					// disable logging since the expressions are not boolean	
					unsetLogging();
				}	
			str_left = io_left:expr str_right = io_right:expr
				{ 		
					setLogging();
					result = "( " + str_left + " " + io.getText() + " " + str_right + " )";
					## = instrBinaryExpression(#io, #io_left, #io_right, result, "a");
				}
		)
	|	#(	um:UNARY_MINUS
			str_right = expr
			{ 
				result = um.getText() + " " + str_right; 
			}
		)
	|	#(	up:UNARY_PLUS
			str_right = expr
			{ 
				result = str_left + " " + up.getText() + " " + str_right; 
			}
	)
	|	!result = pe:primaryExpression
			{
				if ( checkBoolean(result) ) {
					## = instrPrimaryExpression(##, #pe, result); 
				} else {
					## = #(##, pe);
				}
			}
	;

primaryExpression returns [String result = ""]
	{ 	String str_expr = ""; 
		String str_pe = "";
		String str_ta = "";
		String str_elist = "";
	}
	:	id:IDENT
			{ 	
				result = id.getText(); 
			}
	|	#(	dot:DOT
			(	str_expr = expr
				(	id2:IDENT
						{
							result = str_expr + dot.getText() + id2.getText();
						}
				|		{
							unsetLogging(); // disable logging since we don't want the arrayIndex
						}
					result = arrayIndex
						{ 
							resetLogging(); 
						}
				|	"this"
				|	"class"
				|	newExpression
				|	"super"
				|	(typeArguments)? // for generic methods calls
				)
			|	#(ARRAY_DECLARATOR typeSpecArray)
			|	builtInType ("class")?
			)
		)
	|		{
				unsetLogging();  // disable logging since we don't want the arrayIndex
			}
		result = arrayIndex
			{
				resetLogging(); 
			}
	|	#(	METHOD_CALL
			str_pe = primaryExpression 
			(	
				str_ta = typeArguments
			)?
			str_elist = elist
				{
					int p = str_pe.indexOf ( "." );
					String t = null;
					String q;

					if ( p > 0 ) {
						q = str_pe.substring( 0, p );
						t = getType( q );
					} else {
						q = str_pe;
						t = getType( q );
					}
					
					System.out.println("getType(): q " + q + ":" + t );

						if ( t != null ) { 
							Vector v = getClasses ( t );
	
							System.out.println( v );
	
							if ( v != null && v.size() > 0 ) {
								symbolCount++;
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,q))));
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"v"))));
	
								for ( int i = 0; i < v.size(); i++ ) {							
									symbolCount++;
									ExtendedClass e = ( ExtendedClass ) v.get( i );
						
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,e.getThisClass().getName()))));
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"i"))));
								}
							}
											
						// System.out.println( s + ":" + t + ":" + getSubClasses ( t ) );
						}
					
					result = str_pe + "(" + str_elist + ")"; 
				}		
		)
	|	ctorCall
			{
				isCtorCall = true;
			}
	|	#(TYPECAST typeSpec expr)
	|	newExpression
	|	result = constant
	|	su:"super"
			{
				result = su.getText();
			}
	|	tr:"true"
			{	
				result = tr.getText();
			}
	|	fa:"false"
			{	
				result = fa.getText();
			}
	|	th:"this"
			{
				result = th.getText();
			}
	|	nu:"null"
			{
				result = nu.getText();
			}
	|	typeSpec // type name used with instanceof
	;

ctorCall
	:	#( CTOR_CALL elist )
	|	#( SUPER_CTOR_CALL
			(	elist
			|	primaryExpression elist
			)
		 )
	;

arrayIndex returns [String result = ""]
{ 
	String str_exp1 = ""; 
	String str_exp2 = "";
}
	:	#(INDEX_OP
			str_exp1 = expr
			str_exp2 = expression
			{
				result = str_exp1 + "[" + str_exp2 + "]"; 
			}
		)
	;

constant returns [String result = ""]
	:	in:NUM_INT
			{
				result = in.getText();
			}
	|	ch:CHAR_LITERAL
			{ 	
				result = ch.getText(); 
//				## = instrPrimaryExpression(##, #ch, result); 			
			}
	|	str:STRING_LITERAL
			{ 	
				result = str.getText(); 
//				## = instrPrimaryExpression(##, #str, result); 					
			}
	|	fl:NUM_FLOAT
			{
				result = fl.getText(); 
			}
	|	dou:NUM_DOUBLE
			{	
				result = dou.getText();
			}
	|	lo:NUM_LONG
			{
				result = lo.getText();
			}
	;

newExpression returns [String result = ""]
	:	#(	"new" (typeArguments)? type
			(	newArrayDeclarator (arrayInitializer)?
			|	elist (objBlock)?
			)
		)

	;

newArrayDeclarator
	:	#( ARRAY_DECLARATOR (newArrayDeclarator)? (expression)? )
	;
