header {
package de.fau.cs.swe.sa.dynamicdataflowanalysis.instrumentation; 

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Stack;
}
/** Java 1.3 AST Recognizer Grammar
 *
 * Author: (see java.g preamble)
 *
 * This grammar is in the PUBLIC DOMAIN
 */

class JavaTreeInstrumentator extends TreeParser;

options {
	importVocab = Java;
    ASTLabelType = JavaAST;
    buildAST = true;
}
{
    static final int CONSTANT = 1;
    static final int RETURN_TEMPS = 2;
    static final int RETURN_HELPER_CLASSES = 4;
    static final int RETURN_HELPER_METHODS = 8;
    static final int INTEGRATED_BLOCK = 16;

    static final TypeNodeContext RET_DEFAULT = Resolver.NULLTYPE; // this type is never possible for casts

    private boolean valid = true;

    private PrintWriter logfile = new PrintWriter(System.out); // default output    

    String sourceFile = "<n/a>";
    
    public JavaTreeInstrumentator(OutputStream o, String sourceFile){
        this();
        setLog(o);
        this.sourceFile = sourceFile;
    }

    public JavaTreeInstrumentator(Writer o, String sourceFile){
        this();
        setLog(o);
        this.sourceFile = sourceFile;
    }

    public void setLog(OutputStream o){
        logfile = new PrintWriter(o);
    }

    public void setLog(Writer o){
        logfile = new PrintWriter(o);
    }



    private boolean end(Object o){
        if(!(o == null ||  o instanceof antlr.ASTNULLType))
           System.out.println("Unexpected Node: " + o);
        return o == null || o instanceof antlr.ASTNULLType;
    }

    public void reportError(RecognitionException ex) {
        valid = false;
        ex.printStackTrace(System.out);
    }

    public boolean isValid(){
        return valid;
    }

    void log(int pos, String type, JavaAST node, String staticInfo){
        if(Verbose.log)
            System.out.println("log: 0x" + Integer.toHexString(pos) + 
                               " " + type +
                               " " + (node.hasNodeContext() ? "\"" + node.getNodeContext().getCName() + "\"" : "-") + 
                               " " + staticInfo + 
                               " " + sourceFile +
                               " " + node.getLine() +
                               " " + node.getColumn() +
                               " | " + node);

        logfile.println(Integer.toHexString(pos) + 
                        "\t" + type +
                        "\t" + (node.hasNodeContext() ? node.getNodeContext().getCName() : "-") + 
                        "\t" + staticInfo +
                        "\t" + sourceFile +
                        "\t" + node.getLine() +
                        "\t" + node.getColumn());
        logfile.flush();
    }


    static int temporaryCounter = 1;
    static int posCounter = 1;

    static final boolean TRACK_CONSTANT_VARS=false; // FIXME: MAKE CONFIGURABLE
    static final boolean EXPLICIT_ZERO_INIT=true;

    static void reset(){
        temporaryCounter = 1;
        posCounter = 1;
    }

    String __getTempName(){
        return "___t"+temporaryCounter++;
    }

    int getPos(){
        return posCounter++;
    }

    JavaAST __cld(AST tree){
        if((tree != null) && (((JavaAST)tree).getFirstChild() != null)) 
            return ((JavaAST)tree.getFirstChild()).copy();
        else
            return null;
    }

    JavaAST __merge(JavaAST a, JavaAST b){
        return (a == null && b == null) ? null : #(#[SLIST], __cld(a), __cld(b));
    }

    JavaAST __addChild(JavaAST list, JavaAST child){
        return (child == null) ? list : (list == null) ? #(#[SLIST], child) : #(__copyNode(list), __cld(list), child);
    }

    // Avoid aliasing: if the same AST is to be inserted at several places use __copyTree()
    JavaAST __copyTree(JavaAST tree){
        return tree == null ? tree : tree.copyTree();
    }

    JavaAST __copyNode(JavaAST node){
        return node == null ? node : node.copyNode();
    }

    JavaAST __rtPackage(){
        return #(#[DOT],
                 #(#[DOT],
                   #(#[DOT],
                     #(#[DOT],
                       #(#[DOT],
                         #(#[DOT],
                           #[IDENT, "de"],
                           #[IDENT, "fau"]),
                         #[IDENT, "cs"]),
                       #[IDENT, "swe"]),
                     #[IDENT, "sa"]),
                   #[IDENT, "dynamicdataflowanalysis"]),
                 #[IDENT, "rt"]);
        
    }
    // gibt einen Baum mit dem voll qualifizierten Namen von DULog zurck
    JavaAST __fqDULog(){
        return #(#[DOT],
                 __rtPackage(),
                 #[IDENT, "DULog"]);
    }

    boolean __isMarkerPresent(TypeNodeContext type){
        boolean markerFound = false;
        Class[] interfaces = type.getRClass().getInterfaces();

        for(int i=0; i<interfaces.length; i++)
            markerFound |=interfaces[i].getName().equals("de.fau.cs.swe.sa.dynamicdataflowanalysis.rt.InstanceId");

        return markerFound;
    }

    JavaAST __instanceIdMarker(){
        return #(#[DOT], __rtPackage(), #[IDENT, "InstanceId"]);
    }

    JavaAST __instanceIdMethod(){
        return #(#[METHOD_DEF],
                 #(#[MODIFIERS], #[LITERAL_public,"public"], #[FINAL,"final"]),
                 #(#[TYPE], #[LITERAL_int,"int"]),
                 #[IDENT, "___getInstanceId"],
                 #[PARAMETERS],
                 #(#[SLIST],
                   #(#[LITERAL_return,"return"], #(#[EXPR], #[IDENT, "___instanceId"]))));
    }

    JavaAST __instanceIdField(){
        return #(#[VARIABLE_DEF], #(#[MODIFIERS], #[LITERAL_public,"public"], #[FINAL,"final"]),
                 #(#[TYPE], #[LITERAL_int,"int"]), #[IDENT, "___instanceId"],
                 #(#[ASSIGN,"="],
                   #(#[EXPR],
                     #(#[METHOD_CALL],
                       #(#[DOT], __fqDULog(), #[IDENT, "getNewInstanceId"]),
                       #(#[ELIST], #(#[EXPR], #[NUM_INT, "0"]))))));
    }

    JavaAST __explicitZeroInitCall(InitFrames initFrame){
        return #(#[INSTANCE_INIT],
                 __createFrame(initFrame.enter(),
                               initFrame.leave(),
                               #(#[SLIST],
                                 #(#[EXPR],
                                   #(#[METHOD_CALL],
                                     #[IDENT, "___doZeroInit"],
                                     #[ELIST])))));
    }

    JavaAST __explicitClassZeroInitCall(InitFrames initFrame){
        return #(#[STATIC_INIT],
                 __createFrame(initFrame.staticEnter(),
                               initFrame.staticLeave(),
                               #(#[SLIST],
                                 #(#[EXPR],
                                   #(#[METHOD_CALL],
                                     #[IDENT, "___doStaticZeroInit"],
                                     #[ELIST])))));
    }

    JavaAST __explicitZeroInitSuperCall(){
        return #(#[EXPR],
                 #(#[METHOD_CALL],
                   #(#[DOT],
                     #[LITERAL_super, "super"],
                     #[IDENT, "___doZeroInit"]),
                   #[ELIST]));
    }

    JavaAST __explicitZeroInitField(JavaAST vd){
        if(EXPLICIT_ZERO_INIT)
            return __defField(vd, #[LITERAL_this,"this"]);
        else
            return null;
    }

    JavaAST __explicitZeroInitStatic(JavaAST vd){
        if(EXPLICIT_ZERO_INIT)
            return __defStatic(vd);
        else
            return null;
    }

    JavaAST __zeroInitMethod(JavaAST body){
        if(EXPLICIT_ZERO_INIT)
            return #(#[METHOD_DEF],
                     #(#[MODIFIERS], #[LITERAL_public,"protected"]),
                     #(#[TYPE], #[LITERAL_void,"void"]),
                     #[IDENT, "___doZeroInit"],
                     #[PARAMETERS],
                     body);
        else
            return null;
    }

    JavaAST __staticZeroInitMethod(JavaAST body){
        if(EXPLICIT_ZERO_INIT)
            return #(#[METHOD_DEF],
                     #(#[MODIFIERS], #[LITERAL_public,"protected"], #[LITERAL_static, "static"]),
                     #(#[TYPE], #[LITERAL_void,"void"]),
                     #[IDENT, "___doStaticZeroInit"],
                     #[PARAMETERS],
                     body);
        else
            return null;
    }


    JavaAST __createFrame(JavaAST enter, JavaAST leave, JavaAST body){
        return #(#[SLIST],
                 #(#[EXPR],
                   enter),
                 #(#[LITERAL_try,"try"],
                   #body,
                   #(#[LITERAL_finally,"finally"], 
                     #(#[SLIST],
                       #(#[EXPR],
                         leave)))));
    }


    boolean __isPlainAssign(JavaAST op){
        return op.getType() == ASSIGN;
    }

    JavaAST __getAOp(JavaAST op){ // cut "ASSIGN" away
        switch(op.getType()){
        case PLUS_ASSIGN:   return #[PLUS,"+"];
        case MINUS_ASSIGN:  return #[MINUS,"-"];
        case STAR_ASSIGN:   return #[STAR,"*"];
        case DIV_ASSIGN:    return #[DIV,"/"];
        case MOD_ASSIGN:    return #[MOD,"%"];
        case SR_ASSIGN:     return #[SR,">>"];
        case BSR_ASSIGN:    return #[BSR,">>>"];
        case SL_ASSIGN:     return #[SL,"<<"];
        case BAND_ASSIGN:   return #[BAND,"&"];
        case BXOR_ASSIGN:   return #[BXOR,"^"];
        case BOR_ASSIGN:    return #[BOR,"|"];
        default:
            new Exception("Unexpected op in <op>= assignment").printStackTrace();
            valid = false;
            return null;
        }
    }

    // #(PARAMETERS ........) --> String
    String __listParameters(JavaAST params){
        if(params == null || params.getType() != PARAMETERS){
            new Exception("Unexpected Node " + params + " in listParameters.").printStackTrace();
            valid=false;
            return null;
        }

        String res = "";

        for(JavaAST currentParameter = (JavaAST)params.getFirstChild();
            currentParameter != null;
            currentParameter = (JavaAST)currentParameter.getNextSibling())

            res += currentParameter.getNodeContext().getCName() + (currentParameter.getNextSibling() != null ? "#" : "");

        return res;
    }

    JavaAST __getType(TypeNodeContext type){
        if(type.isArray())
            return #(#[ARRAY_DECLARATOR], __getType(type.getComponentType()));
        else{
            String name = type.getDBName();// simplified: no distinct ASTtype for primitives
            return #[IDENT, name];
        }
        
    }

    JavaAST __logCall(String name, TypeNodeContext castTo, JavaAST parameters){
        String logMarkerName = "-->" + name; // for AST tree
        JavaAST call = #(#[METHOD_CALL, "<INSTR-CALL>"], #(#[DOT, logMarkerName], __fqDULog(), #[IDENT, name]), #(#[ELIST], __cld(parameters)));

        if(castTo != null /*&& !castTo.isPrimitive()*/) // FIXME: disabled for testing
            call = #(#[TYPECAST,"<INSTR-CAST>"], #(#[TYPE], __getType(castTo)), call);

        return call;
    }

    //__retType extension: diff explicit & default -- no change if explicit == default && primitive
    TypeNodeContext __retType(TypeNodeContext explicit, TypeNodeContext defaultType){
        if(explicit == RET_DEFAULT)
            return defaultType;
        else
            return explicit;
    }

    TypeNodeContext __retType(TypeNodeContext explicit, JavaAST defaultTypeNode){
        if(explicit == RET_DEFAULT)
            return defaultTypeNode.getNodeContext().getRType();
        else
            return explicit;
    }

    JavaAST __pos(String type, JavaAST node, String staticInfo){
        int pos = getPos();
        log(pos, type, node, staticInfo);
        return #[NUM_INT, Integer.toString(pos)];
    }

    JavaAST __pos(String type, JavaAST node){
        return __pos(type, node, "");
    }

    JavaAST __qualifiedThis(TypeNodeContext ctx){
	TypeNodeContext[] classes = (TypeNodeContext[]) classStack.toArray(new TypeNodeContext[0]);
	for(int i=classes.length-1; i>=0; i--)
	    for(TypeNodeContext cls = classes[i]; cls != null; cls=cls.getSuperclass())
		if(cls.equals(ctx.getRType()))
		    return #(#[DOT], __getType(classes[i]), #[LITERAL_this,"this"]);

	System.err.println("Notice: unable to find corresponding type for 'this' reference ("+ ctx + ")");
	return  #[LITERAL_this,"this"];
    }

    JavaAST __defineVariable(TypeNodeContext type, String name){
        return #(#[VARIABLE_DEF], #[MODIFIERS], #(#[TYPE],__getType(type)), #[IDENT, name]);
    }

    JavaAST __bin(JavaAST r, TypeNodeContext ret, JavaAST first, JavaAST second){
        TypeNodeContext retType = r.getNodeContext().getRType();
        return __logCall("bin", __retType(ret, r), #(#[ELIST], #(#[EXPR], first), #(#[EXPR], second)));
    }
    
    JavaAST __cp(JavaAST r){
        return __logCall("cp", null, #(#[ELIST], #(#[EXPR], __pos("cp", r))));
    }
    JavaAST __cp(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("cp", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("cp", r)), #(#[EXPR], exp)));
    }

    JavaAST __ctorEnter(JavaAST r, JavaAST parameters){
        return __logCall("enter"            , null, #(#[ELIST], #(#[EXPR], __pos("ctorEnter", r, __listParameters(parameters)))));
    }
    JavaAST __ctorLeave(JavaAST r){
        return __logCall("leave"            , null, #(#[ELIST], #(#[EXPR], __pos("ctorLeave", r))));
    }
    JavaAST __earlyCtorEnter(JavaAST r, JavaAST parameters){
        return __logCall("earlyCtorEnter"   , null, #(#[ELIST], #(#[EXPR], __pos("earlyCtorEnter", r, __listParameters(parameters)))));
    }
    JavaAST __methodEnter(JavaAST r, JavaAST parameters){
        return __logCall("enter"            , null, #(#[ELIST], #(#[EXPR], __pos("enter", r, __listParameters(parameters)))));
    }
    JavaAST __methodLeave(JavaAST r){return __logCall("leave"            , null, #(#[ELIST], #(#[EXPR], __pos("leave", r))));
    }
    JavaAST __exceptHandlerCall(JavaAST r){
        return __logCall("exceptHandlerCall", null, #(#[ELIST], #(#[EXPR], __pos("exceptHandlerCall", r))));
    }

    JavaAST __newArray(JavaAST r, TypeNodeContext ret, JavaAST array){
         TypeNodeContext retType = __retType(ret, r);

         int level = 0;
         for(TypeNodeContext componentType = retType ; componentType.isArray() ; componentType = componentType.getComponentType())
             level++;
         
         return __logCall("newArray", retType, #(#[ELIST],
                                                 #(#[EXPR], __pos("newArray", r)),
                                                 #(#[EXPR], #[NUM_INT, Integer.toString(level)]),
                                                 #(#[EXPR], array)));
    }

    // newCallCompleted(p1, newCall(p2), new ...)
    JavaAST __newClass(JavaAST r, TypeNodeContext ret, JavaAST exp){
        TypeNodeContext retType = __retType(ret, r);
        JavaAST newCall = __logCall("newCall", null, #(#[ELIST], #(#[EXPR], __pos("newCall", r))));
        return __logCall("newCallCompleted", retType, #(#[ELIST],
                                               #(#[EXPR], __pos("newCallCompleted", r)),
                                               #(#[EXPR], newCall),
                                               #(#[EXPR], exp)));
    }

    // newCallCompleted(p1, ((Type)newCall(p2, lhs)).new ...)
    JavaAST __newClass(JavaAST r, TypeNodeContext ret, JavaAST lhs, TypeNodeContext lhsType, JavaAST exp){
        TypeNodeContext retType = __retType(ret, r);
        JavaAST newCall = __logCall("newCall", lhsType, #(#[ELIST],
                                                          #(#[EXPR], __pos("newCall", r)),
                                                          #(#[EXPR], lhs)));
        return __logCall("newCallCompleted", retType, #(#[ELIST],
                                               #(#[EXPR], __pos("newCallCompleted", r)),
                                               #(#[EXPR], #(#[DOT], newCall, exp))));
    }

    JavaAST __defArray(JavaAST r, TypeNodeContext ret, JavaAST array, JavaAST index, JavaAST value){
	TypeNodeContext componentType = r.getNodeContext().getRType().getComponentType();
        TypeNodeContext retType = __retType(ret, componentType);
        return __logCall("defArray", retType, 
	    #(#[ELIST],
	      #(#[EXPR],__pos("defArray", r)),
	      #(#[EXPR], array),
	      #(#[EXPR], index),
	      #(#[EXPR],
		#(#[TYPECAST,"<INSTR-CAST-DEF_ARRAY>"],
		  #(#[TYPE], __getType(componentType)),
		  value))));
    }
    JavaAST __useArray(JavaAST r, TypeNodeContext ret, JavaAST array, JavaAST index){
        TypeNodeContext retType = __retType(ret, r.getNodeContext().getRType().getComponentType());
        return __logCall("useArray", retType, #(#[ELIST], #(#[EXPR], __pos("useArray", r)), #(#[EXPR], array), #(#[EXPR], index)));
    }
    JavaAST __useArrayLength(JavaAST r, JavaAST array){
        return __logCall("useArrayLength", null, #(#[ELIST], #(#[EXPR], __pos("useArrayLength", r)), #(#[EXPR], array)));
    }
    JavaAST __incDecArrayOp(JavaAST r, TypeNodeContext ret, JavaAST op, JavaAST array, JavaAST index){
        TypeNodeContext retType = __retType(ret, r.getNodeContext().getRType().getComponentType());
        String arrayOpFunc = "<invalid>";

        switch(op.getType()){
        case INC:      arrayOpFunc = "preIncArray";  break;
        case DEC:      arrayOpFunc = "preDecArray";  break;
        case POST_INC: arrayOpFunc = "postIncArray"; break;
        case POST_DEC: arrayOpFunc = "postDecArray"; break;
        }

        return  __logCall(arrayOpFunc, retType, #(#[ELIST], #(#[EXPR], __pos("useDefArray", r)), #(#[EXPR], array), #(#[EXPR], index)));
    }

    JavaAST __defField(JavaAST r, TypeNodeContext ret, JavaAST instance, JavaAST exp){
        return __logCall("defField", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("defField", r)), #(#[EXPR], instance), #(#[EXPR], exp)));
    }
    JavaAST __defField(JavaAST r, JavaAST instance){
        return __logCall("defField", null, #(#[ELIST], #(#[EXPR], __pos("defField", r)), #(#[EXPR], instance)));
    }
    JavaAST __useField(JavaAST r, TypeNodeContext ret, JavaAST instance, JavaAST exp){
        return __logCall("useField", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useField", r)), #(#[EXPR], instance), #(#[EXPR], exp)));
    }
    JavaAST __useField(JavaAST r, JavaAST instance){
        return __logCall("useField", null, #(#[ELIST], #(#[EXPR], __pos("useField", r)), #(#[EXPR], instance)));
    }
    JavaAST __useDefField(JavaAST r, TypeNodeContext ret, JavaAST instance, JavaAST exp){
        return __logCall("useDefField", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useDefField", r)), #(#[EXPR], instance), #(#[EXPR], exp)));
    }
    JavaAST __useFieldContained(JavaAST r, TypeNodeContext ret, JavaAST instance){
        TypeNodeContext retType = __retType(ret, r);
        return __logCall("useField", retType, #(#[ELIST], #(#[EXPR], __pos("useField", r)), #(#[EXPR], instance)));
    }
    

    JavaAST __defStatic(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("defStatic", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("defStatic", r)), #(#[EXPR], exp)));
    }
    JavaAST __defStatic(JavaAST r){
        return __logCall("defStatic", null, #(#[ELIST], #(#[EXPR], __pos("defStatic", r))));
    }
    JavaAST __useStatic(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("useStatic", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useStatic", r)), #(#[EXPR], exp)));
    }
    JavaAST __useStatic(JavaAST r){
        return __logCall("useStatic", null, #(#[ELIST], #(#[EXPR], __pos("useStatic", r))));
    }
    JavaAST __useDefStatic(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("useDefStatic", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useDefStatic", r)), #(#[EXPR], exp)));
    }

    JavaAST __defLocal(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("defLocal", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("defLocal", r)), #(#[EXPR], exp)));
    }
    JavaAST __defLocal(JavaAST r){
        return __logCall("defLocal", null, #(#[ELIST], #(#[EXPR], __pos("defLocal", r))));
    }
    JavaAST __useLocal(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("useLocal", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useLocal", r)), #(#[EXPR], exp)));
    }
    JavaAST __useLocal(JavaAST r){
        return __logCall("useLocal", null, #(#[ELIST], #(#[EXPR], __pos("useLocal", r))));
    }
    JavaAST __useDefLocal(JavaAST r, TypeNodeContext ret, JavaAST exp){
        return __logCall("useDefLocal", __retType(ret, r), #(#[ELIST], #(#[EXPR], __pos("useDefLocal", r)), #(#[EXPR], exp)));
    }

    JavaAST __pUse(JavaAST r, JavaAST exp, boolean isConstant){
	if(isConstant)
	    return exp;

        JavaAST newPUse = __logCall("newPredicate", null, #(#[ELIST], #(#[EXPR], __pos("newPredicate", r))));
        return __logCall("predResult", null, #(#[ELIST], 
                                               #(#[EXPR], __pos("predResult", r)),
                                               #(#[EXPR], newPUse),
                                               #(#[EXPR], exp)));
    }

    JavaAST __switchPUse(JavaAST r, JavaAST exp){
        JavaAST newSwitchPUse = __logCall("newSwitchPredicate", null, #(#[ELIST], #(#[EXPR], __pos("newSwitchPredicate", r))));
        return __logCall("switchPredResult", null, #(#[ELIST], 
                                                     #(#[EXPR], __pos("switchPredResult", r)),
                                                     #(#[EXPR], newSwitchPUse), 
                                                     #(#[EXPR], exp)));
    }
    JavaAST __switchPUseEquivalent(JavaAST r, int equivalenceClass){
        return __logCall("switchPredEquivalent", null, #(#[ELIST], 
                                                         #(#[EXPR], __pos("switchPredEquivalent", r, Integer.toHexString(equivalenceClass))),
                                                         #(#[EXPR], #[NUM_INT, Integer.toString(equivalenceClass)])));
    }

    class InitFrames{
        JavaAST enterPos, leavePos, clEnterPos, clLeavePos;
        boolean first = true, firstStatic = true;
        InitFrames(JavaAST ob){
            enterPos = __pos("initEnter", ob);
            leavePos = __pos("initLeave", ob);
            clEnterPos = __pos("clinitEnter", ob);
            clLeavePos = __pos("clinitLeave", ob);
        }

        JavaAST staticEnter(){
            if(firstStatic){
                firstStatic = false;
                return __logCall("enterSInit", null, #(#[ELIST], #(#[EXPR], clEnterPos)));
            } else
                return __logCall("reenterSInit", null, #(#[ELIST],#(#[EXPR], clLeavePos)));
        }

        JavaAST staticLeave(){
            return __logCall("leaveSInit", null, #(#[ELIST], #(#[EXPR], clLeavePos)));
        }

        JavaAST clinitCompleted(){
            return __logCall("sInitCompleted", null, #(#[ELIST], #(#[EXPR], clLeavePos)));
        }

        JavaAST enter(){
            if(first){
                first  = false;
                return __logCall("enterInit", null, #(#[ELIST], #(#[EXPR], enterPos)));
            } else
                return __logCall("reenterInit", null, #(#[ELIST], #(#[EXPR], leavePos)));
        }

        JavaAST leave(){
            return __logCall("leaveInit", null, #(#[ELIST], #(#[EXPR], leavePos)));
        }

        JavaAST initCompleted(){
            return __logCall("initCompleted", null, #(#[ELIST], #(#[EXPR], leavePos)));
        }
    }


    // Hack for correct "this" reference -- 
    private Stack classStack = new Stack();

    private void stackPop(){
	classStack.pop();
    }
    private void stackPush(TypeNodeContext cls){
	classStack.push(cls);
    }
}
////////////////////////////////////////////////////////////////////////////////
compilationUnit
	:	(packageDefinition)? /* NOOP */
		(importDefinition)*  /* NOOP */
		(typeDefinition)*
        {end(_t)}?
	;

typeDefinition // self contained
	:   #(  cd:CLASS_DEF modifiers IDENT extendsClause i:implementsClause objBlock {end(_t)}?)
        {
            // Insert the marker interface to the list of interfaces
            if(((TypeNodeContext)cd.getNodeContext()).getSuperclass().equals(Resolver.OBJECTTYPE)
               && !__isMarkerPresent((TypeNodeContext)cd.getNodeContext()))
                #i.addChild(__instanceIdMarker());
        }
    |   #(  INTERFACE_DEF modifiers IDENT extendsClause interfaceBlock {end(_t)}?)
	;

interfaceBlock // self contained
{JavaAST ret = null, temps = null;}
	:	#(	ob:OBJBLOCK
			(	methodDecl     /* NOOP */
			|	ret = fieldDef_instr[RETURN_HELPER_CLASSES, null] // Do not return helper methods
                { temps = __merge(temps, ret); }
            |	typeDefinition /* inner class */
			)*
            { ## = __addChild(##, __cld(temps)); }
            {end(_t)}?
        )
	;

objBlock // self contained
{
    JavaAST ret = null, temps = null, block = null;
    JavaAST explicitZeroInits = #[SLIST], explicitStaticZeroInits = #[SLIST];
    InitFrames initFrames = null;
    boolean hasStaticFields = false;
}
	:!	#(	ob:OBJBLOCK
            {
                TypeNodeContext objCtx = (TypeNodeContext)#ob_in.getNodeContext();

		stackPush(objCtx); //Hack for this-references

                Field[] fields = objCtx.getRClass().getDeclaredFields();

                for(int i=0; i<fields.length; i++)
                    if(Modifier.isStatic(fields[i].getModifiers()))
                        hasStaticFields = true;

                initFrames = new InitFrames(#ob_in);

                // enable repeated instrumenation for testing purposes -- add id field& method only if not already present
                if(!__isMarkerPresent(objCtx)){

                    if(objCtx.getSuperclass().equals(Resolver.OBJECTTYPE)){
                        // This class is directy inherited from Object. Here is the very first point of access
                        // to the this-reference.

                        block = __addChild(block, __instanceIdField());
                        block = __addChild(block, __instanceIdMethod());
                        if(EXPLICIT_ZERO_INIT){
                            block = __addChild(block, __explicitZeroInitCall(initFrames));
                        }
                    } else {

                        // hack for recursive instrumentation
                        boolean hasUninstrumentedSuperclass = false;

                        for(Class currentClass = objCtx.getRClass().getSuperclass();
                            !currentClass.equals(Object.class);
                            currentClass = currentClass.getSuperclass())
                            if(currentClass.getPackage() != null &&
                               currentClass.getPackage().getName() != null &&
                               currentClass.getPackage().getName().startsWith("java.")) //hack
                                hasUninstrumentedSuperclass = true;


                        if(!hasUninstrumentedSuperclass){
                            // prepend super.___doZeroInit() call.
                            explicitZeroInits  = __addChild(explicitZeroInits, __explicitZeroInitSuperCall());
                        } else {
//                            System.err.println("Notice: class " + objCtx.getBName() + " will not call super.___doZeroInit");
                        }
                    }

                    if(EXPLICIT_ZERO_INIT && hasStaticFields)
                        block = __addChild(block, __explicitClassZeroInitCall(initFrames));
                }
                
            }
			(
                (	ret = item:ctorDef_instr[RETURN_HELPER_CLASSES | RETURN_HELPER_METHODS]
                    {
                        temps = __merge(temps, ret); 
                    }
                |	item:methodDef
                |	ret = item:fieldDef_instr[INTEGRATED_BLOCK, initFrames]
                    {
                        if(ret != null){
                            if(((FieldNodeContext)#item_in.getNodeContext()).isStatic()){
                                explicitStaticZeroInits = __addChild(explicitStaticZeroInits, ret);
                            } else {
                                explicitZeroInits = __addChild(explicitZeroInits, ret);
                            }
                        }
                    }
                |	item:typeDefinition /* inner class */
                |	item:objStaticInitializer[initFrames]
                |	item:objInstanceInitializer[initFrames] 
                )
                {
                    block = __addChild(block, #item);
                }
            )*
            {end(_t)}?
		)
        {
            JavaAST staticZeroInitMethod = 
                hasStaticFields ? 
                    __staticZeroInitMethod(explicitStaticZeroInits) :
                    null;
            JavaAST initCompleted =
                #(#[INSTANCE_INIT], #(#[SLIST], #(#[EXPR], initFrames.initCompleted())));

            JavaAST clinitCompleted = 
                hasStaticFields ? 
                #(#[STATIC_INIT], #(#[SLIST], #(#[EXPR], initFrames.clinitCompleted()))) :
                null;

            ## = #(__copyNode(#ob),
                   __cld(block),
                   __cld(##),
                   __cld(temps),
                   staticZeroInitMethod,
                   __zeroInitMethod(explicitZeroInits),
                   initCompleted,
                   clinitCompleted);

	    stackPop(); //Hack for this-references
        }
	;

ctorDef_instr [int t] returns [JavaAST temps = null]
{JavaAST instrSList = null, body = #[SLIST];}
	:	#(  c:CTOR_DEF modifiers IDENT #( p:PARAMETERS (parameterDef)* {end(_t)}?) (throwsClause)?
            (   #(  sl:SLIST
                    (   {_t!=null}?
                        (
                            (#(EXPR (CTOR_CALL | SUPER_CTOR_CALL)))=>
                            (#(EXPR temps = cc:ctorCall_instr[#c_in, t, #p_in]))
                        )?
                        (instrSList = stat:stat_instr!
                            {
                                body = #(#[SLIST], __cld(body), __cld(instrSList), #stat);
                            } 
                        )*
                    |   // empty slist -- ANTLR FIX
                    )
                    {end(_t)}?
                )
                {
                    #sl.addChild(__cld(__createFrame(__ctorEnter(#c_in, #p_in), __ctorLeave(#c_in), body)));
                }
            )?
            {end(_t)}?
        )
	;

methodDef // self contained
	:	#(  m:METHOD_DEF modifiers typeSpec IDENT #( p:PARAMETERS (parameterDef)* {end(_t)}?) (throwsClause)?
            (   body:slist!
                {
                    #m.addChild(__createFrame(__methodEnter(#m_in, #p_in), __methodLeave(#m_in), #body));
                }
            )?
            {end(_t)}?
        )
    ;

fieldDef_instr [int t, InitFrames initFrame] returns [JavaAST ret = null]
{
    JavaAST temps = null;
    JavaAST integratedInit = null;
    JavaAST directAssign = null;
}
	:!	#(vd:VARIABLE_DEF m:modifiers #(tp:TYPE type:typeSpecArray {end(_t)}?) id:IDENT 
            // DO NOT TOUCH THIS CODE... antlr __will__ bite you with very strange runtime errors
            (   (ASSIGN)=>
                (   (#(ASSIGN EXPR))=>  temps = a:fieldDef_assign_value[t, #vd_in, #id_in]
                |	temps = a:fieldDef_assign_array[t, #vd_in, #id_in, #type_in]
                )
            )?
            {end(_t)}?
        )
        {
            FieldNodeContext vdctx = (FieldNodeContext) #vd_in.getNodeContext();

            if((t & INTEGRATED_BLOCK) != 0){

                if(EXPLICIT_ZERO_INIT)
                    if(vdctx.isStatic()){
                        ret = #(#[EXPR], __defStatic(#vd_in));
                    } else{
                        ret = #(#[EXPR], __defField(#vd_in, #[LITERAL_this,"this"]));
                    }
                
                if(temps != null){
                    if(vdctx.isStatic()){
                        integratedInit = #(#[STATIC_INIT],
                                           __createFrame(initFrame.staticEnter(), initFrame.staticLeave(), temps));
                    } else {
                        integratedInit = #(#[INSTANCE_INIT],
                                           __createFrame(initFrame.enter(), initFrame.leave(), temps));
                    }
                }

            } else {

                ret = temps;

                if(!vdctx.isStatic()){
                    new Exception("Nonstatic Field in Interface. Should not happen.").printStackTrace();
                    valid = false;
                }
            }

            ## = #(null, #(#vd, #m, #(#tp, #type), #id, #a), integratedInit);
        }
    ;

fieldDef_assign_value [int t, JavaAST vd, JavaAST id] returns [JavaAST ret = null]
{JavaAST temps = null;}
    :!  #(  a:ASSIGN #(EXPR temps = exp:expr_instr[RETURN_TEMPS, RET_DEFAULT] {end(_t)}?))
        {
            FieldNodeContext vdctx = (FieldNodeContext) vd.getNodeContext();

            ValNodeContext expctx = (ValNodeContext) #exp_in.getNodeContext();
            //                                          ^^^ important


            if(vdctx.isConstant()){ // constant --> compile time eval. --> no def/use
                 ## = #(#[ASSIGN,"="], #(#[EXPR], #exp));

            } else if((t & INTEGRATED_BLOCK) != 0){ // seperate assignment
                JavaAST instrExp;
                if(vdctx.isStatic()){
                    instrExp = __defStatic(vd, RET_DEFAULT, #exp);
                } else {
                    instrExp = __defField(vd, RET_DEFAULT, #[LITERAL_this,"this"], #exp);
                }
                ret = #(#[SLIST],
                        __cld(temps),
                        #(#[EXPR],
                          #(#[ASSIGN,"="],
                            id.copyTree(),
                            instrExp)));
                
            } else if((t & RETURN_HELPER_CLASSES) != 0){
                ## = #(#[ASSIGN,"="], #(#[EXPR], #exp)); // FIXME
                // TODO (Return class ; assign function result)
            } else {
                new Exception("Invalid t-type").printStackTrace();
                valid = false;
                ## = #(#[ASSIGN,"="], #(#[EXPR], #exp));
            }
        }
    ;

fieldDef_assign_array [int t, JavaAST vd, JavaAST id, JavaAST type] returns [JavaAST temps=null]
{
    // array initialization: special short form. Rewriting:
    //  type[]...[] = {...} --> type[]...[] = new type[]...[]{...}

    // type[]...[] -> type, []...[]
    JavaAST componentType = __copyTree(type);
    JavaAST arrayDecl = null;
    
    while(componentType.getType() == ARRAY_DECLARATOR){ //quick'n'dirty
        componentType = (JavaAST)componentType.getFirstChild();
        arrayDecl = #(#[ARRAY_DECLARATOR], arrayDecl);
    }
}
    :!   #( a:ASSIGN temps = ai:arrayInitializer_instr[RETURN_TEMPS, (TypeNodeContext) componentType.getNodeContext()]! {end(_t)}? )
        {
            FieldNodeContext vdctx = (FieldNodeContext) vd.getNodeContext();

            JavaAST arexp = __newArray(vd, RET_DEFAULT, #(#[LITERAL_new,"new"], componentType, arrayDecl, #ai));

            JavaAST instrExp;
            if(vdctx.isStatic()){
                instrExp = __defStatic(vd, RET_DEFAULT, arexp);
            } else {
                instrExp = __defField(vd, RET_DEFAULT, #[LITERAL_this,"this"], arexp);
            }

            if((t  & INTEGRATED_BLOCK) != 0){
                temps = #(#[SLIST],
                          __cld(temps),
                          #(#[EXPR],
                            #(#[ASSIGN,"="],
                              id.copyTree(),
                              instrExp)));

            } else if((t & RETURN_HELPER_CLASSES) != 0){
                ## = #(#[ASSIGN,"="], #ai); // FIXME
                // TODO (Return class ; assign function result)
            } else { // not handled - do nothing till RETURN_HELPER_CLASSES is fixed
                new Exception("Invalid t-type").printStackTrace();
                valid = false;
            }
        }
    ;

objStaticInitializer [InitFrames initFrame]
    :! 	#(si:STATIC_INIT sl:slist {end(_t)}?)
        {
            ## = #(#si, __createFrame(initFrame.staticEnter(), initFrame.staticLeave(), #sl));
        }
    ;

objInstanceInitializer [InitFrames initFrame]
	:!	#(ii:INSTANCE_INIT sl:slist {end(_t)}?)
        {
            ## = #(#ii, __createFrame(initFrame.enter(), initFrame.leave(), #sl));
        }
    ;



////////////////////////////////////////////////////////////////////////////////

slist // self contained
{JavaAST instrSList; JavaAST ret = #[SLIST];}
	:!	#(  SLIST
            (   instrSList = stat:stat_instr
                {
                    #ret = #(#[SLIST], __cld(ret), __cld(instrSList), #stat);
                }
            )* 
            {end(_t)}?
        )
        {
            ## = #ret;
        }
	;

// create surrounding slist if necessary
stat // self contained
{JavaAST temps;}
    :   temps = s:stat_instr
        {
            if(temps != null) // slist required
                ## = #(#[SLIST], __cld(temps), ##);
        }
    ;
stat_instr returns [JavaAST temps=null] // returns temporary variables if any
{JavaAST t2 = null;}
    :	typeDefinition /* local class */
	|	temps = variableDef_instr
	|	temps = expression_instr[RETURN_TEMPS]
	|	#(LABELED_STAT IDENT temps=stat_instr {end(_t)}?)
	|	temps = ifstat_instr
	|	temps = forstat_instr
	|	temps = whilestat_instr
	|	temps = dostat_instr
	|	breakstat
	|   contstat
	|	temps = retstat_instr
	|	temps = switchstat_instr
	|	#("throw" #(EXPR temps = expr_instr[RETURN_TEMPS, RET_DEFAULT] {end(_t)}?) {end(_t)}?)
	|	#("synchronized" temps = expression_instr[RETURN_TEMPS] stat {end(_t)}?)
	|	tryBlock
	|	slist // nested SLIST
    |   #("assert" temps = expression_instr[RETURN_TEMPS]
            ( t2 = expression_instr[RETURN_TEMPS]
                { temps = __merge(temps, t2); }
            )?
            {end(_t)}?)
	|	EMPTY_STAT
	;

ifstat_instr returns [JavaAST temps=null]
    :	#(i:"if" temps=expression_puse_instr[#i_in, RETURN_TEMPS] stat (stat)? {end(_t)}?)
    ;

forstat_instr returns [JavaAST temps=null]
{JavaAST ret=null;}
    :   #(f:"for"
			#(  FOR_INIT 
                (   ( ret = variableDef_instr { temps = __merge(temps, ret); } )+ 
                |   temps = elist_instr[RETURN_TEMPS, null]
                )?
                {end(_t)}?
            )
			#(FOR_CONDITION (ret = expression_puse_instr[#f_in, RETURN_TEMPS] { temps = __merge(temps, ret); })?  {end(_t)}?)
			#(FOR_ITERATOR (ret = elist_instr[RETURN_TEMPS, null] { temps = __merge(temps, ret); })?  {end(_t)}?)
			stat
            {end(_t)}?
		)
    ;

whilestat_instr returns [JavaAST temps=null]
    :	#(w:"while" temps = expression_puse_instr[#w_in, RETURN_TEMPS] stat {end(_t)}?)
    ;

dostat_instr returns [JavaAST temps=null]
    :	#(d:"do" stat temps = expression_puse_instr[#d_in, RETURN_TEMPS] {end(_t)}?)
    ;

retstat_instr returns [JavaAST temps=null]
    :	#("return" ( #(EXPR temps = expr_instr[RETURN_TEMPS, RET_DEFAULT] {end(_t)}?) )? {end(_t)}?)
    ;

switchstat_instr returns [JavaAST temps=null]
{
    int equivCounter = 1;
    boolean defaultPresent = false;
    boolean defaultPresentHere = false;
}
    :	#(  sw:"switch"
            temps=expression_switch_puse_instr[#sw_in, RETURN_TEMPS]
            (
                defaultPresentHere = caseGroup_instr[#sw_in, equivCounter]
                {
                    defaultPresent |= defaultPresentHere;
                    equivCounter++;
                }
            )*
            {end(_t)}?
        )
        {
            if(!defaultPresent) // insert default case
                #sw.addChild(#(#[CASE_GROUP],
                               #[LITERAL_default,"default"], 
                               #(#[SLIST],
                                 #(#[EXPR],
                                   __switchPUseEquivalent(#sw_in, 0)))));
        }
    ;

caseGroup_instr [JavaAST sw, int equivCounter] returns [boolean defaultPresent = false]
	:	#(c:CASE_GROUP 
            (   #("case" constant_expression {end(_t)}?) 
            |   "default" {defaultPresent = true;}
            )+ 
            list:slist!
            {end(_t)}?
        )
        {
            #c.addChild(__merge(#(#[SLIST],#(#[EXPR],__switchPUseEquivalent(sw, equivCounter))), #list));
        }
	;

tryBlock
	:	#( "try" slist (handler)* (#("finally" slist {end(_t)}?))? {end(_t)}?)
	;

handler
{JavaAST parameter = null;}
	:!	#( c:"catch" parameter = pd:parameterDef_instr list:slist {end(_t)}?)
        {
            ## = #(#c,
                   #pd,
                   __merge(#(#[SLIST],
                             #(#[EXPR],
                               __exceptHandlerCall(#c_in))),
                           __merge(parameter, #list)));
        }
	;

// for "catch(Throwable){}" blocks. Functions and constructors "def" implicitly
parameterDef_instr returns [JavaAST instr=null]
    :   #(  pd:PARAMETER_DEF modifiers type:typeSpec id:IDENT {end(_t)}?)
        {
            instr = #(#[SLIST], #(#[EXPR], __defLocal(#pd_in)));
        }
    ;


variableDef_instr returns [JavaAST temps=null] // DEF only required when initialized, JLS takes care...
    :! 	#(  vd:VARIABLE_DEF 
            m:modifiers 
           	#(tp:TYPE type:typeSpecArray {end(_t)}?)
            id:IDENT	
            // DO NOT TOUCH THIS CODE... antlr __will__ bite you with very strange runtime errors
            (   (ASSIGN)=>
                (   (#(ASSIGN EXPR))=>  temps = a:variableDef_assign_value[#vd_in]
                |    temps = a:variableDef_assign_array[#vd_in, #type_in]
                )
            )?
            {end(_t)}?
        )
        {
            // ANTLR-Bugstopper--- voodoo do not change
            ## = #(#vd, #m, #(#tp, #type), #id, #a);
        }
    ;

variableDef_assign_value [JavaAST vd] returns[JavaAST temps=null]
    :!  #(a:ASSIGN #(e:EXPR temps = exp:expr_instr[RETURN_TEMPS, RET_DEFAULT]! {end(_t)}?) {end(_t)}?)
        {
            if(((VarNodeContext)vd.getNodeContext()).isConstant() && !TRACK_CONSTANT_VARS){
                ## = #(#a, #(#e, #exp)); // do nothing
            } else {
                ## = #(#a, #(#e, __defLocal(vd, RET_DEFAULT, #exp)));
            }
        }
    ;

variableDef_assign_array [JavaAST vd, JavaAST type] returns[JavaAST temps=null]
{
    // array initialization: special short form. Rewriting: type[]...[] = {...} --> type[]...[] = new type[]...[]{...}

    // type[]...[] -> type, []...[]; working; not elegant
    JavaAST componentType = __copyTree(type);
    JavaAST arrayDecl = null;

    while(componentType.getType() == ARRAY_DECLARATOR){
        componentType = (JavaAST)componentType.getFirstChild();
        arrayDecl = #(#[ARRAY_DECLARATOR], arrayDecl);
    }
}
    :!	#(a:ASSIGN temps = ai:arrayInitializer_instr[RETURN_TEMPS, (TypeNodeContext) componentType.getNodeContext()]! {end(_t)}?)
        {
            ## = #(#a, #(#[EXPR], __defLocal(#vd_in, RET_DEFAULT, __newArray(vd, RET_DEFAULT, #(#[LITERAL_new,"new"], componentType, arrayDecl, #ai)))));
        }
    ;

////////////////////////////////////////////////////////////////////////////////

constant_expression
{JavaAST ret=null;}
    :   #(EXPR ret = e:expr_instr[CONSTANT, null]
            {ret==null}? 
            {((ValNodeContext)#e_in.getNodeContext()).isConstant()}? 
            {end(_t)}?
        )
    ;

expression_puse_instr [JavaAST condAST, int t] returns [JavaAST temps=null]
    :   #(EXPR temps = expr_puse_instr[condAST, t] {end(_t)}?)
    ;

expression_switch_puse_instr [JavaAST switchAST, int t] returns [JavaAST temps=null]
	:!	#(e:EXPR temps = exp:expr_instr[t, null] {end(_t)}?)
        {
            if(!(Resolver.CHARTYPE.equals (#e.getNodeContext().getRType()) ||
                 Resolver.BYTETYPE.equals (#e.getNodeContext().getRType()) ||
                 Resolver.SHORTTYPE.equals(#e.getNodeContext().getRType()) ||
                 Resolver.INTTYPE.equals  (#e.getNodeContext().getRType()))){
                new Exception("switch_puse: type mismatch").printStackTrace();
                valid = false;
            }

            ## = #(#[EXPR],__switchPUse(switchAST, #exp));
        }
	;
expression_instr [int t] returns [JavaAST temps=null]
	:	#(EXPR temps = expr_instr[t, null] {end(_t)}?)
//                                    ^^ no explicit casts
	;

elist_instr [int t, TypeNodeContext[] parameterTypes] returns [JavaAST temps=null]
{
    JavaAST ret=null;
    int currentParameter=0;
}
    :   #( ELIST
            (   #(EXPR ret = expr_instr[t, parameterTypes != null ? parameterTypes[currentParameter++] : null] {end(_t)}?) 
                {temps=__merge(temps, ret);}
            )*
            {end(_t)}?
        )
    ;

expr_puse_instr [JavaAST condAST, int t] returns [JavaAST temps=null]
	:	temps = e:expr_instr[t, null] // must be boolean
        {Resolver.BOOLEANTYPE.equals(#e_in.getNodeContext().getRType())}?
        {
	    ## = __pUse(condAST, ##,
			((ValNodeContext)#e_in.getNodeContext()).isConstant());
        }
	;

expr_instr [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null, t2=null, t3=null;}
    :   (   ASSIGN | PLUS_ASSIGN|MINUS_ASSIGN|STAR_ASSIGN|DIV_ASSIGN|MOD_ASSIGN|
            SR_ASSIGN|BSR_ASSIGN|SL_ASSIGN|BAND_ASSIGN|BXOR_ASSIGN|BOR_ASSIGN)=> // any assignment
        temps=assign_expr_instr[t, rett]
	|   #(q:QUESTION t1=expr_puse_instr[#q_in,t] t2=expr_instr[t, RET_DEFAULT] t3=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        {
            temps = __merge(t1, __merge(t2, t3));
        }
    |   (	#(LOR       t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(LAND      t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(BOR       t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(BXOR      t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(BAND      t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(NOT_EQUAL t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(EQUAL     t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(LT        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(GT        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(LE        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(GE        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(SL        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(SR        t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(BSR       t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(PLUS      t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(MINUS     t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(DIV       t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(MOD       t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(STAR      t1=expr_instr[t, RET_DEFAULT] t2=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        )
        {
            temps = __merge(t1, t2);
        }
	|   (	#(i:INC         temps= ei:primaryExpression_instr[ #i_in.copyNode(),t, rett] {end(_t)}?){## = #ei;}
        |	#(d:DEC         temps= ed:primaryExpression_instr[ #d_in.copyNode(),t, rett] {end(_t)}?){## = #ed;}
        |	#(pi:POST_INC   temps=epi:primaryExpression_instr[ #pi_in.copyNode(),t, rett] {end(_t)}?){## = #epi;}
        |	#(pd:POST_DEC   temps=epd:primaryExpression_instr[ #pd_in.copyNode(),t, rett] {end(_t)}?){## = #epd;}
        )!
    |   (	#(BNOT        temps=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(LNOT        temps=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#("instanceof" temps=expr_instr[t, RET_DEFAULT] typeSpec {end(_t)}?)
        |	#(UNARY_MINUS temps=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        |	#(UNARY_PLUS  temps=expr_instr[t, RET_DEFAULT] {end(_t)}?)
        )
	|	temps=primaryExpression_instr[null, t, rett]
    ;

assign_expr_instr [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   ( #( . IDENT . ) )=> temps = assign_expr_simple[t, rett]
    |   ( #( . #(DOT "super" .) . ) )=> temps = assign_expr_this_super[t, rett]
    |   ( #( . #(DOT #("DOT" . "super") .) . ) )=> temps = assign_expr_this_super[t, rett]
    |   ( #( . #(DOT "this" .) . ) )=> temps = assign_expr_this_super[t, rett]
    |   ( #( . #(DOT #("DOT" . "this") .) . ) )=> temps = assign_expr_this_super[t, rett]
    |   ( #( . DOT . ) )=> temps = assign_expr_deref[t, rett]
    |   ( #( . INDEX_OP . ) )=> temps = assign_expr_index[t, rett]
    ;

assign_expr_simple [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :!   #( or:. op1:IDENT temps=op2:expr_instr[t, RET_DEFAULT] {end(_t)}?)
        {
            if((#op1.getNodeContext()) instanceof FieldNodeContext){
                FieldNodeContext op1ctx=(FieldNodeContext) #op1.getNodeContext();
                if(op1ctx.isStatic()){

                    if(__isPlainAssign(#or)){
                        ## = __defStatic(#op1_in, rett, #(#or, #op1, #op2));
                    } else {
                        ## = #(#or,
                               #op1,
                               __bin(#op1_in, RET_DEFAULT,
                                     __useStatic(#op1_in),
                                     __defStatic(#op1_in, null, #op2)));
                    }

                } else {
                    if(__isPlainAssign(#or)){
                        ## = __defField(#op1_in, rett, __qualifiedThis(op1ctx.getDeclaringType()), #(#or, #op1, #op2));
                    } else {
                        ## = #(#or,
                               #op1,
                               __bin(#op1_in, RET_DEFAULT,
                                     __useField(#op1_in, __qualifiedThis(op1ctx.getDeclaringType())),
                                     __defField(#op1_in, null, __qualifiedThis(op1ctx.getDeclaringType()), #op2)));
                    }
                }
            } else if((#op1.getNodeContext()) instanceof VarNodeContext){

                if(__isPlainAssign(#or)){
                    ## = __defLocal(#op1_in, rett, #(#or, #op1, #op2));
                } else {
                    ## = #(#or,
                           #op1,
                           __bin(#op1_in, RET_DEFAULT,
                                 __useLocal(#op1_in),
                                 __defLocal(#op1_in, null, #op2)));
                }
            } else {
                new Exception("Unexpected NodeContext in node" + #op1).printStackTrace();
                valid = false;
            }
        }
    ;

assign_expr_this_super [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null, t2=null;}
    :!   #( or:. #(op1:DOT t1=lhs:expr_instr[t, RET_DEFAULT] rhs:IDENT{end(_t)}?) t2=op2:expr_instr[t, RET_DEFAULT] {end(_t)}?)
        {
            temps = __merge(t1, t2);
            
            FieldNodeContext op1ctx=(FieldNodeContext) #op1.getNodeContext();
            if(op1ctx.isStatic()){

                if(__isPlainAssign(#or)){
                    ## = __defStatic(#op1_in, rett, #(#or, #(#op1, #lhs, #rhs), #op2));
                } else {
                    ## = #(#or,
                           #(#op1, #lhs, #rhs),
                           __bin(#op1_in, RET_DEFAULT,
                                 __useStatic(#op1_in),
                                 __defStatic(#op1_in, null, #op2)));
                }

            } else {

                if(__isPlainAssign(#or)){
                    ## = __defField(#op1_in, rett, __qualifiedThis(op1ctx.getDeclaringType()), #(#or, #(#op1, #lhs, #rhs), #op2));
                } else {
                    ## = #(#or,
                           #(#op1, #lhs, #rhs),
                           __bin(#op1_in, RET_DEFAULT,
                                 __useField(#op1_in, __qualifiedThis(op1ctx.getDeclaringType())),
                                 __defField(#op1_in, null, __qualifiedThis(op1ctx.getDeclaringType()), #op2)));
                }
            }
        }        
    ;

assign_expr_deref  [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null, t2=null;}
    :!   #( or:. #(op1:DOT t1=lhs:expr_instr[t, RET_DEFAULT] rhs:IDENT{end(_t)}?) t2=op2:expr_instr[t, RET_DEFAULT]  {end(_t)}?)
        {
            temps = __merge(t1, t2);
             if((#op1.getNodeContext()) instanceof FieldNodeContext){
                FieldNodeContext op1ctx=(FieldNodeContext) #op1.getNodeContext();
                if(op1ctx.isStatic()){
                     if(__isPlainAssign(#or)){
                        ## = __defStatic(#op1_in, rett, #(#or, #(#op1, #lhs, #rhs), op2));
                    } else {
                        ## = #(#or,
                               #(#op1, #lhs, #rhs),
                               __bin(#op1_in, RET_DEFAULT,
                                     __useStatic(#op1_in),
                                     __defStatic(#op1_in, null, #op2)));
                    }
                 } else {
                     if(((#lhs_in.getNodeContext()) instanceof VarNodeContext &&
                        ((ValNodeContext) #lhs_in.getNodeContext()).isConstant())){ // lhs fixed
                         if(__isPlainAssign(#or)){
                            ## = __defField(#op1_in, rett, __copyTree(#lhs_in),  #(#or, #(#op1, #lhs, #rhs), op2)); // lhs_in --> silent reevaluation
                        } else {
                            ## = #(#or,
                                   #(#op1, #lhs, #rhs),
                                   __bin(#op1_in, RET_DEFAULT,
                                         __useField(#op1_in, __copyTree(#lhs_in)),
                                         __defField(#op1_in, null, __copyTree(#lhs_in), #op2)));
                        }
                    } else {
                        if((t & RETURN_TEMPS) > 0) { // temporaries OK
                            String temp = __getTempName();
                            TypeNodeContext lhstype = #lhs_in.getNodeContext().getRType();
                            temps = __merge(temps, #(#[SLIST], __defineVariable(lhstype, temp)));
                             if(__isPlainAssign(#or)){
                                ## = __defField(#op1_in, rett,
                                                #(#[ASSIGN,"="], #[IDENT, temp], #lhs),
                                                #(#[ASSIGN,"="], #(#[DOT], #[IDENT, temp], #rhs), #op2));
                            } else {
                                ## = #(#or,
                                       #(#op1, 
                                         #(#[ASSIGN, "="],
                                           #[IDENT, temp],
                                           #lhs),
                                         #rhs),
                                       __bin(#op1_in, RET_DEFAULT,
                                             __useField(#op1_in, #[IDENT, temp]),
                                             __defField(#op1_in, null, #[IDENT, temp], #op2)));
                            }
                        } else {
                            new Exception("FIXME: HelperClasses not implemented").printStackTrace();
                            /* FIXME: HelperClasses not implemented */
                            valid = false;
                        }
                    }
                }
            }
        }
    ;

assign_expr_index  [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null, t2=null, t3=null;}
    :!   #( or:. #(  io:INDEX_OP t1=array:expr_instr[t, RET_DEFAULT] #(EXPR t2=index:expr_instr[t, null] {end(_t)}?) {end(_t)}? ) t3=op2:expr_instr[t, RET_DEFAULT] {end(_t)}?)
        {
            temps = __merge(t1, __merge(t2, t3));

            if(__isPlainAssign(#or)){
                ## = __defArray(#array_in, rett, #array, #index, #op2);
            } else {
                JavaAST arrayDefNode, arrayUseNode, indexDefNode, indexUseNode;

                // OPT: (array ref.constant || (local. Var. && index side-effects free )) && side-effects free
                if(false){
                    arrayDefNode = #array;
                    arrayUseNode = __copyTree(#array_in);
                } else {
                    if((t & RETURN_TEMPS) == 0){
                        new Exception("FIXME: HelperClasses not implemented").printStackTrace();
                        valid = false;
                    }
                                        
                    String tempa = __getTempName();
                    TypeNodeContext arraytype = #array_in.getNodeContext().getRType();
                    temps = __merge(temps, #(#[SLIST], __defineVariable(arraytype, tempa)));
                    arrayDefNode = #([ASSIGN,"="], #[IDENT, tempa], #array);
                    arrayUseNode = #[IDENT, tempa];
                }

                // OPT: (index constant || (local. Var. && array side-effects free)) && side-effects free
                if(#index_in.getType() == NUM_INT){
                    indexDefNode = #index;
                    indexUseNode = __copyTree(#index_in);
                } else {
                    if((t & RETURN_TEMPS) == 0){
                        new Exception("FIXME: HelperClasses not implemented").printStackTrace();
                        valid = false;
                    }
                                        
                    String tempi = __getTempName();
                    TypeNodeContext iotype = #index_in.getNodeContext().getRType();
                    temps = __merge(temps, #(#[SLIST], __defineVariable(iotype, tempi)));
                    indexDefNode = #(#[ASSIGN,"="], #[IDENT, tempi], #index);
                    indexUseNode = #[IDENT, tempi];
                }

                ## = __defArray(#array_in, rett, arrayDefNode, indexDefNode,
                                #(__getAOp(#or),
                                  __useArray(#array_in, RET_DEFAULT, arrayUseNode, indexUseNode),
                                  #op2));

            }
        }
    ;

primaryExpression_instr [JavaAST incDecOp, int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   ( IDENT )=>
        temps = primaryExpression_ident[incDecOp, t, rett]
    |   ( DOT )=>
        (   ( #(DOT ( . "class" )) )=>  // 6.5.1(2.5.7), 15.8.2
                #(DOT typeSpecArray "class")
        |   ( #(DOT ( . "this" )) )=> // 6.5.1(2.5.8), 15.8.4
            #(DOT identifier "this") // "this" represents an enclosing class here -- not tracked (constant & avoidable)
        |   ( #(DOT "super" . ) )=>           temps = primaryExpression_this_super[incDecOp, t, rett]
        |   ( #(DOT #(DOT . "super") . ) )=>  temps = primaryExpression_this_super[incDecOp, t, rett]
        |   ( #(DOT "this" . ) )=>            temps = primaryExpression_this_super[incDecOp, t, rett]
        |   ( #(DOT #(DOT . "this") . ) )=>   temps = primaryExpression_this_super[incDecOp, t, rett]
        |   ( #(DOT . "new" ) )=>
            temps = primaryExpression_new[t, rett]
        |   temps = primaryExpression_deref[incDecOp, t, rett]
        )
	|	temps=arrayIndex_instr[incDecOp, t, rett]
	|	temps=methodCall_instr[t, rett]
//	|	ctorCall // special cased above
	|	#(TYPECAST typeSpec temps=expr_instr[t, null] {end(_t)}?)
	|   temps=newExpression_instr[t, rett]
	|   constant
    |   "super" // "super" access is not monitored
    |   "true"
    |   "false"
    |   "this"  // "this" access is not monitored
    |   "null"
	;

primaryExpression_ident[JavaAST incDecOp, int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   id:IDENT
        {
            if((#id.getNodeContext()) instanceof FieldNodeContext){
                FieldNodeContext idctx = (FieldNodeContext)#id.getNodeContext();
                if(!idctx.isConstant()){ // constant expressions are evaluated at __compile__ time
                    if(idctx.isStatic()){

                        if(incDecOp == null){
                            ## = __useStatic(#id_in, rett,  #id);
                        } else {
                            ## = __useDefStatic(#id_in, rett, #(incDecOp, #id));
                        }

                    } else {

                        if(incDecOp == null){
                            ## = __useField(#id_in, rett, __qualifiedThis(idctx.getDeclaringType()), #id);
                        } else {
                            ## = __useDefField(#id_in, rett,  __qualifiedThis(idctx.getDeclaringType()),
                                               #(incDecOp, #id));
                        }
                    }
                }
            } else if(id.getNodeContext() instanceof VarNodeContext){
                VarNodeContext idctx = (VarNodeContext)#id.getNodeContext();
                if(!idctx.isConstant() || TRACK_CONSTANT_VARS){

                    if(incDecOp == null){
                        ## = __useLocal(#id_in, rett, #id);
                    } else {
                        ## = __useDefLocal(#id_in, rett, #(incDecOp, #id));
                    }
                }
            }
        }
    ;

primaryExpression_this_super[JavaAST incDecOp, int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null, t2=null, result=null;}
    :   #(d:DOT temps = expr_instr[t, RET_DEFAULT] IDENT) // "[type.]super.IDENT" special case
        {
            FieldNodeContext dctx = (FieldNodeContext)#d.getNodeContext();
            if(dctx.isStatic()){

                if(incDecOp == null){
                    ## = __useStatic(#d_in, rett, ##);
                } else {
                    ## = __useDefStatic(#d_in, rett, #(incDecOp, ##));
                }

            } else {

                if(incDecOp == null){
                    ## = __useField(#d_in, rett, __qualifiedThis(dctx.getDeclaringType()), ##);
                } else {
                    ## = __useDefField(#d_in, rett, __qualifiedThis(dctx.getDeclaringType()),
                                       #(incDecOp, ##));
                }
            }
        }
    ;

primaryExpression_new[int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST t1=null;}
    :!   #( d:DOT 
            temps=lhs:expr_instr[t, null]
            #(  newOp:"new"
                id:IDENT 
                t1=el:elist_instr[t, ((CtorNodeContext)#el_in.getNodeContext()).getParameterTypes()]
                ( ob:objBlock )?
                {end(_t)}?
            ) 
            {end(_t)}?
        )
        {
            temps = __merge(temps, t1);
            
            ## = __newClass(#d_in, rett, #lhs, #lhs_in.getNodeContext().getRType(), #(#newOp, #id, #el, #ob));
        }
    ;

primaryExpression_deref[JavaAST incDecOp, int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :!   #(d:DOT temps=lhs:expr_instr[t, RET_DEFAULT] rhs:IDENT! {end(_t)}?)
        {
            if(#lhs_in.getNodeContext().getRType().isArray() && #rhs.getText().equals("length")){ // array.length problem $&%&$

                ## = __useArrayLength(#lhs_in, #lhs);

            } else if(d.getNodeContext() instanceof FieldNodeContext){
                FieldNodeContext dctx = (FieldNodeContext)#d.getNodeContext();
                if(dctx.isConstant()){ // constant expressions are evaluated at __compile__ time
                    ## = #(#d, #lhs,  #rhs);
                } else {
                    if(dctx.isStatic()){
                        if(incDecOp == null){
                            ## = __useStatic(#d_in, rett, #(#d, #lhs, #rhs));
                        } else {
                            ## =  __useDefStatic(#d_in, rett, #(incDecOp, #(#d,#lhs,#rhs)));
                        }
                    } else {
//                                    "normal" __useField possible iff
//                                    (#lhs_in.getNodeContext() instanceof VarNodeContext ||
//                                       (#lhs_in.getNodeContext() instanceof FieldNodeContext &&
//                                        ((FieldNodeContext)#lhs_in.getNodeContext()).isConstant()))

                        TypeNodeContext lhstype = #lhs_in.getNodeContext().getRType();
                        if(incDecOp == null){
                            ## = #(d, __useFieldContained(#d_in, lhstype, #lhs), #rhs);
                        } else {
                            ## = #(incDecOp, #(#d, __useFieldContained(#d_in, lhstype, #lhs), #rhs));
                        }
                    }
                }
            } else if(d.getNodeContext() instanceof TypeNodeContext){
                ## = #(#d, #lhs, #rhs);
            } else {
                new Exception("Unexpected node in primaryExpression_deref" + d.getNodeContext()).printStackTrace();
                valid = false;
            }
        }
    ;

methodCall_instr [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   ( #(METHOD_CALL . #(ELIST . )) )=> // at least one parameter
        temps = methodCall_instrElist[t, rett]
    |   ( #(METHOD_CALL IDENT #(ELIST {end(_t)}?)) )=> // no argument, no deref.
        temps = methodCall_instrNoderef[t, rett]
    |   ( #(METHOD_CALL #(DOT "super" )) )=> // special case for [type.]super.IDENT
        temps = methodCall_instrSuper[t, rett]
    |   ( #(METHOD_CALL #(DOT #(DOT . "super"))) )=> // special case for [type.]super.IDENT
        temps = methodCall_instrSuper[t, rett]
    |   ( #(METHOD_CALL DOT) )=> // no argument, dereferentiation
        temps = methodCall_instrDeref[t, rett]
    ;

methodCall_instrElist [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{
    JavaAST ret=null;
    TypeNodeContext[] parameterTypes=null;
    int currentParameter=0;
}
    :   #(  m:METHOD_CALL
            {
                parameterTypes = ((MethodNodeContext)#m_in.getNodeContext()).getParameterTypes();
            }
            (   IDENT
            | #(DOT temps=expr_instr[t, RET_DEFAULT] IDENT {end(_t)}?)
            )
            // Last argument gets cp() marker
            #(  ELIST
                (   options { 	warnWhenFollowAmbig = false; }
                :   ( . EXPR )=> // do not match last target -- this line is __not__ superfluous even if antlr warns
//                    ret=expression_instr[t]
                    #(EXPR ret=expr_instr[t, parameterTypes[currentParameter++]] {end(_t)}?)
                    {
                        temps=__merge(temps,ret);
                    }
                )*
                #(x:EXPR ret=e:expr_instr[t, RET_DEFAULT]!)
                {
                    temps= __merge(temps, ret);
//                    TypeNodeContext rettype = #e_in.getNodeContext().getRType();// FIXME: argument type
                    #x.addChild(__cp(#m_in, parameterTypes[currentParameter++], #e));
                }
                {end(_t)}?
            )
            {end(_t)}?
        )
    ;

methodCall_instrNoderef [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   #( m:METHOD_CALL IDENT #(ELIST {end(_t)}?) {end(_t)}?)
        {
            if(((CodeBlockNodeContext)#m.getNodeContext()).getRType().equals(Resolver.VOIDTYPE)){
                temps = __merge(temps, #(#[SLIST], #(#[EXPR],__cp(#m_in)))); // use temps
            } else {
                ## = __bin(#m_in, rett, __cp(#m_in), ##);
            }
        }
    ;

methodCall_instrSuper [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :   #( m:METHOD_CALL #(DOT temps=expr_instr[t, RET_DEFAULT] IDENT {end(_t)}?) #(ELIST {end(_t)}?) {end(_t)}?)
        {
            if(((CodeBlockNodeContext)#m.getNodeContext()).getRType().equals(Resolver.VOIDTYPE)){
                temps = __merge(temps, #(#[SLIST], #(#[EXPR],__cp(#m_in)))); // use temps
            } else {
                ## = __bin(#m_in, rett, __cp(#m_in), ##);
            }
        }
    ;
                
methodCall_instrDeref [int t, TypeNodeContext rett] returns [JavaAST temps=null]
    :!   #( m:METHOD_CALL #(d:DOT temps=lhs:expr_instr[t, RET_DEFAULT] rhs:IDENT {end(_t)}?) #(e:ELIST {end(_t)}?) {end(_t)}?)
        {
            if(((CodeBlockNodeContext)#m.getNodeContext()).isStatic() &&
               #lhs_in.getNodeContext() instanceof TypeNodeContext){

                if(((CodeBlockNodeContext)m.getNodeContext()).getRType().equals(Resolver.VOIDTYPE)){
                    temps = __merge(temps, #(#[SLIST], #(#[EXPR],__cp(#m_in)))); // use temps
                    ## = #(#m, #(#d, #lhs, #rhs), #e);
                } else {
                    ## = __bin(#m_in, rett,  __cp(#m_in), #(#m, #(#d, #lhs, #rhs), #e));
                }

            } else {
                TypeNodeContext rettype = #lhs_in.getNodeContext().getRType();
                ## = #(#m, #(#d, __cp(#m_in, rettype, #lhs), #rhs), #e);
            }
        }
    ;


ctorCall_instr [JavaAST ctor, int t, JavaAST ctorParameters] returns [JavaAST temps=null]
{
    JavaAST t2=null;
    TypeNodeContext[] parameterTypes=null;
    int currentParameter=0;
}
        // ctor calls have several _nice_ properties.
        // One of them is that they have to stand at the very beginning of the constructor.
        // (This makes life much more fun;-) See: "Early Ctor Enter"
	:	#( c:CTOR_CALL 
            {
                parameterTypes = ((CtorNodeContext) #c_in.getNodeContext()).getParameterTypes();
            }
            temps=elist_ctorCall[ctor,t, parameterTypes, ctorParameters] {end(_t)}?)
	|	#( s:SUPER_CTOR_CALL
            {
                parameterTypes = ((CtorNodeContext) #s_in.getNodeContext()).getParameterTypes();
            }
			(	temps=elist_ctorCall[ctor,t, parameterTypes, ctorParameters]
			|	temps=primaryExpression_ctorCall[ctor,t, RET_DEFAULT, ctorParameters] t2=elist_instr[t, parameterTypes] { temps = __merge(temps, t2); }
            )
			{end(_t)}?
        )
	;

elist_ctorCall [JavaAST ctor, int t, TypeNodeContext[] parameterTypes, JavaAST ctorParameters] returns [JavaAST temps=null]
{JavaAST t2=null; int currentParameter=0;}
    :   #( ELIST
            (
                #(e:EXPR temps=exp:expr_instr[t, null]! {end(_t)}?)
                {
                    #e.addChild(__bin(#exp_in, parameterTypes[currentParameter++], __earlyCtorEnter(ctor, ctorParameters), #exp));
                }
                (	#(EXPR t2 = expr_instr[t, parameterTypes[currentParameter++]] {end(_t)}?) {temps = __merge(temps, t2); } )*
            )? // no arguments --> do nothing
            {end(_t)}?
        )
    ;

primaryExpression_ctorCall [JavaAST ctor, int t, TypeNodeContext rett, JavaAST ctorParameters] returns [JavaAST temps=null]
    :   temps=exp:primaryExpression_instr[null, t, RET_DEFAULT]!
        { 
            ## = __bin(#exp_in, rett, __earlyCtorEnter(ctor, ctorParameters), #exp);
        }
    ;

arrayIndex_instr [JavaAST incDecOp, int t, TypeNodeContext rett] returns [JavaAST temps=null]
{ JavaAST t1=null; JavaAST t2=null;}
	:!   #(  io:INDEX_OP t1=array:expr_instr[t, RET_DEFAULT] #(EXPR t2=index:expr_instr[t, null] {end(_t)}?) {end(_t)}? )
        {
            temps = __merge(t1, t2);
            if(incDecOp == null){
                ## = __useArray(#array_in, rett, #array, #index);
            } else {
                ## = __incDecArrayOp(#array_in, rett, incDecOp, #array, #index);
            }
        }
    ;

newExpression_instr [int t, TypeNodeContext rett] returns [JavaAST temps=null]
{JavaAST ret=null;}
	:!   ( #("new" type ARRAY_DECLARATOR) )=> // array
        #(na:"new" at:type temps=ad:newArrayDeclarator_instr[t] 
            ( /* array init */
                ret=ai:arrayInitializer_instr[t, (TypeNodeContext) #at_in.getNodeContext()] {temps=__merge(temps, ret);} 
            )?
            {end(_t)}?
        ) 
        {
            ## = __newArray(#na_in, rett, #(#na, #at, #ad, #ai));
        }
    |!   #(nc:"new" 
            ot:type temps=el:elist_instr[t, ((CtorNodeContext)#el_in.getNodeContext()).getParameterTypes()]
            ( /* anonymous class */
                ob:objBlock
            )?
            {end(_t)}?
        )
        {
            ## = __newClass(#nc_in, rett, #(#nc, #ot, #el, #ob));
        }
    ;

newArrayDeclarator_instr [int t] returns [JavaAST temps=null]
{JavaAST t1=null; JavaAST t2=null;}
	:	#( ARRAY_DECLARATOR (t1=newArrayDeclarator_instr[t])? (t2=expression_instr[t])? {end(_t)}?) 
        {temps=__merge(t1, t2);}
	;


initializer_instr [int t, TypeNodeContext componentRett] returns [JavaAST temps=null]
	:	#(EXPR temps = expr_instr[t, componentRett] {end(_t)}?)
	|	temps=arrayInitializer_instr[t, componentRett]
	;

arrayInitializer_instr [int t, TypeNodeContext componentRett] returns [JavaAST temps=null]
{JavaAST ret=null;}
	:	#(ARRAY_INIT (ret=initializer_instr[t, componentRett] {temps = __merge(temps, ret);} )* {end(_t)}?)
	;


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


// inherited from grammar JavaTreeParser
packageDefinition :#( PACKAGE_DEF identifier {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
importDefinition :#( IMPORT identifierStar {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
typeSpec :#(TYPE typeSpecArray {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
typeSpecArray :#( ARRAY_DECLARATOR typeSpecArray {end(_t)}?)
	|	type
	;

// inherited from grammar JavaTreeParser
type :identifier
	|	builtInType
	;

// inherited from grammar JavaTreeParser
builtInType :"void"
    |   "boolean"
    |   "byte"
    |   "char"
    |   "short"
    |   "int"
    |   "float"
    |   "long"
    |   "double"
    ;

// inherited from grammar JavaTreeParser
modifiers :#( MODIFIERS (modifier)* {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
modifier :"private"
    |   "public"
    |   "protected"
    |   "static"
    |   "transient"
    |   "final"
    |   "abstract"
    |   "native"
    |   "threadsafe"
    |   "synchronized"
    |   "const"
    |   "volatile"
	|	"strictfp"
    ;

// inherited from grammar JavaTreeParser
methodDecl
	:	#(METHOD_DEF modifiers typeSpec methodHead {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
extendsClause :#(EXTENDS_CLAUSE (identifier)* {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
implementsClause :#(IMPLEMENTS_CLAUSE (identifier)* {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
parameterDef :#(PARAMETER_DEF modifiers typeSpec IDENT {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
methodHead :IDENT #( PARAMETERS (parameterDef)* {end(_t)}?) (throwsClause)?
	;

// inherited from grammar JavaTreeParser
throwsClause :#( "throws" (identifier)* {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
identifier :IDENT
	|	#( DOT identifier IDENT {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
identifierStar :IDENT
	|	#( DOT identifier (STAR|IDENT) {end(_t)}?)
	;

// inherited from grammar JavaTreeParser
breakstat :#("break" (IDENT)? {end(_t)}?)
    ;

// inherited from grammar JavaTreeParser
contstat :#("continue" (IDENT)? {end(_t)}?)
    ;

// inherited from grammar JavaTreeParser
constant :NUM_INT
    |   CHAR_LITERAL
    |   STRING_LITERAL
    |   NUM_FLOAT
    |   NUM_DOUBLE
    |   NUM_LONG
    ;

