/*** 
 * 
 * @author Dominik Schindler
 * 
 * SystemUtils.java - Misc system functions.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.*;

public class SystemUtils {

	public static final String CLASS_FILENAME_EXTENSION = ".class";
	public static final String JAVA_FILENAME_EXTENSION = ".java";
	public static final char ZIP_PATH_SEPARATOR_CHAR = '/';
	public static final char PACKAGE_SEPARATOR_CHAR = '.';
	
	public static File[] getAllFilesInDirectory( File dir, final String extension ) {
		return dir.listFiles( new FilenameFilter() {
			public boolean accept( File f, String s ) {
				return s.toLowerCase().endsWith( extension ); 
			}
		});
	}
	
	public static String getPackage( File f ) throws FileNotFoundException, IOException {
		
		BufferedReader in = new BufferedReader( new FileReader( f ) );
    
		Pattern p = Pattern.compile( "package(\\s[A-Za-z.]*);" );
		Matcher m = null;

		String line = in.readLine();
		while ( line != null ) {
			m = p.matcher( line );
			if ( m != null && m.matches() ) {
				return m.group(1).trim();		
			}
			line = in.readLine();
		}
		return null;
	}
	
	public static void main ( String[] args ){
	
		String s = null;
		
		try {
			s = getPackage( new File ( "C:\\Dokumente und Einstellungen\\root.WUMMY-M\\Desktop\\in\\BigFib.java" ) );
		} catch ( Exception e ) {
			System.out.println( e );
		}
		
		System.out.println( s );
		
	}
	
}
