/*** 
 * 
 * @author Dominik Schindler 
 * 
 * Symbol.java - Represents a symbol in the symbol table.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;

public class Symbol {

	public long id;
	public long row;
	public String type;
	public String exp;
	public String notes;
	public long methodId;		// the id of the method, which the symbol belongs to
	public long classId;		// the id of the class, which the symbol belongs to
	public Vector conditionId;	// the id of the combined condition the symbol belongs to
	public long belongsToId;	// to which overall condition, switch or variable belongs it to
	public int trueCount = 0;		// on used temporary by the critera methods
	public int falseCount = 0;		// -"-
	public int unknownCount = 0;	// -"-

	public Symbol(long id, long row, String type, String exp, String notes, long classId, long methodId, long conditionId, long belongsToId ){
			this.id = id;
			this.row = row;
			this.type = type;
			this.exp = exp;
			this.notes = notes;
			this.classId = classId;
			this.methodId = methodId;
			this.conditionId = new Vector();
			this.conditionId.add( new Long( conditionId ) );
			this.belongsToId = belongsToId; // either an branchId, a switchId or a variableId
	}
	
	public String toString() {
		if (notes.length() > 0) {
			return id + " - " + row + " - " + type + " - " + exp + " - " + notes;
		} else {
			return id + " - " + row + " - " + type + " - " + exp;
		}
	}
	
	public void clear() {
		trueCount = 0;
		falseCount = 0;
		unknownCount = 0;		
	}
	
}
