/*** 
 * 
 * @author Dominik Schindler
 * 
 * OverallCoverage.java - Stores and calculates the overall coverage for mcdc, mcc
 * and pc.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;

public class OverallCoverage {
	
	// store sym ==> % 
	private Hashtable symbols;
	
	public OverallCoverage() {
		symbols = new Hashtable();
	}
	
	public void addSymbol( Symbol sym, Double percentage) {
		symbols.put( sym, percentage );
	}
	
	public Hashtable getSymbols() {
		return symbols;
	}

	public int getRows() {
		return symbols.size();
	}
	
	public int getCols() {
		return 3;
	}
	
	public double getPercentage( Symbol sym ) {
		return ( ( Double ) symbols.get( sym ) ).doubleValue();
	}
	
	// for debug output
	public void printSymbolTable() {
		
		Iterator i = symbols.entrySet().iterator();

		while ( i.hasNext() ) {
		 Map.Entry entry = ( Map.Entry ) i.next();
		 Symbol sym = ( Symbol ) entry.getKey();
		 Double perc = ( Double ) entry.getValue();
		 System.out.println( "Id: " + sym.id + " : " + perc.toString() );
		}
	}
	
	public double getOverallCovered() {
		Enumeration enu = symbols.elements();
		
		double overallPercentage = 0;
		
        while ( enu.hasMoreElements() ) {
        	Double d = ( Double ) enu.nextElement();
        	overallPercentage += d.doubleValue();
        }
        
        return ( overallPercentage > 0 ) ? ( overallPercentage / symbols.size() ) : 0;
	}
	
}
