/*** 
 * 
 * @author Dominik Schindler 
 * 
 * MCDCoverageDetails.java - Class which contains the datailed information returned 
 * by the mcdc criteria.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.Vector;

public class MCDCoverageDetails {

	private Integer[][] valuesTable;
	private int cols;
	private int rows;
	private int r_cols;
	private Vector symbols;
	
	public MCDCoverageDetails( Vector v ) {
		this.symbols = v;
		buildValuesTable( v.size() );
	}

	public MCDCoverageDetails( int symbolsCount ) {
		this.symbols = null;
		buildValuesTable( symbolsCount  );
	}

	public void buildValuesTable( int symbolsCount ) {
		// columns = # symbols + 2 
		cols = symbolsCount;
		rows = ( int ) Math.pow( 2 , cols ); 
		r_cols = cols + 2;
		valuesTable = new Integer[ rows ][ r_cols ];
		
		// build symbol table by counting binary  
		for ( int y = 0; y < rows; y++ ) {
			for ( int x = 0; x < cols; x++ ) {
				// test, if bit x of y is set 
				boolean b = (y & 1 << x) != 0;
				valuesTable[y][x] = new Integer( b ? 1 : 0 );
			}
		}
		
		// fill forlast column (= column for branches) with false
		for ( int y = 0; y < rows; y++ ) {
				valuesTable[y][r_cols - 2] = new Integer( -1 );
		}
		
		// fill last column (= column for coverage markers) with false
		for ( int y = 0; y < rows; y++ ) {
				valuesTable[y][r_cols - 1] = new Integer( 0 );
		}
	}
	
	public int getRows() {
		return rows;
	}
	
	public int getCols() {
		return r_cols;
	}
	
	public Vector getSymbols() {
		return symbols;
	}
	
	public Integer[][] getValuesTable() {
		return valuesTable;
	}
	
	public Integer getValuesTable ( int row, int column ) {
		return valuesTable[row][column]; 
	}
	
	// returns covered rows
	public Vector getCovered() {
		Vector temp = new Vector();
		
		for ( int i = 0; i < rows; i++ ) {
			Integer[] item = valuesTable[ i ];
			if ( item[ r_cols - 1 ].intValue() > 0 ) {
				temp.add( item );
			}
		}
		return temp;
	}
	
	public void addEvaluation ( Integer[] row, boolean expression ) {
		for ( int y = 0; y < rows; y++ ) {
			
			boolean m = true;
			
			for ( int x = 0; x < cols; x++ ) {
				int b = valuesTable[y][x].intValue();
				int c = row[x].intValue();
				// wildcard 
				if (c == 2) {
					m = m && true;
				} else {
					m = m && ( b == c);
				}
			}
			// mark the row as covered, if not covered yet
			if ( m ) valuesTable[y][r_cols - 2] = new Integer( ( expression ) ? 1 : 0 );
		}	
	}
	
	public void compute() {
		for ( int i = 0; i < rows; i++ ) {
			Integer[] eval = valuesTable[ i ];
			compare( eval );
		}
	}
	
	private void compare( Integer[] eval1 ) {
		for ( int i = 0; i < rows; i++ ) {
			Integer[] eval2 = valuesTable[ i ];
			compare( eval1, eval2 );
		}
	}
	
	private void compare( Integer[] eval1, Integer[] eval2 ) {
		for ( int i = 0; i < cols; i++ ) {
			compare( eval1, eval2, i );
//			System.out.println(":"+i);
		}
	}
	
	private void compare( Integer[] eval1, Integer[] eval2, int k ) {
		boolean foundPair = true;
		for ( int i = 0; i < cols; i++ ) {
			if ( i == k ) continue;
			if ( eval1[ i ].intValue() == 2 ) {
				foundPair = foundPair && true;
			} else if ( eval2[ i ].intValue() == 2 ){
				foundPair = foundPair && true;
			} else {
				foundPair = foundPair && eval1[ i ].intValue() == eval2[ i ].intValue();
			}
			//System.out.println( eval1[ i ].toString() + ":" + eval2[ i ].toString() + ":" + foundPair );
		}
		
		// set bits, if pair found and complete expressions are not equal
		if ( ( eval2[ r_cols - 2 ].intValue() != -1 ) && (eval1[ r_cols - 2 ].intValue() != -1 )
				&& foundPair && ( eval1[ r_cols - 2 ].intValue() != eval2[ r_cols - 2 ].intValue() ) ) {
			eval1[ r_cols - 1 ] = new Integer( eval1[ r_cols - 1 ].intValue() | ( 1 << ( k ) ) );
			eval2[ r_cols - 1 ] = new Integer( eval2[ r_cols - 1 ].intValue() | ( 1 << ( k ) ) );
		} 
	}
	
	// prints values table to stdout for debugging
	public void printValuesTable() {
		if ( valuesTable == null ) return;
		
		for ( int y = 0; y < rows; y++ ) {
			System.out.print(y + ": ");
			for ( int x = 0; x < r_cols; x++ ) {
				System.out.print( ( valuesTable[y][x].intValue() ) );
			}
			System.out.println();
		}
	}
	
	// test 
	public static void main ( String[] args ) {

		MCDCoverageDetails mcdcod = new MCDCoverageDetails( 4 );
		
		mcdcod.printValuesTable();		
		
		Integer[] b = new Integer[4];
		b[0] = new Integer( 0 );
		b[1] = new Integer( 0 );
		b[2] = new Integer( 0 );
		b[3] = new Integer( 0 );
		mcdcod.addEvaluation( b, false );
		
		b = new Integer[4];
		b[0] = new Integer( 0 );
		b[1] = new Integer( 0 );
		b[2] = new Integer( 0 );
		b[3] = new Integer( 1 );
		mcdcod.addEvaluation( b, false );
		
		b = new Integer[4];
		b[0] = new Integer( 0 );
		b[1] = new Integer( 1 );
		b[2] = new Integer( 0 );
		b[3] = new Integer( 0 );
		mcdcod.addEvaluation( b, true );

		b = new Integer[4];
		b[0] = new Integer( 1 );
		b[1] = new Integer( 0 );
		b[2] = new Integer( 0 );
		b[3] = new Integer( 2 );
		mcdcod.addEvaluation( b, true );

		System.out.println( "====" );
		mcdcod.printValuesTable();
		System.out.println( "====" );
		
		mcdcod.compute();
		mcdcod.printValuesTable();
		System.out.println( "====" );

	}

}
