/*** 
 * 
 * @author Dominik Schindler 
 * 
 * MCCoverageDetails.java - Class which contains the datailed information returned 
 * by the mcc criteria.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;

public class MCCoverageDetails {

	private Integer[][] valuesTable;
	private int cols;
	private int rows;
	private int r_cols;
	private Vector symbols;
	
	public MCCoverageDetails( Vector v ) {
		this.symbols = v;
		buildValuesTable( symbols );
	}
	
	public Integer[][] getValuesTable() {
		return valuesTable;
	}
	
	public int getRows() {
		return rows;
	}
	
	public int getCols() {
		return r_cols;
	}
	
	public Vector getSymbols() {
		return this.symbols;
	}
	
	public void buildValuesTable( Vector symbols ) {
		// columns = # symbols + 1 for coverage
		cols = symbols.size();
		rows = ( int ) Math.pow( 2 , cols ); 
		r_cols = ++cols;
		valuesTable = new Integer[ rows ][ r_cols ];
		
		// build symbol table by counting binary  
		for ( int y = 0; y < rows; y++ ) {
			for ( int x = 0; x < cols; x++ ) {
				// test, if bit x of y is set 
				boolean b = (y & 1 << x) != 0;
				valuesTable[y][x] = new Integer( b ? 1 : 0 );
			}
		}
		
		// fill last column (= column for coverage markers) with false
		for ( int y = 0; y < rows; y++ ) {
				valuesTable[y][r_cols - 1] = new Integer( 0 );
		}
	}
	
	// prints values table to stdout
	public void printValuesTable() {
		if ( valuesTable == null ) return;
		
		for ( int y = 0; y < rows; y++ ) {
			System.out.print(y + ": ");
			for ( int x = 0; x < r_cols; x++ ) {
				System.out.print( ( valuesTable[y][x].intValue() ) );
			}
			System.out.println();
		}
		
	}
	
	// mark covered rows
	public void mark( Integer[] row ) {
		for ( int y = 0; y < rows; y++ ) {
			
			boolean m = true;
			
			for ( int x = 0; x < cols - 1; x++ ) {
				int b = valuesTable[y][x].intValue();
				int c = row[x].intValue();
				// wildcard 
				if (c == 2) {
					m = m && true;
				} else {
					m = m && ( b == c);
				}
			}
			// mark the row as covered, if not covered yet
			if ( valuesTable[y][cols - 1].intValue() == 0 ) {
				valuesTable[y][cols - 1] = new Integer( m ? 1 : 0 );
			}
		}
	}
	
	// retuns covered rows a vector
	public Vector getCovered() {
		Vector v = new Vector();
		for ( int y = 0; y < rows; y++ ) {
			if ( valuesTable[y][cols - 1].intValue() == 1 ) {
				v.add( new Integer ( y ) );
			}
		}
		return v;
	}

	// test 
	public static void main ( String[] args ) {
		Vector v = new Vector();
		v.add( new Integer( 1 ) );
		v.add( new Integer( 0 ) );
		v.add( new Integer( 1 ) );
		v.add( new Integer( 0 ) );
		
		MCCoverageDetails mmcod = new MCCoverageDetails(v);
		mmcod.printValuesTable();
		
		Integer[] b = new Integer[4];
		b[0] = new Integer( 1 );
		b[1] = new Integer( 1 );
		b[2] = new Integer( 1 );
		b[3] = new Integer( 1 );
		
		System.out.println( "====" );
		
		mmcod.mark ( b );

		b = new Integer[4];
		b[0] = new Integer( 1 );
		b[1] = new Integer( 1 );
		b[2] = new Integer( 0 );
		b[3] = new Integer( 0 );
		
		mmcod.mark ( b );
		
		mmcod.printValuesTable();

		System.out.println( "====" );

		System.out.println( mmcod.getCovered() );
		
	}
	
	
}
