/*** 
 * 
 * @author Dominik Schindler 
 * 
 * LoggerInputStream.java - Class for reading the logfiles.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;

public class LoggerInputStream {

	private long id;
	private long value;
	private long threadId;
	private DataInputStream dis;
	
	public LoggerInputStream(InputStream is) {
		dis = new DataInputStream(is);
	}

	public LogfileTriple readLine() throws IOException {
		try {
			id       = dis.readLong();
			value    = dis.readLong();
			threadId = dis.readLong();
			return new LogfileTriple(id, value, threadId);
		} catch (EOFException e) {
			return null;
		}
	}
	
	public void close() throws IOException {
		dis.close();
	}
}
