/*** 
 * 
 * @author Dominik Schindler
 * 
 * Logger.java - Provides the complete dynamic logging functionality  
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;
import java.lang.Thread;

public class Logger {
	
	// string added to the logfile name
	private static String logfilePrefix = null;
	private static String logfileSuffix = null;
	
	private static String logfile = null;
	private static LoggerOutputStream los = null; 
	
	// logs boolean values
	public static boolean _logB( boolean b, long id ) {
		
		Thread th = Thread.currentThread();
		if ( los == null ) initilizeLogfile();

		try {
			los.writeLine( id, ( b ) ? LoggerTypes.TRUE_VALUE : LoggerTypes.FALSE_VALUE, ( th != null) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return b;
	}

	// logs switch case with int
	public static void _logC( long id ) {
		
		Thread th = Thread.currentThread();
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( id, LoggerTypes.TRUE_VALUE, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	}
	
	// logs switch case with long if b = true
	public static void _logC ( boolean b, long id ) {
		if ( b ) {
			Thread th = Thread.currentThread();
			if ( los == null ) initilizeLogfile();
			
			try {
				los.writeLine( id, LoggerTypes.TRUE_VALUE, ( th != null ) ? th.hashCode() : 0 );
			} catch ( IOException e ) {
				printErrorMessage();
			}
		}
	}
	
	// logs polymorphic coverage
	public static void _logP( long var, long clas ) {
		Thread th = Thread.currentThread();
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( clas, LoggerTypes.TRUE_VALUE, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
	}
	
	// switch-case entered methods for all possible values
	public static final long _enterSwitch( long l, long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return l;
	}

	public static int _enterSwitch( int i, long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return i;
	}
	
	public static byte _enterSwitch( byte b, long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return b;
	}
	
	public static char _enterSwitch( char ch, long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return ch;
	}
	
	public static short _enterSwitch( short s, long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		
		return s;
	}
	
	// is called directly after the switch-case
	public static void _leftSwitch( long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.LEFT_SWITCH, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	}

	// functions used to handle exceptions in expressions
	// "container" for start- end endexpression methods
	public static boolean _catchException( long start, boolean b, long end ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.CATCH_EXCEPTION, start, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	
		return b;
	}
	
	// is called before the expression is evaluated
	public static long _startExpression(long id) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.START_EXPRESSION, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}

		return id;
	}
	
	// is called after the expression is succesfully evaluated
	public static long _endExpression( long id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.END_EXPRESSION, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
		return id;
	}

	// is called if the expresion throwed an exception
	public static void _handleException( long row ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.HANDLE_EXCEPTION, row, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	}
	
	// is called if a method is entered
	public static void _enterMethod( int id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.ENTER_METHOD, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	}

	// is called if the method is left
	public static void _leftMethod( int id ) {
		Thread th = Thread.currentThread();
		
		if ( los == null ) initilizeLogfile();
		
		try {
			los.writeLine( LoggerTypes.LEFT_METHOD, id, ( th != null ) ? th.hashCode() : 0 );
		} catch ( IOException e ) {
			printErrorMessage();
		}
	}

	// set up the logging functionality if not yet done
	private static void initilizeLogfile() {
		int count = 1;

		logfilePrefix = System.getProperty( "de.fau.cs.swe.sa.conditionCoverage.LogfilePrefix", "" );
		logfileSuffix = System.getProperty( "de.fau.cs.swe.sa.conditionCoverage.LogfileSuffix", "" );
		
		logfilePrefix.replace( SystemUtils.PACKAGE_SEPARATOR_CHAR, File.separatorChar );
		
	    // if logfiles not set, set do default	
	    if ( logfilePrefix.equals( "" ) ) logfilePrefix = "log.";
	    if ( logfileSuffix.equals( "" ) ) logfileSuffix = "";
		
		try {
			// do not overwrite existing logfiles
			logfile = logfilePrefix + count + logfileSuffix;
			File f = new File( logfile );

			while ( f.exists() ) {
				count++;
				logfile = logfilePrefix + count + logfileSuffix;
				f = new File( logfile );
			}
			
			los = new LoggerOutputStream( new FileOutputStream( f ) );
		} catch ( IOException e ) {
			System.out.println( "Could not create logfile '" + logfile + "'!" );	
			System.exit( 1 );
		}
	}
	
	private static void printErrorMessage() {
		System.err.println( "Error writing to logfile '" + logfile + "'!" );
		System.exit( 1 );
	}
}
