// $ANTLR 2.7.5 (20050128): "java15.tree.writer.g" -> "JavaTreeWriter.java"$

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;
import java.util.*;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/** Java 1.5 AST Recognizer Grammar
 *
 * JavaTreeWriter.java - This class implements all the 
 * functionality to write the AST back to valid (and pretty) 
 * java code using the PrintWriter "dest".
 *
 * @author: (see java.g preamble) && Dominik Schindler
 *
 * This grammar is in the PUBLIC DOMAIN
 */
public class JavaTreeWriter extends antlr.TreeParser       implements JavaTreeWriterTokenTypes
 {
	// methods for logging
	private final String logCString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logC";
	private final String logBString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logB";
	private final String logPString = "de.fau.cs.swe.sa.conditionCoverage.Logger._logP";
	private final String enterSwitch = "de.fau.cs.swe.sa.conditionCoverage.Logger._enterSwitch";
	private final String leaveSwitch = "de.fau.cs.swe.sa.conditionCoverage.Logger._leftSwitch";
	private final String startExpression = "de.fau.cs.swe.sa.conditionCoverage.Logger._startExpression";
	private final String endExpression = "de.fau.cs.swe.sa.conditionCoverage.Logger._endExpression";
	private final String handleException = "de.fau.cs.swe.sa.conditionCoverage.Logger._handleException";
	private final String catchException = "de.fau.cs.swe.sa.conditionCoverage.Logger._catchException";
	private final String enterMethod = "de.fau.cs.swe.sa.conditionCoverage.Logger._enterMethod";
	private final String leaveMethod = "de.fau.cs.swe.sa.conditionCoverage.Logger._leftMethod";
	
	//
	private boolean autoFlush = true;
	
	// used for pretty printing
	private int level = 0;
	
	// store the current row for the symbol table
	private int row = 1;
	
	// is logging on or off?
	private boolean isLogging = false;
	
	// dont print an EOS = ";" 	
	boolean noEos = false;
	
	// 
	private String methodID = "0";
	
	//
	private boolean isCtorCall = false;
	
	// for writing the output file
	private PrintWriter dest = new PrintWriter(System.out, true); 
	
	// for writing the symbol table
	private PrintWriter symbolTable = new PrintWriter(System.out, true);
	
	// parentheses arround an elist (= list of expressions)
	private boolean Paren = false;
	//
	private ClassHierarchie ch = null;
	
	// constructors
	public JavaTreeWriter( OutputStream os ) {
		this();		
		dest = new PrintWriter( os, autoFlush );
	}
	//
//	public JavaTreeWriter( OutputStream os ) { // , ClassHierarchie ch, Hashtable variables, Hashtable methods ) {
//		this();		
//		this.ch = ch;
//		this.variableDecls = variables;
//		this.methodDecls = methods;
//		dest = new PrintWriter( os, autoFlush );
//	}
	
	// set the output for the symbol table
	public void setSymbolTable(OutputStream os) {
		symbolTable = new PrintWriter(os, autoFlush);
	}
	
	// === internal helper functions ===
	
	// end of statement
	private void eos() { 
		dest.print(";");
	}
	
	// print newline to dest
	private void newline() {
		dest.println();
		for (int i = 0; i < level; i++) {
			dest.print("\t");
			dest.flush();
		}
		row++;
	}
	
	// print count newlines to dest
	private void newline(int count) {
		for (int i = 0; i < count; i++)
			dest.println();
		for (int i = 0; i < level; i++) {
			dest.print("\t");
			dest.flush();
		}
		row += count;
	}
	// print s to dest
	private void pprint(String s) {
		dest.print(s);
		dest.flush(); // remove later!
	}
	// increase level 
	private void incLevel() {
		level++;
		newline();
	}	
	// decrease level
	private void decLevel() {
		if (level > 0) level--;
		newline();
	}
	
	// writes the symbol table
	private void writeSTable(String id, int row, String type_, String exp, String notes) {
		symbolTable.println(
			id + "\t" + 
			String.valueOf(row) + "\t" +
			type_ + "\t" +		  						  	
			exp + "\t" + 
			notes);
		symbolTable.flush();		
	}
	
public JavaTreeWriter() {
	tokenNames = _tokenNames;
}

	public final void compilationUnit(AST _t) throws RecognitionException {
		
		AST compilationUnit_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case PACKAGE_DEF:
			{
				packageDefinition(_t);
				_t = _retTree;
				break;
			}
			case 3:
			case CLASS_DEF:
			case INTERFACE_DEF:
			case IMPORT:
			case STATIC_IMPORT:
			case ENUM_DEF:
			case ANNOTATION_DEF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
				
							// add the logging functionality to class
							// newline();
							// write header of symbol table
							//symbolTable.println("ID\tRow\tType\tExpression\tNotes");
						
			{
			_loop4:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IMPORT||_t.getType()==STATIC_IMPORT)) {
					importDefinition(_t);
					_t = _retTree;
				}
				else {
					break _loop4;
				}
				
			} while (true);
			}
			{
			_loop6:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					typeDefinition(_t);
					_t = _retTree;
				}
				else {
					break _loop6;
				}
				
			} while (true);
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void packageDefinition(AST _t) throws RecognitionException {
		
		AST packageDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t8 = _t;
			AST tmp1_AST_in = (AST)_t;
			match(_t,PACKAGE_DEF);
			_t = _t.getFirstChild();
			annotations(_t);
			_t = _retTree;
			
								pprint("package "); 
							
			identifier(_t);
			_t = _retTree;
			
				   				eos(); 
				   				newline();
				   			
			_t = __t8;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void importDefinition(AST _t) throws RecognitionException {
		
		AST importDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST im = null;
		AST sim = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IMPORT:
			{
				AST __t10 = _t;
				im = _t==ASTNULL ? null :(AST)_t;
				match(_t,IMPORT);
				_t = _t.getFirstChild();
				
									pprint(im.getText() + " "); 
								
				identifierStar(_t);
				_t = _retTree;
				
					   				eos(); 
					   				newline();
					   			
				_t = __t10;
				_t = _t.getNextSibling();
				break;
			}
			case STATIC_IMPORT:
			{
				AST __t11 = _t;
				sim = _t==ASTNULL ? null :(AST)_t;
				match(_t,STATIC_IMPORT);
				_t = _t.getFirstChild();
				identifierStar(_t);
				_t = _retTree;
				_t = __t11;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void typeDefinition(AST _t) throws RecognitionException {
		
		AST typeDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id4 = null;
		AST name = null;
		AST type = null;
		AST id = null;
		AST id2 = null;
		AST id3 = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CLASS_DEF:
			{
				AST __t13 = _t;
				AST tmp2_AST_in = (AST)_t;
				match(_t,CLASS_DEF);
				_t = _t.getFirstChild();
				id4 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				name = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				type = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								writeSTable(id4.getText(), row, type.getText(), name.getText(), "");
									newline(); 
								
				modifiers(_t);
				_t = _retTree;
					
						   			pprint("class ");
						   		
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						   			pprint(id.getText() + " "); 
						   		
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_PARAMETERS:
				{
					typeParameters(_t);
					_t = _retTree;
					break;
				}
				case EXTENDS_CLAUSE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				extendsClause(_t);
				_t = _retTree;
				implementsClause(_t);
				_t = _retTree;
				
						   		//	pprint("{");
						   		// 	incLevel(); 
						   		
				objBlock(_t);
				_t = _retTree;
				
						   		//	decLevel(); 
								writeSTable(id4.getText(), row, "kl", name.getText(), "");
						   		//  	pprint("}");
						   		//  	newline();
						   		
				_t = __t13;
				_t = _t.getNextSibling();
				break;
			}
			case INTERFACE_DEF:
			{
				AST __t15 = _t;
				AST tmp3_AST_in = (AST)_t;
				match(_t,INTERFACE_DEF);
				_t = _t.getFirstChild();
				
									newline(); 
								
				modifiers(_t);
				_t = _retTree;
					
						   			pprint("interface ");
						   		
				id2 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						   			pprint(id2.getText() + " "); 
						   		
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_PARAMETERS:
				{
					typeParameters(_t);
					_t = _retTree;
					break;
				}
				case EXTENDS_CLAUSE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				extendsClause(_t);
				_t = _retTree;
				
						   			pprint("{");
						   		 	incLevel(); 
						   		
				interfaceBlock(_t);
				_t = _retTree;
				
						   			decLevel();  
						   		  	pprint("}");
						   		  	newline();
						   		
				_t = __t15;
				_t = _t.getNextSibling();
				break;
			}
			case ENUM_DEF:
			{
				AST __t17 = _t;
				AST tmp4_AST_in = (AST)_t;
				match(_t,ENUM_DEF);
				_t = _t.getFirstChild();
				modifiers(_t);
				_t = _retTree;
					
						   			pprint("enum ");
						   		
				id3 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						   			pprint(id3.getText() + " "); 
						   		
				implementsClause(_t);
				_t = _retTree;
				
						   			pprint("{ ");
				//		   		 	incLevel(); 
						   		
				enumBlock(_t);
				_t = _retTree;
				
				//		   			decLevel();  
						   		  	pprint(" }");
						   		  	newline();
						   		
				_t = __t17;
				_t = _t.getNextSibling();
				break;
			}
			case ANNOTATION_DEF:
			{
				AST __t18 = _t;
				AST tmp5_AST_in = (AST)_t;
				match(_t,ANNOTATION_DEF);
				_t = _t.getFirstChild();
				modifiers(_t);
				_t = _retTree;
				AST tmp6_AST_in = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				annotationBlock(_t);
				_t = _retTree;
				_t = __t18;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void annotations(AST _t) throws RecognitionException {
		
		AST annotations_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t62 = _t;
			AST tmp7_AST_in = (AST)_t;
			match(_t,ANNOTATIONS);
			_t = _t.getFirstChild();
			{
			_loop64:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ANNOTATION)) {
					annotation(_t);
					_t = _retTree;
				}
				else {
					break _loop64;
				}
				
			} while (true);
			}
			_t = __t62;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void identifier(AST _t) throws RecognitionException {
		
		AST identifier_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ide = null;
		AST dot = null;
		AST ide_ = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				ide = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								dest.print(ide.getText()); 
							
				break;
			}
			case DOT:
			{
				AST __t160 = _t;
				dot = _t==ASTNULL ? null :(AST)_t;
				match(_t,DOT);
				_t = _t.getFirstChild();
				identifier(_t);
				_t = _retTree;
				
						   			dest.print(dot.getText());
						   		
				ide_ = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						   			dest.print(ide_.getText());
						   		
				_t = __t160;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void identifierStar(AST _t) throws RecognitionException {
		
		AST identifierStar_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST dot = null;
		AST st = null;
		AST id_ = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								pprint(id.getText()); 
							
				break;
			}
			case DOT:
			{
				AST __t162 = _t;
				dot = _t==ASTNULL ? null :(AST)_t;
				match(_t,DOT);
				_t = _t.getFirstChild();
				identifier(_t);
				_t = _retTree;
				
						   			pprint(dot.getText()); 
						   		
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case STAR:
				{
					st = (AST)_t;
					match(_t,STAR);
					_t = _t.getNextSibling();
					
							   			pprint(st.getText()); 
							   		
					break;
				}
				case IDENT:
				{
					id_ = (AST)_t;
					match(_t,IDENT);
					_t = _t.getNextSibling();
					
							   			pprint(id_.getText()); 
							   		
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t162;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void modifiers(AST _t) throws RecognitionException {
		
		AST modifiers_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t57 = _t;
			AST tmp8_AST_in = (AST)_t;
			match(_t,MODIFIERS);
			_t = _t.getFirstChild();
			{
			_loop59:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_1.member(_t.getType()))) {
					modifier(_t);
					_t = _retTree;
				}
				else {
					break _loop59;
				}
				
			} while (true);
			}
			_t = __t57;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void typeParameters(AST _t) throws RecognitionException {
		
		AST typeParameters_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		int i = 0;
		
		try {      // for error handling
			AST __t20 = _t;
			AST tmp9_AST_in = (AST)_t;
			match(_t,TYPE_PARAMETERS);
			_t = _t.getFirstChild();
			{
			int _cnt22=0;
			_loop22:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==TYPE_PARAMETER)) {
					typeParameter(_t);
					_t = _retTree;
						
										// to handle the trailing comma correctly
										if (i > 0) pprint(", "); 
										i++;
									
				}
				else {
					if ( _cnt22>=1 ) { break _loop22; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt22++;
			} while (true);
			}
			_t = __t20;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void extendsClause(AST _t) throws RecognitionException {
		
		AST extendsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t79 = _t;
			AST tmp10_AST_in = (AST)_t;
			match(_t,EXTENDS_CLAUSE);
			_t = _t.getFirstChild();
			{
			_loop81:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					
											pprint("extends ");
										
					classOrInterfaceType(_t);
					_t = _retTree;
				}
				else {
					break _loop81;
				}
				
			} while (true);
			}
			_t = __t79;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void implementsClause(AST _t) throws RecognitionException {
		
		AST implementsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
			int i = 0;
		
		
		try {      // for error handling
			AST __t83 = _t;
			AST tmp11_AST_in = (AST)_t;
			match(_t,IMPLEMENTS_CLAUSE);
			_t = _t.getFirstChild();
			{
			_loop85:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						
										// to handle the trailing comma correctly
										if (i == 0) pprint("implements "); 
										if (i > 0) pprint(", "); 
										i++;
									
					classOrInterfaceType(_t);
					_t = _retTree;
				}
				else {
					break _loop85;
				}
				
			} while (true);
			}
			_t = __t83;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void objBlock(AST _t) throws RecognitionException {
		
		AST objBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t91 = _t;
			AST tmp12_AST_in = (AST)_t;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			
								pprint("{");
								incLevel();
							
			{
			_loop97:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case CTOR_DEF:
				{
					{
					
											newline();
										
					ctorDef(_t);
					_t = _retTree;
					}
					break;
				}
				case METHOD_DEF:
				{
					{
					
											newline();
										
					methodDef(_t);
					_t = _retTree;
					}
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					
											eos();
											newline();
										
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					break;
				}
				case STATIC_INIT:
				{
					AST __t95 = _t;
					AST tmp13_AST_in = (AST)_t;
					match(_t,STATIC_INIT);
					_t = _t.getFirstChild();
					slist(_t,null);
					_t = _retTree;
					_t = __t95;
					_t = _t.getNextSibling();
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t96 = _t;
					AST tmp14_AST_in = (AST)_t;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t,null);
					_t = _retTree;
					_t = __t96;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop97;
				}
				}
			} while (true);
			}
			_t = __t91;
			_t = _t.getNextSibling();
			
								pprint("}");
								decLevel();
							
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void interfaceBlock(AST _t) throws RecognitionException {
		
		AST interfaceBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t87 = _t;
			AST tmp15_AST_in = (AST)_t;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop89:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case METHOD_DEF:
				{
					methodDecl(_t);
					_t = _retTree;
					
											eos();
											newline();
										
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					
											eos();
											newline();
										
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					break;
				}
				default:
				{
					break _loop89;
				}
				}
			} while (true);
			}
			_t = __t87;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void enumBlock(AST _t) throws RecognitionException {
		
		AST enumBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		int i = 0;
		
		try {      // for error handling
			AST __t103 = _t;
			AST tmp16_AST_in = (AST)_t;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop105:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ENUM_CONSTANT_DEF)) {
						
										// to handle the trailing comma correctly
										if (i > 0) pprint(", "); 
										i++;
									
					enumConstantDef(_t);
					_t = _retTree;
				}
				else {
					break _loop105;
				}
				
			} while (true);
			}
			{
			_loop109:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case CTOR_DEF:
				{
					ctorDef(_t);
					_t = _retTree;
					break;
				}
				case METHOD_DEF:
				{
					methodDef(_t);
					_t = _retTree;
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					break;
				}
				case STATIC_INIT:
				{
					AST __t107 = _t;
					AST tmp17_AST_in = (AST)_t;
					match(_t,STATIC_INIT);
					_t = _t.getFirstChild();
					slist(_t,null);
					_t = _retTree;
					_t = __t107;
					_t = _t.getNextSibling();
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t108 = _t;
					AST tmp18_AST_in = (AST)_t;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t,null);
					_t = _retTree;
					_t = __t108;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop109;
				}
				}
			} while (true);
			}
			_t = __t103;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void annotationBlock(AST _t) throws RecognitionException {
		
		AST annotationBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t99 = _t;
			AST tmp19_AST_in = (AST)_t;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop101:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ANNOTATION_FIELD_DEF:
				{
					annotationFieldDecl(_t);
					_t = _retTree;
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					break;
				}
				default:
				{
					break _loop101;
				}
				}
			} while (true);
			}
			_t = __t99;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void typeParameter(AST _t) throws RecognitionException {
		
		AST typeParameter_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t24 = _t;
			AST tmp20_AST_in = (AST)_t;
			match(_t,TYPE_PARAMETER);
			_t = _t.getFirstChild();
			AST tmp21_AST_in = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			{
				typeUpperBounds(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t24;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void typeUpperBounds(AST _t) throws RecognitionException {
		
		AST typeUpperBounds_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t27 = _t;
			AST tmp22_AST_in = (AST)_t;
			match(_t,TYPE_UPPER_BOUNDS);
			_t = _t.getFirstChild();
			{
			int _cnt29=0;
			_loop29:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					classOrInterfaceType(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt29>=1 ) { break _loop29; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt29++;
			} while (true);
			}
			_t = __t27;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void classOrInterfaceType(AST _t) throws RecognitionException {
		
		AST classOrInterfaceType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST dot = null;
		AST ide = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								pprint(id.getText() + " ");
							
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_ARGUMENTS:
				{
					typeArguments(_t);
					_t = _retTree;
					break;
				}
				case 3:
				case ARRAY_DECLARATOR:
				case ELIST:
				case IDENT:
				case DOT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			case DOT:
			{
				AST __t37 = _t;
				dot = _t==ASTNULL ? null :(AST)_t;
				match(_t,DOT);
				_t = _t.getFirstChild();
				classOrInterfaceType(_t);
				_t = _retTree;
				ide = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						   			pprint(dot.getText() + ide + " ");
						   		
				_t = __t37;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  typeSpec(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeSpec_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t31 = _t;
			AST tmp23_AST_in = (AST)_t;
			match(_t,TYPE);
			_t = _t.getFirstChild();
			typeSpecArray(_t);
			_t = _retTree;
			_t = __t31;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void typeSpecArray(AST _t) throws RecognitionException {
		
		AST typeSpecArray_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				AST __t33 = _t;
				AST tmp24_AST_in = (AST)_t;
				match(_t,ARRAY_DECLARATOR);
				_t = _t.getFirstChild();
				typeSpecArray(_t);
				_t = _retTree;
				
					       			pprint("[]" + " "); 
					       		
				_t = __t33;
				_t = _t.getNextSibling();
				break;
			}
			case IDENT:
			case DOT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				type(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  type(AST _t) throws RecognitionException {
		String result = "";
		
		AST type_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			case DOT:
			{
				classOrInterfaceType(_t);
				_t = _retTree;
				break;
			}
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				builtInType(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void builtInType(AST _t) throws RecognitionException {
		
		AST builtInType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST vo = null;
		AST bo = null;
		AST by = null;
		AST ch = null;
		AST sh = null;
		AST in = null;
		AST fl = null;
		AST lo = null;
		AST dou = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_void:
			{
				vo = (AST)_t;
				match(_t,LITERAL_void);
				_t = _t.getNextSibling();
				
								pprint(vo.getText() + " "); 
							
				break;
			}
			case LITERAL_boolean:
			{
				bo = (AST)_t;
				match(_t,LITERAL_boolean);
				_t = _t.getNextSibling();
				
								pprint(bo.getText() + " "); 
							
				break;
			}
			case LITERAL_byte:
			{
				by = (AST)_t;
				match(_t,LITERAL_byte);
				_t = _t.getNextSibling();
				
								pprint(by.getText() + " "); 
							
				break;
			}
			case LITERAL_char:
			{
				ch = (AST)_t;
				match(_t,LITERAL_char);
				_t = _t.getNextSibling();
					
								pprint(ch.getText() + " "); 
							
				break;
			}
			case LITERAL_short:
			{
				sh = (AST)_t;
				match(_t,LITERAL_short);
				_t = _t.getNextSibling();
				
								pprint(sh.getText() + " "); 
							
				break;
			}
			case LITERAL_int:
			{
				in = (AST)_t;
				match(_t,LITERAL_int);
				_t = _t.getNextSibling();
				
								pprint(in.getText() + " "); 
							
				break;
			}
			case LITERAL_float:
			{
				fl = (AST)_t;
				match(_t,LITERAL_float);
				_t = _t.getNextSibling();
				
								pprint(fl.getText() + " "); 
							
				break;
			}
			case LITERAL_long:
			{
				lo = (AST)_t;
				match(_t,LITERAL_long);
				_t = _t.getNextSibling();
				
								pprint(lo.getText() + " "); 
							
				break;
			}
			case LITERAL_double:
			{
				dou = (AST)_t;
				match(_t,LITERAL_double);
				_t = _t.getNextSibling();
				
								pprint(dou.getText() + " "); 
							
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  typeArguments(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeArguments_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t39 = _t;
			AST tmp25_AST_in = (AST)_t;
			match(_t,TYPE_ARGUMENTS);
			_t = _t.getFirstChild();
			{
			int _cnt41=0;
			_loop41:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==TYPE_ARGUMENT)) {
					typeArgument(_t);
					_t = _retTree;
				}
				else {
					if ( _cnt41>=1 ) { break _loop41; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt41++;
			} while (true);
			}
			_t = __t39;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void typeArgument(AST _t) throws RecognitionException {
		
		AST typeArgument_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t43 = _t;
			AST tmp26_AST_in = (AST)_t;
			match(_t,TYPE_ARGUMENT);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			{
				typeSpec(_t);
				_t = _retTree;
				break;
			}
			case WILDCARD_TYPE:
			{
				wildcardType(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t43;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void wildcardType(AST _t) throws RecognitionException {
		
		AST wildcardType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t46 = _t;
			AST tmp27_AST_in = (AST)_t;
			match(_t,WILDCARD_TYPE);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			case TYPE_LOWER_BOUNDS:
			{
				typeArgumentBounds(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t46;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void typeArgumentBounds(AST _t) throws RecognitionException {
		
		AST typeArgumentBounds_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			{
				AST __t49 = _t;
				AST tmp28_AST_in = (AST)_t;
				match(_t,TYPE_UPPER_BOUNDS);
				_t = _t.getFirstChild();
				{
				int _cnt51=0;
				_loop51:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						classOrInterfaceType(_t);
						_t = _retTree;
					}
					else {
						if ( _cnt51>=1 ) { break _loop51; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt51++;
				} while (true);
				}
				_t = __t49;
				_t = _t.getNextSibling();
				break;
			}
			case TYPE_LOWER_BOUNDS:
			{
				AST __t52 = _t;
				AST tmp29_AST_in = (AST)_t;
				match(_t,TYPE_LOWER_BOUNDS);
				_t = _t.getFirstChild();
				{
				int _cnt54=0;
				_loop54:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						classOrInterfaceType(_t);
						_t = _retTree;
					}
					else {
						if ( _cnt54>=1 ) { break _loop54; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt54++;
				} while (true);
				}
				_t = __t52;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void modifier(AST _t) throws RecognitionException {
		
		AST modifier_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST pr = null;
		AST pu = null;
		AST pro = null;
		AST st = null;
		AST tr = null;
		AST fi = null;
		AST ab = null;
		AST na = null;
		AST th = null;
		AST sy = null;
		AST co = null;
		AST vo = null;
		AST str = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_private:
			{
				pr = (AST)_t;
				match(_t,LITERAL_private);
				_t = _t.getNextSibling();
				
								pprint(pr.getText() + " "); 
							
				break;
			}
			case LITERAL_public:
			{
				pu = (AST)_t;
				match(_t,LITERAL_public);
				_t = _t.getNextSibling();
				
								pprint(pu.getText() + " "); 
							
				break;
			}
			case LITERAL_protected:
			{
				pro = (AST)_t;
				match(_t,LITERAL_protected);
				_t = _t.getNextSibling();
				
								pprint(pro.getText() + " "); 
							
				break;
			}
			case LITERAL_static:
			{
				st = (AST)_t;
				match(_t,LITERAL_static);
				_t = _t.getNextSibling();
				
								pprint(st.getText() + " "); 
							
				break;
			}
			case LITERAL_transient:
			{
				tr = (AST)_t;
				match(_t,LITERAL_transient);
				_t = _t.getNextSibling();
				
								pprint(tr.getText() + " "); 
							
				break;
			}
			case FINAL:
			{
				fi = (AST)_t;
				match(_t,FINAL);
				_t = _t.getNextSibling();
				
								pprint(fi.getText() + " "); 
							
				break;
			}
			case ABSTRACT:
			{
				ab = (AST)_t;
				match(_t,ABSTRACT);
				_t = _t.getNextSibling();
				
								pprint(ab.getText() + " "); 
							
				break;
			}
			case LITERAL_native:
			{
				na = (AST)_t;
				match(_t,LITERAL_native);
				_t = _t.getNextSibling();
				
								pprint(na.getText() + " "); 
							
				break;
			}
			case LITERAL_threadsafe:
			{
				th = (AST)_t;
				match(_t,LITERAL_threadsafe);
				_t = _t.getNextSibling();
				
								pprint(th.getText() + " "); 
							
				break;
			}
			case LITERAL_synchronized:
			{
				sy = (AST)_t;
				match(_t,LITERAL_synchronized);
				_t = _t.getNextSibling();
				
								pprint(sy.getText() + " "); 
							
				break;
			}
			case LITERAL_const:
			{
				co = (AST)_t;
				match(_t,LITERAL_const);
				_t = _t.getNextSibling();
				
								pprint(co.getText() + " "); 
							
				break;
			}
			case LITERAL_volatile:
			{
				vo = (AST)_t;
				match(_t,LITERAL_volatile);
				_t = _t.getNextSibling();
				
								pprint(vo.getText() + " "); 
							
				break;
			}
			case STRICTFP:
			{
				str = (AST)_t;
				match(_t,STRICTFP);
				_t = _t.getNextSibling();
				
								pprint(str.getText() + " "); 
							
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void annotation(AST _t) throws RecognitionException {
		
		AST annotation_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t66 = _t;
			AST tmp30_AST_in = (AST)_t;
			match(_t,ANNOTATION);
			_t = _t.getFirstChild();
			identifier(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case ANNOTATION:
			case ANNOTATION_ARRAY_INIT:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				annotationMemberValueInitializer(_t);
				_t = _retTree;
				break;
			}
			case ANNOTATION_MEMBER_VALUE_PAIR:
			{
				{
				int _cnt69=0;
				_loop69:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==ANNOTATION_MEMBER_VALUE_PAIR)) {
						anntotationMemberValuePair(_t);
						_t = _retTree;
					}
					else {
						if ( _cnt69>=1 ) { break _loop69; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt69++;
				} while (true);
				}
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t66;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void annotationMemberValueInitializer(AST _t) throws RecognitionException {
		
		AST annotationMemberValueInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				conditionalExpr(_t);
				_t = _retTree;
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				break;
			}
			case ANNOTATION_ARRAY_INIT:
			{
				annotationMemberializer(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void anntotationMemberValuePair(AST _t) throws RecognitionException {
		
		AST anntotationMemberValuePair_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t72 = _t;
			AST tmp31_AST_in = (AST)_t;
			match(_t,ANNOTATION_MEMBER_VALUE_PAIR);
			_t = _t.getFirstChild();
			AST tmp32_AST_in = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			annotationMemberValueInitializer(_t);
			_t = _retTree;
			_t = __t72;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  conditionalExpr(AST _t) throws RecognitionException {
		String result = "";
		
		AST conditionalExpr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST que = null;
		AST id = null;
		AST exp = null;
		AST type_ = null;
		AST lor = null;
		AST land = null;
		AST bo = null;
		AST bx = null;
		AST ba = null;
		AST neq = null;
		AST eq = null;
		AST lt = null;
		AST gt = null;
		AST le = null;
		AST ge = null;
		AST sl = null;
		AST sr = null;
		AST bsr = null;
		AST pl = null;
		AST mi = null;
		AST di = null;
		AST mo = null;
		AST st = null;
		AST in = null;
		AST de = null;
		AST poi = null;
		AST pod = null;
		AST bnot = null;
		AST lnot = null;
		AST io = null;
		AST um = null;
		AST up = null;
		
			String str_right = "";
			String str_left = "";
			String str_middle = "";
			
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case QUESTION:
			{
				AST __t233 = _t;
				que = _t==ASTNULL ? null :(AST)_t;
				match(_t,QUESTION);
				_t = _t.getFirstChild();
					// if the "logB"-token is matched, insert the logB function
									pprint(" ( " + catchException + " ( ");
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
									pprint(startExpression + "( " + id.getText() + " ), " + logBString + "( ");				
								
				str_left=expr(_t);
				_t = _retTree;
				
						   			pprint(", "); 
						   			pprint(id.getText() + " ), " + endExpression + "( " + id + " ) ) )"); 
						   		
				exp = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				type_ = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
					
									// write the symbol table
									writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
									pprint(que.getText() + " ( ");
								
				str_middle=expr(_t);
				_t = _retTree;
				
									pprint(" ) : ( "); 
								
				str_right=expr(_t);
				_t = _retTree;
					
									pprint(" ) "); 
									result = str_left + " " + que.getText() + " " + str_middle + " : " + str_right;
								
				_t = __t233;
				_t = _t.getNextSibling();
				break;
			}
			case LOR:
			{
				AST __t234 = _t;
				lor = _t==ASTNULL ? null :(AST)_t;
				match(_t,LOR);
				_t = _t.getFirstChild();
					
									pprint("( "); 
								
				str_left=expr(_t);
				_t = _retTree;
				
					      			pprint(" " + lor.getText() + " "); 
					      		
				str_right=expr(_t);
				_t = _retTree;
					
					      			pprint(") "); 
									result = str_left + " " + lor.getText() + " " + str_right;
					      		
				_t = __t234;
				_t = _t.getNextSibling();
				break;
			}
			case LAND:
			{
				AST __t235 = _t;
				land = _t==ASTNULL ? null :(AST)_t;
				match(_t,LAND);
				_t = _t.getFirstChild();
				
									pprint("( "); 
								
				str_left=expr(_t);
				_t = _retTree;
				
						    		pprint(" " + land.getText() + " "); 
						    	
				str_right=expr(_t);
				_t = _retTree;
				
					      			pprint(") "); 
									result = str_left + " " + land.getText() + " " + str_right;
					      		
				_t = __t235;
				_t = _t.getNextSibling();
				break;
			}
			case BOR:
			{
				AST __t236 = _t;
				bo = _t==ASTNULL ? null :(AST)_t;
				match(_t,BOR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							  		pprint(" " + bo.getText() + " "); 
							  	
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bo.getText() + " " + str_right;
								
				_t = __t236;
				_t = _t.getNextSibling();
				break;
			}
			case BXOR:
			{
				AST __t237 = _t;
				bx = _t==ASTNULL ? null :(AST)_t;
				match(_t,BXOR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							  		pprint(" " + bx.getText() + " ");
							  	
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bx.getText() + " " + str_right;
								
				_t = __t237;
				_t = _t.getNextSibling();
				break;
			}
			case BAND:
			{
				AST __t238 = _t;
				ba = _t==ASTNULL ? null :(AST)_t;
				match(_t,BAND);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							  		pprint(" " + ba.getText() + " "); 
							  	
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + ba.getText() + " " + str_right;
								
				_t = __t238;
				_t = _t.getNextSibling();
				break;
			}
			case NOT_EQUAL:
			{
				AST __t239 = _t;
				neq = _t==ASTNULL ? null :(AST)_t;
				match(_t,NOT_EQUAL);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							  		pprint(" " + neq.getText() + " "); 
							  	
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + neq.getText() + " " + str_right;
								
				_t = __t239;
				_t = _t.getNextSibling();
				break;
			}
			case EQUAL:
			{
				AST __t240 = _t;
				eq = _t==ASTNULL ? null :(AST)_t;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							  		pprint(" " + eq.getText() + " "); 
							  	
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + eq.getText() + " " + str_right;
								
				_t = __t240;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t241 = _t;
				lt = _t==ASTNULL ? null :(AST)_t;
				match(_t,LT);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
									pprint(" " + lt.getText() + " "); 
								
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + lt.getText() + " " + str_right;
								
				_t = __t241;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t242 = _t;
				gt = _t==ASTNULL ? null :(AST)_t;
				match(_t,GT);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + gt.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + gt.getText() + " " + str_right;
						    	
				_t = __t242;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t243 = _t;
				le = _t==ASTNULL ? null :(AST)_t;
				match(_t,LE);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + le.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + le.getText() + " " + str_right;
								
				_t = __t243;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t244 = _t;
				ge = _t==ASTNULL ? null :(AST)_t;
				match(_t,GE);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + ge.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + ge.getText() + " " + str_right;
								
				_t = __t244;
				_t = _t.getNextSibling();
				break;
			}
			case SL:
			{
				AST __t245 = _t;
				sl = _t==ASTNULL ? null :(AST)_t;
				match(_t,SL);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + sl.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + sl.getText() + " " + str_right;
								
				_t = __t245;
				_t = _t.getNextSibling();
				break;
			}
			case SR:
			{
				AST __t246 = _t;
				sr = _t==ASTNULL ? null :(AST)_t;
				match(_t,SR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + sr.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + sr.getText() + " " + str_right;
								
				_t = __t246;
				_t = _t.getNextSibling();
				break;
			}
			case BSR:
			{
				AST __t247 = _t;
				bsr = _t==ASTNULL ? null :(AST)_t;
				match(_t,BSR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + bsr.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bsr.getText() + " " + str_right;
								
				_t = __t247;
				_t = _t.getNextSibling();
				break;
			}
			case PLUS:
			{
				AST __t248 = _t;
				pl = _t==ASTNULL ? null :(AST)_t;
				match(_t,PLUS);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + pl.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + pl.getText() + " " + str_right;
								
				_t = __t248;
				_t = _t.getNextSibling();
				break;
			}
			case MINUS:
			{
				AST __t249 = _t;
				mi = _t==ASTNULL ? null :(AST)_t;
				match(_t,MINUS);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + mi.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + mi.getText() + " " + str_right;
								
				_t = __t249;
				_t = _t.getNextSibling();
				break;
			}
			case DIV:
			{
				AST __t250 = _t;
				di = _t==ASTNULL ? null :(AST)_t;
				match(_t,DIV);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + di.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + di.getText() + " " + str_right;
								
				_t = __t250;
				_t = _t.getNextSibling();
				break;
			}
			case MOD:
			{
				AST __t251 = _t;
				mo = _t==ASTNULL ? null :(AST)_t;
				match(_t,MOD);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + mo.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + mo.getText() + " " + str_right;
								
				_t = __t251;
				_t = _t.getNextSibling();
				break;
			}
			case STAR:
			{
				AST __t252 = _t;
				st = _t==ASTNULL ? null :(AST)_t;
				match(_t,STAR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
							    	pprint(" " + st.getText() + " "); 
							
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + st.getText() + " " + str_right;
								
				_t = __t252;
				_t = _t.getNextSibling();
				break;
			}
			case INC:
			{
				AST __t253 = _t;
				in = _t==ASTNULL ? null :(AST)_t;
				match(_t,INC);
				_t = _t.getFirstChild();
				
									pprint(in.getText()); 
								
				str_right=expr(_t);
				_t = _retTree;
				
									result = in.getText() + " " + str_right;
								
				_t = __t253;
				_t = _t.getNextSibling();
				break;
			}
			case DEC:
			{
				AST __t254 = _t;
				de = _t==ASTNULL ? null :(AST)_t;
				match(_t,DEC);
				_t = _t.getFirstChild();
				
									pprint(de.getText()); 
								
				str_right=expr(_t);
				_t = _retTree;
				
									result = de.getText() + " " + str_right;
								
				_t = __t254;
				_t = _t.getNextSibling();
				break;
			}
			case POST_INC:
			{
				AST __t255 = _t;
				poi = _t==ASTNULL ? null :(AST)_t;
				match(_t,POST_INC);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
									pprint(poi.getText()); 
									result = str_left + " " + poi.getText();
								
				_t = __t255;
				_t = _t.getNextSibling();
				break;
			}
			case POST_DEC:
			{
				AST __t256 = _t;
				pod = _t==ASTNULL ? null :(AST)_t;
				match(_t,POST_DEC);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
									pprint(pod.getText()); 
									result = str_left + " " + pod.getText();
								
				_t = __t256;
				_t = _t.getNextSibling();
				break;
			}
			case BNOT:
			{
				AST __t257 = _t;
				bnot = _t==ASTNULL ? null :(AST)_t;
				match(_t,BNOT);
				_t = _t.getFirstChild();
				
									pprint(bnot.getText()); 
								
				str_right=expr(_t);
				_t = _retTree;
				
									result = bnot.getText() + " " + str_right;
					      		
				_t = __t257;
				_t = _t.getNextSibling();
				break;
			}
			case LNOT:
			{
				AST __t258 = _t;
				lnot = _t==ASTNULL ? null :(AST)_t;
				match(_t,LNOT);
				_t = _t.getFirstChild();
				
									pprint(lnot.getText()); 
								
				str_right=expr(_t);
				_t = _retTree;
				
									result = lnot.getText() + " " + str_right;
					     		
				_t = __t258;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_instanceof:
			{
				AST __t259 = _t;
				io = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_instanceof);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
					      			pprint(" " + io.getText() + " "); 
					      		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + io.getText() + " " + str_right;
					      		
				_t = __t259;
				_t = _t.getNextSibling();
				break;
			}
			case UNARY_MINUS:
			{
				AST __t260 = _t;
				um = _t==ASTNULL ? null :(AST)_t;
				match(_t,UNARY_MINUS);
				_t = _t.getFirstChild();
				pprint(um.getText());
				expr(_t);
				_t = _retTree;
				_t = __t260;
				_t = _t.getNextSibling();
				break;
			}
			case UNARY_PLUS:
			{
				AST __t261 = _t;
				up = _t==ASTNULL ? null :(AST)_t;
				match(_t,UNARY_PLUS);
				_t = _t.getFirstChild();
				pprint(up.getText());
				expr(_t);
				_t = _retTree;
				_t = __t261;
				_t = _t.getNextSibling();
				break;
			}
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case METHOD_CALL:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case LITERAL_super:
			case LITERAL_this:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				result=primaryExpression(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void annotationMemberializer(AST _t) throws RecognitionException {
		
		AST annotationMemberializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t74 = _t;
			AST tmp33_AST_in = (AST)_t;
			match(_t,ANNOTATION_ARRAY_INIT);
			_t = _t.getFirstChild();
			{
			_loop76:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_2.member(_t.getType()))) {
					annotationMemberArrayValueInitializer(_t);
					_t = _retTree;
				}
				else {
					break _loop76;
				}
				
			} while (true);
			}
			_t = __t74;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void annotationMemberArrayValueInitializer(AST _t) throws RecognitionException {
		
		AST annotationMemberArrayValueInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				conditionalExpr(_t);
				_t = _retTree;
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void methodDecl(AST _t) throws RecognitionException {
		
		AST methodDecl_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t115 = _t;
			AST tmp34_AST_in = (AST)_t;
			match(_t,METHOD_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				typeParameters(_t);
				_t = _retTree;
				break;
			}
			case TYPE:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			typeSpec(_t);
			_t = _retTree;
			methodHead(_t);
			_t = _retTree;
			_t = __t115;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void variableDef(AST _t) throws RecognitionException {
		
		AST variableDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t122 = _t;
			AST tmp35_AST_in = (AST)_t;
			match(_t,VARIABLE_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			typeSpec(_t);
			_t = _retTree;
			variableDeclarator(_t);
			_t = _retTree;
			varInitializer(_t);
			_t = _retTree;
			_t = __t122;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void ctorDef(AST _t) throws RecognitionException {
		
		AST ctorDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST name = null;
		AST type = null;
		AST ctor = null;
		
			String s = "";
		
		
		try {      // for error handling
			AST __t111 = _t;
			AST tmp36_AST_in = (AST)_t;
			match(_t,CTOR_DEF);
			_t = _t.getFirstChild();
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			name = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			type = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			ctor = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			modifiers(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				typeParameters(_t);
				_t = _retTree;
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			s=methodHead(_t);
			_t = _retTree;
			
					   			pprint("{");
				   	   			incLevel();
								methodID = id.getText();
			
				   		   		if ( ctor.getText().equals("n") ) {
									pprint(enterMethod + "( " + id.getText() + " );");
					   	   			newline();
					      			pprint("try {");
					      			incLevel();
									writeSTable(id.getText(), row, type.getText(), name.getText(), "");
								}
						
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case SLIST:
			{
				slist(_t,id.getText());
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
				
					      		decLevel(); 
					      		pprint("} finally {");
					      		incLevel();
					      		pprint(handleException + "( " + row + " );");
					      		newline();
					      		pprint(leaveMethod + "( " + id.getText() + " );");
					      		decLevel();
					      		pprint("}");
					      		decLevel();
					      	  	pprint("}");
					      	  	newline();
							
			_t = __t111;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void methodDef(AST _t) throws RecognitionException {
		
		AST methodDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST name = null;
		AST type = null;
		AST ctor = null;
		
			String methodName = "";
		
		
		try {      // for error handling
			AST __t118 = _t;
			AST tmp37_AST_in = (AST)_t;
			match(_t,METHOD_DEF);
			_t = _t.getFirstChild();
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			name = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			type = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			ctor = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			modifiers(_t);
			_t = _retTree;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				typeParameters(_t);
				_t = _retTree;
				break;
			}
			case TYPE:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			typeSpec(_t);
			_t = _retTree;
			methodName=methodHead(_t);
			_t = _retTree;
				
				      		pprint("{");
				      		incLevel();
				      		pprint(enterMethod + "( " + id.getText() + " );");
				      		newline();
						writeSTable(id.getText(), row, type.getText(), name.getText(), "");
				      		pprint("try {");
				      		incLevel();
				      	
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case SLIST:
			{
				slist(_t,null);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
				
				      		decLevel(); 
				      		pprint("} finally {");
				      		incLevel();
				      		pprint(handleException + "( " + row + " );");
				      		newline();
				      		pprint(leaveMethod + "( " + id.getText() + " );");
				      		decLevel();
				      		pprint("}");
				      		decLevel();
				      	  	pprint("}");
				      	  	newline();
						
			_t = __t118;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final boolean  slist(AST _t,
		String id
	) throws RecognitionException {
		boolean handled = false;
		
		AST slist_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t165 = _t;
			AST tmp38_AST_in = (AST)_t;
			match(_t,SLIST);
			_t = _t.getFirstChild();
			{
			_loop167:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_3.member(_t.getType()))) {
					stat(_t);
					_t = _retTree;
				}
				else {
					break _loop167;
				}
				
			} while (true);
			}
			_t = __t165;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return handled;
	}
	
	public final void annotationFieldDecl(AST _t) throws RecognitionException {
		
		AST annotationFieldDecl_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t128 = _t;
			AST tmp39_AST_in = (AST)_t;
			match(_t,ANNOTATION_FIELD_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			typeSpec(_t);
			_t = _retTree;
			AST tmp40_AST_in = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case ANNOTATION:
			case ANNOTATION_ARRAY_INIT:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				annotationMemberValueInitializer(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t128;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void enumConstantDef(AST _t) throws RecognitionException {
		
		AST enumConstantDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			AST __t131 = _t;
			AST tmp41_AST_in = (AST)_t;
			match(_t,ENUM_CONSTANT_DEF);
			_t = _t.getFirstChild();
			annotations(_t);
			_t = _retTree;
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
					  			pprint(id.getText()); 
					  		
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ELIST:
			{
				elist(_t);
				_t = _retTree;
				break;
			}
			case 3:
			case OBJBLOCK:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OBJBLOCK:
			{
				enumConstantBlock(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t131;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  methodHead(AST _t) throws RecognitionException {
		String result = "";
		
		AST methodHead_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
			int i = 0; 
		
		
		try {      // for error handling
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
							result = id.getText();
							pprint(result); 
						
			AST __t151 = _t;
			AST tmp42_AST_in = (AST)_t;
			match(_t,PARAMETERS);
			_t = _t.getFirstChild();
			
					 			pprint("( "); 
					 		
			{
			_loop153:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==PARAMETER_DEF)) {
						// to handle the trailing comma correctly
													if (i > 0) pprint(", "); 
													i++;
												
					parameterDef(_t);
					_t = _retTree;
				}
				else {
					break _loop153;
				}
				
			} while (true);
			}
			
					    		pprint(" ) ");
					    	
			_t = __t151;
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_throws:
			{
				throwsClause(_t);
				_t = _retTree;
				break;
			}
			case 3:
			case SLIST:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void variableDeclarator(AST _t) throws RecognitionException {
		
		AST variableDeclarator_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST lb = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								pprint(id.getText() + " "); 
							
				break;
			}
			case LBRACK:
			{
				lb = (AST)_t;
				match(_t,LBRACK);
				_t = _t.getNextSibling();
				
								pprint(lb.getText());
							
				variableDeclarator(_t);
				_t = _retTree;
				
								pprint("]"); 
							
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void varInitializer(AST _t) throws RecognitionException {
		
		AST varInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ASSIGN:
			{
				AST __t143 = _t;
				AST tmp43_AST_in = (AST)_t;
				match(_t,ASSIGN);
				_t = _t.getFirstChild();
				
									pprint("= "); 
								
				initializer(_t);
				_t = _retTree;
				_t = __t143;
				_t = _t.getNextSibling();
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void parameterDef(AST _t) throws RecognitionException {
		
		AST parameterDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		
		try {      // for error handling
			AST __t124 = _t;
			AST tmp44_AST_in = (AST)_t;
			match(_t,PARAMETER_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			typeSpec(_t);
			_t = _retTree;
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
					  			pprint(id.getText()); 
					  		
			_t = __t124;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void variableLengthParameterDef(AST _t) throws RecognitionException {
		
		AST variableLengthParameterDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t126 = _t;
			AST tmp45_AST_in = (AST)_t;
			match(_t,VARIABLE_PARAMETER_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			typeSpec(_t);
			_t = _retTree;
			AST tmp46_AST_in = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			_t = __t126;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  elist(AST _t) throws RecognitionException {
		String result = "";
		
		AST elist_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		int i = 0;
		
		try {      // for error handling
			AST __t212 = _t;
			AST tmp47_AST_in = (AST)_t;
			match(_t,ELIST);
			_t = _t.getFirstChild();
			
								if (Paren) pprint("( ");	
							
			{
			_loop214:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==EXPR||_t.getType()==LOGB)) {
						// to handle the trailing comma correctly
											if (i > 0) pprint(", "); 
											i++;
										
					expression(_t);
					_t = _retTree;
				}
				else {
					break _loop214;
				}
				
			} while (true);
			}
			
								if (Paren) pprint(" )");	
								Paren = false;
							
			_t = __t212;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void enumConstantBlock(AST _t) throws RecognitionException {
		
		AST enumConstantBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t135 = _t;
			AST tmp48_AST_in = (AST)_t;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop138:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case METHOD_DEF:
				{
					methodDef(_t);
					_t = _retTree;
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t137 = _t;
					AST tmp49_AST_in = (AST)_t;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t,null);
					_t = _retTree;
					_t = __t137;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop138;
				}
				}
			} while (true);
			}
			_t = __t135;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void objectinitializer(AST _t) throws RecognitionException {
		
		AST objectinitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t140 = _t;
			AST tmp50_AST_in = (AST)_t;
			match(_t,INSTANCE_INIT);
			_t = _t.getFirstChild();
			slist(_t,null);
			_t = _retTree;
			_t = __t140;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void initializer(AST _t) throws RecognitionException {
		
		AST initializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EXPR:
			case LOGB:
			{
				expression(_t);
				_t = _retTree;
				break;
			}
			case ARRAY_INIT:
			{
				{
				
								pprint("{ ");
							
				arrayInitializer(_t);
				_t = _retTree;
				
								pprint(" }");
							
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  expression(AST _t) throws RecognitionException {
		String result = "";
		
		AST expression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST exp = null;
		AST id = null;
		AST exp2 = null;
		AST type_ = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EXPR:
			{
				AST __t216 = _t;
				exp = _t==ASTNULL ? null :(AST)_t;
				match(_t,EXPR);
				_t = _t.getFirstChild();
				result=expr(_t);
				_t = _retTree;
				_t = __t216;
				_t = _t.getNextSibling();
				break;
			}
			case LOGB:
			{
				AST __t217 = _t;
				AST tmp51_AST_in = (AST)_t;
				match(_t,LOGB);
				_t = _t.getFirstChild();
					// if the "logB"-token is matched, insert the logB function
									pprint(catchException + " ( ");
								
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
						    		 pprint(startExpression + "( " + id.getText() + " ), " + logBString + "( ");
						    	
				expression(_t);
				_t = _retTree;
				
						   			pprint(", "); 
						   			pprint(id.getText() + " ), " + endExpression + "( " + id + " ) )"); 
						   		
				exp2 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				type_ = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
					// write the symbol table
									writeSTable(id.getText(), row, type_.getText(), exp2.getText(), "");
						  		
				_t = __t217;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void arrayInitializer(AST _t) throws RecognitionException {
		
		AST arrayInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		int i = 0;
		
		try {      // for error handling
			AST __t147 = _t;
			AST tmp52_AST_in = (AST)_t;
			match(_t,ARRAY_INIT);
			_t = _t.getFirstChild();
			{
			_loop149:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==EXPR||_t.getType()==ARRAY_INIT||_t.getType()==LOGB)) {
						// to handle the trailing comma correctly
										if (i > 0) pprint(", "); 
										i++;
									
					initializer(_t);
					_t = _retTree;
				}
				else {
					break _loop149;
				}
				
			} while (true);
			}
			_t = __t147;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void throwsClause(AST _t) throws RecognitionException {
		
		AST throwsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST th = null;
		
			int i = 0; 
		
		
		try {      // for error handling
			AST __t156 = _t;
			th = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_throws);
			_t = _t.getFirstChild();
			
								pprint(th.getText() + " "); 
							
			{
			_loop158:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						// to handle the trailing comma correctly
										if (i > 0) pprint(", "); 
										i++;
									
					classOrInterfaceType(_t);
					_t = _retTree;
				}
				else {
					break _loop158;
				}
				
			} while (true);
			}
			_t = __t156;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void stat(AST _t) throws RecognitionException {
		
		AST stat_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id2 = null;
		AST if_ = null;
		AST fo = null;
		AST wh = null;
		AST do_ = null;
		AST br = null;
		AST id = null;
		AST con = null;
		AST con_id = null;
		AST re = null;
		AST sw = null;
		AST ids = null;
		AST expr = null;
		AST type_ = null;
		AST th = null;
		
			isCtorCall = false;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CLASS_DEF:
			case INTERFACE_DEF:
			case ENUM_DEF:
			case ANNOTATION_DEF:
			{
				typeDefinition(_t);
				_t = _retTree;
				
								eos(); 
								newline();
							
				break;
			}
			case VARIABLE_DEF:
			{
				variableDef(_t);
				_t = _retTree;
				
								eos();
								newline();
							
				break;
			}
			case EXPR:
			case LOGB:
			{
				expression(_t);
				_t = _retTree;
					
								if ( !noEos ) {
									eos();
									noEos = false;
								}
								newline();
								if ( isCtorCall ) { 					
									pprint(enterMethod + "( " + methodID + " );");
					   	   			newline();
					      			pprint("try {");
					      			incLevel();
								}
							
				break;
			}
			case LABELED_STAT:
			{
				AST __t169 = _t;
				AST tmp53_AST_in = (AST)_t;
				match(_t,LABELED_STAT);
				_t = _t.getFirstChild();
				id2 = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
									pprint(id2.getText() + ": ");
								
				stat(_t);
				_t = _retTree;
				_t = __t169;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_if:
			{
				AST __t170 = _t;
				if_ = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_if);
				_t = _t.getFirstChild();
					
									pprint(if_.getText()+ " ( "); 
									isLogging = true;
								
				expression(_t);
				_t = _retTree;
					
									isLogging = false;
									pprint(" ) { "); 
								 	incLevel();
								
				stat(_t);
				_t = _retTree;
					
									decLevel();
								  	pprint("} "); 
								
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case SLIST:
				case VARIABLE_DEF:
				case CLASS_DEF:
				case INTERFACE_DEF:
				case LABELED_STAT:
				case EXPR:
				case EMPTY_STAT:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				case LOGB:
				case LITERAL_synchronized:
				case LITERAL_if:
				case LITERAL_while:
				case LITERAL_do:
				case LITERAL_break:
				case LITERAL_continue:
				case LITERAL_return:
				case LITERAL_switch:
				case LITERAL_throw:
				case LITERAL_assert:
				case LITERAL_for:
				case LITERAL_try:
				{
						
							  			pprint("else { ");
							  			incLevel();
							
					stat(_t);
					_t = _retTree;
						
							   			decLevel();
							   			pprint("} ");
							
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				
						  		newline(); 
						  	
				_t = __t170;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_for:
			{
				AST __t172 = _t;
				fo = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_for);
				_t = _t.getFirstChild();
				
									pprint(fo.getText() + " ( "); 
								
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case FOR_INIT:
				{
					AST __t174 = _t;
					AST tmp54_AST_in = (AST)_t;
					match(_t,FOR_INIT);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case VARIABLE_DEF:
					{
						{
						int _cnt177=0;
						_loop177:
						do {
							if (_t==null) _t=ASTNULL;
							if ((_t.getType()==VARIABLE_DEF)) {
								variableDef(_t);
								_t = _retTree;
							}
							else {
								if ( _cnt177>=1 ) { break _loop177; } else {throw new NoViableAltException(_t);}
							}
							
							_cnt177++;
						} while (true);
						}
						break;
					}
					case ELIST:
					{
						elist(_t);
						_t = _retTree;
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					_t = __t174;
					_t = _t.getNextSibling();
					
												pprint("; "); 
											
					AST __t178 = _t;
					AST tmp55_AST_in = (AST)_t;
					match(_t,FOR_CONDITION);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case EXPR:
					case LOGB:
					{
						expression(_t);
						_t = _retTree;
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					_t = __t178;
					_t = _t.getNextSibling();
					
												pprint("; "); 
											
					AST __t180 = _t;
					AST tmp56_AST_in = (AST)_t;
					match(_t,FOR_ITERATOR);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case ELIST:
					{
						elist(_t);
						_t = _retTree;
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					_t = __t180;
					_t = _t.getNextSibling();
					break;
				}
				case FOR_EACH_CLAUSE:
				{
					AST __t182 = _t;
					AST tmp57_AST_in = (AST)_t;
					match(_t,FOR_EACH_CLAUSE);
					_t = _t.getFirstChild();
					parameterDef(_t);
					_t = _retTree;
					expression(_t);
					_t = _retTree;
					_t = __t182;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
					
									pprint(" ) {");
									incLevel();
								
				stat(_t);
				_t = _retTree;
					
									decLevel();
									pprint("}");
								
				
								newline(); 
							
				_t = __t172;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_while:
			{
				AST __t183 = _t;
				wh = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_while);
				_t = _t.getFirstChild();
					
									pprint(wh.getText() + " ( "); 
									isLogging = true;
								
				expression(_t);
				_t = _retTree;
					
									isLogging = false;
									pprint(" ) { "); 
								 	incLevel();
								
				stat(_t);
				_t = _retTree;
					
									decLevel();
								  	pprint("} "); 
								
				
								newline(); 
							
				_t = __t183;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_do:
			{
				AST __t184 = _t;
				do_ = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_do);
				_t = _t.getFirstChild();
					
									pprint(do_.getText() + " {");  
								 	incLevel();
								
				stat(_t);
				_t = _retTree;
					
									decLevel();
									pprint("} while ( "); 
									isLogging = true;
								
				expression(_t);
				_t = _retTree;
					
									isLogging = false;
									pprint(" );"); 
								
				
								newline(); 
							
				_t = __t184;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_break:
			{
				AST __t185 = _t;
				br = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_break);
				_t = _t.getFirstChild();
				
									pprint(br.getText() + " "); 
								
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IDENT:
				{
					id = (AST)_t;
					match(_t,IDENT);
					_t = _t.getNextSibling();
					
										pprint(id.getText()); 
									
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				
						  		eos(); 
						  	
				_t = __t185;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_continue:
			{
				AST __t187 = _t;
				con = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_continue);
				_t = _t.getFirstChild();
				
								pprint(con.getText() + " "); 
							
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IDENT:
				{
					con_id = (AST)_t;
					match(_t,IDENT);
					_t = _t.getNextSibling();
					
											pprint(con_id.getText()); 
										
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				
								eos();
							
				_t = __t187;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_return:
			{
				AST __t189 = _t;
				re = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_return);
				_t = _t.getFirstChild();
				
									pprint(re.getText() + " ");
								
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case EXPR:
				case LOGB:
				{
					expression(_t);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				
					      		eos();
					      	
				_t = __t189;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_switch:
			{
				AST __t191 = _t;
				sw = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_switch);
				_t = _t.getFirstChild();
				
									pprint(sw.getText() + " ( " + enterSwitch + " ( ");
								
				ids = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				expression(_t);
				_t = _retTree;
					
					      			pprint(", " + ids.getText() + " ) ) { "); 
									incLevel();
								
				expr = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				type_ = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
					
									// write the symbol table
									writeSTable(ids.getText(), row, type_.getText(), expr.getText(), "");
								
				{
				_loop193:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==CASE_GROUP)) {
						caseGroup(_t,expr.getText());
						_t = _retTree;
					}
					else {
						break _loop193;
					}
					
				} while (true);
				}
					
					 		decLevel();
								pprint("} ");
								newline();
								pprint(leaveSwitch + "( " + ids.getText() + " );");
								newline(2);
						 	
				_t = __t191;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_throw:
			{
				AST __t194 = _t;
				th = _t==ASTNULL ? null :(AST)_t;
				match(_t,LITERAL_throw);
				_t = _t.getFirstChild();
				
									pprint(th.getText() + " ");
								
				expression(_t);
				_t = _retTree;
				
									eos();
								
				_t = __t194;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_synchronized:
			{
				AST __t195 = _t;
				AST tmp58_AST_in = (AST)_t;
				match(_t,LITERAL_synchronized);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				stat(_t);
				_t = _retTree;
				_t = __t195;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_try:
			{
				tryBlock(_t);
				_t = _retTree;
				break;
			}
			case SLIST:
			{
				slist(_t,null);
				_t = _retTree;
				break;
			}
			case LITERAL_assert:
			{
				AST __t196 = _t;
				AST tmp59_AST_in = (AST)_t;
				match(_t,LITERAL_assert);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case EXPR:
				case LOGB:
				{
					expression(_t);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t196;
				_t = _t.getNextSibling();
				break;
			}
			case EMPTY_STAT:
			{
				AST tmp60_AST_in = (AST)_t;
				match(_t,EMPTY_STAT);
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void caseGroup(AST _t,
		String ids
	) throws RecognitionException {
		
		AST caseGroup_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ca = null;
		AST de = null;
		AST id = null;
		AST exp = null;
		AST type_ = null;
		
			String str_exp = "";	
			Vector v = new Vector();
		
		
		try {      // for error handling
			AST __t199 = _t;
			AST tmp61_AST_in = (AST)_t;
			match(_t,CASE_GROUP);
			_t = _t.getFirstChild();
			{
			int _cnt202=0;
			_loop202:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case LITERAL_case:
				{
					AST __t201 = _t;
					ca = _t==ASTNULL ? null :(AST)_t;
					match(_t,LITERAL_case);
					_t = _t.getFirstChild();
						
											pprint(ca.getText() + " "); 
										
					str_exp=expression(_t);
					_t = _retTree;
					
											pprint(": "); 
											v.add(str_exp);
										
					_t = __t201;
					_t = _t.getNextSibling();
					break;
				}
				case LITERAL_default:
				{
					de = (AST)_t;
					match(_t,LITERAL_default);
					_t = _t.getNextSibling();
					
											pprint(de.getText() + ": ");
											v.add(de.getText());
										
					break;
				}
				default:
				{
					if ( _cnt202>=1 ) { break _loop202; } else {throw new NoViableAltException(_t);}
				}
				}
				_cnt202++;
			} while (true);
			}
				
								incLevel();
			//					newline();
							
			id = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			exp = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			type_ = (AST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
				
								// write the symbol table
								writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
					  			// print the logging function
								for ( int i = 0; i < v.size(); i++ ) {
									String s = ( String ) v.get(i);
			
									if ( s.trim().equals( "default" ) ) {
										pprint(logCString + "( " + id.getText() + " );");
									} else {
										pprint(logCString + "( " + ids + " == " + s + ", " + id.getText() + " );");
										newline();
									}
								}
								newline(); 
							
			slist(_t,null);
			_t = _retTree;
			
								decLevel();
							
			_t = __t199;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void tryBlock(AST _t) throws RecognitionException {
		
		AST tryBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST tr = null;
		
		try {      // for error handling
			AST __t204 = _t;
			tr = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_try);
			_t = _t.getFirstChild();
				pprint(tr.getText() + " { ");
							  	incLevel();
							
			slist(_t,null);
			_t = _retTree;
				decLevel();
					  			pprint("} ");
							
			{
			_loop206:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==LITERAL_catch)) {
					handler(_t);
					_t = _retTree;
				}
				else {
					break _loop206;
				}
				
			} while (true);
			}
			
					  			//newline(); 
					  		
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_finally:
			{
				AST __t208 = _t;
				AST tmp62_AST_in = (AST)_t;
				match(_t,LITERAL_finally);
				_t = _t.getFirstChild();
				
						  				pprint("finally {");
						  				incLevel();
						  			
				slist(_t,null);
				_t = _retTree;
				
						  				decLevel();
						  				pprint("} ");	
						  				newline();	  				
						  			
				_t = __t208;
				_t = _t.getNextSibling();
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t204;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final void handler(AST _t) throws RecognitionException {
		
		AST handler_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ca = null;
		
		try {      // for error handling
			AST __t210 = _t;
			ca = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_catch);
			_t = _t.getFirstChild();
				pprint(ca.getText() + " ( ");
			parameterDef(_t);
			_t = _retTree;
				pprint(" ) { ");
					  			incLevel();
					  		
			slist(_t,null);
			_t = _retTree;
				decLevel();
					  		  	pprint("} ");
					  		  	newline();
					  		
			_t = __t210;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  expr(AST _t) throws RecognitionException {
		String result = "";
		
		AST expr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST exp = null;
		AST type_ = null;
		AST as = null;
		AST pl = null;
		AST mi = null;
		AST sa = null;
		AST di = null;
		AST mo = null;
		AST sr = null;
		AST bsr = null;
		AST sl = null;
		AST band = null;
		AST bxor = null;
		AST bor = null;
		
			String str_left = "";
			String str_right = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				result=conditionalExpr(_t);
				_t = _retTree;
				break;
			}
			case LOGB:
			{
				AST __t219 = _t;
				AST tmp63_AST_in = (AST)_t;
				match(_t,LOGB);
				_t = _t.getFirstChild();
					// if the "logB"-token is matched, insert the logB function
						    		 pprint(logBString + "( ");
						    	
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				expr(_t);
				_t = _retTree;
				
						   			pprint(", "); 
						   			pprint(id.getText() + " )"); 
						   		
				exp = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				type_ = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
					// write the symbol table
						  			writeSTable(id.getText(), row, type_.getText(), exp.getText(), "");
						  		
				_t = __t219;
				_t = _t.getNextSibling();
				break;
			}
			case ASSIGN:
			{
				AST __t220 = _t;
				as = _t==ASTNULL ? null :(AST)_t;
				match(_t,ASSIGN);
				_t = _t.getFirstChild();
				
									// support 
									if (isLogging) pprint("( ");
								
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + as.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									if (isLogging) pprint(" )");
									result = str_left + " " + as.getText() + " " + str_right;
								
				_t = __t220;
				_t = _t.getNextSibling();
				break;
			}
			case PLUS_ASSIGN:
			{
				AST __t221 = _t;
				pl = _t==ASTNULL ? null :(AST)_t;
				match(_t,PLUS_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + pl.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + pl.getText() + " " + str_right;
						  		
				_t = __t221;
				_t = _t.getNextSibling();
				break;
			}
			case MINUS_ASSIGN:
			{
				AST __t222 = _t;
				mi = _t==ASTNULL ? null :(AST)_t;
				match(_t,MINUS_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + mi.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + mi.getText() + " " + str_right;
						  		
				_t = __t222;
				_t = _t.getNextSibling();
				break;
			}
			case STAR_ASSIGN:
			{
				AST __t223 = _t;
				sa = _t==ASTNULL ? null :(AST)_t;
				match(_t,STAR_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + sa.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + as.getText() + " " + str_right;
								
				_t = __t223;
				_t = _t.getNextSibling();
				break;
			}
			case DIV_ASSIGN:
			{
				AST __t224 = _t;
				di = _t==ASTNULL ? null :(AST)_t;
				match(_t,DIV_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + di.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + di.getText() + " " + str_right;
								
				_t = __t224;
				_t = _t.getNextSibling();
				break;
			}
			case MOD_ASSIGN:
			{
				AST __t225 = _t;
				mo = _t==ASTNULL ? null :(AST)_t;
				match(_t,MOD_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + mo.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + mo.getText() + " " + str_right;
								
				_t = __t225;
				_t = _t.getNextSibling();
				break;
			}
			case SR_ASSIGN:
			{
				AST __t226 = _t;
				sr = _t==ASTNULL ? null :(AST)_t;
				match(_t,SR_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + sr.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + sr.getText() + " " + str_right;
								
				_t = __t226;
				_t = _t.getNextSibling();
				break;
			}
			case BSR_ASSIGN:
			{
				AST __t227 = _t;
				bsr = _t==ASTNULL ? null :(AST)_t;
				match(_t,BSR_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + bsr.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bsr.getText() + " " + str_right;
								
				_t = __t227;
				_t = _t.getNextSibling();
				break;
			}
			case SL_ASSIGN:
			{
				AST __t228 = _t;
				sl = _t==ASTNULL ? null :(AST)_t;
				match(_t,SL_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + sl.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + sl.getText() + " " + str_right;
								
				_t = __t228;
				_t = _t.getNextSibling();
				break;
			}
			case BAND_ASSIGN:
			{
				AST __t229 = _t;
				band = _t==ASTNULL ? null :(AST)_t;
				match(_t,BAND_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + band.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + band.getText() + " " + str_right;
								
				_t = __t229;
				_t = _t.getNextSibling();
				break;
			}
			case BXOR_ASSIGN:
			{
				AST __t230 = _t;
				bxor = _t==ASTNULL ? null :(AST)_t;
				match(_t,BXOR_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				
						  			pprint(" " + bxor.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bxor.getText() + " " + str_right;
								
				_t = __t230;
				_t = _t.getNextSibling();
				break;
			}
			case BOR_ASSIGN:
			{
				AST __t231 = _t;
				bor = _t==ASTNULL ? null :(AST)_t;
				match(_t,BOR_ASSIGN);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
					
						  			pprint(" " + bor.getText() + " "); 
						  		
				str_right=expr(_t);
				_t = _retTree;
				
									result = str_left + " " + bor.getText() + " " + str_right;
								
				_t = __t231;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final String  primaryExpression(AST _t) throws RecognitionException {
		String result = "";
		
		AST primaryExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST id = null;
		AST do_ = null;
		AST id_ = null;
		AST thi = null;
		AST cla = null;
		AST sup = null;
		AST id2 = null;
		AST expr = null;
		AST type = null;
		AST su = null;
		AST tr = null;
		AST fa = null;
		AST th = null;
		AST nu = null;
			
			String str_expr = "";
			String str_pe = "";
			String str_ta = ""; 
			String str_elist = "";
			String str_temp = "";
			String ref_variable = "";
			String ref_variable_id = "";
			boolean firstIf = true;
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								pprint(id.getText()); 
								result = id.getText();
							
				break;
			}
			case DOT:
			{
				AST __t263 = _t;
				do_ = _t==ASTNULL ? null :(AST)_t;
				match(_t,DOT);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE:
				case TYPECAST:
				case INDEX_OP:
				case POST_INC:
				case POST_DEC:
				case METHOD_CALL:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case SUPER_CTOR_CALL:
				case CTOR_CALL:
				case LOGB:
				case IDENT:
				case DOT:
				case QUESTION:
				case LITERAL_super:
				case LT:
				case GT:
				case SR:
				case BSR:
				case STAR:
				case ASSIGN:
				case BAND:
				case LITERAL_this:
				case PLUS_ASSIGN:
				case MINUS_ASSIGN:
				case STAR_ASSIGN:
				case DIV_ASSIGN:
				case MOD_ASSIGN:
				case SR_ASSIGN:
				case BSR_ASSIGN:
				case SL_ASSIGN:
				case BAND_ASSIGN:
				case BXOR_ASSIGN:
				case BOR_ASSIGN:
				case LOR:
				case LAND:
				case BOR:
				case BXOR:
				case NOT_EQUAL:
				case EQUAL:
				case LE:
				case GE:
				case LITERAL_instanceof:
				case SL:
				case PLUS:
				case MINUS:
				case DIV:
				case MOD:
				case INC:
				case DEC:
				case BNOT:
				case LNOT:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				{
					str_expr=expr(_t);
					_t = _retTree;
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case IDENT:
					{
						id_ = (AST)_t;
						match(_t,IDENT);
						_t = _t.getNextSibling();
							
													pprint(do_.getText());
												  	pprint(id_.getText()); 
													result = str_expr + do_.getText() + id_.getText();						  	
												
						break;
					}
					case INDEX_OP:
					{
						result=arrayIndex(_t);
						_t = _retTree;
						break;
					}
					case LITERAL_this:
					{
						thi = (AST)_t;
						match(_t,LITERAL_this);
						_t = _t.getNextSibling();
						
													pprint("." + thi.getText()); 
													result = str_expr + do_.getText() + thi.getText();
												
						break;
					}
					case LITERAL_class:
					{
						cla = (AST)_t;
						match(_t,LITERAL_class);
						_t = _t.getNextSibling();
						
													pprint("." + cla.getText()); 
													result = str_expr + do_.getText() + cla.getText();
												
						break;
					}
					case LITERAL_new:
					{
						str_temp=newExpression(_t);
						_t = _retTree;
						
													result = str_expr + do_.getText() + str_temp;
												
						break;
					}
					case LITERAL_super:
					{
						sup = (AST)_t;
						match(_t,LITERAL_super);
						_t = _t.getNextSibling();
						
													Paren = true;
													pprint("." + sup.getText()); 
													isCtorCall = true;
													result = str_expr + do_.getText() + sup.getText();
												
						break;
					}
					case 3:
					case TYPE_ARGUMENTS:
					{
						{
						if (_t==null) _t=ASTNULL;
						switch ( _t.getType()) {
						case TYPE_ARGUMENTS:
						{
							typeArguments(_t);
							_t = _retTree;
							break;
						}
						case 3:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(_t);
						}
						}
						}
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					break;
				}
				case ARRAY_DECLARATOR:
				{
					AST __t267 = _t;
					AST tmp64_AST_in = (AST)_t;
					match(_t,ARRAY_DECLARATOR);
					_t = _t.getFirstChild();
					typeSpecArray(_t);
					_t = _retTree;
					_t = __t267;
					_t = _t.getNextSibling();
					break;
				}
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				{
					builtInType(_t);
					_t = _retTree;
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case LITERAL_class:
					{
						AST tmp65_AST_in = (AST)_t;
						match(_t,LITERAL_class);
						_t = _t.getNextSibling();
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t263;
				_t = _t.getNextSibling();
				break;
			}
			case INDEX_OP:
			{
				result=arrayIndex(_t);
				_t = _retTree;
				break;
			}
			case METHOD_CALL:
			{
				AST __t269 = _t;
				AST tmp66_AST_in = (AST)_t;
				match(_t,METHOD_CALL);
				_t = _t.getFirstChild();
				str_pe=primaryExpression(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_ARGUMENTS:
				{
					str_ta=typeArguments(_t);
					_t = _retTree;
					break;
				}
				case ELIST:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
					
					      			// print parentheses around the expression (method arguments)
					      			pprint("( "); 
					      			Paren = false;
					      		
				str_elist=elist(_t);
				_t = _retTree;
				
					      			result = str_pe + "(" + str_elist + ")";
					      			pprint(" )");
					      			noEos = false;
					      		
				{
				_loop272:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==IDENT)) {
						id2 = (AST)_t;
						match(_t,IDENT);
						_t = _t.getNextSibling();
						expr = (AST)_t;
						match(_t,IDENT);
						_t = _t.getNextSibling();
						type = (AST)_t;
						match(_t,IDENT);
						_t = _t.getNextSibling();
						
											if (!noEos) pprint(";");
											newline();
						
											if ( type.getText().equals( "v" ) ) {
												ref_variable = expr.getText();
												ref_variable_id = id2.getText();
							     				writeSTable(ref_variable_id, row, "v", ref_variable, "");
											}
						
											if ( ref_variable.length() > 0 && type.getText().equals( "i") ) {
												if ( !firstIf ) pprint(" else ");
												firstIf = false;
												pprint ( "if ( " + ref_variable + " instanceof " + expr.getText() + " ) {" );
												incLevel();
												pprint ( logPString + "( " + ref_variable_id + ", " + id2.getText() + " );" ) ;
							     				writeSTable(id2.getText(), row, "i", expr.getText(), "");
												decLevel();
												pprint ("}");
												newline();
											}
						
							      			System.out.println ( id2.getText() + ":" + expr.getText() + ":" + type.getText() );
							      			
											noEos = true;
							      			
							      		
					}
					else {
						break _loop272;
					}
					
				} while (true);
				}
				_t = __t269;
				_t = _t.getNextSibling();
				break;
			}
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			{
				ctorCall(_t);
				_t = _retTree;
				break;
			}
			case TYPECAST:
			{
				AST __t273 = _t;
				AST tmp67_AST_in = (AST)_t;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				
										pprint("( ");
									
				str_ta=typeSpec(_t);
				_t = _retTree;
				
										pprint(")");
									
				str_expr=expr(_t);
				_t = _retTree;
				
										result = "( " + str_ta +" ) " + str_expr;
									
				_t = __t273;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_new:
			{
				newExpression(_t);
				_t = _retTree;
				break;
			}
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				result=constant(_t);
				_t = _retTree;
				break;
			}
			case LITERAL_super:
			{
				su = (AST)_t;
				match(_t,LITERAL_super);
				_t = _t.getNextSibling();
				
								pprint(su.getText()); 
								result = su.getText();
							
				break;
			}
			case LITERAL_true:
			{
				tr = (AST)_t;
				match(_t,LITERAL_true);
				_t = _t.getNextSibling();
				
								pprint(tr.getText()); 
								result = tr.getText();
							
				break;
			}
			case LITERAL_false:
			{
				fa = (AST)_t;
				match(_t,LITERAL_false);
				_t = _t.getNextSibling();
				
								pprint(fa.getText());
								result = fa.getText(); 
							
				break;
			}
			case LITERAL_this:
			{
				th = (AST)_t;
				match(_t,LITERAL_this);
				_t = _t.getNextSibling();
				
								pprint(th.getText()); 
								result = th.getText();
							
				break;
			}
			case LITERAL_null:
			{
				nu = (AST)_t;
				match(_t,LITERAL_null);
				_t = _t.getNextSibling();
				
								pprint(nu.getText());
								result = nu.getText();			
							
				break;
			}
			case TYPE:
			{
				typeSpec(_t);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final String  arrayIndex(AST _t) throws RecognitionException {
		String result = "";
		
		AST arrayIndex_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
			String str_exp1 = ""; 
			String str_exp2 = "";
		
		
		try {      // for error handling
			AST __t279 = _t;
			AST tmp68_AST_in = (AST)_t;
			match(_t,INDEX_OP);
			_t = _t.getFirstChild();
			str_exp1=expr(_t);
			_t = _retTree;
				// print brackets around the expression
								pprint("[");
							
			str_exp2=expression(_t);
			_t = _retTree;
			_t = __t279;
			_t = _t.getNextSibling();
			
						pprint("]");
						result = str_exp1 + "[" + str_exp2 + "]"; 
					
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final String  newExpression(AST _t) throws RecognitionException {
		String result = "";
		
		AST newExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST ne = null;
		
			String str_ta = "";
			String str_type = "";
		
		
		try {      // for error handling
			AST __t282 = _t;
			ne = _t==ASTNULL ? null :(AST)_t;
			match(_t,LITERAL_new);
			_t = _t.getFirstChild();
			
								pprint(ne.getText() + " "); 
								result = ne.getText() + " ";
							
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_ARGUMENTS:
			{
				str_ta=typeArguments(_t);
				_t = _retTree;
				
					      				result = result + str_ta;
					      			
				break;
			}
			case IDENT:
			case DOT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			str_type=type(_t);
			_t = _retTree;
			
				      			result = result + " " + str_type;	      		
				      		
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				newArrayDeclarator(_t);
				_t = _retTree;
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ARRAY_INIT:
				{
					arrayInitializer(_t);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			case ELIST:
			{
				
										pprint("( "); 
										Paren = false;
									
				elist(_t);
				_t = _retTree;
				
										pprint(" )"); 
									
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case OBJBLOCK:
				{
					objBlock(_t);
					_t = _retTree;
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t282;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void ctorCall(AST _t) throws RecognitionException {
		
		AST ctorCall_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CTOR_CALL:
			{
				AST __t275 = _t;
				AST tmp69_AST_in = (AST)_t;
				match(_t,CTOR_CALL);
				_t = _t.getFirstChild();
				
									pprint("this( ");
									Paren = false;
								
				elist(_t);
				_t = _retTree;
				
									pprint(" )");
									Paren = false;
									isCtorCall = true;
					      		
				_t = __t275;
				_t = _t.getNextSibling();
				break;
			}
			case SUPER_CTOR_CALL:
			{
				AST __t276 = _t;
				AST tmp70_AST_in = (AST)_t;
				match(_t,SUPER_CTOR_CALL);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ELIST:
				{
					
										pprint("super (");
										Paren = false;
									
					elist(_t);
					_t = _retTree;
					
										pprint(" )");
										Paren = false;
										isCtorCall = true;
									
					break;
				}
				case TYPE:
				case TYPECAST:
				case INDEX_OP:
				case METHOD_CALL:
				case SUPER_CTOR_CALL:
				case CTOR_CALL:
				case IDENT:
				case DOT:
				case LITERAL_super:
				case LITERAL_this:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				{
					primaryExpression(_t);
					_t = _retTree;
					elist(_t);
					_t = _retTree;
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				_t = __t276;
				_t = _t.getNextSibling();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	public final String  constant(AST _t) throws RecognitionException {
		String result = "";
		
		AST constant_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		AST nu = null;
		AST ch = null;
		AST st = null;
		AST fl = null;
		AST dou = null;
		AST lo = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case NUM_INT:
			{
				nu = (AST)_t;
				match(_t,NUM_INT);
				_t = _t.getNextSibling();
				
								pprint(nu.getText()); 
								result = nu.getText();
							
				break;
			}
			case CHAR_LITERAL:
			{
				ch = (AST)_t;
				match(_t,CHAR_LITERAL);
				_t = _t.getNextSibling();
				
								pprint(ch.getText()); 
								result = ch.getText();
							
				break;
			}
			case STRING_LITERAL:
			{
				st = (AST)_t;
				match(_t,STRING_LITERAL);
				_t = _t.getNextSibling();
				
								pprint(st.getText()); 
								result = st.getText();
							
				break;
			}
			case NUM_FLOAT:
			{
				fl = (AST)_t;
				match(_t,NUM_FLOAT);
				_t = _t.getNextSibling();
				
								pprint(fl.getText()); 
								result = fl.getText();
							
				break;
			}
			case NUM_DOUBLE:
			{
				dou = (AST)_t;
				match(_t,NUM_DOUBLE);
				_t = _t.getNextSibling();
				
								pprint(dou.getText()); 
								result = dou.getText();
							
				break;
			}
			case NUM_LONG:
			{
				lo = (AST)_t;
				match(_t,NUM_LONG);
				_t = _t.getNextSibling();
				
								pprint(lo.getText());
								result = lo.getText();
							
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
		return result;
	}
	
	public final void newArrayDeclarator(AST _t) throws RecognitionException {
		
		AST newArrayDeclarator_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		
		try {      // for error handling
			AST __t288 = _t;
			AST tmp71_AST_in = (AST)_t;
			match(_t,ARRAY_DECLARATOR);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				newArrayDeclarator(_t);
				_t = _retTree;
				break;
			}
			case 3:
			case EXPR:
			case LOGB:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			
								pprint("[ ");
							
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EXPR:
			case LOGB:
			{
				expression(_t);
				_t = _retTree;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			
								pprint(" ]");
							
			_t = __t288;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"BLOCK",
		"MODIFIERS",
		"OBJBLOCK",
		"SLIST",
		"CTOR_DEF",
		"METHOD_DEF",
		"VARIABLE_DEF",
		"INSTANCE_INIT",
		"STATIC_INIT",
		"TYPE",
		"CLASS_DEF",
		"INTERFACE_DEF",
		"PACKAGE_DEF",
		"ARRAY_DECLARATOR",
		"EXTENDS_CLAUSE",
		"IMPLEMENTS_CLAUSE",
		"PARAMETERS",
		"PARAMETER_DEF",
		"LABELED_STAT",
		"TYPECAST",
		"INDEX_OP",
		"POST_INC",
		"POST_DEC",
		"METHOD_CALL",
		"EXPR",
		"ARRAY_INIT",
		"IMPORT",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"CASE_GROUP",
		"ELIST",
		"FOR_INIT",
		"FOR_CONDITION",
		"FOR_ITERATOR",
		"EMPTY_STAT",
		"\"final\"",
		"\"abstract\"",
		"\"strictfp\"",
		"SUPER_CTOR_CALL",
		"CTOR_CALL",
		"VARIABLE_PARAMETER_DEF",
		"STATIC_IMPORT",
		"ENUM_DEF",
		"ENUM_CONSTANT_DEF",
		"FOR_EACH_CLAUSE",
		"ANNOTATION_DEF",
		"ANNOTATIONS",
		"ANNOTATION",
		"ANNOTATION_MEMBER_VALUE_PAIR",
		"ANNOTATION_FIELD_DEF",
		"ANNOTATION_ARRAY_INIT",
		"TYPE_ARGUMENTS",
		"TYPE_ARGUMENT",
		"TYPE_PARAMETERS",
		"TYPE_PARAMETER",
		"WILDCARD_TYPE",
		"TYPE_UPPER_BOUNDS",
		"TYPE_LOWER_BOUNDS",
		"LOGB",
		"\"package\"",
		"SEMI",
		"\"import\"",
		"\"static\"",
		"LBRACK",
		"RBRACK",
		"IDENT",
		"DOT",
		"QUESTION",
		"\"extends\"",
		"\"super\"",
		"LT",
		"COMMA",
		"GT",
		"SR",
		"BSR",
		"\"void\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"STAR",
		"\"private\"",
		"\"public\"",
		"\"protected\"",
		"\"transient\"",
		"\"native\"",
		"\"threadsafe\"",
		"\"synchronized\"",
		"\"volatile\"",
		"AT",
		"LPAREN",
		"RPAREN",
		"ASSIGN",
		"LCURLY",
		"RCURLY",
		"\"class\"",
		"\"interface\"",
		"\"enum\"",
		"BAND",
		"\"default\"",
		"\"implements\"",
		"\"this\"",
		"\"throws\"",
		"TRIPLE_DOT",
		"COLON",
		"\"if\"",
		"\"else\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"\"continue\"",
		"\"return\"",
		"\"switch\"",
		"\"throw\"",
		"\"assert\"",
		"\"for\"",
		"\"case\"",
		"\"try\"",
		"\"finally\"",
		"\"catch\"",
		"PLUS_ASSIGN",
		"MINUS_ASSIGN",
		"STAR_ASSIGN",
		"DIV_ASSIGN",
		"MOD_ASSIGN",
		"SR_ASSIGN",
		"BSR_ASSIGN",
		"SL_ASSIGN",
		"BAND_ASSIGN",
		"BXOR_ASSIGN",
		"BOR_ASSIGN",
		"LOR",
		"LAND",
		"BOR",
		"BXOR",
		"NOT_EQUAL",
		"EQUAL",
		"LE",
		"GE",
		"\"instanceof\"",
		"SL",
		"PLUS",
		"MINUS",
		"DIV",
		"MOD",
		"INC",
		"DEC",
		"BNOT",
		"LNOT",
		"\"true\"",
		"\"false\"",
		"\"null\"",
		"\"new\"",
		"NUM_INT",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"NUM_FLOAT",
		"NUM_LONG",
		"NUM_DOUBLE",
		"WS",
		"SL_COMMENT",
		"ML_COMMENT",
		"ESC",
		"HEX_DIGIT",
		"VOCAB",
		"EXPONENT",
		"FLOAT_SUFFIX",
		"\"const\""
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 633318697648128L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 2255648104382464L, 8556380164L, 140737488355328L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 2265000655724544L, 39582435407584L, 549755811840L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 4612319612275573888L, 3457075666107760640L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	}
	
