// $ANTLR 2.7.5 (20050128): "java15.tree.instrumenter.g" -> "JavaTreeInstrumenter.java"$


package de.fau.cs.swe.sa.conditionCoverage;

import java.io.*;
import java.util.*;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/** Java 1.5 AST Recognizer Grammar
 *
 * JavaTreeInstrumenter.java - This class instruments the AST returned by
 * the JavaRecognizer and returns the instrumented AST.
 *
 * @author: (see java.g preamble) && Dominik Schindler
 *
 * This grammar is in the PUBLIC DOMAIN, the additional
 * code is copyright by Dominik Schindler
 */
public class JavaTreeInstrumenter extends antlr.TreeParser       implements JavaTreeInstrumenterTokenTypes
 {
	// 2 HashMaps to store local variables and methods and their types
	private Hashtable variableDecls = null;
	private Hashtable methodDecls = null;
	
	// ArrayList to store import definitions
	private Vector imports = null;

	// current position in the symbol table
	private long symbolCount = 0;

	//
	private boolean autoFlush = true;

	// is logging on or off?
	private boolean isLogging = false;

	// store old state for resetLogging()
	private boolean isLoggingOld = false;
	
	//
	private boolean isCtorCall = false;
	
	//
	private ClassHierarchie ch = null;
	
	//
	public JavaTreeInstrumenter( ClassHierarchie ch ) {
		this();
		this.ch = ch;
	}
	
	public JavaTreeInstrumenter( ClassHierarchie ch, Hashtable variables, Hashtable methods, Vector imports ) {
		this( ch );
		this.variableDecls = variables;
		this.methodDecls = methods;
		this.imports = imports;
	}
	
	public JavaTreeInstrumenter( Hashtable variables, Hashtable methods, Vector imports ) {
		this();
		this.variableDecls = variables;
		this.methodDecls = methods;
		this.imports = imports;
	}
	
	// === instrumenter functions ===
	// returns the instrumented AST and assings the current expression "exp"
	private AST instrTrinaryExpression(AST root, AST child1, AST child2, AST child3, String exp ) {
		symbolCount++;
		return (AST)astFactory.make( (new ASTArray(7)).add(root).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add(child1).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,"b")).add(child2).add(child3));
	}

	private AST instrBinaryExpression(AST root, AST child1, AST child2, String exp, String type) {
		if (isLogging) {
			symbolCount++;
			return (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(LOGB,"LOGB")).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add((AST)astFactory.make( (new ASTArray(3)).add(root).add(child1).add(child2))).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,type)));	
		} else {
			return (AST)astFactory.make( (new ASTArray(3)).add(root).add(child1).add(child2));	
		}
	}

	// instrument unary conditional expression like !(...)
	private AST instrUnaryExpression(AST root, AST child, String exp) {
		if (isLogging) {
			symbolCount++;
			return (AST)astFactory.make( (new ASTArray(6)).add(astFactory.create(LOGB,"LOGB")).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,"c")).add((AST)astFactory.make( (new ASTArray(2)).add(root).add(child))));	
		} else {
			return (AST)astFactory.make( (new ASTArray(2)).add(root).add(child));
		}
	}

	// instrument primary expression like variables, ...	
	private AST instrPrimaryExpression(AST root, AST child, String ident) {
		if (isLogging) { // if logging is on & variable type = boolean
			symbolCount++;
			return (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(LOGB,"LOGB")).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add((AST)astFactory.make( (new ASTArray(2)).add(root).add(child))).add(astFactory.create(IDENT,ident)).add(astFactory.create(IDENT,"p")));
		} else {
			return (AST)astFactory.make( (new ASTArray(2)).add(root).add(child));
		}
	}
	
	// instrument branch/decition expression
	private AST instrDecitionExpression(AST root, AST child, String exp) {
		if (isLogging) {
			symbolCount++;
			return (AST)astFactory.make( (new ASTArray(5)).add(astFactory.create(LOGB,"LOGB")).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add((AST)astFactory.make( (new ASTArray(2)).add(root).add(child))).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,"b")));	
		} else {
			return (AST)astFactory.make( (new ASTArray(2)).add(root).add(child));
		}
	}
	
	// instrument switch/case expressions
	private AST instrCaseExpression(AST root, AST child1, AST child2, String exp) {
		symbolCount++;
		return (AST)astFactory.make( (new ASTArray(6)).add(root).add(child1).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add(astFactory.create(IDENT,exp)).add(astFactory.create(IDENT,"s")).add(child2));
	}
	
	// instrument methods, constructors, ...
	private AST instrMethod(AST root, AST child1, AST child2, AST child3, AST child4, AST child5, String methodName, String type, String ctor) {
		symbolCount++;
		return (AST)astFactory.make( (new ASTArray(10)).add(root).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add(astFactory.create(IDENT,methodName)).add(astFactory.create(IDENT,type)).add(astFactory.create(IDENT,ctor)).add(child1).add(child2).add(child3).add(child4).add(child5));
	}

	// instrument classes and interfaces
	private AST instrClasses(AST root, AST child1, AST child2, AST child3, AST child4, AST child5, AST child6, String className, String type) {
		symbolCount++;
		return (AST)astFactory.make( (new ASTArray(10)).add(root).add(astFactory.create(IDENT,String.valueOf(symbolCount))).add(astFactory.create(IDENT,className)).add(astFactory.create(IDENT,type)).add(child1).add(child2).add(child3).add(child4).add(child5).add(child6));
	}

	// helper functions	
	//
	private String getType( String s ) {
		return ( String ) variableDecls.get( s );
	}
	
	private Vector getClasses( String s ) {
		if ( s == null ) return null;
		if ( ch == null ) return null;
		
		Vector temp;

		for ( int i = 0; i < imports.size(); i++ ) {
			String t = ( String ) imports.get( i );
			
			if ( t.endsWith( "*" ) ) {
				String u = t.substring( 0, t.indexOf( "*" ) ) + s;
				ExtendedClass e = ch.getExtendedClass( u );
				if ( e != null ) {
					temp = new Vector( e.getSubClasses() );
					temp.add( e );
					return temp;
				}
			} else if ( t.endsWith( "." + s ) ) {
				ExtendedClass e = ch.getExtendedClass( t );
				if ( e != null ) {
					temp = new Vector( e.getSubClasses() );
					temp.add( e );
					return temp;
				}
			} 
		}	

		ExtendedClass e = ch.getExtendedClass( s );
		if ( e != null ) {
			temp = new Vector( e.getSubClasses() );
			temp.add( e );
			return temp;
		}

		return null;
	}
	
	// true, if the variable or method name is of type boolean (local or external 
	// by reflection)
	private boolean checkBoolean(String ident) {
	
		if ( variableDecls == null || methodDecls == null ) return false;
		
		if ( ident.trim().length() == 0 ) return false;
		
		//System.out.println( "check: " + ident );
	
		String s = ( String ) variableDecls.get( ident );
		if (s != null && s.equals( "boolean" ) ) {
			// local variable
			return true;
		} else if ( ch != null ) { 
			// use class hierachie if not local
			String c = ( String )  variableDecls.get( ident );
			//System.out.println(c);
			return false;
		} 
		
		// search method in variable-decls		
		int p = ident.indexOf( "(" );
		if ( p < 1 ) return false;
		ident = ident.substring( 0, p );
		ident.trim();

       	System.out.println( "method decls" );
		
		System.out.println( methodDecls );
		
		s = ( String ) methodDecls.get( ident );

		// System.out.println( ident + ":" + s );

		if (s != null && s.equals( "boolean" ) ) {
			// local variable
			return true;
		} else if ( ch != null ) { 
			// use class hierarchie if not local
			String c = (String) methodDecls.get( ident );
			System.out.println(c);
			return false;
		} 
		
		
		return false;
	}

	private void setLogging() {
		isLoggingOld = isLogging;
		isLogging = true;
	}
	
	private void unsetLogging() {
		isLoggingOld = isLogging;
		isLogging = false;
	}
	
	private void resetLogging() {
		isLogging = isLoggingOld;	
	}
	
	// public methods
	public long getSymbolCount() {
		return symbolCount;
	}
	
	public void setSymbolCount(long value) {
		symbolCount = value;
	}

public JavaTreeInstrumenter() {
	tokenNames = _tokenNames;
}

	public final void compilationUnit(AST _t) throws RecognitionException {
		
		AST compilationUnit_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST compilationUnit_AST = null;
		
		try {      // for error handling
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case PACKAGE_DEF:
			{
				packageDefinition(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			case CLASS_DEF:
			case INTERFACE_DEF:
			case IMPORT:
			case STATIC_IMPORT:
			case ENUM_DEF:
			case ANNOTATION_DEF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			{
			_loop4:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IMPORT||_t.getType()==STATIC_IMPORT)) {
					importDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop4;
				}
				
			} while (true);
			}
			{
			_loop6:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop6;
				}
				
			} while (true);
			}
			compilationUnit_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = compilationUnit_AST;
		_retTree = _t;
	}
	
	public final void packageDefinition(AST _t) throws RecognitionException {
		
		AST packageDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST packageDefinition_AST = null;
		
		try {      // for error handling
			AST __t8 = _t;
			AST tmp1_AST = null;
			AST tmp1_AST_in = null;
			tmp1_AST = astFactory.create((AST)_t);
			tmp1_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp1_AST);
			ASTPair __currentAST8 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,PACKAGE_DEF);
			_t = _t.getFirstChild();
			annotations(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			identifier(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST8;
			_t = __t8;
			_t = _t.getNextSibling();
			packageDefinition_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = packageDefinition_AST;
		_retTree = _t;
	}
	
	public final void importDefinition(AST _t) throws RecognitionException {
		
		AST importDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST importDefinition_AST = null;
		
			String str_ids = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IMPORT:
			{
				AST __t10 = _t;
				AST tmp2_AST = null;
				AST tmp2_AST_in = null;
				tmp2_AST = astFactory.create((AST)_t);
				tmp2_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp2_AST);
				ASTPair __currentAST10 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,IMPORT);
				_t = _t.getFirstChild();
				identifierStar(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST10;
				_t = __t10;
				_t = _t.getNextSibling();
				importDefinition_AST = (AST)currentAST.root;
				break;
			}
			case STATIC_IMPORT:
			{
				AST __t11 = _t;
				AST tmp3_AST = null;
				AST tmp3_AST_in = null;
				tmp3_AST = astFactory.create((AST)_t);
				tmp3_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp3_AST);
				ASTPair __currentAST11 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,STATIC_IMPORT);
				_t = _t.getFirstChild();
				identifierStar(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST11;
				_t = __t11;
				_t = _t.getNextSibling();
				importDefinition_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = importDefinition_AST;
		_retTree = _t;
	}
	
	public final void typeDefinition(AST _t) throws RecognitionException {
		
		AST typeDefinition_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeDefinition_AST = null;
		AST cd = null;
		AST cd_AST = null;
		AST mo_AST = null;
		AST mo = null;
		AST id = null;
		AST id_AST = null;
		AST tp_AST = null;
		AST tp = null;
		AST ec_AST = null;
		AST ec = null;
		AST ic_AST = null;
		AST ic = null;
		AST ob_AST = null;
		AST ob = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CLASS_DEF:
			{
				AST __t13 = _t;
				cd = _t==ASTNULL ? null :(AST)_t;
				AST cd_AST_in = null;
				cd_AST = astFactory.create(cd);
				ASTPair __currentAST13 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,CLASS_DEF);
				_t = _t.getFirstChild();
				mo = _t==ASTNULL ? null : (AST)_t;
				modifiers(_t);
				_t = _retTree;
				mo_AST = (AST)returnAST;
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_PARAMETERS:
				{
					tp = _t==ASTNULL ? null : (AST)_t;
					typeParameters(_t);
					_t = _retTree;
					tp_AST = (AST)returnAST;
					break;
				}
				case EXTENDS_CLAUSE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				ec = _t==ASTNULL ? null : (AST)_t;
				extendsClause(_t);
				_t = _retTree;
				ec_AST = (AST)returnAST;
				ic = _t==ASTNULL ? null : (AST)_t;
				implementsClause(_t);
				_t = _retTree;
				ic_AST = (AST)returnAST;
				ob = _t==ASTNULL ? null : (AST)_t;
				objBlock(_t);
				_t = _retTree;
				ob_AST = (AST)returnAST;
				typeDefinition_AST = (AST)currentAST.root;
				
									typeDefinition_AST = instrClasses(cd_AST, mo_AST, id_AST, tp_AST, ec_AST, ic_AST, ob_AST, id.getText(), "ke"); 
								
				currentAST.root = typeDefinition_AST;
				currentAST.child = typeDefinition_AST!=null &&typeDefinition_AST.getFirstChild()!=null ?
					typeDefinition_AST.getFirstChild() : typeDefinition_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST13;
				_t = __t13;
				_t = _t.getNextSibling();
				break;
			}
			case INTERFACE_DEF:
			{
				AST __t15 = _t;
				AST tmp4_AST = null;
				AST tmp4_AST_in = null;
				tmp4_AST = astFactory.create((AST)_t);
				tmp4_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp4_AST);
				ASTPair __currentAST15 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,INTERFACE_DEF);
				_t = _t.getFirstChild();
				modifiers(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp5_AST = null;
				AST tmp5_AST_in = null;
				tmp5_AST = astFactory.create((AST)_t);
				tmp5_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp5_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_PARAMETERS:
				{
					typeParameters(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case EXTENDS_CLAUSE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				extendsClause(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				interfaceBlock(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST15;
				_t = __t15;
				_t = _t.getNextSibling();
				typeDefinition_AST = (AST)currentAST.root;
				break;
			}
			case ENUM_DEF:
			{
				AST __t17 = _t;
				AST tmp6_AST = null;
				AST tmp6_AST_in = null;
				tmp6_AST = astFactory.create((AST)_t);
				tmp6_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp6_AST);
				ASTPair __currentAST17 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,ENUM_DEF);
				_t = _t.getFirstChild();
				modifiers(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp7_AST = null;
				AST tmp7_AST_in = null;
				tmp7_AST = astFactory.create((AST)_t);
				tmp7_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp7_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				implementsClause(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				enumBlock(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST17;
				_t = __t17;
				_t = _t.getNextSibling();
				typeDefinition_AST = (AST)currentAST.root;
				break;
			}
			case ANNOTATION_DEF:
			{
				AST __t18 = _t;
				AST tmp8_AST = null;
				AST tmp8_AST_in = null;
				tmp8_AST = astFactory.create((AST)_t);
				tmp8_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp8_AST);
				ASTPair __currentAST18 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,ANNOTATION_DEF);
				_t = _t.getFirstChild();
				modifiers(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				AST tmp9_AST = null;
				AST tmp9_AST_in = null;
				tmp9_AST = astFactory.create((AST)_t);
				tmp9_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp9_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				annotationBlock(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST18;
				_t = __t18;
				_t = _t.getNextSibling();
				typeDefinition_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeDefinition_AST;
		_retTree = _t;
	}
	
	public final void annotations(AST _t) throws RecognitionException {
		
		AST annotations_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotations_AST = null;
		
		try {      // for error handling
			AST __t62 = _t;
			AST tmp10_AST = null;
			AST tmp10_AST_in = null;
			tmp10_AST = astFactory.create((AST)_t);
			tmp10_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp10_AST);
			ASTPair __currentAST62 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ANNOTATIONS);
			_t = _t.getFirstChild();
			{
			_loop64:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ANNOTATION)) {
					annotation(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop64;
				}
				
			} while (true);
			}
			currentAST = __currentAST62;
			_t = __t62;
			_t = _t.getNextSibling();
			annotations_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotations_AST;
		_retTree = _t;
	}
	
	public final String  identifier(AST _t) throws RecognitionException {
		String result = "";
		
		AST identifier_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST identifier_AST = null;
		AST id = null;
		AST id_AST = null;
		AST do_ = null;
		AST do__AST = null;
		AST id2 = null;
		AST id2_AST = null;
		
			String str_id = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				astFactory.addASTChild(currentAST, id_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								result = id.getText(); 
							
				identifier_AST = (AST)currentAST.root;
				break;
			}
			case DOT:
			{
				AST __t157 = _t;
				do_ = _t==ASTNULL ? null :(AST)_t;
				AST do__AST_in = null;
				do__AST = astFactory.create(do_);
				astFactory.addASTChild(currentAST, do__AST);
				ASTPair __currentAST157 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DOT);
				_t = _t.getFirstChild();
				str_id=identifier(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				id2 = (AST)_t;
				AST id2_AST_in = null;
				id2_AST = astFactory.create(id2);
				astFactory.addASTChild(currentAST, id2_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
									result = str_id + do_.getText() + id2.getText();
								
				currentAST = __currentAST157;
				_t = __t157;
				_t = _t.getNextSibling();
				identifier_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = identifier_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  identifierStar(AST _t) throws RecognitionException {
		String result = "";
		
		AST identifierStar_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST identifierStar_AST = null;
		AST id = null;
		AST id_AST = null;
		AST do_ = null;
		AST do__AST = null;
		AST st = null;
		AST st_AST = null;
		AST id2 = null;
		AST id2_AST = null;
		
			String str_id = ""; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				astFactory.addASTChild(currentAST, id_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								result = id.getText(); 
							
				identifierStar_AST = (AST)currentAST.root;
				break;
			}
			case DOT:
			{
				AST __t159 = _t;
				do_ = _t==ASTNULL ? null :(AST)_t;
				AST do__AST_in = null;
				do__AST = astFactory.create(do_);
				astFactory.addASTChild(currentAST, do__AST);
				ASTPair __currentAST159 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DOT);
				_t = _t.getFirstChild();
				str_id=identifier(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case STAR:
				{
					st = (AST)_t;
					AST st_AST_in = null;
					st_AST = astFactory.create(st);
					astFactory.addASTChild(currentAST, st_AST);
					match(_t,STAR);
					_t = _t.getNextSibling();
					
												result = str_id + do_.getText() + st.getText(); 
											
					break;
				}
				case IDENT:
				{
					id2 = (AST)_t;
					AST id2_AST_in = null;
					id2_AST = astFactory.create(id2);
					astFactory.addASTChild(currentAST, id2_AST);
					match(_t,IDENT);
					_t = _t.getNextSibling();
						
												result = str_id + do_.getText() + id2.getText();
											
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST159;
				_t = __t159;
				_t = _t.getNextSibling();
				identifierStar_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = identifierStar_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  modifiers(AST _t) throws RecognitionException {
		String result = "";
		
		AST modifiers_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST modifiers_AST = null;
		
		try {      // for error handling
			AST __t57 = _t;
			AST tmp11_AST = null;
			AST tmp11_AST_in = null;
			tmp11_AST = astFactory.create((AST)_t);
			tmp11_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp11_AST);
			ASTPair __currentAST57 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,MODIFIERS);
			_t = _t.getFirstChild();
			{
			_loop59:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_1.member(_t.getType()))) {
					modifier(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop59;
				}
				
			} while (true);
			}
			currentAST = __currentAST57;
			_t = __t57;
			_t = _t.getNextSibling();
			modifiers_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = modifiers_AST;
		_retTree = _t;
		return result;
	}
	
	public final void typeParameters(AST _t) throws RecognitionException {
		
		AST typeParameters_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeParameters_AST = null;
		
		try {      // for error handling
			AST __t20 = _t;
			AST tmp12_AST = null;
			AST tmp12_AST_in = null;
			tmp12_AST = astFactory.create((AST)_t);
			tmp12_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp12_AST);
			ASTPair __currentAST20 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE_PARAMETERS);
			_t = _t.getFirstChild();
			{
			int _cnt22=0;
			_loop22:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==TYPE_PARAMETER)) {
					typeParameter(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					if ( _cnt22>=1 ) { break _loop22; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt22++;
			} while (true);
			}
			currentAST = __currentAST20;
			_t = __t20;
			_t = _t.getNextSibling();
			typeParameters_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeParameters_AST;
		_retTree = _t;
	}
	
	public final void extendsClause(AST _t) throws RecognitionException {
		
		AST extendsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST extendsClause_AST = null;
		
		try {      // for error handling
			AST __t79 = _t;
			AST tmp13_AST = null;
			AST tmp13_AST_in = null;
			tmp13_AST = astFactory.create((AST)_t);
			tmp13_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp13_AST);
			ASTPair __currentAST79 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,EXTENDS_CLAUSE);
			_t = _t.getFirstChild();
			{
			_loop81:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					classOrInterfaceType(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop81;
				}
				
			} while (true);
			}
			currentAST = __currentAST79;
			_t = __t79;
			_t = _t.getNextSibling();
			extendsClause_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = extendsClause_AST;
		_retTree = _t;
	}
	
	public final void implementsClause(AST _t) throws RecognitionException {
		
		AST implementsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST implementsClause_AST = null;
		
		try {      // for error handling
			AST __t83 = _t;
			AST tmp14_AST = null;
			AST tmp14_AST_in = null;
			tmp14_AST = astFactory.create((AST)_t);
			tmp14_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp14_AST);
			ASTPair __currentAST83 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,IMPLEMENTS_CLAUSE);
			_t = _t.getFirstChild();
			{
			_loop85:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					classOrInterfaceType(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop85;
				}
				
			} while (true);
			}
			currentAST = __currentAST83;
			_t = __t83;
			_t = _t.getNextSibling();
			implementsClause_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = implementsClause_AST;
		_retTree = _t;
	}
	
	public final void objBlock(AST _t) throws RecognitionException {
		
		AST objBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST objBlock_AST = null;
		
		try {      // for error handling
			AST __t91 = _t;
			AST tmp15_AST = null;
			AST tmp15_AST_in = null;
			tmp15_AST = astFactory.create((AST)_t);
			tmp15_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp15_AST);
			ASTPair __currentAST91 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop95:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case CTOR_DEF:
				{
					ctorDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case METHOD_DEF:
				{
					methodDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case STATIC_INIT:
				{
					AST __t93 = _t;
					AST tmp16_AST = null;
					AST tmp16_AST_in = null;
					tmp16_AST = astFactory.create((AST)_t);
					tmp16_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp16_AST);
					ASTPair __currentAST93 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,STATIC_INIT);
					_t = _t.getFirstChild();
					slist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST93;
					_t = __t93;
					_t = _t.getNextSibling();
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t94 = _t;
					AST tmp17_AST = null;
					AST tmp17_AST_in = null;
					tmp17_AST = astFactory.create((AST)_t);
					tmp17_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp17_AST);
					ASTPair __currentAST94 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST94;
					_t = __t94;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop95;
				}
				}
			} while (true);
			}
			currentAST = __currentAST91;
			_t = __t91;
			_t = _t.getNextSibling();
			objBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = objBlock_AST;
		_retTree = _t;
	}
	
	public final void interfaceBlock(AST _t) throws RecognitionException {
		
		AST interfaceBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST interfaceBlock_AST = null;
		
		try {      // for error handling
			AST __t87 = _t;
			AST tmp18_AST = null;
			AST tmp18_AST_in = null;
			tmp18_AST = astFactory.create((AST)_t);
			tmp18_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp18_AST);
			ASTPair __currentAST87 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop89:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case METHOD_DEF:
				{
					methodDecl(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					break _loop89;
				}
				}
			} while (true);
			}
			currentAST = __currentAST87;
			_t = __t87;
			_t = _t.getNextSibling();
			interfaceBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = interfaceBlock_AST;
		_retTree = _t;
	}
	
	public final void enumBlock(AST _t) throws RecognitionException {
		
		AST enumBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumBlock_AST = null;
		
		try {      // for error handling
			AST __t101 = _t;
			AST tmp19_AST = null;
			AST tmp19_AST_in = null;
			tmp19_AST = astFactory.create((AST)_t);
			tmp19_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp19_AST);
			ASTPair __currentAST101 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop103:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==ENUM_CONSTANT_DEF)) {
					enumConstantDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop103;
				}
				
			} while (true);
			}
			{
			_loop107:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case CTOR_DEF:
				{
					ctorDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case METHOD_DEF:
				{
					methodDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case STATIC_INIT:
				{
					AST __t105 = _t;
					AST tmp20_AST = null;
					AST tmp20_AST_in = null;
					tmp20_AST = astFactory.create((AST)_t);
					tmp20_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp20_AST);
					ASTPair __currentAST105 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,STATIC_INIT);
					_t = _t.getFirstChild();
					slist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST105;
					_t = __t105;
					_t = _t.getNextSibling();
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t106 = _t;
					AST tmp21_AST = null;
					AST tmp21_AST_in = null;
					tmp21_AST = astFactory.create((AST)_t);
					tmp21_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp21_AST);
					ASTPair __currentAST106 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST106;
					_t = __t106;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop107;
				}
				}
			} while (true);
			}
			currentAST = __currentAST101;
			_t = __t101;
			_t = _t.getNextSibling();
			enumBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = enumBlock_AST;
		_retTree = _t;
	}
	
	public final void annotationBlock(AST _t) throws RecognitionException {
		
		AST annotationBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationBlock_AST = null;
		
		try {      // for error handling
			AST __t97 = _t;
			AST tmp22_AST = null;
			AST tmp22_AST_in = null;
			tmp22_AST = astFactory.create((AST)_t);
			tmp22_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp22_AST);
			ASTPair __currentAST97 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop99:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ANNOTATION_FIELD_DEF:
				{
					annotationFieldDecl(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					break _loop99;
				}
				}
			} while (true);
			}
			currentAST = __currentAST97;
			_t = __t97;
			_t = _t.getNextSibling();
			annotationBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotationBlock_AST;
		_retTree = _t;
	}
	
	public final void typeParameter(AST _t) throws RecognitionException {
		
		AST typeParameter_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeParameter_AST = null;
		
		try {      // for error handling
			AST __t24 = _t;
			AST tmp23_AST = null;
			AST tmp23_AST_in = null;
			tmp23_AST = astFactory.create((AST)_t);
			tmp23_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp23_AST);
			ASTPair __currentAST24 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE_PARAMETER);
			_t = _t.getFirstChild();
			AST tmp24_AST = null;
			AST tmp24_AST_in = null;
			tmp24_AST = astFactory.create((AST)_t);
			tmp24_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp24_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			{
				typeUpperBounds(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST24;
			_t = __t24;
			_t = _t.getNextSibling();
			typeParameter_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeParameter_AST;
		_retTree = _t;
	}
	
	public final void typeUpperBounds(AST _t) throws RecognitionException {
		
		AST typeUpperBounds_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeUpperBounds_AST = null;
		
		try {      // for error handling
			AST __t27 = _t;
			AST tmp25_AST = null;
			AST tmp25_AST_in = null;
			tmp25_AST = astFactory.create((AST)_t);
			tmp25_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp25_AST);
			ASTPair __currentAST27 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE_UPPER_BOUNDS);
			_t = _t.getFirstChild();
			{
			int _cnt29=0;
			_loop29:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					classOrInterfaceType(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					if ( _cnt29>=1 ) { break _loop29; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt29++;
			} while (true);
			}
			currentAST = __currentAST27;
			_t = __t27;
			_t = _t.getNextSibling();
			typeUpperBounds_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeUpperBounds_AST;
		_retTree = _t;
	}
	
	public final String  classOrInterfaceType(AST _t) throws RecognitionException {
		String result = "";
		
		AST classOrInterfaceType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST classOrInterfaceType_AST = null;
		AST id = null;
		AST id_AST = null;
		AST dot = null;
		AST dot_AST = null;
		AST ide = null;
		AST ide_AST = null;
		
			String s = ""; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				astFactory.addASTChild(currentAST, id_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								result = id.getText(); 
							
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_ARGUMENTS:
				{
					typeArguments(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				case ARRAY_DECLARATOR:
				case ELIST:
				case IDENT:
				case DOT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				classOrInterfaceType_AST = (AST)currentAST.root;
				break;
			}
			case DOT:
			{
				AST __t37 = _t;
				dot = _t==ASTNULL ? null :(AST)_t;
				AST dot_AST_in = null;
				dot_AST = astFactory.create(dot);
				astFactory.addASTChild(currentAST, dot_AST);
				ASTPair __currentAST37 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DOT);
				_t = _t.getFirstChild();
				s=classOrInterfaceType(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				ide = (AST)_t;
				AST ide_AST_in = null;
				ide_AST = astFactory.create(ide);
				astFactory.addASTChild(currentAST, ide_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								result = s + dot.getText() + ide;
							
				currentAST = __currentAST37;
				_t = __t37;
				_t = _t.getNextSibling();
				classOrInterfaceType_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = classOrInterfaceType_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  typeSpec(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeSpec_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeSpec_AST = null;
		
		try {      // for error handling
			AST __t31 = _t;
			AST tmp26_AST = null;
			AST tmp26_AST_in = null;
			tmp26_AST = astFactory.create((AST)_t);
			tmp26_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp26_AST);
			ASTPair __currentAST31 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE);
			_t = _t.getFirstChild();
			result=typeSpecArray(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST31;
			_t = __t31;
			_t = _t.getNextSibling();
			typeSpec_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeSpec_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  typeSpecArray(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeSpecArray_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeSpecArray_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				AST __t33 = _t;
				AST tmp27_AST = null;
				AST tmp27_AST_in = null;
				tmp27_AST = astFactory.create((AST)_t);
				tmp27_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp27_AST);
				ASTPair __currentAST33 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,ARRAY_DECLARATOR);
				_t = _t.getFirstChild();
				result=typeSpecArray(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result += "[]";
								
				currentAST = __currentAST33;
				_t = __t33;
				_t = _t.getNextSibling();
				typeSpecArray_AST = (AST)currentAST.root;
				break;
			}
			case IDENT:
			case DOT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				result=type(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				typeSpecArray_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeSpecArray_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  type(AST _t) throws RecognitionException {
		String result = "";
		
		AST type_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST type_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			case DOT:
			{
				result=classOrInterfaceType(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				type_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				result=builtInType(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				type_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = type_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  builtInType(AST _t) throws RecognitionException {
		String result = "";
		
		AST builtInType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST builtInType_AST = null;
		AST vo = null;
		AST vo_AST = null;
		AST bo = null;
		AST bo_AST = null;
		AST by = null;
		AST by_AST = null;
		AST ch = null;
		AST ch_AST = null;
		AST sh = null;
		AST sh_AST = null;
		AST in = null;
		AST in_AST = null;
		AST fl = null;
		AST fl_AST = null;
		AST lo = null;
		AST lo_AST = null;
		AST dou = null;
		AST dou_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_void:
			{
				vo = (AST)_t;
				AST vo_AST_in = null;
				vo_AST = astFactory.create(vo);
				astFactory.addASTChild(currentAST, vo_AST);
				match(_t,LITERAL_void);
				_t = _t.getNextSibling();
				
								result = vo.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_boolean:
			{
				bo = (AST)_t;
				AST bo_AST_in = null;
				bo_AST = astFactory.create(bo);
				astFactory.addASTChild(currentAST, bo_AST);
				match(_t,LITERAL_boolean);
				_t = _t.getNextSibling();
				
								result = bo.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_byte:
			{
				by = (AST)_t;
				AST by_AST_in = null;
				by_AST = astFactory.create(by);
				astFactory.addASTChild(currentAST, by_AST);
				match(_t,LITERAL_byte);
				_t = _t.getNextSibling();
				
								result = by.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_char:
			{
				ch = (AST)_t;
				AST ch_AST_in = null;
				ch_AST = astFactory.create(ch);
				astFactory.addASTChild(currentAST, ch_AST);
				match(_t,LITERAL_char);
				_t = _t.getNextSibling();
				
								result = ch.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_short:
			{
				sh = (AST)_t;
				AST sh_AST_in = null;
				sh_AST = astFactory.create(sh);
				astFactory.addASTChild(currentAST, sh_AST);
				match(_t,LITERAL_short);
				_t = _t.getNextSibling();
				
								result = sh.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_int:
			{
				in = (AST)_t;
				AST in_AST_in = null;
				in_AST = astFactory.create(in);
				astFactory.addASTChild(currentAST, in_AST);
				match(_t,LITERAL_int);
				_t = _t.getNextSibling();
				
								result = in.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_float:
			{
				fl = (AST)_t;
				AST fl_AST_in = null;
				fl_AST = astFactory.create(fl);
				astFactory.addASTChild(currentAST, fl_AST);
				match(_t,LITERAL_float);
				_t = _t.getNextSibling();
				
								result = fl.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_long:
			{
				lo = (AST)_t;
				AST lo_AST_in = null;
				lo_AST = astFactory.create(lo);
				astFactory.addASTChild(currentAST, lo_AST);
				match(_t,LITERAL_long);
				_t = _t.getNextSibling();
				
								result = lo.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_double:
			{
				dou = (AST)_t;
				AST dou_AST_in = null;
				dou_AST = astFactory.create(dou);
				astFactory.addASTChild(currentAST, dou_AST);
				match(_t,LITERAL_double);
				_t = _t.getNextSibling();
					
								result = dou.getText();
							
				builtInType_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = builtInType_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  typeArguments(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeArguments_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArguments_AST = null;
		
			String str_ta = ""; 
		
		
		try {      // for error handling
			AST __t39 = _t;
			AST tmp28_AST = null;
			AST tmp28_AST_in = null;
			tmp28_AST = astFactory.create((AST)_t);
			tmp28_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp28_AST);
			ASTPair __currentAST39 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE_ARGUMENTS);
			_t = _t.getFirstChild();
			{
			int _cnt41=0;
			_loop41:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==TYPE_ARGUMENT)) {
					str_ta=typeArgument(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					
										result += str_ta + " ";
									
				}
				else {
					if ( _cnt41>=1 ) { break _loop41; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt41++;
			} while (true);
			}
			currentAST = __currentAST39;
			_t = __t39;
			_t = _t.getNextSibling();
			typeArguments_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeArguments_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  typeArgument(AST _t) throws RecognitionException {
		String result = "";
		
		AST typeArgument_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArgument_AST = null;
		
		try {      // for error handling
			AST __t43 = _t;
			AST tmp29_AST = null;
			AST tmp29_AST_in = null;
			tmp29_AST = astFactory.create((AST)_t);
			tmp29_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp29_AST);
			ASTPair __currentAST43 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,TYPE_ARGUMENT);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			{
				typeSpec(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case WILDCARD_TYPE:
			{
				wildcardType(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST43;
			_t = __t43;
			_t = _t.getNextSibling();
			typeArgument_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeArgument_AST;
		_retTree = _t;
		return result;
	}
	
	public final void wildcardType(AST _t) throws RecognitionException {
		
		AST wildcardType_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST wildcardType_AST = null;
		
		try {      // for error handling
			AST __t46 = _t;
			AST tmp30_AST = null;
			AST tmp30_AST_in = null;
			tmp30_AST = astFactory.create((AST)_t);
			tmp30_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp30_AST);
			ASTPair __currentAST46 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,WILDCARD_TYPE);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			case TYPE_LOWER_BOUNDS:
			{
				typeArgumentBounds(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST46;
			_t = __t46;
			_t = _t.getNextSibling();
			wildcardType_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = wildcardType_AST;
		_retTree = _t;
	}
	
	public final void typeArgumentBounds(AST _t) throws RecognitionException {
		
		AST typeArgumentBounds_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST typeArgumentBounds_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_UPPER_BOUNDS:
			{
				AST __t49 = _t;
				AST tmp31_AST = null;
				AST tmp31_AST_in = null;
				tmp31_AST = astFactory.create((AST)_t);
				tmp31_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp31_AST);
				ASTPair __currentAST49 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,TYPE_UPPER_BOUNDS);
				_t = _t.getFirstChild();
				{
				int _cnt51=0;
				_loop51:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						classOrInterfaceType(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						if ( _cnt51>=1 ) { break _loop51; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt51++;
				} while (true);
				}
				currentAST = __currentAST49;
				_t = __t49;
				_t = _t.getNextSibling();
				typeArgumentBounds_AST = (AST)currentAST.root;
				break;
			}
			case TYPE_LOWER_BOUNDS:
			{
				AST __t52 = _t;
				AST tmp32_AST = null;
				AST tmp32_AST_in = null;
				tmp32_AST = astFactory.create((AST)_t);
				tmp32_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp32_AST);
				ASTPair __currentAST52 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,TYPE_LOWER_BOUNDS);
				_t = _t.getFirstChild();
				{
				int _cnt54=0;
				_loop54:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==IDENT||_t.getType()==DOT)) {
						classOrInterfaceType(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						if ( _cnt54>=1 ) { break _loop54; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt54++;
				} while (true);
				}
				currentAST = __currentAST52;
				_t = __t52;
				_t = _t.getNextSibling();
				typeArgumentBounds_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = typeArgumentBounds_AST;
		_retTree = _t;
	}
	
	public final void modifier(AST _t) throws RecognitionException {
		
		AST modifier_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST modifier_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_private:
			{
				AST tmp33_AST = null;
				AST tmp33_AST_in = null;
				tmp33_AST = astFactory.create((AST)_t);
				tmp33_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp33_AST);
				match(_t,LITERAL_private);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_public:
			{
				AST tmp34_AST = null;
				AST tmp34_AST_in = null;
				tmp34_AST = astFactory.create((AST)_t);
				tmp34_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp34_AST);
				match(_t,LITERAL_public);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_protected:
			{
				AST tmp35_AST = null;
				AST tmp35_AST_in = null;
				tmp35_AST = astFactory.create((AST)_t);
				tmp35_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp35_AST);
				match(_t,LITERAL_protected);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_static:
			{
				AST tmp36_AST = null;
				AST tmp36_AST_in = null;
				tmp36_AST = astFactory.create((AST)_t);
				tmp36_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp36_AST);
				match(_t,LITERAL_static);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_transient:
			{
				AST tmp37_AST = null;
				AST tmp37_AST_in = null;
				tmp37_AST = astFactory.create((AST)_t);
				tmp37_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp37_AST);
				match(_t,LITERAL_transient);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case FINAL:
			{
				AST tmp38_AST = null;
				AST tmp38_AST_in = null;
				tmp38_AST = astFactory.create((AST)_t);
				tmp38_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp38_AST);
				match(_t,FINAL);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case ABSTRACT:
			{
				AST tmp39_AST = null;
				AST tmp39_AST_in = null;
				tmp39_AST = astFactory.create((AST)_t);
				tmp39_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp39_AST);
				match(_t,ABSTRACT);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_native:
			{
				AST tmp40_AST = null;
				AST tmp40_AST_in = null;
				tmp40_AST = astFactory.create((AST)_t);
				tmp40_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp40_AST);
				match(_t,LITERAL_native);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_threadsafe:
			{
				AST tmp41_AST = null;
				AST tmp41_AST_in = null;
				tmp41_AST = astFactory.create((AST)_t);
				tmp41_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp41_AST);
				match(_t,LITERAL_threadsafe);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_synchronized:
			{
				AST tmp42_AST = null;
				AST tmp42_AST_in = null;
				tmp42_AST = astFactory.create((AST)_t);
				tmp42_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp42_AST);
				match(_t,LITERAL_synchronized);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_const:
			{
				AST tmp43_AST = null;
				AST tmp43_AST_in = null;
				tmp43_AST = astFactory.create((AST)_t);
				tmp43_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp43_AST);
				match(_t,LITERAL_const);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_volatile:
			{
				AST tmp44_AST = null;
				AST tmp44_AST_in = null;
				tmp44_AST = astFactory.create((AST)_t);
				tmp44_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp44_AST);
				match(_t,LITERAL_volatile);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case STRICTFP:
			{
				AST tmp45_AST = null;
				AST tmp45_AST_in = null;
				tmp45_AST = astFactory.create((AST)_t);
				tmp45_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp45_AST);
				match(_t,STRICTFP);
				_t = _t.getNextSibling();
				modifier_AST = (AST)currentAST.root;
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				modifier_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = modifier_AST;
		_retTree = _t;
	}
	
	public final void annotation(AST _t) throws RecognitionException {
		
		AST annotation_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotation_AST = null;
		
		try {      // for error handling
			AST __t66 = _t;
			AST tmp46_AST = null;
			AST tmp46_AST_in = null;
			tmp46_AST = astFactory.create((AST)_t);
			tmp46_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp46_AST);
			ASTPair __currentAST66 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ANNOTATION);
			_t = _t.getFirstChild();
			identifier(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case ANNOTATION:
			case ANNOTATION_ARRAY_INIT:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				annotationMemberValueInitializer(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case ANNOTATION_MEMBER_VALUE_PAIR:
			{
				{
				int _cnt69=0;
				_loop69:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==ANNOTATION_MEMBER_VALUE_PAIR)) {
						anntotationMemberValuePair(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						if ( _cnt69>=1 ) { break _loop69; } else {throw new NoViableAltException(_t);}
					}
					
					_cnt69++;
				} while (true);
				}
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST66;
			_t = __t66;
			_t = _t.getNextSibling();
			annotation_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotation_AST;
		_retTree = _t;
	}
	
	public final void annotationMemberValueInitializer(AST _t) throws RecognitionException {
		
		AST annotationMemberValueInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberValueInitializer_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				conditionalExpr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				annotationMemberValueInitializer_AST = (AST)currentAST.root;
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				annotationMemberValueInitializer_AST = (AST)currentAST.root;
				break;
			}
			case ANNOTATION_ARRAY_INIT:
			{
				annotationMemberArrayInitializer(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				annotationMemberValueInitializer_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotationMemberValueInitializer_AST;
		_retTree = _t;
	}
	
	public final void anntotationMemberValuePair(AST _t) throws RecognitionException {
		
		AST anntotationMemberValuePair_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST anntotationMemberValuePair_AST = null;
		
		try {      // for error handling
			AST __t72 = _t;
			AST tmp47_AST = null;
			AST tmp47_AST_in = null;
			tmp47_AST = astFactory.create((AST)_t);
			tmp47_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp47_AST);
			ASTPair __currentAST72 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ANNOTATION_MEMBER_VALUE_PAIR);
			_t = _t.getFirstChild();
			AST tmp48_AST = null;
			AST tmp48_AST_in = null;
			tmp48_AST = astFactory.create((AST)_t);
			tmp48_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp48_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			annotationMemberValueInitializer(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST72;
			_t = __t72;
			_t = _t.getNextSibling();
			anntotationMemberValuePair_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = anntotationMemberValuePair_AST;
		_retTree = _t;
	}
	
	public final String  conditionalExpr(AST _t) throws RecognitionException {
		String result = "";
		
		AST conditionalExpr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST conditionalExpr_AST = null;
		AST que = null;
		AST que_AST = null;
		AST que_left_AST = null;
		AST que_left = null;
		AST que_middle_AST = null;
		AST que_middle = null;
		AST que_right_AST = null;
		AST que_right = null;
		AST lor = null;
		AST lor_AST = null;
		AST lor_left_AST = null;
		AST lor_left = null;
		AST lor_right_AST = null;
		AST lor_right = null;
		AST land = null;
		AST land_AST = null;
		AST land_left_AST = null;
		AST land_left = null;
		AST land_right_AST = null;
		AST land_right = null;
		AST bo = null;
		AST bo_AST = null;
		AST bx = null;
		AST bx_AST = null;
		AST ba = null;
		AST ba_AST = null;
		AST n_equal = null;
		AST n_equal_AST = null;
		AST n_equal_left_AST = null;
		AST n_equal_left = null;
		AST n_equal_right_AST = null;
		AST n_equal_right = null;
		AST equal = null;
		AST equal_AST = null;
		AST equal_left_AST = null;
		AST equal_left = null;
		AST equal_right_AST = null;
		AST equal_right = null;
		AST lt = null;
		AST lt_AST = null;
		AST lt_left_AST = null;
		AST lt_left = null;
		AST lt_right_AST = null;
		AST lt_right = null;
		AST gt = null;
		AST gt_AST = null;
		AST gt_left_AST = null;
		AST gt_left = null;
		AST gt_right_AST = null;
		AST gt_right = null;
		AST le = null;
		AST le_AST = null;
		AST le_left_AST = null;
		AST le_left = null;
		AST le_right_AST = null;
		AST le_right = null;
		AST ge = null;
		AST ge_AST = null;
		AST ge_left_AST = null;
		AST ge_left = null;
		AST ge_right_AST = null;
		AST ge_right = null;
		AST sl_ = null;
		AST sl__AST = null;
		AST sr_ = null;
		AST sr__AST = null;
		AST bsr_ = null;
		AST bsr__AST = null;
		AST pl = null;
		AST pl_AST = null;
		AST mi = null;
		AST mi_AST = null;
		AST di = null;
		AST di_AST = null;
		AST mo = null;
		AST mo_AST = null;
		AST st = null;
		AST st_AST = null;
		AST in = null;
		AST in_AST = null;
		AST de = null;
		AST de_AST = null;
		AST poi = null;
		AST poi_AST = null;
		AST pod = null;
		AST pod_AST = null;
		AST bn = null;
		AST bn_AST = null;
		AST lnot = null;
		AST lnot_AST = null;
		AST lnot_right_AST = null;
		AST lnot_right = null;
		AST io = null;
		AST io_AST = null;
		AST io_left_AST = null;
		AST io_left = null;
		AST io_right_AST = null;
		AST io_right = null;
		AST um = null;
		AST um_AST = null;
		AST up = null;
		AST up_AST = null;
		AST pe_AST = null;
		AST pe = null;
			
			String str_right = "";
			String str_left = ""; 
			String str_middle = "";
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case QUESTION:
			{
				AST __t228 = _t;
				que = _t==ASTNULL ? null :(AST)_t;
				AST que_AST_in = null;
				que_AST = astFactory.create(que);
				ASTPair __currentAST228 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,QUESTION);
				_t = _t.getFirstChild();
				
									setLogging();
								
				que_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				que_left_AST = (AST)returnAST;
				
								 	unsetLogging();
								
				que_middle = _t==ASTNULL ? null : (AST)_t;
				str_middle=expr(_t);
				_t = _retTree;
				que_middle_AST = (AST)returnAST;
				
								 	unsetLogging();
								
				que_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				que_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									result = str_left + " " + que.getText() + " " + str_middle + " : " + str_right ; 
									conditionalExpr_AST = instrTrinaryExpression(que_AST, que_left_AST, que_middle_AST, que_right_AST, result);
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST228;
				_t = __t228;
				_t = _t.getNextSibling();
				break;
			}
			case LOR:
			{
				AST __t229 = _t;
				lor = _t==ASTNULL ? null :(AST)_t;
				AST lor_AST_in = null;
				lor_AST = astFactory.create(lor);
				ASTPair __currentAST229 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LOR);
				_t = _t.getFirstChild();
				lor_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				lor_left_AST = (AST)returnAST;
				lor_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				lor_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									result = str_left + " " + lor.getText() + " " + str_right;
									conditionalExpr_AST = instrBinaryExpression(lor_AST, lor_left_AST, lor_right_AST, result, "c");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST229;
				_t = __t229;
				_t = _t.getNextSibling();
				break;
			}
			case LAND:
			{
				AST __t230 = _t;
				land = _t==ASTNULL ? null :(AST)_t;
				AST land_AST_in = null;
				land_AST = astFactory.create(land);
				ASTPair __currentAST230 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LAND);
				_t = _t.getFirstChild();
				land_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				land_left_AST = (AST)returnAST;
				land_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				land_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									result = str_left + " " + land.getText() + " " + str_right;
									conditionalExpr_AST = instrBinaryExpression(land_AST, land_left_AST, land_right_AST, result, "c");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST230;
				_t = __t230;
				_t = _t.getNextSibling();
				break;
			}
			case BOR:
			{
				AST __t231 = _t;
				bo = _t==ASTNULL ? null :(AST)_t;
				AST bo_AST_in = null;
				bo_AST = astFactory.create(bo);
				astFactory.addASTChild(currentAST, bo_AST);
				ASTPair __currentAST231 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BOR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + bo.getText() + " " + str_right;
								
				currentAST = __currentAST231;
				_t = __t231;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case BXOR:
			{
				AST __t232 = _t;
				bx = _t==ASTNULL ? null :(AST)_t;
				AST bx_AST_in = null;
				bx_AST = astFactory.create(bx);
				astFactory.addASTChild(currentAST, bx_AST);
				ASTPair __currentAST232 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BXOR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				result = str_left + " " + bx.getText() + " " + str_right;
				currentAST = __currentAST232;
				_t = __t232;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case BAND:
			{
				AST __t233 = _t;
				ba = _t==ASTNULL ? null :(AST)_t;
				AST ba_AST_in = null;
				ba_AST = astFactory.create(ba);
				astFactory.addASTChild(currentAST, ba_AST);
				ASTPair __currentAST233 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BAND);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				result = str_left + " " + ba.getText() + " " + str_right;
				currentAST = __currentAST233;
				_t = __t233;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case NOT_EQUAL:
			{
				AST __t234 = _t;
				n_equal = _t==ASTNULL ? null :(AST)_t;
				AST n_equal_AST_in = null;
				n_equal_AST = astFactory.create(n_equal);
				ASTPair __currentAST234 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,NOT_EQUAL);
				_t = _t.getFirstChild();
				n_equal_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				n_equal_left_AST = (AST)returnAST;
				n_equal_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				n_equal_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									setLogging();
									result = str_left + " " + n_equal.getText() + " " + str_right;
									conditionalExpr_AST = instrBinaryExpression(n_equal_AST, n_equal_left_AST, n_equal_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST234;
				_t = __t234;
				_t = _t.getNextSibling();
				break;
			}
			case EQUAL:
			{
				AST __t235 = _t;
				equal = _t==ASTNULL ? null :(AST)_t;
				AST equal_AST_in = null;
				equal_AST = astFactory.create(equal);
				ASTPair __currentAST235 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,EQUAL);
				_t = _t.getFirstChild();
				equal_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				equal_left_AST = (AST)returnAST;
				equal_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				equal_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									setLogging();
									result = "( " + str_left + " " + equal.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(equal_AST, equal_left_AST, equal_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST235;
				_t = __t235;
				_t = _t.getNextSibling();
				break;
			}
			case LT:
			{
				AST __t236 = _t;
				lt = _t==ASTNULL ? null :(AST)_t;
				AST lt_AST_in = null;
				lt_AST = astFactory.create(lt);
				ASTPair __currentAST236 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LT);
				_t = _t.getFirstChild();
				
									// disable logging since the expressions are not boolean	
									unsetLogging();
								
				lt_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				lt_left_AST = (AST)returnAST;
				lt_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				lt_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									setLogging();				
									result = "( " + str_left + " " + lt.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(lt_AST, lt_left_AST, lt_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST236;
				_t = __t236;
				_t = _t.getNextSibling();
				break;
			}
			case GT:
			{
				AST __t237 = _t;
				gt = _t==ASTNULL ? null :(AST)_t;
				AST gt_AST_in = null;
				gt_AST = astFactory.create(gt);
				ASTPair __currentAST237 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,GT);
				_t = _t.getFirstChild();
				
									// disable logging since the expressions are not boolean	
									unsetLogging();
								
				gt_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				gt_left_AST = (AST)returnAST;
				gt_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				gt_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
						
									setLogging();				
									result = "( " + str_left + " " + gt.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(gt_AST, gt_left_AST, gt_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST237;
				_t = __t237;
				_t = _t.getNextSibling();
				break;
			}
			case LE:
			{
				AST __t238 = _t;
				le = _t==ASTNULL ? null :(AST)_t;
				AST le_AST_in = null;
				le_AST = astFactory.create(le);
				ASTPair __currentAST238 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LE);
				_t = _t.getFirstChild();
				
									// disable logging since the expressions are not boolean	
									unsetLogging();
								
				le_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				le_left_AST = (AST)returnAST;
				le_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				le_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
						
									setLogging();				
									result = "( " + str_left + " " + le.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(le_AST, le_left_AST, le_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST238;
				_t = __t238;
				_t = _t.getNextSibling();
				break;
			}
			case GE:
			{
				AST __t239 = _t;
				ge = _t==ASTNULL ? null :(AST)_t;
				AST ge_AST_in = null;
				ge_AST = astFactory.create(ge);
				ASTPair __currentAST239 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,GE);
				_t = _t.getFirstChild();
				
									// disable logging since the expressions are not boolean	
									unsetLogging();
								
				ge_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				ge_left_AST = (AST)returnAST;
				ge_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				ge_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
						
									setLogging();				
									result = "( " + str_left + " " + ge.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(ge_AST, ge_left_AST, ge_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST239;
				_t = __t239;
				_t = _t.getNextSibling();
				break;
			}
			case SL:
			{
				AST __t240 = _t;
				sl_ = _t==ASTNULL ? null :(AST)_t;
				AST sl__AST_in = null;
				sl__AST = astFactory.create(sl_);
				astFactory.addASTChild(currentAST, sl__AST);
				ASTPair __currentAST240 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,SL);
				_t = _t.getFirstChild();
				
									unsetLogging();
								
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + sl_.getText() + " " + str_right; 
									resetLogging();
								
				currentAST = __currentAST240;
				_t = __t240;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case SR:
			{
				AST __t241 = _t;
				sr_ = _t==ASTNULL ? null :(AST)_t;
				AST sr__AST_in = null;
				sr__AST = astFactory.create(sr_);
				astFactory.addASTChild(currentAST, sr__AST);
				ASTPair __currentAST241 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,SR);
				_t = _t.getFirstChild();
				
									unsetLogging();
								
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + sr_.getText() + " " + str_right;
									resetLogging();
								
				currentAST = __currentAST241;
				_t = __t241;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case BSR:
			{
				AST __t242 = _t;
				bsr_ = _t==ASTNULL ? null :(AST)_t;
				AST bsr__AST_in = null;
				bsr__AST = astFactory.create(bsr_);
				astFactory.addASTChild(currentAST, bsr__AST);
				ASTPair __currentAST242 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BSR);
				_t = _t.getFirstChild();
				
									unsetLogging();
								
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + bsr_.getText() + " " + str_right; 
									resetLogging();
								
				currentAST = __currentAST242;
				_t = __t242;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case PLUS:
			{
				AST __t243 = _t;
				pl = _t==ASTNULL ? null :(AST)_t;
				AST pl_AST_in = null;
				pl_AST = astFactory.create(pl);
				astFactory.addASTChild(currentAST, pl_AST);
				ASTPair __currentAST243 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,PLUS);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + pl.getText() + " " + str_right; 
								
				currentAST = __currentAST243;
				_t = __t243;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case MINUS:
			{
				AST __t244 = _t;
				mi = _t==ASTNULL ? null :(AST)_t;
				AST mi_AST_in = null;
				mi_AST = astFactory.create(mi);
				astFactory.addASTChild(currentAST, mi_AST);
				ASTPair __currentAST244 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,MINUS);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + mi.getText() + " " + str_right;
								
				currentAST = __currentAST244;
				_t = __t244;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case DIV:
			{
				AST __t245 = _t;
				di = _t==ASTNULL ? null :(AST)_t;
				AST di_AST_in = null;
				di_AST = astFactory.create(di);
				astFactory.addASTChild(currentAST, di_AST);
				ASTPair __currentAST245 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DIV);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + di.getText() + " " + str_right;
								
				currentAST = __currentAST245;
				_t = __t245;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case MOD:
			{
				AST __t246 = _t;
				mo = _t==ASTNULL ? null :(AST)_t;
				AST mo_AST_in = null;
				mo_AST = astFactory.create(mo);
				astFactory.addASTChild(currentAST, mo_AST);
				ASTPair __currentAST246 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,MOD);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + mo.getText() + " " + str_right; 
								
				currentAST = __currentAST246;
				_t = __t246;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case STAR:
			{
				AST __t247 = _t;
				st = _t==ASTNULL ? null :(AST)_t;
				AST st_AST_in = null;
				st_AST = astFactory.create(st);
				astFactory.addASTChild(currentAST, st_AST);
				ASTPair __currentAST247 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,STAR);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + " " + st.getText() + " " + str_right; 
								
				currentAST = __currentAST247;
				_t = __t247;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case INC:
			{
				AST __t248 = _t;
				in = _t==ASTNULL ? null :(AST)_t;
				AST in_AST_in = null;
				in_AST = astFactory.create(in);
				astFactory.addASTChild(currentAST, in_AST);
				ASTPair __currentAST248 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,INC);
				_t = _t.getFirstChild();
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = in.getText() + str_right; 
								
				currentAST = __currentAST248;
				_t = __t248;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case DEC:
			{
				AST __t249 = _t;
				de = _t==ASTNULL ? null :(AST)_t;
				AST de_AST_in = null;
				de_AST = astFactory.create(de);
				astFactory.addASTChild(currentAST, de_AST);
				ASTPair __currentAST249 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DEC);
				_t = _t.getFirstChild();
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = de.getText() + str_right; 
								
				currentAST = __currentAST249;
				_t = __t249;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case POST_INC:
			{
				AST __t250 = _t;
				poi = _t==ASTNULL ? null :(AST)_t;
				AST poi_AST_in = null;
				poi_AST = astFactory.create(poi);
				astFactory.addASTChild(currentAST, poi_AST);
				ASTPair __currentAST250 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,POST_INC);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + poi.getText(); 
								
				currentAST = __currentAST250;
				_t = __t250;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case POST_DEC:
			{
				AST __t251 = _t;
				pod = _t==ASTNULL ? null :(AST)_t;
				AST pod_AST_in = null;
				pod_AST = astFactory.create(pod);
				astFactory.addASTChild(currentAST, pod_AST);
				ASTPair __currentAST251 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,POST_DEC);
				_t = _t.getFirstChild();
				str_left=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									result = str_left + pod.getText(); 
								
				currentAST = __currentAST251;
				_t = __t251;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case BNOT:
			{
				AST __t252 = _t;
				bn = _t==ASTNULL ? null :(AST)_t;
				AST bn_AST_in = null;
				bn_AST = astFactory.create(bn);
				astFactory.addASTChild(currentAST, bn_AST);
				ASTPair __currentAST252 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BNOT);
				_t = _t.getFirstChild();
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST252;
				_t = __t252;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case LNOT:
			{
				AST __t253 = _t;
				lnot = _t==ASTNULL ? null :(AST)_t;
				AST lnot_AST_in = null;
				lnot_AST = astFactory.create(lnot);
				ASTPair __currentAST253 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LNOT);
				_t = _t.getFirstChild();
				lnot_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				lnot_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
					
									result = "( " + lnot.getText() + str_right + " )";
									conditionalExpr_AST = instrUnaryExpression(lnot_AST, lnot_right_AST, result);
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST253;
				_t = __t253;
				_t = _t.getNextSibling();
				break;
			}
			case LITERAL_instanceof:
			{
				AST __t254 = _t;
				io = _t==ASTNULL ? null :(AST)_t;
				AST io_AST_in = null;
				io_AST = astFactory.create(io);
				ASTPair __currentAST254 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_instanceof);
				_t = _t.getFirstChild();
				
									// disable logging since the expressions are not boolean	
									unsetLogging();
								
				io_left = _t==ASTNULL ? null : (AST)_t;
				str_left=expr(_t);
				_t = _retTree;
				io_left_AST = (AST)returnAST;
				io_right = _t==ASTNULL ? null : (AST)_t;
				str_right=expr(_t);
				_t = _retTree;
				io_right_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
						
									setLogging();
									result = "( " + str_left + " " + io.getText() + " " + str_right + " )";
									conditionalExpr_AST = instrBinaryExpression(io_AST, io_left_AST, io_right_AST, result, "a");
								
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				currentAST = __currentAST254;
				_t = __t254;
				_t = _t.getNextSibling();
				break;
			}
			case UNARY_MINUS:
			{
				AST __t255 = _t;
				um = _t==ASTNULL ? null :(AST)_t;
				AST um_AST_in = null;
				um_AST = astFactory.create(um);
				astFactory.addASTChild(currentAST, um_AST);
				ASTPair __currentAST255 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,UNARY_MINUS);
				_t = _t.getFirstChild();
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
								result = um.getText() + " " + str_right; 
							
				currentAST = __currentAST255;
				_t = __t255;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case UNARY_PLUS:
			{
				AST __t256 = _t;
				up = _t==ASTNULL ? null :(AST)_t;
				AST up_AST_in = null;
				up_AST = astFactory.create(up);
				astFactory.addASTChild(currentAST, up_AST);
				ASTPair __currentAST256 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,UNARY_PLUS);
				_t = _t.getFirstChild();
				str_right=expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
								result = str_left + " " + up.getText() + " " + str_right; 
							
				currentAST = __currentAST256;
				_t = __t256;
				_t = _t.getNextSibling();
				conditionalExpr_AST = (AST)currentAST.root;
				break;
			}
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case METHOD_CALL:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case LITERAL_super:
			case LITERAL_this:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				pe = _t==ASTNULL ? null : (AST)_t;
				result=primaryExpression(_t);
				_t = _retTree;
				pe_AST = (AST)returnAST;
				conditionalExpr_AST = (AST)currentAST.root;
				
								if ( checkBoolean(result) ) {
									conditionalExpr_AST = instrPrimaryExpression(conditionalExpr_AST, pe_AST, result); 
								} else {
									conditionalExpr_AST = (AST)astFactory.make( (new ASTArray(2)).add(conditionalExpr_AST).add(pe_AST));
								}
							
				currentAST.root = conditionalExpr_AST;
				currentAST.child = conditionalExpr_AST!=null &&conditionalExpr_AST.getFirstChild()!=null ?
					conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
				currentAST.advanceChildToEnd();
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = conditionalExpr_AST;
		_retTree = _t;
		return result;
	}
	
	public final void annotationMemberArrayInitializer(AST _t) throws RecognitionException {
		
		AST annotationMemberArrayInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberArrayInitializer_AST = null;
		
		try {      // for error handling
			AST __t74 = _t;
			AST tmp49_AST = null;
			AST tmp49_AST_in = null;
			tmp49_AST = astFactory.create((AST)_t);
			tmp49_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp49_AST);
			ASTPair __currentAST74 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ANNOTATION_ARRAY_INIT);
			_t = _t.getFirstChild();
			{
			_loop76:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_2.member(_t.getType()))) {
					annotationMemberArrayValueInitializer(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop76;
				}
				
			} while (true);
			}
			currentAST = __currentAST74;
			_t = __t74;
			_t = _t.getNextSibling();
			annotationMemberArrayInitializer_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotationMemberArrayInitializer_AST;
		_retTree = _t;
	}
	
	public final void annotationMemberArrayValueInitializer(AST _t) throws RecognitionException {
		
		AST annotationMemberArrayValueInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationMemberArrayValueInitializer_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				conditionalExpr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				annotationMemberArrayValueInitializer_AST = (AST)currentAST.root;
				break;
			}
			case ANNOTATION:
			{
				annotation(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				annotationMemberArrayValueInitializer_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotationMemberArrayValueInitializer_AST;
		_retTree = _t;
	}
	
	public final void methodDecl(AST _t) throws RecognitionException {
		
		AST methodDecl_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST methodDecl_AST = null;
		
		try {      // for error handling
			AST __t113 = _t;
			AST tmp50_AST = null;
			AST tmp50_AST_in = null;
			tmp50_AST = astFactory.create((AST)_t);
			tmp50_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp50_AST);
			ASTPair __currentAST113 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,METHOD_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				typeParameters(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case TYPE:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			typeSpec(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			methodHead(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST113;
			_t = __t113;
			_t = _t.getNextSibling();
			methodDecl_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = methodDecl_AST;
		_retTree = _t;
	}
	
	public final void variableDef(AST _t) throws RecognitionException {
		
		AST variableDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDef_AST = null;
		
		try {      // for error handling
			AST __t120 = _t;
			AST tmp51_AST = null;
			AST tmp51_AST_in = null;
			tmp51_AST = astFactory.create((AST)_t);
			tmp51_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp51_AST);
			ASTPair __currentAST120 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,VARIABLE_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			typeSpec(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			variableDeclarator(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			varInitializer(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST120;
			_t = __t120;
			_t = _t.getNextSibling();
			variableDef_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = variableDef_AST;
		_retTree = _t;
	}
	
	public final void ctorDef(AST _t) throws RecognitionException {
		
		AST ctorDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST ctorDef_AST = null;
		AST cd = null;
		AST cd_AST = null;
		AST mo_AST = null;
		AST mo = null;
		AST tp_AST = null;
		AST tp = null;
		AST mh_AST = null;
		AST mh = null;
		AST sl_AST = null;
		AST sl = null;
		
			String str_mh = "";
		
		
		try {      // for error handling
			AST __t109 = _t;
			cd = _t==ASTNULL ? null :(AST)_t;
			AST cd_AST_in = null;
			cd_AST = astFactory.create(cd);
			ASTPair __currentAST109 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,CTOR_DEF);
			_t = _t.getFirstChild();
			mo = _t==ASTNULL ? null : (AST)_t;
			modifiers(_t);
			_t = _retTree;
			mo_AST = (AST)returnAST;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				tp = _t==ASTNULL ? null : (AST)_t;
				typeParameters(_t);
				_t = _retTree;
				tp_AST = (AST)returnAST;
				break;
			}
			case IDENT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			mh = _t==ASTNULL ? null : (AST)_t;
			str_mh=methodHead(_t);
			_t = _retTree;
			mh_AST = (AST)returnAST;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case SLIST:
			{
				sl = _t==ASTNULL ? null : (AST)_t;
				slist(_t);
				_t = _retTree;
				sl_AST = (AST)returnAST;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			ctorDef_AST = (AST)currentAST.root;
			
								ctorDef_AST = instrMethod(cd_AST, mo_AST, tp_AST, mh_AST, sl_AST, null, str_mh, "o", ( isCtorCall ) ? "y" : "n" );
							
			currentAST.root = ctorDef_AST;
			currentAST.child = ctorDef_AST!=null &&ctorDef_AST.getFirstChild()!=null ?
				ctorDef_AST.getFirstChild() : ctorDef_AST;
			currentAST.advanceChildToEnd();
			currentAST = __currentAST109;
			_t = __t109;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = ctorDef_AST;
		_retTree = _t;
	}
	
	public final void methodDef(AST _t) throws RecognitionException {
		
		AST methodDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST methodDef_AST = null;
		AST md = null;
		AST md_AST = null;
		AST mo_AST = null;
		AST mo = null;
		AST tp_AST = null;
		AST tp = null;
		AST ts_AST = null;
		AST ts = null;
		AST mh_AST = null;
		AST mh = null;
		AST sl_AST = null;
		AST sl = null;
		
			String str_type = ""; // store type name and method name
			String str_mh = "";
		
		
		try {      // for error handling
			AST __t116 = _t;
			md = _t==ASTNULL ? null :(AST)_t;
			AST md_AST_in = null;
			md_AST = astFactory.create(md);
			ASTPair __currentAST116 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,METHOD_DEF);
			_t = _t.getFirstChild();
			mo = _t==ASTNULL ? null : (AST)_t;
			modifiers(_t);
			_t = _retTree;
			mo_AST = (AST)returnAST;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_PARAMETERS:
			{
				tp = _t==ASTNULL ? null : (AST)_t;
				typeParameters(_t);
				_t = _retTree;
				tp_AST = (AST)returnAST;
				break;
			}
			case TYPE:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			ts = _t==ASTNULL ? null : (AST)_t;
			str_type=typeSpec(_t);
			_t = _retTree;
			ts_AST = (AST)returnAST;
			mh = _t==ASTNULL ? null : (AST)_t;
			str_mh=methodHead(_t);
			_t = _retTree;
			mh_AST = (AST)returnAST;
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case SLIST:
			{
				sl = _t==ASTNULL ? null : (AST)_t;
				slist(_t);
				_t = _retTree;
				sl_AST = (AST)returnAST;
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			methodDef_AST = (AST)currentAST.root;
			
								methodDef_AST = instrMethod(md_AST, mo_AST, tp_AST, ts_AST, mh_AST, sl_AST, str_mh, "m", "n");
							
			currentAST.root = methodDef_AST;
			currentAST.child = methodDef_AST!=null &&methodDef_AST.getFirstChild()!=null ?
				methodDef_AST.getFirstChild() : methodDef_AST;
			currentAST.advanceChildToEnd();
			currentAST = __currentAST116;
			_t = __t116;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = methodDef_AST;
		_retTree = _t;
	}
	
	public final void slist(AST _t) throws RecognitionException {
		
		AST slist_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST slist_AST = null;
		
			isCtorCall = false;
		
		
		try {      // for error handling
			AST __t162 = _t;
			AST tmp52_AST = null;
			AST tmp52_AST_in = null;
			tmp52_AST = astFactory.create((AST)_t);
			tmp52_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp52_AST);
			ASTPair __currentAST162 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,SLIST);
			_t = _t.getFirstChild();
			{
			_loop164:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_3.member(_t.getType()))) {
					stat(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop164;
				}
				
			} while (true);
			}
			currentAST = __currentAST162;
			_t = __t162;
			_t = _t.getNextSibling();
			slist_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = slist_AST;
		_retTree = _t;
	}
	
	public final void annotationFieldDecl(AST _t) throws RecognitionException {
		
		AST annotationFieldDecl_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST annotationFieldDecl_AST = null;
		
		try {      // for error handling
			AST __t126 = _t;
			AST tmp53_AST = null;
			AST tmp53_AST_in = null;
			tmp53_AST = astFactory.create((AST)_t);
			tmp53_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp53_AST);
			ASTPair __currentAST126 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ANNOTATION_FIELD_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			typeSpec(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp54_AST = null;
			AST tmp54_AST_in = null;
			tmp54_AST = astFactory.create((AST)_t);
			tmp54_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp54_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case ANNOTATION:
			case ANNOTATION_ARRAY_INIT:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				annotationMemberValueInitializer(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST126;
			_t = __t126;
			_t = _t.getNextSibling();
			annotationFieldDecl_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = annotationFieldDecl_AST;
		_retTree = _t;
	}
	
	public final void enumConstantDef(AST _t) throws RecognitionException {
		
		AST enumConstantDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumConstantDef_AST = null;
		
		try {      // for error handling
			AST __t129 = _t;
			AST tmp55_AST = null;
			AST tmp55_AST_in = null;
			tmp55_AST = astFactory.create((AST)_t);
			tmp55_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp55_AST);
			ASTPair __currentAST129 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ENUM_CONSTANT_DEF);
			_t = _t.getFirstChild();
			annotations(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp56_AST = null;
			AST tmp56_AST_in = null;
			tmp56_AST = astFactory.create((AST)_t);
			tmp56_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp56_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ELIST:
			{
				elist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			case OBJBLOCK:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case OBJBLOCK:
			{
				enumConstantBlock(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST129;
			_t = __t129;
			_t = _t.getNextSibling();
			enumConstantDef_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = enumConstantDef_AST;
		_retTree = _t;
	}
	
	public final String  methodHead(AST _t) throws RecognitionException {
		String result = "";
		
		AST methodHead_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST methodHead_AST = null;
		AST id = null;
		AST id_AST = null;
		
			String str_pd = "";
			int i = 0;
		
		
		try {      // for error handling
			id = (AST)_t;
			AST id_AST_in = null;
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
							result = id.getText(); 
						
			AST __t148 = _t;
			AST tmp57_AST = null;
			AST tmp57_AST_in = null;
			tmp57_AST = astFactory.create((AST)_t);
			tmp57_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp57_AST);
			ASTPair __currentAST148 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,PARAMETERS);
			_t = _t.getFirstChild();
			
					 			result += " ( "; 
					 		
			{
			_loop150:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==PARAMETER_DEF)) {
						// to handle the trailing comma correctly
													if (i > 0) result += ", "; 
													i++;
												
					str_pd=parameterDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					
													result += str_pd;
												
				}
				else {
					break _loop150;
				}
				
			} while (true);
			}
			
					    		result += " ) ";
					    	
			currentAST = __currentAST148;
			_t = __t148;
			_t = _t.getNextSibling();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_throws:
			{
				throwsClause(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			case SLIST:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			methodHead_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = methodHead_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  variableDeclarator(AST _t) throws RecognitionException {
		String result = "";
		
		AST variableDeclarator_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableDeclarator_AST = null;
		AST id = null;
		AST id_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				astFactory.addASTChild(currentAST, id_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				
								result = id.getText(); 
							
				variableDeclarator_AST = (AST)currentAST.root;
				break;
			}
			case LBRACK:
			{
				AST tmp58_AST = null;
				AST tmp58_AST_in = null;
				tmp58_AST = astFactory.create((AST)_t);
				tmp58_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp58_AST);
				match(_t,LBRACK);
				_t = _t.getNextSibling();
				variableDeclarator(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				variableDeclarator_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = variableDeclarator_AST;
		_retTree = _t;
		return result;
	}
	
	public final void varInitializer(AST _t) throws RecognitionException {
		
		AST varInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST varInitializer_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ASSIGN:
			{
				AST __t141 = _t;
				AST tmp59_AST = null;
				AST tmp59_AST_in = null;
				tmp59_AST = astFactory.create((AST)_t);
				tmp59_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp59_AST);
				ASTPair __currentAST141 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,ASSIGN);
				_t = _t.getFirstChild();
				initializer(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST141;
				_t = __t141;
				_t = _t.getNextSibling();
				varInitializer_AST = (AST)currentAST.root;
				break;
			}
			case 3:
			{
				varInitializer_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = varInitializer_AST;
		_retTree = _t;
	}
	
	public final String  parameterDef(AST _t) throws RecognitionException {
		String result = "";
		
		AST parameterDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST parameterDef_AST = null;
		AST id = null;
		AST id_AST = null;
		
			String str_mo = "";
			String str_ts = "";
		
		
		try {      // for error handling
			AST __t122 = _t;
			AST tmp60_AST = null;
			AST tmp60_AST_in = null;
			tmp60_AST = astFactory.create((AST)_t);
			tmp60_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp60_AST);
			ASTPair __currentAST122 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,PARAMETER_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			str_ts=typeSpec(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			id = (AST)_t;
			AST id_AST_in = null;
			id_AST = astFactory.create(id);
			astFactory.addASTChild(currentAST, id_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
								result += str_ts + " " + id.getText();
							
			currentAST = __currentAST122;
			_t = __t122;
			_t = _t.getNextSibling();
			parameterDef_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = parameterDef_AST;
		_retTree = _t;
		return result;
	}
	
	public final void variableLengthParameterDef(AST _t) throws RecognitionException {
		
		AST variableLengthParameterDef_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST variableLengthParameterDef_AST = null;
		
		try {      // for error handling
			AST __t124 = _t;
			AST tmp61_AST = null;
			AST tmp61_AST_in = null;
			tmp61_AST = astFactory.create((AST)_t);
			tmp61_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp61_AST);
			ASTPair __currentAST124 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,VARIABLE_PARAMETER_DEF);
			_t = _t.getFirstChild();
			modifiers(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			typeSpec(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			AST tmp62_AST = null;
			AST tmp62_AST_in = null;
			tmp62_AST = astFactory.create((AST)_t);
			tmp62_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp62_AST);
			match(_t,IDENT);
			_t = _t.getNextSibling();
			currentAST = __currentAST124;
			_t = __t124;
			_t = _t.getNextSibling();
			variableLengthParameterDef_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = variableLengthParameterDef_AST;
		_retTree = _t;
	}
	
	public final String  elist(AST _t) throws RecognitionException {
		String result = "";
		
		AST elist_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST elist_AST = null;
		String str_expr = "";
		
		try {      // for error handling
			AST __t209 = _t;
			AST tmp63_AST = null;
			AST tmp63_AST_in = null;
			tmp63_AST = astFactory.create((AST)_t);
			tmp63_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp63_AST);
			ASTPair __currentAST209 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ELIST);
			_t = _t.getFirstChild();
			
								unsetLogging(); 
							
			{
			_loop211:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==EXPR)) {
					str_expr=expression(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					
											result += str_expr + ", ";
										
				}
				else {
					break _loop211;
				}
				
			} while (true);
			}
				
							if (result.length() > 2) // remove the trailing comma
								result = result.substring(0, result.length() - 2); 
							resetLogging();	
						
			currentAST = __currentAST209;
			_t = __t209;
			_t = _t.getNextSibling();
			elist_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = elist_AST;
		_retTree = _t;
		return result;
	}
	
	public final void enumConstantBlock(AST _t) throws RecognitionException {
		
		AST enumConstantBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST enumConstantBlock_AST = null;
		
		try {      // for error handling
			AST __t133 = _t;
			AST tmp64_AST = null;
			AST tmp64_AST_in = null;
			tmp64_AST = astFactory.create((AST)_t);
			tmp64_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp64_AST);
			ASTPair __currentAST133 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,OBJBLOCK);
			_t = _t.getFirstChild();
			{
			_loop136:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case METHOD_DEF:
				{
					methodDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case VARIABLE_DEF:
				{
					variableDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case CLASS_DEF:
				case INTERFACE_DEF:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				{
					typeDefinition(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case INSTANCE_INIT:
				{
					AST __t135 = _t;
					AST tmp65_AST = null;
					AST tmp65_AST_in = null;
					tmp65_AST = astFactory.create((AST)_t);
					tmp65_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp65_AST);
					ASTPair __currentAST135 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,INSTANCE_INIT);
					_t = _t.getFirstChild();
					slist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST135;
					_t = __t135;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					break _loop136;
				}
				}
			} while (true);
			}
			currentAST = __currentAST133;
			_t = __t133;
			_t = _t.getNextSibling();
			enumConstantBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = enumConstantBlock_AST;
		_retTree = _t;
	}
	
	public final void objectinitializer(AST _t) throws RecognitionException {
		
		AST objectinitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST objectinitializer_AST = null;
		
		try {      // for error handling
			AST __t138 = _t;
			AST tmp66_AST = null;
			AST tmp66_AST_in = null;
			tmp66_AST = astFactory.create((AST)_t);
			tmp66_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp66_AST);
			ASTPair __currentAST138 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,INSTANCE_INIT);
			_t = _t.getFirstChild();
			slist(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST138;
			_t = __t138;
			_t = _t.getNextSibling();
			objectinitializer_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = objectinitializer_AST;
		_retTree = _t;
	}
	
	public final void initializer(AST _t) throws RecognitionException {
		
		AST initializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST initializer_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EXPR:
			{
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				initializer_AST = (AST)currentAST.root;
				break;
			}
			case ARRAY_INIT:
			{
				arrayInitializer(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				initializer_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = initializer_AST;
		_retTree = _t;
	}
	
	public final String  expression(AST _t) throws RecognitionException {
		String result = "";
		
		AST expression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expression_AST = null;
		AST exp1 = null;
		AST exp1_AST = null;
		AST exp2_AST = null;
		AST exp2 = null;
		
		try {      // for error handling
			AST __t213 = _t;
			exp1 = _t==ASTNULL ? null :(AST)_t;
			AST exp1_AST_in = null;
			exp1_AST = astFactory.create(exp1);
			ASTPair __currentAST213 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,EXPR);
			_t = _t.getFirstChild();
			exp2 = _t==ASTNULL ? null : (AST)_t;
			result=expr(_t);
			_t = _retTree;
			exp2_AST = (AST)returnAST;
			expression_AST = (AST)currentAST.root;
				
								// overall boolean expressions are descition expressions 
								expression_AST = instrDecitionExpression(exp1_AST, exp2_AST, result); 
							
			currentAST.root = expression_AST;
			currentAST.child = expression_AST!=null &&expression_AST.getFirstChild()!=null ?
				expression_AST.getFirstChild() : expression_AST;
			currentAST.advanceChildToEnd();
			currentAST = __currentAST213;
			_t = __t213;
			_t = _t.getNextSibling();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = expression_AST;
		_retTree = _t;
		return result;
	}
	
	public final void arrayInitializer(AST _t) throws RecognitionException {
		
		AST arrayInitializer_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arrayInitializer_AST = null;
		
		try {      // for error handling
			AST __t144 = _t;
			AST tmp67_AST = null;
			AST tmp67_AST_in = null;
			tmp67_AST = astFactory.create((AST)_t);
			tmp67_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp67_AST);
			ASTPair __currentAST144 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ARRAY_INIT);
			_t = _t.getFirstChild();
			{
			_loop146:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==EXPR||_t.getType()==ARRAY_INIT)) {
					initializer(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop146;
				}
				
			} while (true);
			}
			currentAST = __currentAST144;
			_t = __t144;
			_t = _t.getNextSibling();
			arrayInitializer_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = arrayInitializer_AST;
		_retTree = _t;
	}
	
	public final void throwsClause(AST _t) throws RecognitionException {
		
		AST throwsClause_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST throwsClause_AST = null;
		
		try {      // for error handling
			AST __t153 = _t;
			AST tmp68_AST = null;
			AST tmp68_AST_in = null;
			tmp68_AST = astFactory.create((AST)_t);
			tmp68_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp68_AST);
			ASTPair __currentAST153 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,LITERAL_throws);
			_t = _t.getFirstChild();
			{
			_loop155:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==IDENT||_t.getType()==DOT)) {
					classOrInterfaceType(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop155;
				}
				
			} while (true);
			}
			currentAST = __currentAST153;
			_t = __t153;
			_t = _t.getNextSibling();
			throwsClause_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = throwsClause_AST;
		_retTree = _t;
	}
	
	public final void stat(AST _t) throws RecognitionException {
		
		AST stat_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST stat_AST = null;
		
			String str_exp = ""; 
		
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CLASS_DEF:
			case INTERFACE_DEF:
			case ENUM_DEF:
			case ANNOTATION_DEF:
			{
				typeDefinition(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat_AST = (AST)currentAST.root;
				break;
			}
			case VARIABLE_DEF:
			{
				variableDef(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat_AST = (AST)currentAST.root;
				break;
			}
			case EXPR:
			{
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LABELED_STAT:
			{
				AST __t166 = _t;
				AST tmp69_AST = null;
				AST tmp69_AST_in = null;
				tmp69_AST = astFactory.create((AST)_t);
				tmp69_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp69_AST);
				ASTPair __currentAST166 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LABELED_STAT);
				_t = _t.getFirstChild();
				AST tmp70_AST = null;
				AST tmp70_AST_in = null;
				tmp70_AST = astFactory.create((AST)_t);
				tmp70_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp70_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST166;
				_t = __t166;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_if:
			{
				AST __t167 = _t;
				AST tmp71_AST = null;
				AST tmp71_AST_in = null;
				tmp71_AST = astFactory.create((AST)_t);
				tmp71_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp71_AST);
				ASTPair __currentAST167 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_if);
				_t = _t.getFirstChild();
					// set loging since expressions are boolean
									setLogging(); 
								
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									unsetLogging();
								
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									unsetLogging();
								
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case SLIST:
				case VARIABLE_DEF:
				case CLASS_DEF:
				case INTERFACE_DEF:
				case LABELED_STAT:
				case EXPR:
				case EMPTY_STAT:
				case ENUM_DEF:
				case ANNOTATION_DEF:
				case LITERAL_synchronized:
				case LITERAL_if:
				case LITERAL_while:
				case LITERAL_do:
				case LITERAL_break:
				case LITERAL_continue:
				case LITERAL_return:
				case LITERAL_switch:
				case LITERAL_throw:
				case LITERAL_assert:
				case LITERAL_for:
				case LITERAL_try:
				{
					stat(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST167;
				_t = __t167;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_for:
			{
				AST __t169 = _t;
				AST tmp72_AST = null;
				AST tmp72_AST_in = null;
				tmp72_AST = astFactory.create((AST)_t);
				tmp72_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp72_AST);
				ASTPair __currentAST169 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_for);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case FOR_INIT:
				{
					AST __t171 = _t;
					AST tmp73_AST = null;
					AST tmp73_AST_in = null;
					tmp73_AST = astFactory.create((AST)_t);
					tmp73_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp73_AST);
					ASTPair __currentAST171 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,FOR_INIT);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case VARIABLE_DEF:
					{
						{
						int _cnt174=0;
						_loop174:
						do {
							if (_t==null) _t=ASTNULL;
							if ((_t.getType()==VARIABLE_DEF)) {
								variableDef(_t);
								_t = _retTree;
								astFactory.addASTChild(currentAST, returnAST);
							}
							else {
								if ( _cnt174>=1 ) { break _loop174; } else {throw new NoViableAltException(_t);}
							}
							
							_cnt174++;
						} while (true);
						}
						break;
					}
					case ELIST:
					{
						elist(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					currentAST = __currentAST171;
					_t = __t171;
					_t = _t.getNextSibling();
					AST __t175 = _t;
					AST tmp74_AST = null;
					AST tmp74_AST_in = null;
					tmp74_AST = astFactory.create((AST)_t);
					tmp74_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp74_AST);
					ASTPair __currentAST175 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,FOR_CONDITION);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case EXPR:
					{
							
													// set loging since expressions are boolean
													setLogging(); 
												
						expression(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					
											unsetLogging(); 
										
					currentAST = __currentAST175;
					_t = __t175;
					_t = _t.getNextSibling();
					AST __t177 = _t;
					AST tmp75_AST = null;
					AST tmp75_AST_in = null;
					tmp75_AST = astFactory.create((AST)_t);
					tmp75_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp75_AST);
					ASTPair __currentAST177 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,FOR_ITERATOR);
					_t = _t.getFirstChild();
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case ELIST:
					{
						elist(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					currentAST = __currentAST177;
					_t = __t177;
					_t = _t.getNextSibling();
					break;
				}
				case FOR_EACH_CLAUSE:
				{
					AST __t179 = _t;
					AST tmp76_AST = null;
					AST tmp76_AST_in = null;
					tmp76_AST = astFactory.create((AST)_t);
					tmp76_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp76_AST);
					ASTPair __currentAST179 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,FOR_EACH_CLAUSE);
					_t = _t.getFirstChild();
					parameterDef(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					expression(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST179;
					_t = __t179;
					_t = _t.getNextSibling();
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST169;
				_t = __t169;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_while:
			{
				AST __t180 = _t;
				AST tmp77_AST = null;
				AST tmp77_AST_in = null;
				tmp77_AST = astFactory.create((AST)_t);
				tmp77_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp77_AST);
				ASTPair __currentAST180 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_while);
				_t = _t.getFirstChild();
					// set loging since expressions are boolean
									setLogging(); 
								
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
					// set loging since expressions are boolean 
									unsetLogging(); 
								
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST180;
				_t = __t180;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_do:
			{
				AST __t181 = _t;
				AST tmp78_AST = null;
				AST tmp78_AST_in = null;
				tmp78_AST = astFactory.create((AST)_t);
				tmp78_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp78_AST);
				ASTPair __currentAST181 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_do);
				_t = _t.getFirstChild();
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
					// set loging since expressions are boolean
									setLogging(); 
								
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST181;
				_t = __t181;
				_t = _t.getNextSibling();
				
									unsetLogging();
								
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_break:
			{
				AST __t182 = _t;
				AST tmp79_AST = null;
				AST tmp79_AST_in = null;
				tmp79_AST = astFactory.create((AST)_t);
				tmp79_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp79_AST);
				ASTPair __currentAST182 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_break);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IDENT:
				{
					AST tmp80_AST = null;
					AST tmp80_AST_in = null;
					tmp80_AST = astFactory.create((AST)_t);
					tmp80_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp80_AST);
					match(_t,IDENT);
					_t = _t.getNextSibling();
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST182;
				_t = __t182;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_continue:
			{
				AST __t184 = _t;
				AST tmp81_AST = null;
				AST tmp81_AST_in = null;
				tmp81_AST = astFactory.create((AST)_t);
				tmp81_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp81_AST);
				ASTPair __currentAST184 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_continue);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case IDENT:
				{
					AST tmp82_AST = null;
					AST tmp82_AST_in = null;
					tmp82_AST = astFactory.create((AST)_t);
					tmp82_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp82_AST);
					match(_t,IDENT);
					_t = _t.getNextSibling();
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST184;
				_t = __t184;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_return:
			{
				AST __t186 = _t;
				AST tmp83_AST = null;
				AST tmp83_AST_in = null;
				tmp83_AST = astFactory.create((AST)_t);
				tmp83_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp83_AST);
				ASTPair __currentAST186 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_return);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case EXPR:
				{
					expression(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST186;
				_t = __t186;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_switch:
			{
				AST __t188 = _t;
				AST tmp84_AST = null;
				AST tmp84_AST_in = null;
				tmp84_AST = astFactory.create((AST)_t);
				tmp84_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp84_AST);
				ASTPair __currentAST188 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_switch);
				_t = _t.getFirstChild();
				
									symbolCount++;
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
								
				str_exp=expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,str_exp))));
									astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"w"))));
								
				{
				_loop190:
				do {
					if (_t==null) _t=ASTNULL;
					if ((_t.getType()==CASE_GROUP)) {
						caseGroup(_t,str_exp);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop190;
					}
					
				} while (true);
				}
				currentAST = __currentAST188;
				_t = __t188;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_throw:
			{
				AST __t191 = _t;
				AST tmp85_AST = null;
				AST tmp85_AST_in = null;
				tmp85_AST = astFactory.create((AST)_t);
				tmp85_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp85_AST);
				ASTPair __currentAST191 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_throw);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST191;
				_t = __t191;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_synchronized:
			{
				AST __t192 = _t;
				AST tmp86_AST = null;
				AST tmp86_AST_in = null;
				tmp86_AST = astFactory.create((AST)_t);
				tmp86_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp86_AST);
				ASTPair __currentAST192 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_synchronized);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST192;
				_t = __t192;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_try:
			{
				tryBlock(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat_AST = (AST)currentAST.root;
				break;
			}
			case SLIST:
			{
				slist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				stat_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_assert:
			{
				AST __t193 = _t;
				AST tmp87_AST = null;
				AST tmp87_AST_in = null;
				tmp87_AST = astFactory.create((AST)_t);
				tmp87_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp87_AST);
				ASTPair __currentAST193 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_assert);
				_t = _t.getFirstChild();
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case EXPR:
				{
					expression(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST193;
				_t = __t193;
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			case EMPTY_STAT:
			{
				AST tmp88_AST = null;
				AST tmp88_AST_in = null;
				tmp88_AST = astFactory.create((AST)_t);
				tmp88_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp88_AST);
				match(_t,EMPTY_STAT);
				_t = _t.getNextSibling();
				stat_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = stat_AST;
		_retTree = _t;
	}
	
	public final void caseGroup(AST _t,
		String s
	) throws RecognitionException {
		
		AST caseGroup_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST caseGroup_AST = null;
		AST cg = null;
		AST cg_AST = null;
		AST ca = null;
		AST ca_AST = null;
		AST exp_AST = null;
		AST exp = null;
		AST de = null;
		AST de_AST = null;
		AST sl_AST = null;
		AST sl = null;
			
			String str_exp = ""; 
			String t = "";
		
		
		try {      // for error handling
			AST __t196 = _t;
			cg = _t==ASTNULL ? null :(AST)_t;
			AST cg_AST_in = null;
			cg_AST = astFactory.create(cg);
			astFactory.addASTChild(currentAST, cg_AST);
			ASTPair __currentAST196 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,CASE_GROUP);
			_t = _t.getFirstChild();
			{
			int _cnt199=0;
			_loop199:
			do {
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case LITERAL_case:
				{
					AST __t198 = _t;
					ca = _t==ASTNULL ? null :(AST)_t;
					AST ca_AST_in = null;
					ca_AST = astFactory.create(ca);
					astFactory.addASTChild(currentAST, ca_AST);
					ASTPair __currentAST198 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,LITERAL_case);
					_t = _t.getFirstChild();
					exp = _t==ASTNULL ? null : (AST)_t;
					t=expression(_t);
					_t = _retTree;
					exp_AST = (AST)returnAST;
					astFactory.addASTChild(currentAST, returnAST);
					
												str_exp += "case: " + t + " ";
											
					currentAST = __currentAST198;
					_t = __t198;
					_t = _t.getNextSibling();
					break;
				}
				case LITERAL_default:
				{
					de = (AST)_t;
					AST de_AST_in = null;
					de_AST = astFactory.create(de);
					astFactory.addASTChild(currentAST, de_AST);
					match(_t,LITERAL_default);
					_t = _t.getNextSibling();
					
												str_exp = "case default";
											
					break;
				}
				default:
				{
					if ( _cnt199>=1 ) { break _loop199; } else {throw new NoViableAltException(_t);}
				}
				}
				_cnt199++;
			} while (true);
			}
			
								// instrumentating case group
								symbolCount++;
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,str_exp))));
								astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"s"))));
							
			sl = _t==ASTNULL ? null : (AST)_t;
			slist(_t);
			_t = _retTree;
			sl_AST = (AST)returnAST;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST196;
			_t = __t196;
			_t = _t.getNextSibling();
			caseGroup_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = caseGroup_AST;
		_retTree = _t;
	}
	
	public final void tryBlock(AST _t) throws RecognitionException {
		
		AST tryBlock_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST tryBlock_AST = null;
		
		try {      // for error handling
			AST __t201 = _t;
			AST tmp89_AST = null;
			AST tmp89_AST_in = null;
			tmp89_AST = astFactory.create((AST)_t);
			tmp89_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp89_AST);
			ASTPair __currentAST201 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,LITERAL_try);
			_t = _t.getFirstChild();
			slist(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop203:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_t.getType()==LITERAL_catch)) {
					handler(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop203;
				}
				
			} while (true);
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case LITERAL_finally:
			{
				AST __t205 = _t;
				AST tmp90_AST = null;
				AST tmp90_AST_in = null;
				tmp90_AST = astFactory.create((AST)_t);
				tmp90_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp90_AST);
				ASTPair __currentAST205 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,LITERAL_finally);
				_t = _t.getFirstChild();
				slist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST205;
				_t = __t205;
				_t = _t.getNextSibling();
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST201;
			_t = __t201;
			_t = _t.getNextSibling();
			tryBlock_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = tryBlock_AST;
		_retTree = _t;
	}
	
	public final void handler(AST _t) throws RecognitionException {
		
		AST handler_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST handler_AST = null;
		
		try {      // for error handling
			AST __t207 = _t;
			AST tmp91_AST = null;
			AST tmp91_AST_in = null;
			tmp91_AST = astFactory.create((AST)_t);
			tmp91_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp91_AST);
			ASTPair __currentAST207 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,LITERAL_catch);
			_t = _t.getFirstChild();
			parameterDef(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			slist(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			currentAST = __currentAST207;
			_t = __t207;
			_t = _t.getNextSibling();
			handler_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = handler_AST;
		_retTree = _t;
	}
	
	public final String  expr(AST _t) throws RecognitionException {
		String result = "";
		
		AST expr_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expr_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE:
			case TYPECAST:
			case INDEX_OP:
			case POST_INC:
			case POST_DEC:
			case METHOD_CALL:
			case UNARY_MINUS:
			case UNARY_PLUS:
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			case IDENT:
			case DOT:
			case QUESTION:
			case LITERAL_super:
			case LT:
			case GT:
			case SR:
			case BSR:
			case STAR:
			case BAND:
			case LITERAL_this:
			case LOR:
			case LAND:
			case BOR:
			case BXOR:
			case NOT_EQUAL:
			case EQUAL:
			case LE:
			case GE:
			case LITERAL_instanceof:
			case SL:
			case PLUS:
			case MINUS:
			case DIV:
			case MOD:
			case INC:
			case DEC:
			case BNOT:
			case LNOT:
			case LITERAL_true:
			case LITERAL_false:
			case LITERAL_null:
			case LITERAL_new:
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				result=conditionalExpr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr_AST = (AST)currentAST.root;
				break;
			}
			case ASSIGN:
			{
				AST __t215 = _t;
				AST tmp92_AST = null;
				AST tmp92_AST_in = null;
				tmp92_AST = astFactory.create((AST)_t);
				tmp92_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp92_AST);
				ASTPair __currentAST215 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									unsetLogging(); 
								
				currentAST = __currentAST215;
				_t = __t215;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case PLUS_ASSIGN:
			{
				AST __t216 = _t;
				AST tmp93_AST = null;
				AST tmp93_AST_in = null;
				tmp93_AST = astFactory.create((AST)_t);
				tmp93_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp93_AST);
				ASTPair __currentAST216 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,PLUS_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST216;
				_t = __t216;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case MINUS_ASSIGN:
			{
				AST __t217 = _t;
				AST tmp94_AST = null;
				AST tmp94_AST_in = null;
				tmp94_AST = astFactory.create((AST)_t);
				tmp94_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp94_AST);
				ASTPair __currentAST217 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,MINUS_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST217;
				_t = __t217;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case STAR_ASSIGN:
			{
				AST __t218 = _t;
				AST tmp95_AST = null;
				AST tmp95_AST_in = null;
				tmp95_AST = astFactory.create((AST)_t);
				tmp95_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp95_AST);
				ASTPair __currentAST218 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,STAR_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST218;
				_t = __t218;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case DIV_ASSIGN:
			{
				AST __t219 = _t;
				AST tmp96_AST = null;
				AST tmp96_AST_in = null;
				tmp96_AST = astFactory.create((AST)_t);
				tmp96_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp96_AST);
				ASTPair __currentAST219 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DIV_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging();
								
				currentAST = __currentAST219;
				_t = __t219;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case MOD_ASSIGN:
			{
				AST __t220 = _t;
				AST tmp97_AST = null;
				AST tmp97_AST_in = null;
				tmp97_AST = astFactory.create((AST)_t);
				tmp97_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp97_AST);
				ASTPair __currentAST220 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,MOD_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST220;
				_t = __t220;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case SR_ASSIGN:
			{
				AST __t221 = _t;
				AST tmp98_AST = null;
				AST tmp98_AST_in = null;
				tmp98_AST = astFactory.create((AST)_t);
				tmp98_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp98_AST);
				ASTPair __currentAST221 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,SR_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST221;
				_t = __t221;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case BSR_ASSIGN:
			{
				AST __t222 = _t;
				AST tmp99_AST = null;
				AST tmp99_AST_in = null;
				tmp99_AST = astFactory.create((AST)_t);
				tmp99_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp99_AST);
				ASTPair __currentAST222 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BSR_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST222;
				_t = __t222;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case SL_ASSIGN:
			{
				AST __t223 = _t;
				AST tmp100_AST = null;
				AST tmp100_AST_in = null;
				tmp100_AST = astFactory.create((AST)_t);
				tmp100_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp100_AST);
				ASTPair __currentAST223 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,SL_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST223;
				_t = __t223;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case BAND_ASSIGN:
			{
				AST __t224 = _t;
				AST tmp101_AST = null;
				AST tmp101_AST_in = null;
				tmp101_AST = astFactory.create((AST)_t);
				tmp101_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp101_AST);
				ASTPair __currentAST224 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BAND_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST224;
				_t = __t224;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case BXOR_ASSIGN:
			{
				AST __t225 = _t;
				AST tmp102_AST = null;
				AST tmp102_AST_in = null;
				tmp102_AST = astFactory.create((AST)_t);
				tmp102_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp102_AST);
				ASTPair __currentAST225 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BXOR_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST225;
				_t = __t225;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			case BOR_ASSIGN:
			{
				AST __t226 = _t;
				AST tmp103_AST = null;
				AST tmp103_AST_in = null;
				tmp103_AST = astFactory.create((AST)_t);
				tmp103_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp103_AST);
				ASTPair __currentAST226 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,BOR_ASSIGN);
				_t = _t.getFirstChild();
					
									// disable logging since the expressions are not boolean	
									unsetLogging(); 
								
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									resetLogging(); 
								
				currentAST = __currentAST226;
				_t = __t226;
				_t = _t.getNextSibling();
				expr_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = expr_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  primaryExpression(AST _t) throws RecognitionException {
		String result = "";
		
		AST primaryExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST primaryExpression_AST = null;
		AST id = null;
		AST id_AST = null;
		AST dot = null;
		AST dot_AST = null;
		AST id2 = null;
		AST id2_AST = null;
		AST su = null;
		AST su_AST = null;
		AST tr = null;
		AST tr_AST = null;
		AST fa = null;
		AST fa_AST = null;
		AST th = null;
		AST th_AST = null;
		AST nu = null;
		AST nu_AST = null;
			String str_expr = ""; 
				String str_pe = "";
				String str_ta = "";
				String str_elist = "";
			
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case IDENT:
			{
				id = (AST)_t;
				AST id_AST_in = null;
				id_AST = astFactory.create(id);
				astFactory.addASTChild(currentAST, id_AST);
				match(_t,IDENT);
				_t = _t.getNextSibling();
					
								result = id.getText(); 
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case DOT:
			{
				AST __t258 = _t;
				dot = _t==ASTNULL ? null :(AST)_t;
				AST dot_AST_in = null;
				dot_AST = astFactory.create(dot);
				astFactory.addASTChild(currentAST, dot_AST);
				ASTPair __currentAST258 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,DOT);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE:
				case TYPECAST:
				case INDEX_OP:
				case POST_INC:
				case POST_DEC:
				case METHOD_CALL:
				case UNARY_MINUS:
				case UNARY_PLUS:
				case SUPER_CTOR_CALL:
				case CTOR_CALL:
				case IDENT:
				case DOT:
				case QUESTION:
				case LITERAL_super:
				case LT:
				case GT:
				case SR:
				case BSR:
				case STAR:
				case ASSIGN:
				case BAND:
				case LITERAL_this:
				case PLUS_ASSIGN:
				case MINUS_ASSIGN:
				case STAR_ASSIGN:
				case DIV_ASSIGN:
				case MOD_ASSIGN:
				case SR_ASSIGN:
				case BSR_ASSIGN:
				case SL_ASSIGN:
				case BAND_ASSIGN:
				case BXOR_ASSIGN:
				case BOR_ASSIGN:
				case LOR:
				case LAND:
				case BOR:
				case BXOR:
				case NOT_EQUAL:
				case EQUAL:
				case LE:
				case GE:
				case LITERAL_instanceof:
				case SL:
				case PLUS:
				case MINUS:
				case DIV:
				case MOD:
				case INC:
				case DEC:
				case BNOT:
				case LNOT:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				{
					str_expr=expr(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case IDENT:
					{
						id2 = (AST)_t;
						AST id2_AST_in = null;
						id2_AST = astFactory.create(id2);
						astFactory.addASTChild(currentAST, id2_AST);
						match(_t,IDENT);
						_t = _t.getNextSibling();
						
													result = str_expr + dot.getText() + id2.getText();
												
						break;
					}
					case INDEX_OP:
					{
						
													unsetLogging(); // disable logging since we don't want the arrayIndex
												
						result=arrayIndex(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
						
													resetLogging(); 
												
						break;
					}
					case LITERAL_this:
					{
						AST tmp104_AST = null;
						AST tmp104_AST_in = null;
						tmp104_AST = astFactory.create((AST)_t);
						tmp104_AST_in = (AST)_t;
						astFactory.addASTChild(currentAST, tmp104_AST);
						match(_t,LITERAL_this);
						_t = _t.getNextSibling();
						break;
					}
					case LITERAL_class:
					{
						AST tmp105_AST = null;
						AST tmp105_AST_in = null;
						tmp105_AST = astFactory.create((AST)_t);
						tmp105_AST_in = (AST)_t;
						astFactory.addASTChild(currentAST, tmp105_AST);
						match(_t,LITERAL_class);
						_t = _t.getNextSibling();
						break;
					}
					case LITERAL_new:
					{
						newExpression(_t);
						_t = _retTree;
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case LITERAL_super:
					{
						AST tmp106_AST = null;
						AST tmp106_AST_in = null;
						tmp106_AST = astFactory.create((AST)_t);
						tmp106_AST_in = (AST)_t;
						astFactory.addASTChild(currentAST, tmp106_AST);
						match(_t,LITERAL_super);
						_t = _t.getNextSibling();
						break;
					}
					case 3:
					case TYPE_ARGUMENTS:
					{
						{
						if (_t==null) _t=ASTNULL;
						switch ( _t.getType()) {
						case TYPE_ARGUMENTS:
						{
							typeArguments(_t);
							_t = _retTree;
							astFactory.addASTChild(currentAST, returnAST);
							break;
						}
						case 3:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(_t);
						}
						}
						}
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					break;
				}
				case ARRAY_DECLARATOR:
				{
					AST __t262 = _t;
					AST tmp107_AST = null;
					AST tmp107_AST_in = null;
					tmp107_AST = astFactory.create((AST)_t);
					tmp107_AST_in = (AST)_t;
					astFactory.addASTChild(currentAST, tmp107_AST);
					ASTPair __currentAST262 = currentAST.copy();
					currentAST.root = currentAST.child;
					currentAST.child = null;
					match(_t,ARRAY_DECLARATOR);
					_t = _t.getFirstChild();
					typeSpecArray(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					currentAST = __currentAST262;
					_t = __t262;
					_t = _t.getNextSibling();
					break;
				}
				case LITERAL_void:
				case LITERAL_boolean:
				case LITERAL_byte:
				case LITERAL_char:
				case LITERAL_short:
				case LITERAL_int:
				case LITERAL_float:
				case LITERAL_long:
				case LITERAL_double:
				{
					builtInType(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case LITERAL_class:
					{
						AST tmp108_AST = null;
						AST tmp108_AST_in = null;
						tmp108_AST = astFactory.create((AST)_t);
						tmp108_AST_in = (AST)_t;
						astFactory.addASTChild(currentAST, tmp108_AST);
						match(_t,LITERAL_class);
						_t = _t.getNextSibling();
						break;
					}
					case 3:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST258;
				_t = __t258;
				_t = _t.getNextSibling();
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case INDEX_OP:
			{
				
								unsetLogging();  // disable logging since we don't want the arrayIndex
							
				result=arrayIndex(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
								resetLogging(); 
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case METHOD_CALL:
			{
				AST __t264 = _t;
				AST tmp109_AST = null;
				AST tmp109_AST_in = null;
				tmp109_AST = astFactory.create((AST)_t);
				tmp109_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp109_AST);
				ASTPair __currentAST264 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,METHOD_CALL);
				_t = _t.getFirstChild();
				str_pe=primaryExpression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case TYPE_ARGUMENTS:
				{
					str_ta=typeArguments(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case ELIST:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				str_elist=elist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
									int p = str_pe.indexOf ( "." );
									String t = null;
									String q;
				
									if ( p > 0 ) {
										q = str_pe.substring( 0, p );
										t = getType( q );
									} else {
										q = str_pe;
										t = getType( q );
									}
									
									System.out.println("getType(): q " + q + ":" + t );
				
										if ( t != null ) { 
											Vector v = getClasses ( t );
					
											System.out.println( v );
					
											if ( v != null && v.size() > 0 ) {
												symbolCount++;
												astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
												astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,q))));
												astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"v"))));
					
												for ( int i = 0; i < v.size(); i++ ) {							
													symbolCount++;
													ExtendedClass e = ( ExtendedClass ) v.get( i );
										
													astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,String.valueOf(symbolCount)))));
													astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,e.getThisClass().getName()))));
													astFactory.addASTChild(currentAST, (AST)astFactory.make( (new ASTArray(1)).add(astFactory.create(IDENT,"i"))));
												}
											}
															
										// System.out.println( s + ":" + t + ":" + getSubClasses ( t ) );
										}
									
									result = str_pe + "(" + str_elist + ")"; 
								
				currentAST = __currentAST264;
				_t = __t264;
				_t = _t.getNextSibling();
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case SUPER_CTOR_CALL:
			case CTOR_CALL:
			{
				ctorCall(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				
								isCtorCall = true;
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case TYPECAST:
			{
				AST __t266 = _t;
				AST tmp110_AST = null;
				AST tmp110_AST_in = null;
				tmp110_AST = astFactory.create((AST)_t);
				tmp110_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp110_AST);
				ASTPair __currentAST266 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,TYPECAST);
				_t = _t.getFirstChild();
				typeSpec(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				expr(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST266;
				_t = __t266;
				_t = _t.getNextSibling();
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_new:
			{
				newExpression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case NUM_INT:
			case CHAR_LITERAL:
			case STRING_LITERAL:
			case NUM_FLOAT:
			case NUM_LONG:
			case NUM_DOUBLE:
			{
				result=constant(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_super:
			{
				su = (AST)_t;
				AST su_AST_in = null;
				su_AST = astFactory.create(su);
				astFactory.addASTChild(currentAST, su_AST);
				match(_t,LITERAL_super);
				_t = _t.getNextSibling();
				
								result = su.getText();
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_true:
			{
				tr = (AST)_t;
				AST tr_AST_in = null;
				tr_AST = astFactory.create(tr);
				astFactory.addASTChild(currentAST, tr_AST);
				match(_t,LITERAL_true);
				_t = _t.getNextSibling();
					
								result = tr.getText();
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_false:
			{
				fa = (AST)_t;
				AST fa_AST_in = null;
				fa_AST = astFactory.create(fa);
				astFactory.addASTChild(currentAST, fa_AST);
				match(_t,LITERAL_false);
				_t = _t.getNextSibling();
					
								result = fa.getText();
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_this:
			{
				th = (AST)_t;
				AST th_AST_in = null;
				th_AST = astFactory.create(th);
				astFactory.addASTChild(currentAST, th_AST);
				match(_t,LITERAL_this);
				_t = _t.getNextSibling();
				
								result = th.getText();
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_null:
			{
				nu = (AST)_t;
				AST nu_AST_in = null;
				nu_AST = astFactory.create(nu);
				astFactory.addASTChild(currentAST, nu_AST);
				match(_t,LITERAL_null);
				_t = _t.getNextSibling();
				
								result = nu.getText();
							
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			case TYPE:
			{
				typeSpec(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				primaryExpression_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = primaryExpression_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  arrayIndex(AST _t) throws RecognitionException {
		String result = "";
		
		AST arrayIndex_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arrayIndex_AST = null;
		
			String str_exp1 = ""; 
			String str_exp2 = "";
		
		
		try {      // for error handling
			AST __t272 = _t;
			AST tmp111_AST = null;
			AST tmp111_AST_in = null;
			tmp111_AST = astFactory.create((AST)_t);
			tmp111_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp111_AST);
			ASTPair __currentAST272 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,INDEX_OP);
			_t = _t.getFirstChild();
			str_exp1=expr(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			str_exp2=expression(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			
							result = str_exp1 + "[" + str_exp2 + "]"; 
						
			currentAST = __currentAST272;
			_t = __t272;
			_t = _t.getNextSibling();
			arrayIndex_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = arrayIndex_AST;
		_retTree = _t;
		return result;
	}
	
	public final String  newExpression(AST _t) throws RecognitionException {
		String result = "";
		
		AST newExpression_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST newExpression_AST = null;
		
		try {      // for error handling
			AST __t275 = _t;
			AST tmp112_AST = null;
			AST tmp112_AST_in = null;
			tmp112_AST = astFactory.create((AST)_t);
			tmp112_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp112_AST);
			ASTPair __currentAST275 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,LITERAL_new);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case TYPE_ARGUMENTS:
			{
				typeArguments(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case IDENT:
			case DOT:
			case LITERAL_void:
			case LITERAL_boolean:
			case LITERAL_byte:
			case LITERAL_char:
			case LITERAL_short:
			case LITERAL_int:
			case LITERAL_float:
			case LITERAL_long:
			case LITERAL_double:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			type(_t);
			_t = _retTree;
			astFactory.addASTChild(currentAST, returnAST);
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				newArrayDeclarator(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ARRAY_INIT:
				{
					arrayInitializer(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			case ELIST:
			{
				elist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case OBJBLOCK:
				{
					objBlock(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case 3:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST275;
			_t = __t275;
			_t = _t.getNextSibling();
			newExpression_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = newExpression_AST;
		_retTree = _t;
		return result;
	}
	
	public final void ctorCall(AST _t) throws RecognitionException {
		
		AST ctorCall_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST ctorCall_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case CTOR_CALL:
			{
				AST __t268 = _t;
				AST tmp113_AST = null;
				AST tmp113_AST_in = null;
				tmp113_AST = astFactory.create((AST)_t);
				tmp113_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp113_AST);
				ASTPair __currentAST268 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,CTOR_CALL);
				_t = _t.getFirstChild();
				elist(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				currentAST = __currentAST268;
				_t = __t268;
				_t = _t.getNextSibling();
				ctorCall_AST = (AST)currentAST.root;
				break;
			}
			case SUPER_CTOR_CALL:
			{
				AST __t269 = _t;
				AST tmp114_AST = null;
				AST tmp114_AST_in = null;
				tmp114_AST = astFactory.create((AST)_t);
				tmp114_AST_in = (AST)_t;
				astFactory.addASTChild(currentAST, tmp114_AST);
				ASTPair __currentAST269 = currentAST.copy();
				currentAST.root = currentAST.child;
				currentAST.child = null;
				match(_t,SUPER_CTOR_CALL);
				_t = _t.getFirstChild();
				{
				if (_t==null) _t=ASTNULL;
				switch ( _t.getType()) {
				case ELIST:
				{
					elist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case TYPE:
				case TYPECAST:
				case INDEX_OP:
				case METHOD_CALL:
				case SUPER_CTOR_CALL:
				case CTOR_CALL:
				case IDENT:
				case DOT:
				case LITERAL_super:
				case LITERAL_this:
				case LITERAL_true:
				case LITERAL_false:
				case LITERAL_null:
				case LITERAL_new:
				case NUM_INT:
				case CHAR_LITERAL:
				case STRING_LITERAL:
				case NUM_FLOAT:
				case NUM_LONG:
				case NUM_DOUBLE:
				{
					primaryExpression(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					elist(_t);
					_t = _retTree;
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					throw new NoViableAltException(_t);
				}
				}
				}
				currentAST = __currentAST269;
				_t = __t269;
				_t = _t.getNextSibling();
				ctorCall_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = ctorCall_AST;
		_retTree = _t;
	}
	
	public final String  constant(AST _t) throws RecognitionException {
		String result = "";
		
		AST constant_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST constant_AST = null;
		AST in = null;
		AST in_AST = null;
		AST ch = null;
		AST ch_AST = null;
		AST str = null;
		AST str_AST = null;
		AST fl = null;
		AST fl_AST = null;
		AST dou = null;
		AST dou_AST = null;
		AST lo = null;
		AST lo_AST = null;
		
		try {      // for error handling
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case NUM_INT:
			{
				in = (AST)_t;
				AST in_AST_in = null;
				in_AST = astFactory.create(in);
				astFactory.addASTChild(currentAST, in_AST);
				match(_t,NUM_INT);
				_t = _t.getNextSibling();
				
								result = in.getText();
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			case CHAR_LITERAL:
			{
				ch = (AST)_t;
				AST ch_AST_in = null;
				ch_AST = astFactory.create(ch);
				astFactory.addASTChild(currentAST, ch_AST);
				match(_t,CHAR_LITERAL);
				_t = _t.getNextSibling();
					
								result = ch.getText(); 
				//				## = instrPrimaryExpression(##, #ch, result); 			
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			case STRING_LITERAL:
			{
				str = (AST)_t;
				AST str_AST_in = null;
				str_AST = astFactory.create(str);
				astFactory.addASTChild(currentAST, str_AST);
				match(_t,STRING_LITERAL);
				_t = _t.getNextSibling();
					
								result = str.getText(); 
				//				## = instrPrimaryExpression(##, #str, result); 					
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			case NUM_FLOAT:
			{
				fl = (AST)_t;
				AST fl_AST_in = null;
				fl_AST = astFactory.create(fl);
				astFactory.addASTChild(currentAST, fl_AST);
				match(_t,NUM_FLOAT);
				_t = _t.getNextSibling();
				
								result = fl.getText(); 
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			case NUM_DOUBLE:
			{
				dou = (AST)_t;
				AST dou_AST_in = null;
				dou_AST = astFactory.create(dou);
				astFactory.addASTChild(currentAST, dou_AST);
				match(_t,NUM_DOUBLE);
				_t = _t.getNextSibling();
					
								result = dou.getText();
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			case NUM_LONG:
			{
				lo = (AST)_t;
				AST lo_AST_in = null;
				lo_AST = astFactory.create(lo);
				astFactory.addASTChild(currentAST, lo_AST);
				match(_t,NUM_LONG);
				_t = _t.getNextSibling();
				
								result = lo.getText();
							
				constant_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = constant_AST;
		_retTree = _t;
		return result;
	}
	
	public final void newArrayDeclarator(AST _t) throws RecognitionException {
		
		AST newArrayDeclarator_AST_in = (_t == ASTNULL) ? null : (AST)_t;
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST newArrayDeclarator_AST = null;
		
		try {      // for error handling
			AST __t281 = _t;
			AST tmp115_AST = null;
			AST tmp115_AST_in = null;
			tmp115_AST = astFactory.create((AST)_t);
			tmp115_AST_in = (AST)_t;
			astFactory.addASTChild(currentAST, tmp115_AST);
			ASTPair __currentAST281 = currentAST.copy();
			currentAST.root = currentAST.child;
			currentAST.child = null;
			match(_t,ARRAY_DECLARATOR);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case ARRAY_DECLARATOR:
			{
				newArrayDeclarator(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			case EXPR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case EXPR:
			{
				expression(_t);
				_t = _retTree;
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			currentAST = __currentAST281;
			_t = __t281;
			_t = _t.getNextSibling();
			newArrayDeclarator_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			if (_t!=null) {_t = _t.getNextSibling();}
		}
		returnAST = newArrayDeclarator_AST;
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"BLOCK",
		"MODIFIERS",
		"OBJBLOCK",
		"SLIST",
		"CTOR_DEF",
		"METHOD_DEF",
		"VARIABLE_DEF",
		"INSTANCE_INIT",
		"STATIC_INIT",
		"TYPE",
		"CLASS_DEF",
		"INTERFACE_DEF",
		"PACKAGE_DEF",
		"ARRAY_DECLARATOR",
		"EXTENDS_CLAUSE",
		"IMPLEMENTS_CLAUSE",
		"PARAMETERS",
		"PARAMETER_DEF",
		"LABELED_STAT",
		"TYPECAST",
		"INDEX_OP",
		"POST_INC",
		"POST_DEC",
		"METHOD_CALL",
		"EXPR",
		"ARRAY_INIT",
		"IMPORT",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"CASE_GROUP",
		"ELIST",
		"FOR_INIT",
		"FOR_CONDITION",
		"FOR_ITERATOR",
		"EMPTY_STAT",
		"\"final\"",
		"\"abstract\"",
		"\"strictfp\"",
		"SUPER_CTOR_CALL",
		"CTOR_CALL",
		"VARIABLE_PARAMETER_DEF",
		"STATIC_IMPORT",
		"ENUM_DEF",
		"ENUM_CONSTANT_DEF",
		"FOR_EACH_CLAUSE",
		"ANNOTATION_DEF",
		"ANNOTATIONS",
		"ANNOTATION",
		"ANNOTATION_MEMBER_VALUE_PAIR",
		"ANNOTATION_FIELD_DEF",
		"ANNOTATION_ARRAY_INIT",
		"TYPE_ARGUMENTS",
		"TYPE_ARGUMENT",
		"TYPE_PARAMETERS",
		"TYPE_PARAMETER",
		"WILDCARD_TYPE",
		"TYPE_UPPER_BOUNDS",
		"TYPE_LOWER_BOUNDS",
		"LOGB",
		"\"package\"",
		"SEMI",
		"\"import\"",
		"\"static\"",
		"LBRACK",
		"RBRACK",
		"IDENT",
		"DOT",
		"QUESTION",
		"\"extends\"",
		"\"super\"",
		"LT",
		"COMMA",
		"GT",
		"SR",
		"BSR",
		"\"void\"",
		"\"boolean\"",
		"\"byte\"",
		"\"char\"",
		"\"short\"",
		"\"int\"",
		"\"float\"",
		"\"long\"",
		"\"double\"",
		"STAR",
		"\"private\"",
		"\"public\"",
		"\"protected\"",
		"\"transient\"",
		"\"native\"",
		"\"threadsafe\"",
		"\"synchronized\"",
		"\"volatile\"",
		"AT",
		"LPAREN",
		"RPAREN",
		"ASSIGN",
		"LCURLY",
		"RCURLY",
		"\"class\"",
		"\"interface\"",
		"\"enum\"",
		"BAND",
		"\"default\"",
		"\"implements\"",
		"\"this\"",
		"\"throws\"",
		"TRIPLE_DOT",
		"COLON",
		"\"if\"",
		"\"else\"",
		"\"while\"",
		"\"do\"",
		"\"break\"",
		"\"continue\"",
		"\"return\"",
		"\"switch\"",
		"\"throw\"",
		"\"assert\"",
		"\"for\"",
		"\"case\"",
		"\"try\"",
		"\"finally\"",
		"\"catch\"",
		"PLUS_ASSIGN",
		"MINUS_ASSIGN",
		"STAR_ASSIGN",
		"DIV_ASSIGN",
		"MOD_ASSIGN",
		"SR_ASSIGN",
		"BSR_ASSIGN",
		"SL_ASSIGN",
		"BAND_ASSIGN",
		"BXOR_ASSIGN",
		"BOR_ASSIGN",
		"LOR",
		"LAND",
		"BOR",
		"BXOR",
		"NOT_EQUAL",
		"EQUAL",
		"LE",
		"GE",
		"\"instanceof\"",
		"SL",
		"PLUS",
		"MINUS",
		"DIV",
		"MOD",
		"INC",
		"DEC",
		"BNOT",
		"LNOT",
		"\"true\"",
		"\"false\"",
		"\"null\"",
		"\"new\"",
		"NUM_INT",
		"CHAR_LITERAL",
		"STRING_LITERAL",
		"NUM_FLOAT",
		"NUM_LONG",
		"NUM_DOUBLE",
		"WS",
		"SL_COMMENT",
		"ML_COMMENT",
		"ESC",
		"HEX_DIGIT",
		"VOCAB",
		"EXPONENT",
		"FLOAT_SUFFIX",
		"\"const\""
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 633318697648128L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 2255648104382464L, 8556380164L, 140737488355328L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 2265000655724544L, 39582435407584L, 549755811840L, 0L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 633593848185984L, 3457075666107760640L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	}
	
