/*** 
 * 
 * @author Dominik Schindler 
 * 
 * GUISymbolTableTableModel.java - Table model for the symbol table JTable 
 * component. 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;
import javax.swing.table.*;


public class GUISymbolTableTableModel extends AbstractTableModel {
    
	private Vector v;

	public GUISymbolTableTableModel( Hashtable h ) {
		
		Symbol sym = null;
		int i = 0;
		int size = h.size();
		v = new Vector();
		
		while ( i < size ) {
			sym = ( Symbol) h.get( new Long ( i + 1 ) );
			if (sym == null ) {
				size++;
			} else {
				v.add( sym );
			}
			i++;
		}
	}

	public GUISymbolTableTableModel( Vector v ) {
		this.v = v;
	}
	
	public int getRowCount() {
		return v.size();
	}
	
	public int getColumnCount() {
		return 5;
	}
	
	public Object getValueAt( int row, int column ) {
		
		Symbol sym = ( Symbol ) v.get( row );
		
		if ( sym == null ) return null;
		
		//Symbol sym = ( Symbol ) h.get( new Long ( row ) );
		switch (column) {
			case 0: return new Long ( sym.id ); 
			case 1: return new Long ( sym.row ); 
			case 2: return sym.type;
			case 3: return sym.exp;
			case 4: if (sym.notes.length() == 0) return new String (""); 
					else return sym.notes;
		}
		return null;
	}
	
	public Object getElementAt( int row ) {
		return v.get( row );
	}
	
    public String getColumnName( int col ) {
    	switch ( col ) {
    		case 0: return "Id";
    		case 1: return "Row";
    		case 2: return "Type";
    		case 3: return "Expression";
    		case 4: return "Notes";
    	}
    	return null;
    }
    
    public boolean isCellEditable(int row, int col) {
    	return false;
    }
    
    public void clear() {
    	v.clear();
    	this.fireTableDataChanged();
    }
}
