/*** 
 * 
 * @author Dominik Schindler 
 * 
 * GUIOverallTableModel.java - Table modell for GUIOverallCoverageDetails.java.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;

import javax.swing.table.AbstractTableModel;

public class GUIOverallTableModel extends AbstractTableModel {

	private OverallCoverage oc;
	private DecimalFormat df = new DecimalFormat( "#00.00" );

	public GUIOverallTableModel( OverallCoverage oc ) {
		this.oc = oc;
	}
	
	public int getRowCount() {
		return oc.getRows();
	}
	
	public int getColumnCount() {
		return oc.getCols();
	}
	
	public Object getValueAt( int row, int column ) {
		
		Symbol sym = getSymbolByIndex( row );

		switch ( column ) {
			case 0: return Long.toString( sym.id );
			case 1: return sym.exp;
			case 2: return df.format( oc.getPercentage( sym ) * 100 );
		}	
		
		return null;
	}
	
	public String getColumnName( int col ) {
		switch( col ) {
			case 0: return "ID";
			case 1: return "Branch/Variable";
			case 2: return "% covered";
		}
		return "test";
    }
	    
    public boolean isCellEditable(int row, int col) {
    	return false;
    }	
    
    public Symbol getSymbolByIndex( int index ) {
		
    	Enumeration enu = oc.getSymbols().keys();
		int i = 0;
		
        while ( enu.hasMoreElements() ) {
        	Symbol sym = ( Symbol ) enu.nextElement();
        	if ( i == index ) return sym;
        	i++;
        }
    	
        return null;
    }
    
	
}
