/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIOverallTableCellRenderer.java - Table cell renderer for 
 * GUIOverallCoverageDetails.java. 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.HashMap;

public class GUIOverallTableCellRenderer {
	
	private MCDCoverageDetails mcdcod;
	private HashMap symbolTable;

	public GUIOverallTableCellRenderer( MCDCoverageDetails mmccod, HashMap symbolTable ) {
		this.mcdcod = mmccod;
		this.symbolTable = symbolTable;
	}
	
	public int getRowCount() {
		return mcdcod.getRows();
	}
	
	public int getColumnCount() {
		return mcdcod.getCols() + 1;
	}
	
	public Object getValueAt( int row, int column ) {
		if (column == 0) {
			return String.valueOf( row ); 
		} if ( column == mcdcod.getCols() ) {
			
			String s = new String();
			
			int b = mcdcod.getValuesTable( row, column - 1).intValue();
			for ( int i = 0; i < mcdcod.getCols() - 2; i++ ) {
				if ( ( b & 1 << i ) != 0 ) s += " "+ ( int ) Math.pow( 2 , i ); 
			}
			
			return s;
			
		} else {
			if ( mcdcod.getValuesTable( row, column - 1 ).intValue() == 1 )  {
				return "T";
			} else if ( mcdcod.getValuesTable( row, column - 1 ).intValue() == 0 ) {
				return "F";
			} else {
				return "N";
			}
		}
	}
	
	public String getColumnName( int col ) {
	   	if ( col == mcdcod.getCols() -1 ) {
	   		return "Branch";
    	} else if ( col == 0 ) {
    		return "Count";
    	} else if ( col == mcdcod.getCols() ) {
    		return "atomic covered";
    	}
	    	
    	Long l = ( Long ) mcdcod.getSymbols().get( col - 1 );
    	Symbol sym = ( Symbol ) symbolTable.get( l );
        return sym.exp;
    }
	    
    public boolean isCellEditable(int row, int col) {
    	return false;
    }
   
}