/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIOverallCoverageDetails.java - GUI Class which shows the overall detailed 
 * information.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import javax.swing.*;
import javax.swing.table.TableColumn;

import java.awt.*;
import java.awt.event.*;
import java.util.Enumeration;

import javax.swing.event.*;

import org.jfree.*;
import org.jfree.chart.*;
import org.jfree.data.*;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.chart.plot.PlotOrientation;

public class GUIOverallCoverageDetails extends JFrame implements WindowListener {

	// type of overall view
	public static final int MCDC = 0;
	public static final int MCC = 1;
	public static final int PC = 2;
	
	private ChartPanel chartPanel;
	private JFreeChart chart;
	private JTable conditionsTable;
	private OverallCoverage oc;
	private Analyzer analyzer;
	private DefaultCategoryDataset categoryDataset;
	private int type;
	
	public GUIOverallCoverageDetails( OverallCoverage omcdc, String title, Analyzer analyzer, int type ) {
	
		this.setTitle( title );
		this.oc = omcdc;
		this.analyzer = analyzer;
		this.type = type; // MCC, MCDC, PC
		
		initializeComponents();
	}
	
	private void initializeComponents() {
		
		this.getContentPane().setLayout( new BorderLayout() );
		this.setSize( 800, 400 );
		
		// center window
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );

		// tabbed pane
		JPanel panel1 = new JPanel();
		panel1.setLayout( new BorderLayout(5,5) );
		
		conditionsTable = new JTable();
		conditionsTable.setModel( new GUIOverallTableModel( oc ) );
		//conditionsTable.setDefaultRenderer( Object.class, new GUI() );
		conditionsTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		conditionsTable.addMouseListener( new MouseAdapter() {
			public void mouseClicked( MouseEvent e ) {
				int row = conditionsTable.getSelectedRow();

				if ( row >= 0 && e.getClickCount() == 2 ) {
					GUIOverallTableModel model = ( GUIOverallTableModel ) conditionsTable.getModel();
					Symbol sym = ( Symbol ) model.getSymbolByIndex( row );
				
					try {
						
						if ( type == MCC ) {						
							MCCoverageDetails mmccod = analyzer.getMCC( sym );

							if ( mmccod == null ) {
								GUIMisc.InfoDialog( null, "No relevant conditions found! " );
							} else {
								new GUIMCCDetailedView( mmccod, "Multiple condition coverage for: (" + sym.id + ") " + sym.exp, analyzer.getSymbolTable() );
							}
						} else if ( type == MCDC ) {							
							MCDCoverageDetails mcdcod = analyzer.getMCDC( sym );

							if ( mcdcod == null ) {
								GUIMisc.InfoDialog( null, "No relevant conditions found! " );
							} else {
								new GUIMCDCDetailedView( mcdcod, "Modified condition-/decition coverage for: (" + sym.id + ") " + sym.exp, analyzer.getSymbolTable() );
							}
						} else if ( type == PC ) {
							CoverageDetails cod = analyzer.getPC( sym );

							if ( cod == null ) {
								GUIMisc.InfoDialog( null, "No relevant conditions found! " );
							} else {
								new GUIDetailedConditionsView( cod, "Polymorphic coverage for: (" + sym.id + ") " + sym.exp, true );
							}
						}
					} catch (Exception ex) {
						GUIMisc.ExceptionDialog( null, "AnalyzerException: ", ex );
					}
				}
			}
	    });   
	    
		//panel1.add( new JScrollPane ( conditionsTable ) );
		
		categoryDataset = new DefaultCategoryDataset();		
    	Enumeration enu = oc.getSymbols().keys();
        while ( enu.hasMoreElements() ) {
        	Symbol sym = ( Symbol ) enu.nextElement();
        	Double perc = ( Double ) oc.getSymbols().get( sym );
        	categoryDataset.addValue( perc.doubleValue(), sym.exp, "" );
        }
		
        chart = ChartFactory.createBarChart(
                "Coverage overview",         // chart title
                "Coverage",               // domain axis label
                "Percent",                  // range axis label
                categoryDataset,                  // data
                PlotOrientation.VERTICAL,
                true,                     // include legend
                true,                     // tooltips?
                false                     // URLs?
            );
        
		chartPanel = new ChartPanel( chart );
		JScrollPane sp = new JScrollPane( chartPanel );
		JScrollPane sp2 = new JScrollPane ( conditionsTable );
		chartPanel.setPreferredSize( new Dimension( this.getWidth()/ 2 - 1, Math.min( this.getHeight(), chartPanel.getHeight() ) ) );
		sp.setMinimumSize( new Dimension ( this.getWidth()/ 2, this.getHeight() ) );
		sp2.setMinimumSize( new Dimension ( 200, this.getHeight() ) );
		//conditionsTable.setPreferredSize( new Dimension( this.getWidth()/ 2, this.getHeight() ) );
		JSplitPane splitPane = new JSplitPane( JSplitPane.HORIZONTAL_SPLIT, sp2, sp );   
		
		this.getContentPane().add( splitPane );
		this.getContentPane().add( new JPanel(), BorderLayout.NORTH );
		this.getContentPane().add( new JPanel(), BorderLayout.WEST );
		this.getContentPane().add( new JPanel(), BorderLayout.SOUTH );
		this.getContentPane().add( new JPanel(), BorderLayout.EAST );
		this.addWindowListener( this );
		
		this.setVisible( true );	
	}
	
	private void setColumnWidth( JTable table ) {
		TableColumn column = null;
		for ( int i = 0; i < table.getColumnCount(); i++ ) {
		    column = table.getColumnModel().getColumn( i );
		    switch ( i ) {
		    	case 0: column.setMinWidth( 50 );
		    			column.setMaxWidth( 100 );
		    			column.setPreferredWidth( 50 );
		    	case 1: column.setMinWidth( 50 );
    					column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 2: column.setMinWidth( 50 );
    					column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 4: column.setMinWidth( 50 );
						column.setMaxWidth( 50 );
						column.setPreferredWidth( 50 );
		    }
		}	

	}
	
	// listeners
	public void windowClosing( WindowEvent event ) {
	    this.dispose();
	}
	public void windowClosed( WindowEvent event ) {}
	public void windowDeiconified( WindowEvent event ) {}
	public void windowIconified( WindowEvent event ) {}
	public void windowActivated( WindowEvent event ) {}
	public void windowDeactivated( WindowEvent event ) {}
	public void windowOpened( WindowEvent event ) {}
	
}
