/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMisc.java - Miscellaneous GUI functionality, e.g. load/save dialogs, message
 * boxes, ...   
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.awt.*;

public class GUIMisc {

	public static File[] OpenDialog( Component parent, String title, String filter, String filterDesc, String filename, boolean multiple) {
	    
		JFileChooser fileOpenChooser = new JFileChooser();
		fileOpenChooser.setDialogTitle( title );
		
		fileOpenChooser.setFileFilter( new MyFileFilter( filter, filterDesc ) );
		
		if ( filename != null ) fileOpenChooser.setSelectedFile( new File( filename ) );
   
	    int state = 0;
		
	    // allows to select more files
    	fileOpenChooser.setMultiSelectionEnabled( multiple );
    	state = fileOpenChooser.showOpenDialog( parent );
	    
	    if (state == JFileChooser.APPROVE_OPTION) {
	    	if ( multiple ) {
		    	return fileOpenChooser.getSelectedFiles();
	    	} else {
	    		File[] f = new File[1];
	    		f[0] = fileOpenChooser.getSelectedFile();
	    		return f;
	    	}
	    } else { 
	    	return null;
		}
	}
	
	public static File SaveDialog( Component parent, String title, String filter, String filterDesc, String filename) {
	    
		JFileChooser fileSaveChooser = new JFileChooser();
		fileSaveChooser.setDialogTitle( title );
		
		fileSaveChooser.setFileFilter( new MyFileFilter( filter, filterDesc ) );
		
		if ( filename != null ) fileSaveChooser.setSelectedFile( new File( filename ) );
   
	    int state = 0;
		
    	fileSaveChooser.setMultiSelectionEnabled( false );
    	state = fileSaveChooser.showSaveDialog( parent );
	    
	    if ( state == JFileChooser.APPROVE_OPTION ) {
	    	return fileSaveChooser.getSelectedFile();
	    } else { 
	    	return null;
		}
	}
	
	public static File GetFolderDialog( Component parent, String title ) {
	    
		JFileChooser fileOpenChooser = new JFileChooser();
		fileOpenChooser.setDialogTitle( title );
		
		fileOpenChooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );
		
    	fileOpenChooser.setMultiSelectionEnabled( false );
	    
	    if (fileOpenChooser.showOpenDialog( parent ) ==  JFileChooser.APPROVE_OPTION) {
	    	return fileOpenChooser.getSelectedFile();
	    } else { 
	    	return null;
		}
	}
	
	public static void InfoDialog( Component parent, String text ) {
		JOptionPane.showMessageDialog( parent, text, "Information", JOptionPane.INFORMATION_MESSAGE );
	}
	
	public static void ExceptionDialog( Component parent, String text, Exception e) {
		JOptionPane.showMessageDialog( parent, text + "\n" + e.getLocalizedMessage(), "Exception", JOptionPane.ERROR_MESSAGE );
	}

	public static void ErrorDialog( Component parent, String text ) {
		JOptionPane.showMessageDialog( parent, text, "Error", JOptionPane.ERROR_MESSAGE );
	}
	
	public static int YesNoDialog( Component parent, String text) {
		return JOptionPane.showConfirmDialog( parent, text );
	}
	
}

class MyFileFilter extends FileFilter {
	
	private String filter;
	private String filterDesc;
	
	public boolean accept(File f) {
		return f.isDirectory() || f.getName().toLowerCase().endsWith(filter) ||
			f.getName().toLowerCase().startsWith(filter);
	}

	public String getDescription() {
		return filterDesc;
	}
	
	public MyFileFilter(String filter, String filterDesc) {
		this.filter = filter;
		this.filterDesc = filterDesc;
	}
	
}
