/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMCDCTableCellRenderer.java - Table cell renderer for GUIMCDCDetailedView.java 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class GUIMCDCTableCellRenderer extends JLabel implements TableCellRenderer {
	
	public Component getTableCellRendererComponent(
			    JTable table,
			    Object value,
			    boolean isSelected,
			    boolean hasFocus,
			    int row,
			    int column){
		JLabel label = new JLabel( (String) value);

		label.setOpaque( true );
		Border b = BorderFactory.createEmptyBorder( 1, 1, 1, 1 );
		label.setBorder( b );
		label.setFont( table.getFont() );
		label.setForeground( table.getForeground() );

		value = table.getValueAt( row, table.getColumnCount() - 1 );
		
		String s = ( String ) value;
		
		if ( s.equals("") ) {
			label.setBackground( Color.RED );
		} else {
			label.setBackground( Color.GREEN );
		}

//		if (hasFocus) {
//			label.setBackground(darkBlue);
//			label.setForeground(Color.white);
//		} else if (isSelected) {
//		    label.setBackground(lightBlue);
//		} else {
//		}
		return label;
	} 
}
