/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMCDCDetailedView - GUI Class which shows the detailed mcdc information 
 * with charts.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import java.util.*;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;

public class GUIMCDCDetailedView extends JFrame implements ChangeListener, WindowListener  {

	private JTabbedPane conditionsPane;
	private ChartPanel chartPanel;
	private JTable conditionsTable;
	private DefaultPieDataset dataset;
	private MCDCoverageDetails mcdcod;
	private JFreeChart coverageChart;
	private Hashtable symbolTable;
	private DecimalFormat df = new DecimalFormat( "#00.00" );  
	
	public GUIMCDCDetailedView ( MCDCoverageDetails mcdcod, String title, Hashtable symbolTable ) {
		if ( mcdcod == null ) return;

		this.mcdcod = mcdcod;
		this.symbolTable = symbolTable;
		this.setTitle(title);		
		
		initializeComponents();		 
	}

	private void initializeComponents() {
		getContentPane().setLayout( new BorderLayout() );
		this.setSize( 800, 400 );
		
		// center window
		Dimension d = Toolkit.getDefaultToolkit().  getScreenSize()  ;
		setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );

		// tabbed pane
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BorderLayout(5,5));
		
		// conditions pane
		conditionsPane = new JTabbedPane();
		conditionsPane.addChangeListener(this);

		dataset = new DefaultPieDataset();
			
		JPanel coveredPanel = new JPanel();
		coveredPanel.setLayout( new BorderLayout() );
		conditionsTable = new JTable();
		conditionsTable.setModel( new GUIMCDCTableModel( mcdcod, symbolTable ) );
		conditionsTable.setDefaultRenderer( Object.class, new GUIMCDCTableCellRenderer() );
		
		conditionsTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		coveredPanel.add( new JScrollPane ( conditionsTable ) );

		conditionsPane.addTab( "Modified condition-/decition coverage (" + Math.round( ( float ) mcdcod.getCovered().size() / 2 ) +" / " + ( ( mcdcod.getCols() - 2 > 0 ) ? ( df.format( ( float ) mcdcod.getCovered().size() / 2 / ( mcdcod.getCols() - 2 ) * 100 ) ) : "100" ) + "%)", coveredPanel);
		dataset.setValue( "Covered", new Double( mcdcod.getCovered().size() / 2 ));
		dataset.setValue( "Not covered ", new Double( mcdcod.getCols() - 2 - mcdcod.getCovered().size()/2 ) );

		coverageChart = ChartFactory.createPieChart(
			      "Coverage details", // The chart title
			      dataset,         // The dataset for the chart
			      true,          // Is a legend required?
			      true,          // Use tooltips
			      false          // Configure chart to generate URLs?
			    );
		PiePlot plot = (PiePlot)coverageChart.getPlot();
	    plot.setExplodePercent(0, 0.25);
	    
		chartPanel = new ChartPanel(coverageChart);
		chartPanel.setPreferredSize(new Dimension( this.getWidth()/ 3, this.getHeight() ));
	    
		panel1.add(conditionsPane);
		panel1.add(chartPanel, BorderLayout.EAST);
			
		this.getContentPane().add(panel1);
		this.getContentPane().add(new JPanel(), BorderLayout.NORTH);
		this.getContentPane().add(new JPanel(), BorderLayout.WEST);
		this.getContentPane().add(new JPanel(), BorderLayout.SOUTH);
		this.getContentPane().add(new JPanel(), BorderLayout.EAST);
		this.addWindowListener(this);
		
		this.setVisible(true);	
	}
	
	public void stateChanged( ChangeEvent e ) {
		
	}
	
	public void windowClosing( WindowEvent event ) {
	    this.dispose();
	}
	public void windowClosed( WindowEvent event ) {}
	public void windowDeiconified( WindowEvent event ) {}
	public void windowIconified( WindowEvent event ) {}
	public void windowActivated( WindowEvent event ) {}
	public void windowDeactivated( WindowEvent event ) {}
	public void windowOpened( WindowEvent event ) {}
}
