/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMCCTableModel.java - Table model for GUIMCCDetailedView.java 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import javax.swing.table.AbstractTableModel;

import java.util.*;

public class GUIMCCTableModel extends AbstractTableModel {
	
	private MCCoverageDetails mmccod;
	private Hashtable symbolTable;

	public GUIMCCTableModel( MCCoverageDetails mmccod, Hashtable symbolTable ) {
		this.mmccod = mmccod;
		this.symbolTable = symbolTable;
	}
	
	public int getRowCount() {
		return mmccod.getRows();
	}
	
	public int getColumnCount() {
		return mmccod.getCols();
	}
	
	public Object getValueAt( int row, int column ) {
		if (column == 0) {
			return String.valueOf( row ); 
		} else {
			return ( mmccod.getValuesTable()[row][column - 1].intValue() == 1 ) ? "T"  : "F"  ;
		}
	}
	
    public String getColumnName( int col ) {
    	if ( col == mmccod.getCols() ) {
    		return "Covered";
    	} else if ( col == 0 ) {
    		return "Count";
    	}
    	
    	System.out.println ( mmccod.getSymbols() );
    	
    	Long l = ( Long ) mmccod.getSymbols().get( col - 1 );
    	Symbol sym = ( Symbol ) symbolTable.get( l );
        return sym.exp;
    }
    
    public boolean isCellEditable(int row, int col) {
    	return false;
    }
    
}
