/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMCCTableCellRenderer.java - Table cell renderer for GUIMCCDetailedView.java 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;

public class GUIMCCTableCellRenderer extends JLabel implements TableCellRenderer {
	
	public Component getTableCellRendererComponent(
			    JTable table,
			    Object value,
			    boolean isSelected,
			    boolean hasFocus,
			    int row,
			    int column){
		JLabel label = new JLabel( (String) value);

		value = table.getModel().getValueAt( row, table.getColumnCount() );
		
		label.setOpaque( true );
		Border b = BorderFactory.createEmptyBorder( 1, 1, 1, 1 );
		label.setBorder( b );
		label.setFont( table.getFont() );
		label.setForeground( table.getForeground() );

		if ( ( ( String ) value ).equals( "F" ) ) {
			label.setBackground( Color.RED );
		} else {
			label.setBackground( Color.GREEN );
		}

//		if (hasFocus) {
//			label.setBackground(darkBlue);
//			label.setForeground(Color.white);
//		} else if (isSelected) {
//		    label.setBackground(lightBlue);
//		} else {
//		}
		return label;
	} 
}
