/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIMCCDetailedView - GUI Class which shows the detailed mcc information 
 * with charts.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.*;

import java.text.DecimalFormat;
import java.util.*;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;

public class GUIMCCDetailedView extends JFrame implements WindowListener {

	private JTabbedPane conditionsPane;
	private ChartPanel chartPanel;
	private JTable conditionsTable;
	private DefaultPieDataset dataset;
	private MCCoverageDetails mmccod;
	private JFreeChart coverageChart;
	private Hashtable symbolTable;
	private DecimalFormat df = new DecimalFormat( "#00.00" );  
	
	public GUIMCCDetailedView( MCCoverageDetails mmccod, String title, Hashtable symbolTable ) {

		if ( mmccod == null ) return;

		this.mmccod = mmccod;
		this.symbolTable = symbolTable;
		this.setTitle(title);		
		
		initializeComponents();
	}
	
	private void initializeComponents() {
		getContentPane().setLayout( new BorderLayout() );
		this.setSize( 800, 400 );
		
		// center window
		Dimension d = Toolkit.getDefaultToolkit().  getScreenSize()  ;
		setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );

		// tabbed pane
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BorderLayout(5,5));
		
		// conditions pane
		conditionsPane = new JTabbedPane();

		dataset = new DefaultPieDataset();
			
		JPanel coveredPanel = new JPanel();
		coveredPanel.setLayout( new BorderLayout() );
		conditionsTable = new JTable();
		conditionsTable.setModel( new GUIMCCTableModel( mmccod, symbolTable ) );
		conditionsTable.setDefaultRenderer( Object.class, new GUIMCCTableCellRenderer() );
		
		conditionsTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		coveredPanel.add( new JScrollPane ( conditionsTable ) );

		conditionsPane.addTab( "Multiple condition coverage (" + mmccod.getCovered().size() +" / " + ( ( mmccod.getRows() > 0 ) ? ( df.format( ( float ) mmccod.getCovered().size() / mmccod.getRows() * 100 ) ) : "100" ) + "%)", coveredPanel);
		dataset.setValue( "Covered", new Double( mmccod.getCovered().size() ));
		dataset.setValue( "Not covered ", new Double( mmccod.getRows() - mmccod.getCovered().size() ) );

		coverageChart = ChartFactory.createPieChart(
			      "Coverage details", // The chart title
			      dataset,         // The dataset for the chart
			      true,          // Is a legend required?
			      true,          // Use tooltips
			      false          // Configure chart to generate URLs?
			    );
		PiePlot plot = (PiePlot)coverageChart.getPlot();
	    plot.setExplodePercent(0, 0.25);
	    
		chartPanel = new ChartPanel(coverageChart);
		chartPanel.setPreferredSize(new Dimension( this.getWidth()/ 3, this.getHeight() ));
	    
		panel1.add(conditionsPane);
		panel1.add(chartPanel, BorderLayout.EAST);
			
		this.getContentPane().add(panel1);
		
		// padding
		this.getContentPane().add(new JPanel(), BorderLayout.NORTH);
		this.getContentPane().add(new JPanel(), BorderLayout.WEST);
		this.getContentPane().add(new JPanel(), BorderLayout.SOUTH);
		this.getContentPane().add(new JPanel(), BorderLayout.EAST);
		this.addWindowListener(this);
		
		this.setVisible(true);	
	}
	
	public void windowClosing( WindowEvent event ) {
	    this.dispose();
	}
	public void windowClosed( WindowEvent event ) {}
	public void windowDeiconified( WindowEvent event ) {}
	public void windowIconified( WindowEvent event ) {}
	public void windowActivated( WindowEvent event ) {}
	public void windowDeactivated( WindowEvent event ) {}
	public void windowOpened( WindowEvent event ) {}
	
}
