/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIDetailedView.java - GUI Class which shows the detailed information in an 
 * uniform manner and with charts.
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import javax.swing.*;

import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.table.TableColumn;
import java.text.*;

import java.awt.*;

import org.jfree.chart.*;
import org.jfree.chart.plot.*;
import org.jfree.data.general.*;


public class GUIDetailedConditionsView extends JFrame implements ChangeListener, WindowListener {

	private JTabbedPane conditionsPane;
	private ChartPanel chartPanel;
	private JTable coveredTable;
	private JTable trueOnlyTable;
	private JTable falseOnlyTable;
	private JTable neverCoveredTable;
	private JTable unknownTable;
	private JFreeChart coverageChart;
	private DefaultPieDataset dataset;
		
	private long covered;
	private long trueOnly;		
	private long falseOnly;		
	private long neverCovered;
	private long unknown;
	private long total;
	
	private boolean truecov;
	
	private CoverageDetails cod;
	
	public GUIDetailedConditionsView( CoverageDetails cod, String title, boolean truecov ) {
		
		// truecov = true, if a symbol, which is only true should be treated as covered
		
		if ( cod == null ) return;
		
		this.setTitle( title );
		this.cod = cod;
		this.truecov = truecov; // true, if a symbol is covered if only true

		covered = cod.getCovered();
		trueOnly = cod.getTrueOnly();
		falseOnly = cod.getFalseOnly();
		neverCovered = cod.getNeverCovered();
		unknown = cod.getUnknwon();	
		total = cod.getCount();
		
		initializeComponents();
	}
	
	
	private void initializeComponents() {

		getContentPane().setLayout( new BorderLayout() );
		this.setSize( 800, 400 );
		
		// center window on screen
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize()  ;
		setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );

		// tabbed pane
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BorderLayout(5,5));
		
		// conditions pane
		conditionsPane = new JTabbedPane();
		conditionsPane.addChangeListener(this);

		dataset = new DefaultPieDataset();
		DecimalFormat df = new DecimalFormat( "00.00" );
		
		// TODO: adjust chart colors
		if ( covered > 0 ) {
			JPanel coveredPanel = new JPanel();
			coveredPanel.setLayout( new BorderLayout() );
			coveredTable = new JTable();
			coveredTable.setModel( new GUISymbolTableTableModel( cod.coveredSymbols  ) ) ;
			coveredTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
			coveredPanel.add( new JScrollPane ( coveredTable ) );
			
			conditionsPane.addTab( "Covered (" + covered +" / " + ( ( total > 0 ) ? ( df.format( ( float ) covered / total * 100 ) ) : "100" ) + "%)", coveredPanel);
			dataset.setValue( "Covered", new Double( covered ));

			setColumnWidth( coveredTable );
		}
		
		if ( trueOnly > 0 ) {
			JPanel onlyTruePanel = new JPanel();
			onlyTruePanel.setLayout(new BorderLayout());
			trueOnlyTable = new JTable();
			trueOnlyTable.setModel( new GUISymbolTableTableModel ( cod.trueOnlySymbols ) );
			trueOnlyTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
			onlyTruePanel.add( new JScrollPane( trueOnlyTable ) );
			
			
			if ( !truecov ) {
				conditionsPane.addTab( "True only (" + trueOnly +" / " + ( ( total > 0 ) ? ( df.format( ( float ) trueOnly / total * 100 ) ) : "100" ) + "%)", onlyTruePanel);
				dataset.setValue( "True only", new Double( trueOnly ));
			} else {
				conditionsPane.addTab( "Covered (" + trueOnly +" / " + ( ( total > 0 ) ? ( df.format( ( float ) trueOnly / total * 100 ) ) : "100" ) + "%)", onlyTruePanel);
				dataset.setValue( "Covered", new Double( trueOnly ));
			}
			
			setColumnWidth( trueOnlyTable );
		}

		if ( falseOnly > 0 ) {
			JPanel onlyFalsePanel = new JPanel();
			onlyFalsePanel.setLayout(new BorderLayout());
			falseOnlyTable = new JTable();
			falseOnlyTable.setModel( new GUISymbolTableTableModel ( cod.falseOnlySymbols ) );
			falseOnlyTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
			onlyFalsePanel.add ( new JScrollPane ( falseOnlyTable ) );
			
			conditionsPane.addTab( "False only (" + falseOnly +" / " + ( ( total > 0 ) ? ( df.format( ( float ) falseOnly / total * 100 ) ) : "100" ) + "%)", onlyFalsePanel);
			dataset.setValue( "False only", new Double( falseOnly ));
			
			setColumnWidth( falseOnlyTable );
		}
				
		if ( neverCovered > 0 ) {
			JPanel neverCoveredPanel = new JPanel();
			neverCoveredPanel.setLayout(new BorderLayout());
			neverCoveredTable = new JTable();
			neverCoveredTable.setModel( new GUISymbolTableTableModel ( cod.neverCoveredSymbols ));
			neverCoveredTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
			neverCoveredPanel.add( new JScrollPane ( neverCoveredTable ) );
			
			conditionsPane.addTab( "Never covered (" + neverCovered +" / " + ( ( total > 0 ) ? ( df.format( ( float ) neverCovered / total * 100 ) ) : "100" ) + "%)", neverCoveredPanel);
			dataset.setValue( "Never covered", new Double( neverCovered ));
			
			setColumnWidth( neverCoveredTable );
		}
		
		if ( unknown > 0 ) {
			JPanel unknownPanel = new JPanel();
			unknownPanel.setLayout(new BorderLayout());
			unknownTable = new JTable();
			unknownTable.setModel( new GUISymbolTableTableModel ( cod.unknownSymbols ) );
			unknownTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
			unknownPanel.add( new JScrollPane ( unknownTable ) );			

			conditionsPane.addTab( "Unknown (" + unknown +" / " + ( ( total > 0 ) ? ( df.format( ( float ) unknown / total * 100 ) ) : "100" ) + "%)", unknownPanel);
			dataset.setValue( "Unkown", new Double( unknown ));
			
			setColumnWidth( unknownTable );
		}
 
		// === chart panel ===
		// chart data
		
		coverageChart = ChartFactory.createPieChart(
			      "Coverage overview", // The chart title
			      dataset,         // The dataset for the chart
			      true,          // Is a legend required?
			      true,          // Use tooltips
			      false          // Configure chart to generate URLs?
			    );
		
		PiePlot plot = (PiePlot) coverageChart.getPlot();
	    plot.setExplodePercent(0, 0.25);
	    
		chartPanel = new ChartPanel( coverageChart );
		chartPanel.setPreferredSize( new Dimension( this.getWidth()/ 2, this.getHeight() ));
	    
		panel1.add( conditionsPane );
		panel1.add( chartPanel, BorderLayout.EAST );
			
		this.getContentPane().add( panel1 );
		
		// padding
		this.getContentPane().add( new JPanel(), BorderLayout.NORTH );
		this.getContentPane().add( new JPanel(), BorderLayout.WEST );
		this.getContentPane().add( new JPanel(), BorderLayout.SOUTH );
		this.getContentPane().add( new JPanel(), BorderLayout.EAST );
		this.addWindowListener( this );
		
		this.setVisible( true );
	}
	
	public void stateChanged( ChangeEvent e) {
		if ( ( e.getSource() == conditionsPane ) && ( coverageChart != null ) ) {
			PiePlot plot = ( PiePlot ) coverageChart.getPlot();
			// reset highlight
			for ( int i = 0; i < conditionsPane.getTabCount(); i++ ) {
				plot.setExplodePercent( i, 0.0 );
			}
			// highlight the selected condition
			int i = conditionsPane.getSelectedIndex();
			if ( i > -1 ) plot.setExplodePercent( i , 0.25 );
		}
	}
	
	private void setColumnWidth( JTable table ) {
		TableColumn column = null;
		for ( int i = 0; i < table.getColumnCount(); i++ ) {
		    column = table.getColumnModel().getColumn( i );
		    switch ( i ) {
		    	case 0: column.setMinWidth( 50 );
		    			column.setMaxWidth( 100 );
		    			column.setPreferredWidth( 50 );
		    	case 1: column.setMinWidth( 50 );
    					column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 2: column.setMinWidth( 50 );
    					column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 4: column.setMinWidth( 50 );
						column.setMaxWidth( 50 );
						column.setPreferredWidth( 50 );
		    }
		}	

	}
	
	public void windowClosing( WindowEvent event ) {
	    this.dispose();
	}
	public void windowClosed( WindowEvent event ) {}
	public void windowDeiconified( WindowEvent event ) {}
	public void windowIconified( WindowEvent event ) {}
	public void windowActivated( WindowEvent event ) {}
	public void windowDeactivated( WindowEvent event ) {}
	public void windowOpened( WindowEvent event ) {}
}
