/*** 
 * 
 * @author Dominik Schindler
 * 
 * GUIConditionCoverage - Main GUI class. 
 *
 */

package de.fau.cs.swe.sa.conditionCoverage;

import javax.swing.*;

import java.awt.event.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.text.*;

import javax.swing.border.EmptyBorder;
import javax.swing.event.*;
import javax.swing.table.*;

import antlr.*;

public class GUIConditionCoverage extends JFrame implements ActionListener {

	
	// main menu
	// menu file
	private JMenu menuFile;
	private JMenuItem menuFileExit;
	private JMenuItem menuFileNew;
	// menu instrument
	private JMenu menuInstrument;
	private JMenuItem menuInstrumentAddFiles;	
	private JMenuItem menuInstrumentAddPack;
	private JMenuItem menuInstrumentInstrument;
	// menu analyze
	private JMenu menuAnalyze;
	private JMenuItem menuAnalyzeLoadSymbolTable;
	private JMenuItem menuAnalyzeShowOverallSCC;
	private JMenuItem menuAnalyzeShowOverallCDC;
	private JMenuItem menuAnalyzeShowOverallMMCC;
	private JMenuItem menuAnalyzeShowOverallMCDC;
	private JMenuItem menuAnalyzeShowOverallMCC;
	private JMenuItem menuAnalyzeShowOverallMC;
	private JMenuItem menuAnalyzeShowOverallSC;
	private JMenuItem menuAnalyzeShowOverallPC;
	// menu logfiles
	private JMenu menuLogfiles;
	private JMenuItem menuLogfilesAddFiles;
	// menu messages
	private JMenu menuMessages;
	private JMenuItem menuSaveMessages;
	private JMenuItem menuClearMessages;
	// menu help
	private JMenu menuHelp;
	private JMenuItem menuHelpAbout;
	
	// instrument buttons
	private JButton buttonAddInstrFile;
	private JButton buttonAddInstrPack;
	private JButton buttonRemoveInstrFile;
	private JButton buttonClearInstrFiles;
	private JButton buttonShowAST;
	private JButton buttonInstrFiles;
	private JButton buttonSelectOutputDir;
	private JButton buttonSaveSymbolTable;
	// logfiles buttons
	private JButton buttonAddLogfiles;
	private JButton buttonRemoveLogfile;
	private JButton buttonClearLogfiles;
	// analyzer buttons
	private JButton buttonLoadSymbolTable;

	private JButton buttonShowOverallSCC;
	private JButton buttonShowOverallCDC;
	private JButton buttonShowOverallMMCC;
	private JButton buttonShowOverallMCDC;
	private JButton buttonShowOverallMCC;
	private JButton buttonShowOverallMC;
	private JButton buttonShowOverallSC;
	private JButton buttonShowOverallPC;
	
	private JButton buttonShowSCC;
	private JButton buttonShowCDC;
	private JButton buttonShowMMCC;
	private JButton buttonShowMCDC;
	private JButton buttonShowMCC;
	private JButton buttonShowMC;
	private JButton buttonShowSC;
	private JButton buttonShowPC;

	// messages buttons
	private JButton buttonSaveMessages;
	private JButton buttonClearMessages;
	
	// other components
	private JTabbedPane mainTabbedPane;

	private JList listInstrFiles;
	private JList listLogfiles;
	
	private JTable symbolTableTable;
	
	private JTextField outputDirTextField;
	private JTextField symbolTableTextField;
	private JTextArea messagesTextArea;
	
	private JCheckBox checkboxBuildClassHierarchie;
	
	// other variables
	private DefaultListModel modelInstrFiles;
	private GUILogfilesListModel modelLogfiles;
	private GUISymbolTableTableModel modelSymbolTable;
	private Analyzer analyzer;
	private Instrumenter instr;
	private File symbolTableFile; 
	
	public GUIConditionCoverage(int width, int height, String title) {
		
		// typical adjustments
		setTitle( title ); 
		
		try {
			UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
		} catch( Exception e ) { }

		setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		setSize( width, height );	
		getContentPane().setLayout( new BorderLayout() );
				
		// center window on screen
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize()  ;
		setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
		
		// initialize components
		initializeComponents();
		
		setVisible(true);
		
	}
	
	// initializes all components of the program
	public void initializeComponents() {

		// initialize lists a.s.o.
		modelInstrFiles = new DefaultListModel();
		analyzer = new Analyzer();
		modelLogfiles = new GUILogfilesListModel( analyzer.getLogfiles() );		

		// build the menu
		JMenuBar menuBar = new JMenuBar();
		
		menuFile = new JMenu( "File" );
		menuFileNew = new JMenuItem( "New" );
		menuFileNew.addActionListener( this );
		menuFile.add( menuFileNew );
		menuFile.addSeparator();
		menuFileExit = new JMenuItem( "Exit" );
		menuFileExit.addActionListener( this );	
		menuFile.add( menuFileExit );

		menuInstrument = new JMenu( "Instrument" );
		menuInstrumentAddFiles = new JMenuItem( "Add file(s) ..." );
		menuInstrumentAddFiles.addActionListener( this );
		menuInstrument.add( menuInstrumentAddFiles );
		menuInstrumentAddPack = new JMenuItem( "Add package ..." );
		menuInstrumentAddPack.addActionListener( this );
		menuInstrument.add( menuInstrumentAddPack );
		menuInstrument.addSeparator();
		menuInstrumentInstrument = new JMenuItem( "Instrument files" );
		menuInstrumentInstrument.addActionListener( this );
		menuInstrumentInstrument.setEnabled( false );
		menuInstrument.add( menuInstrumentInstrument );
		
		menuLogfiles = new JMenu("Logfiles");
		menuLogfilesAddFiles = new JMenuItem("Add logfile(s) ...");
		menuLogfilesAddFiles.addActionListener(this);
		menuLogfiles.add(menuLogfilesAddFiles);
		
		menuAnalyze = new JMenu("Analyze");
		menuAnalyzeLoadSymbolTable = new JMenuItem("Load symbol table ...");
		menuAnalyzeLoadSymbolTable.addActionListener(this);
		menuAnalyze.add(menuAnalyzeLoadSymbolTable);
		menuAnalyze.addSeparator();

		menuAnalyzeShowOverallSCC = new JMenuItem( "Overall SCC ..." );
		menuAnalyzeShowOverallSCC.setEnabled( false );
		menuAnalyzeShowOverallSCC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallSCC );

		menuAnalyzeShowOverallCDC = new JMenuItem( "Overall CDC ..." );
		menuAnalyzeShowOverallCDC.setEnabled( false );
		menuAnalyzeShowOverallCDC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallCDC );

		menuAnalyzeShowOverallMMCC = new JMenuItem( "Overall MMCC ..." );
		menuAnalyzeShowOverallMMCC.setEnabled( false );
		menuAnalyzeShowOverallMMCC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallMMCC );

		menuAnalyzeShowOverallMCDC = new JMenuItem( "Overall MCDC ..." );
		menuAnalyzeShowOverallMCDC.setEnabled( false );
		menuAnalyzeShowOverallMCDC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallMCDC );

		menuAnalyzeShowOverallMCC = new JMenuItem( "Overall MCC ..." );
		menuAnalyzeShowOverallMCC.setEnabled( false );
		menuAnalyzeShowOverallMCC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallMCC );
		
		menuAnalyze.addSeparator();

		menuAnalyzeShowOverallMC = new JMenuItem( "Overall MC ..." );
		menuAnalyzeShowOverallMC.setEnabled( false );
		menuAnalyzeShowOverallMC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallMC );

		menuAnalyzeShowOverallSC = new JMenuItem( "Overall SC ..." );
		menuAnalyzeShowOverallSC.setEnabled( false );
		menuAnalyzeShowOverallSC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallSC );
		
		menuAnalyze.addSeparator();
		
		menuAnalyzeShowOverallPC = new JMenuItem( "Overall PC ..." );
		menuAnalyzeShowOverallPC.setEnabled( false );
		menuAnalyzeShowOverallPC.addActionListener( this );
		menuAnalyze.add( menuAnalyzeShowOverallPC );		
		//
		menuMessages = new JMenu("Messages");
		menuSaveMessages = new JMenuItem("Save messages ...");
		menuSaveMessages.addActionListener(this);
		menuMessages.add(menuSaveMessages);
		menuMessages.addSeparator();
		menuClearMessages = new JMenuItem("Clear messages");
		menuClearMessages.addActionListener(this);
		menuMessages.add(menuClearMessages);		
		//
		menuHelp = new JMenu( "Help" );
		menuHelpAbout = new JMenuItem( "About" );
		menuHelpAbout.addActionListener( this );
		menuHelp.add(menuHelpAbout);

		menuBar.add(menuFile);
		menuBar.add(menuInstrument);
		menuBar.add(menuLogfiles);
		menuBar.add(menuAnalyze);
		menuBar.add(menuMessages);
		menuBar.add(menuHelp);
		
		setJMenuBar( menuBar );
		mainTabbedPane = new JTabbedPane();
		getContentPane().add(mainTabbedPane);
		// padding
		getContentPane().add(new JPanel(), BorderLayout.NORTH);
		getContentPane().add(new JPanel(), BorderLayout.WEST);
		getContentPane().add(new JPanel(), BorderLayout.SOUTH);
		getContentPane().add(new JPanel(), BorderLayout.EAST);
		
		initializeInstrumentTab();
		initializeAnalyzeTab();
		initializeLogfilesTab();
		initializeMessagesTab();
	}
	
	public void initializeInstrumentTab () {
		JPanel instrumentPanel = new JPanel();
		instrumentPanel.setLayout(new BorderLayout());

		// instrument files panel
		JPanel instrumentFilesPanel = new JPanel();
		instrumentFilesPanel.setLayout(new BorderLayout(5,5));
		instrumentFilesPanel.setBorder(BorderFactory.createTitledBorder(" Files to instrument: "));
		
		// intrument buttons
		JPanel instrButtonPanel = new JPanel();
		instrButtonPanel.setLayout( new GridLayout(12,1) );
		buttonAddInstrFile = new JButton( "Add file(s) ..." );
		buttonAddInstrFile.addActionListener( this );
		instrButtonPanel.add( buttonAddInstrFile );
		buttonAddInstrPack = new JButton( "Add package ..." );
		buttonAddInstrPack.addActionListener( this );
		buttonAddInstrPack.setEnabled( true );
		instrButtonPanel.add( buttonAddInstrPack );
		buttonRemoveInstrFile = new JButton("Remove selected");
		buttonRemoveInstrFile.addActionListener(this);
		buttonRemoveInstrFile.setEnabled(false);
		instrButtonPanel.add(buttonRemoveInstrFile);
		buttonClearInstrFiles = new JButton("Clear list");
		buttonClearInstrFiles.addActionListener(this);
		buttonClearInstrFiles.setEnabled(false);
		instrButtonPanel.add(buttonClearInstrFiles);
		buttonShowAST = new JButton("Show AST");
		buttonShowAST.addActionListener(this);
		buttonShowAST.setEnabled(false);
		instrButtonPanel.add(buttonShowAST);
		instrButtonPanel.add( new JPanel() );
		buttonInstrFiles = new JButton("Instrument file(s)");
		buttonInstrFiles.addActionListener(this);
		buttonInstrFiles.setEnabled(false);
		instrButtonPanel.add(buttonInstrFiles);
		checkboxBuildClassHierarchie = new JCheckBox( "Determine PC" );
		instrButtonPanel.add( checkboxBuildClassHierarchie );

		instrumentFilesPanel.add(instrButtonPanel, BorderLayout.EAST);
		// files list to instrument
		listInstrFiles = new JList(modelInstrFiles);
		listInstrFiles.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		listInstrFiles.addMouseListener( new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				int index = listInstrFiles.locationToIndex( e.getPoint() );

				if ( index >= 0 ) {
					
//					InstrItem item = ( InstrItem ) modelInstrFiles.getElementAt( index ); 
//					if ( item.type == InstrItem.FILE ) {
//						buttonAddInstrPack.setEnabled( true );
//						menuInstrumentAddPack.setEnabled( true );
//					} else {
//						buttonAddInstrPack.setEnabled( false );
//						menuInstrumentAddPack.setEnabled( false );
//					}
					
					buttonRemoveInstrFile.setEnabled( true );
					buttonShowAST.setEnabled( true );
				} else {
					buttonRemoveInstrFile.setEnabled( false );
					buttonShowAST.setEnabled( false );
				}
			}
	    });  
		instrumentFilesPanel.add( new JScrollPane( listInstrFiles ) );

		// output dir panel
		JPanel panel2 = new JPanel();
		panel2.setLayout(new BorderLayout());
		
		JPanel outputDirPanel = new JPanel();
		outputDirPanel.setLayout( new BorderLayout(5,5) );
		outputDirPanel.setBorder( BorderFactory.createTitledBorder("Output directory:" ));
		buttonSelectOutputDir = new JButton( "Select output dir ..." );
		buttonSelectOutputDir.addActionListener( this );
		outputDirTextField = new JTextField();
		outputDirTextField.setEditable( false);
		outputDirPanel.add( outputDirTextField );
		outputDirPanel.add( buttonSelectOutputDir, BorderLayout.EAST );
		
		panel2.add( outputDirPanel, BorderLayout.NORTH );
		
		// symbol table panel
		JPanel symbolTablePanel = new JPanel();
		symbolTablePanel.setLayout( new BorderLayout(5,5));
		symbolTablePanel.setBorder( BorderFactory.createTitledBorder( "Symbol table:" ) );
		buttonSaveSymbolTable = new JButton( "Save symbol table ..." );
		buttonSaveSymbolTable.addActionListener( this);
		symbolTableTextField = new  JTextField( "Java.sym" );
		symbolTableTextField.setEditable( false );
		symbolTablePanel.add( symbolTableTextField );
		symbolTablePanel.add( buttonSaveSymbolTable, BorderLayout.EAST );
		panel2.add( symbolTablePanel, BorderLayout.SOUTH );

		instrumentFilesPanel.add(panel2, BorderLayout.SOUTH);
		
		instrumentPanel.add(instrumentFilesPanel);
		// padding
		instrumentPanel.add(new JPanel(), BorderLayout.NORTH);
		instrumentPanel.add(new JPanel(), BorderLayout.EAST);
		instrumentPanel.add(new JPanel(), BorderLayout.SOUTH);
		instrumentPanel.add(new JPanel(), BorderLayout.WEST);
		mainTabbedPane.addTab("Instrument", instrumentPanel);
	}
	
	public void initializeLogfilesTab() {
		JPanel logFilesPanel = new JPanel();
		logFilesPanel.setLayout(new BorderLayout());
		
		JPanel panel3 = new JPanel();
		panel3.setLayout(new BorderLayout(5,5));
		panel3.setBorder(BorderFactory.createTitledBorder(" Logfiles to analyze: "));
		
		// intrument buttons
		JPanel logButtonPanel = new JPanel();
		logButtonPanel.setLayout(new GridLayout(14,1));
		buttonAddLogfiles = new JButton("Add logfile(s) ...");
		buttonAddLogfiles.addActionListener(this);
		logButtonPanel.add(buttonAddLogfiles);
		buttonRemoveLogfile = new JButton("Remove selected");
		buttonRemoveLogfile.addActionListener(this);
		buttonRemoveLogfile.setEnabled(false);
		logButtonPanel.add(buttonRemoveLogfile);
		buttonClearLogfiles = new JButton("Clear list");
		buttonClearLogfiles.addActionListener(this);
		buttonClearLogfiles.setEnabled(false);
		logButtonPanel.add(buttonClearLogfiles);

		panel3.add(logButtonPanel, BorderLayout.EAST);

		// files list to instrument
		listLogfiles = new JList();
		listLogfiles.setCellRenderer( new GUICheckListRenderer() );
		listLogfiles.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		//listLogfiles.setBorder( new EmptyBorder( 0,4,0,0 ) );
		listLogfiles.addMouseListener( new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				int index = listLogfiles.locationToIndex( e.getPoint() );

				if ( index >= 0 ) {
					Rectangle rect = listLogfiles.getCellBounds( index, index );
					LogfileItem item = ( LogfileItem ) listLogfiles.getModel().getElementAt( index );
					item.setSelected( !item.isSelected() );
					listLogfiles.repaint( rect );
					buttonRemoveLogfile.setEnabled( true );
				}
			}
	    });   

		
		panel3.add(new JScrollPane(listLogfiles));

		logFilesPanel.add(panel3);
		// padding
		logFilesPanel.add(new JPanel(), BorderLayout.NORTH);
		logFilesPanel.add(new JPanel(), BorderLayout.EAST);
		logFilesPanel.add(new JPanel(), BorderLayout.SOUTH);
		logFilesPanel.add(new JPanel(), BorderLayout.WEST);
		mainTabbedPane.addTab("Logfiles", logFilesPanel);
	}
	
	public void initializeAnalyzeTab() {
		JPanel analyzePanel = new JPanel();
		analyzePanel.setLayout(new BorderLayout());
		
		JPanel panel2 = new JPanel();
		panel2.setLayout(new BorderLayout());
		
		// overall condition coverages
		JPanel overallCCPanel = new JPanel();
		overallCCPanel.setLayout(new BorderLayout());
		overallCCPanel.setBorder(BorderFactory.createTitledBorder(" Overall condition coverages: "));
		
		JPanel panel3 = new JPanel();
		panel3.setLayout(new GridLayout(2,4));
		
		buttonShowOverallSCC = new JButton( "Overall SC coverage ..." );
		buttonShowOverallSCC.setEnabled( false );
		buttonShowOverallSCC.addActionListener( this );
		panel3.add(buttonShowOverallSCC);
		
		buttonShowOverallCDC = new JButton( "Overall C/D coverage ..." );
		buttonShowOverallCDC.setEnabled( false );
		buttonShowOverallCDC.addActionListener( this );
		panel3.add(buttonShowOverallCDC);
		
		buttonShowOverallMMCC = new JButton( "Overall MMC coverage ..." );
		buttonShowOverallMMCC.setEnabled( false );
		buttonShowOverallMMCC.addActionListener( this );
		panel3.add(buttonShowOverallMMCC);
		
		buttonShowOverallMCDC = new JButton( "Overall MC/D coverage ..." );
		buttonShowOverallMCDC.setEnabled( false );
		buttonShowOverallMCDC.addActionListener( this );
		panel3.add(buttonShowOverallMCDC);
		
		buttonShowOverallMCC = new JButton( "Overall MC coverage..." );
		buttonShowOverallMCC.setEnabled( false );
		buttonShowOverallMCC.addActionListener( this );
		panel3.add(buttonShowOverallMCC);

		buttonShowOverallMC = new JButton( "Overall method coverage ..." );
		buttonShowOverallMC.setEnabled( false );
		buttonShowOverallMC.addActionListener( this );
		panel3.add(buttonShowOverallMC);

		buttonShowOverallSC = new JButton( "Overall switch coverage ..." );
		buttonShowOverallSC.setEnabled( false );
		buttonShowOverallSC.addActionListener( this );
		panel3.add(buttonShowOverallSC);
		
		buttonShowOverallPC = new JButton( "Overall polymorphic coverage ..." );
		buttonShowOverallPC.setEnabled( false );
		buttonShowOverallPC.addActionListener( this );
		panel3.add(buttonShowOverallPC);
		
		overallCCPanel.add( panel3 );
		// padding
		overallCCPanel.add( new JPanel(), BorderLayout.NORTH );
		overallCCPanel.add( new JPanel(), BorderLayout.WEST );
		overallCCPanel.add( new JPanel(), BorderLayout.SOUTH );
		overallCCPanel.add( new JPanel(), BorderLayout.EAST );		
		
		// === symbol table ===	
		JPanel symbolTablePanel = new JPanel();
		symbolTablePanel.setLayout( new BorderLayout(5,5) );
		symbolTablePanel.setBorder(BorderFactory.createTitledBorder(" List of instrumented conditions, methods and classes: "));

		symbolTableTable = new JTable();
		//symbolTableTable.setAutoResizeMode( JTable.AUTO_RESIZE_OFF );
		symbolTableTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );

		symbolTableTable.addMouseListener( new MouseAdapter() {
			public void mouseClicked( MouseEvent e ) {
				int row = symbolTableTable.getSelectedRow();

				if ( row >= 0 ) {
					Symbol sym = ( Symbol ) modelSymbolTable.getElementAt( row );
					
					// enable buttons only which make sence
					if ( sym.type.equals( "c" ) || sym.type.equals( "b" ) ||
							sym.type.equals( "o") || sym.type.equals( "m" ) ||
							sym.type.equals( "k" )) {
						buttonShowSCC.setEnabled( true );
						buttonShowCDC.setEnabled( true );
						buttonShowMMCC.setEnabled( true );
					} else {
						buttonShowSCC.setEnabled( false );
						buttonShowCDC.setEnabled( false );
						buttonShowMMCC.setEnabled( false );
					}
					
					if ( sym.type.equals( "b" ) ) {
						buttonShowMCDC.setEnabled( true );
						buttonShowMCC.setEnabled( true );
					} else {
						buttonShowMCDC.setEnabled( false );
						buttonShowMCC.setEnabled( false );
					}

					// if sym is method ==> enabel method coverage
					if ( sym.type.equals( "o") || sym.type.equals( "m" ) ) {
						buttonShowMC.setEnabled( true );
					} else {
						buttonShowMC.setEnabled( false );
					}
					// if sym is switch ==> enable switch coverage
					if ( sym.type.equals( "w") ) {
						buttonShowSC.setEnabled( true );
					} else {
						buttonShowSC.setEnabled( false );
					}
					// if sym is polymorphic variable ==> enable pc
					if ( sym.type.equals( "v") ) {
						buttonShowPC.setEnabled( true );
					} else {
						buttonShowPC.setEnabled( false );
					}
				
				}
			}
	    });   
		JScrollPane scp = new JScrollPane( symbolTableTable );
		symbolTablePanel.add( scp );
		
		JPanel symbolTableButtonPanel = new JPanel();
		symbolTableButtonPanel.setLayout( new GridLayout(12,1) );
		
		buttonLoadSymbolTable = new JButton( "Load symbol table ..." );
		buttonLoadSymbolTable.addActionListener( this );
		symbolTableButtonPanel.add( buttonLoadSymbolTable);

		buttonShowSCC = new JButton( "Show SC coverage ..." );
		buttonShowSCC.setEnabled( false );
		buttonShowSCC.addActionListener(this );
		symbolTableButtonPanel.add( buttonShowSCC );

		buttonShowCDC = new JButton( "Show C/D coverage ..." );
		buttonShowCDC.setEnabled( false );
		buttonShowCDC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowCDC );

		buttonShowMMCC = new JButton( "Show MMC coverage ..." );
		buttonShowMMCC.setEnabled( false );
		buttonShowMMCC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowMMCC );
		
		symbolTableButtonPanel.add( new JPanel() );

		buttonShowMCDC = new JButton( "Show MC/D coverage ..." );
		buttonShowMCDC.setEnabled( false );
		buttonShowMCDC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowMCDC );

		buttonShowMCC = new JButton( "Show MC coverage ..." );
		buttonShowMCC.setEnabled( false );
		buttonShowMCC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowMCC );
		
		symbolTableButtonPanel.add( new JPanel() );

		buttonShowMC = new JButton( "Show method coverage ..." );
		buttonShowMC.setEnabled( false );
		buttonShowMC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowMC );
		
		buttonShowSC = new JButton( "Show switch coverage ..." );
		buttonShowSC.setEnabled( false );
		buttonShowSC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowSC );
		
		symbolTableButtonPanel.add( new JPanel() );

		buttonShowPC = new JButton( "Show polymorphic coverage ..." );
		buttonShowPC.setEnabled( false );
		buttonShowPC.addActionListener( this );
		symbolTableButtonPanel.add( buttonShowPC );

		symbolTablePanel.add( symbolTableButtonPanel, BorderLayout.EAST );
		
		panel2.add( overallCCPanel, BorderLayout.SOUTH );
		panel2.add( symbolTablePanel );
		analyzePanel.add( panel2 );
		// padding
		analyzePanel.add( new JPanel(), BorderLayout.NORTH );
		analyzePanel.add( new JPanel(), BorderLayout.EAST );
		analyzePanel.add( new JPanel(), BorderLayout.SOUTH );
		analyzePanel.add( new JPanel(), BorderLayout.WEST );		
		mainTabbedPane.addTab( "Analyze" , analyzePanel );
	}
	
	public void initializeMessagesTab() {
		JPanel messagesTab = new JPanel();
		messagesTab.setLayout(new BorderLayout());
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BorderLayout( 5,5 ));
		//panel1.setBorder(BorderFactory.createTitledBorder(" Messages: "));
		
		messagesTextArea = new JTextArea();
		panel1.add( messagesTextArea );
		
		JPanel messagesButtonPanel = new JPanel();
		messagesButtonPanel.setLayout( new GridLayout( 16,1 ));
		
		buttonSaveMessages = new JButton( "Save messages ..." );
		buttonSaveMessages.addActionListener( this );
		messagesButtonPanel.add( buttonSaveMessages );	
		
		buttonClearMessages = new JButton( "Clear messages" );
		buttonClearMessages.addActionListener( this );
		messagesButtonPanel.add( buttonClearMessages );		
			
		panel1.add( messagesButtonPanel, BorderLayout.EAST );
		
		
		messagesTab.add( panel1 );
		// padding
		messagesTab.add( new JPanel(), BorderLayout.NORTH );
		messagesTab.add( new JPanel(), BorderLayout.EAST );
		messagesTab.add( new JPanel(), BorderLayout.SOUTH );
		messagesTab.add( new JPanel(), BorderLayout.WEST );		
		
		mainTabbedPane.addTab( "Messages", messagesTab );
	}
	
	// general action handler
	public void actionPerformed( ActionEvent e ) {
		// === menues ===
		// File/Exit selected
		if ( e.getSource() == menuFileExit ) {
			System.exit( 0 );
		}
		
		// File/New selected
		if ( e.getSource() == menuFileNew ) {
			
			int i = GUIMisc.YesNoDialog( this, "Do you really want to restart?" );
			
			if ( i != JOptionPane.YES_OPTION ) return;
			
			analyzer.clear();
			modelLogfiles.clear();
			modelSymbolTable.clear();
			listLogfiles.revalidate();
			symbolTableTable.revalidate();
			modelInstrFiles.clear();
			listInstrFiles.revalidate();
			
			buttonClearInstrFiles.setEnabled( false );
			buttonRemoveInstrFile.setEnabled( false );
			buttonInstrFiles.setEnabled( false );
			menuInstrumentInstrument.setEnabled( false );
			buttonShowAST.setEnabled( false );			

			buttonShowOverallSCC.setEnabled( false );
			buttonShowOverallCDC.setEnabled( false );
			buttonShowOverallMMCC.setEnabled( false );
			buttonShowOverallMCDC.setEnabled( false );
			buttonShowOverallMCC.setEnabled( false );
			buttonShowOverallMC.setEnabled( false );
			buttonShowOverallSC.setEnabled( false);
			buttonShowOverallPC.setEnabled( false);
			
			menuAnalyzeShowOverallSCC.setEnabled( false );
			menuAnalyzeShowOverallCDC.setEnabled( false );
			menuAnalyzeShowOverallMMCC.setEnabled( false );
			menuAnalyzeShowOverallMCDC.setEnabled( false );
			menuAnalyzeShowOverallMCC.setEnabled( false );
			menuAnalyzeShowOverallMC.setEnabled( false );
			menuAnalyzeShowOverallSC.setEnabled( false );			
			menuAnalyzeShowOverallPC.setEnabled( false );	
		}
		
		// === instrumenter buttons ===
		// "Instr/Add file" selected
		if ( e.getSource() == buttonAddInstrFile || e.getSource() == menuInstrumentAddFiles ) {
			File[] f = GUIMisc.OpenDialog( this, "Select java sourecode file(s) ...", ".java", "Java sourcecode files (*.java)", null, true);
			if (f != null) {
				for (int i = 0; i < f.length; i++) {
					modelInstrFiles.addElement( new InstrItem ( f[i] ) );
					if (modelInstrFiles.size() > 0) {
						buttonClearInstrFiles.setEnabled(true);
						buttonInstrFiles.setEnabled(true);
						menuInstrumentInstrument.setEnabled(true);
					}
				}
			}
		}
		// "Instr/Add package" selecte
		if ( e.getSource() == buttonAddInstrPack || e.getSource() == menuInstrumentAddPack ) {

			File f = GUIMisc.GetFolderDialog( this, "Select dir which is a package ...");
			if (f != null && f.isDirectory() ) {

				File[] files = SystemUtils.getAllFilesInDirectory( f, SystemUtils.JAVA_FILENAME_EXTENSION );
						
				if ( files.length > 0 ) {

					for ( int x = 0; x < files.length; x++ ) {
						String packageName = "(not detected)";
						
						try {
							 packageName = SystemUtils.getPackage( files[x] );
						} catch ( FileNotFoundException fnfe ) {
							System.out.println( fnfe );
						} catch ( IOException ioe ) {
							System.out.println( ioe ); 
						}
						
						modelInstrFiles.addElement( new InstrItem ( files[x], packageName ) );
					}
				}	
							
			}
			if ( modelInstrFiles.size() > 0 ) {
				buttonClearInstrFiles.setEnabled( true );
				buttonInstrFiles.setEnabled( true );
				menuInstrumentInstrument.setEnabled( true );
			}
		}
		
		// "Instr/symbol table" button selected
		if ( e.getSource() == buttonSaveSymbolTable ) {
			File f = GUIMisc.SaveDialog( this, "Select a file for the symbol table ...", ".sym", "Symbol tables (*.sym)", "Java.sym");
			if ( f != null ) {
				symbolTableTextField.setText( f.getPath() );
				symbolTableFile = f;
			}
		}
		// "Instr/clear instr files" button selected
		if (e.getSource() == buttonClearInstrFiles) {
			modelInstrFiles.clear();
			buttonClearInstrFiles.setEnabled(false);
			buttonRemoveInstrFile.setEnabled(false);
			buttonInstrFiles.setEnabled(false);
			menuInstrumentInstrument.setEnabled(false);
			buttonShowAST.setEnabled(false);
		}
		// "Instr/remove selected file" button selected
		if (e.getSource() == buttonRemoveInstrFile) {
			int sel = listInstrFiles.getSelectedIndex(); 
			
			if (sel >= 0) {
				modelInstrFiles.remove(sel);
				buttonRemoveInstrFile.setEnabled(false);
				buttonShowAST.setEnabled(false);
				if (modelInstrFiles.size() == 0) {
					buttonClearInstrFiles.setEnabled(false);
					buttonInstrFiles.setEnabled(false);
					menuInstrumentInstrument.setEnabled(false);
				}		
			}
		}
		// "Instr/SchowAST" button selected
		if ( e.getSource() == buttonShowAST ) {
			int sel = listInstrFiles.getSelectedIndex(); 
			
			if ( sel >= 0 ) {
				InstrItem item = ( InstrItem ) modelInstrFiles.getElementAt( sel );
				
				if ( !item.file.isFile() ) {
					GUIMisc.InfoDialog( this, "Please select a java sourccode file!" );	
					return;
				}
				
				try {
					Instrumenter.showAST( item.file );
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "Error creating AST: ", ex );
				}
			} else {
				GUIMisc.InfoDialog( this, "Please select a java sourccode file!" );				
			}
		}
		// "Instr/select output dir" button selected
		if (e.getSource() == buttonSelectOutputDir) {
			File f = GUIMisc.GetFolderDialog( this, "Select output folder ..." );
			
			if (f != null) {
				outputDirTextField.setText( f.getPath() + File.separator );
				symbolTableTextField.setText( f.getPath() + File.separator + "Java.sym" );
			}
		}
		// "Instr/instrument" button selected
		if ( e.getSource() == buttonInstrFiles || e.getSource() == menuInstrumentInstrument ) {
			try {
				
				File f = new File( symbolTableTextField.getText() );
				
				if ( ( outputDirTextField.getText().length() == 0 ) ) {
					GUIMisc.InfoDialog( this, "Please select an existing output directory first!" );
					return;
				}
				
				// prepare symbol table 
				FileOutputStream ous = new FileOutputStream( f );			
				instr = new Instrumenter( ous );
				
				this.setCursor( Cursor.WAIT_CURSOR );				
				
				ClassHierarchie ch = null;
				
				// build class hierarchy if checked
				if ( checkboxBuildClassHierarchie.isSelected() ) {
					ch = new ClassHierarchie();
				
					for ( int i = 0; i < modelInstrFiles.getSize(); i++ ) {
						InstrItem item = ( InstrItem ) modelInstrFiles.getElementAt( i );
						
						//System.out.println( "ch:" + item.file.getParentFile() + ":" + item.packageName + ":" + item.rootPath );
						
						ch.addClassAndSearchPath( item.file.getParentFile(), item.packageName, item.file.getParentFile() );
					}

					ch.setupKnownClassesHashtable();
					ch.setupInheritanceRelations();			
					
				}
				
				// instrument files
				for ( int i = 0; i < modelInstrFiles.getSize(); i++ ) {
					InstrItem item = ( InstrItem ) modelInstrFiles.getElementAt( i );
					
					// if entry is a package ...
					if ( item.type == InstrItem.PACKAGE ) {
						// create package dir if not existent
						File dir = new File ( outputDirTextField.getText() + item.getPackageAsPath() );
						
						if ( !dir.exists() && !dir.mkdirs() ) {
							throw new IOException ( "Can't create directory \"" + dir.getAbsolutePath() + "\"");
						}
						
						File in = ( ( InstrItem ) modelInstrFiles.getElementAt( i ) ).file;
						File out = new File( dir.getAbsolutePath() + File.separator + in.getName() );
						instr.instrumentFile( in.getAbsoluteFile(), out, ch );
						
					} else {
						File in = ( ( InstrItem ) modelInstrFiles.getElementAt( i ) ).file;
						File out = new File( outputDirTextField.getText() + in.getName() );
						instr.instrumentFile( in.getAbsoluteFile(), out, ch );
						// Instrumenter.showAST( instr.getInstrAST() );
					}
					
					try {
						
						analyzer.clear();
						analyzer.loadSymbolTable( f );
						
						updateSymbolTable();						
						
					} catch ( AnalyzerException ex ) {
						GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
					} catch ( IOException ex ) {
						GUIMisc.ExceptionDialog( this, "IOException: ", ex );
					}
				}
				GUIMisc.InfoDialog( this, "Instrumentation completed sucessfully!" );
			} catch ( IOException ioex ) {
			} catch ( TokenStreamException tse ) {
			} catch ( RecognitionException rex ) {
			} catch ( ClassNotFoundException cnfex ) {
			} catch ( DuplicateClassException dcex ) {
				GUIMisc.ExceptionDialog( this, "Exception during instrumentation!", null );
			} finally {
				this.setCursor( Cursor.DEFAULT_CURSOR );
				try {
					instr.closeSymbolTable();
				} catch ( IOException ioe ) {
					System.out.println( ioe );
				}
			}
		}

		// === Logfile buttons ===
		// "Logfiles/add logfiles" button selected
		if ( e.getSource() == buttonAddLogfiles || e.getSource() == menuLogfilesAddFiles ) {
			File[] f = GUIMisc.OpenDialog( this, "Select logfiles ...", ".log", "Named logfiles (*.log)", null, true );
			if ( f != null ) {
				for ( int i = 0; i < f.length; i++ ) {
					analyzer.addLogfile( f[i] );
					if ( analyzer.getLogfiles().size() > 0 ) {
						buttonClearLogfiles.setEnabled( true );
						buttonRemoveLogfile.setEnabled( true );
					}
				}
				listLogfiles.setModel( new GUILogfilesListModel(analyzer.getLogfiles()) );
			}
		}
		// "Logfiles/clear logfiles" button selected
		if ( e.getSource() == buttonClearLogfiles ) {
			modelLogfiles.clear();
			buttonRemoveLogfile.setEnabled( false );
			buttonClearLogfiles.setEnabled( false );
			listLogfiles.repaint();
		}
		// "Logfiles/remove logfile" button selected
		if ( e.getSource() == buttonRemoveLogfile ) {
			int sel = listLogfiles.getSelectedIndex(); 
			
			if ( sel >= 0 ) {
				modelLogfiles.remove( sel );
				buttonRemoveLogfile.setEnabled( false );
			}
			
			if ( modelLogfiles.getSize() == 0 ) {
				buttonClearLogfiles.setEnabled( false );
			}
			
			listLogfiles.repaint();
		}

		// === Analyzer buttons === 
		// "Analyzer/load symbol table" button or menu "Anazyler/load symbol table"
		// selected
		if ( e.getSource() == buttonLoadSymbolTable || e.getSource() == menuAnalyzeLoadSymbolTable ) {
			File[] f = GUIMisc.OpenDialog( this, "Load symbol table ...", ".sym", "Symbol tables (*.sym)", null, false );
			if ( f != null ) {
				try {
					analyzer.clear();
					analyzer.loadSymbolTable( f[0] );
					analyzer.printSymbolTable();
					
					updateSymbolTable();
					
				} catch ( AnalyzerException ex ) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				} catch ( IOException ex ) {
					GUIMisc.ExceptionDialog( this, "IOException: ", ex );
				}
			}
		}
		// === overall cc ===
		// "Analyzer/show overall scc" button selected
		if ( e.getSource() == buttonShowOverallSCC || e.getSource() == menuAnalyzeShowOverallSCC ) {
			try {
				CoverageDetails cod = analyzer.getOverallSCC();
				if ( cod != null ) {
					new GUIDetailedConditionsView( cod, "Overall simple condition coverage", false );
				} else {
					GUIMisc.InfoDialog( this, "No relevant conditions found! " );
				}
			} catch ( IOException ex ) {
				GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
			}
		}
		// "Analyzer/show overall cdc" button selected
		if ( e.getSource() == buttonShowOverallCDC || e.getSource() == menuAnalyzeShowOverallCDC ) {
			try {
				CoverageDetails cod = analyzer.getOverallCDC();
				if ( cod != null ) {
					new GUIDetailedConditionsView( cod, "Overall condition/decition coverage", false );
				} else {
					GUIMisc.InfoDialog( this, "No relevant conditions found! " );
				}
			} catch ( Exception ex ) {
				GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
			}
		}
		// "Analyzer/show overall mmcc" button selected
		if ( e.getSource() == buttonShowOverallMMCC || e.getSource() == menuAnalyzeShowOverallMMCC ) {
			try {
				CoverageDetails cod = analyzer.getOverallMMCC();
				if ( cod != null ) {
					new GUIDetailedConditionsView( cod, "Overall minimal multiple condition coverage", false );
				} else {
					GUIMisc.InfoDialog( this, "No relevant conditions found! " );
				}
			} catch ( Exception ex ) {
				GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
			}
		}
		// "Analyzer/show overall mcdc" button selected
		if ( e.getSource() == buttonShowOverallMCDC || e.getSource() == menuAnalyzeShowOverallMCDC ) {
			try {
				OverallCoverage co = analyzer.getOverallMCDC();
				co.printSymbolTable();
				
				System.out.println( "Overall covered: " + co.getOverallCovered() );
				
				DecimalFormat df = new DecimalFormat  ( "00.00" );  
				
				new GUIOverallCoverageDetails( co, "Overall modified condition/decition coverage: " + df.format( co.getOverallCovered() * 100 ) + "%", analyzer, GUIOverallCoverageDetails.MCDC );
			} catch ( IOException ioe ) {
				GUIMisc.ExceptionDialog( this, "IOException: ", ioe );
			}			
		}
		
		// "Analyzer/show overall mcc" button selected
		if ( e.getSource() == buttonShowOverallMCC || e.getSource() == menuAnalyzeShowOverallMCC ) {
			try {
				OverallCoverage co = analyzer.getOverallMCC();
				co.printSymbolTable();
				
				System.out.println( "Overall covered: " + co.getOverallCovered() );
				
				DecimalFormat df = new DecimalFormat  ( "00.00" );  
				
				new GUIOverallCoverageDetails( co, "Overall multiple condition coverage: " + df.format( co.getOverallCovered() * 100 ) + "%", analyzer, GUIOverallCoverageDetails.MCC );
			} catch ( IOException ioe ) {
				GUIMisc.ExceptionDialog( this, "IOException: ", ioe );
			}
		}
		
		// "Analyzer/show overall method cov" button selected
		if ( e.getSource() == buttonShowOverallMC || e.getSource() == menuAnalyzeShowOverallMC ) {
			try {
				CoverageDetails cod = analyzer.getOverallMC();
				// CoverageDetails.printCoverageDetails(cod);
				new GUIDetailedConditionsView(cod, "Overall method coverage", true );
			} catch (Exception ex) {
				GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
			}
		}
		
		// "Analyzer/show overall method cov" button selected
		if ( e.getSource() == buttonShowOverallSC || e.getSource() == menuAnalyzeShowOverallSC ) {
			try {
				CoverageDetails cod = analyzer.getOverallSC();
				// CoverageDetails.printCoverageDetails(cod);
				if ( cod != null ) new GUIDetailedConditionsView(cod, "Overall switch coverage", true);
			} catch (Exception ex) {
				GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
			}
		}
		
		// "Analyzer/show overall mcdc" button selected
		if ( e.getSource() == buttonShowOverallPC || e.getSource() == menuAnalyzeShowOverallPC ) {
			try {
				OverallCoverage co = analyzer.getOverallPC();
				co.printSymbolTable();
				
				System.out.println( "Overall covered: " + co.getOverallCovered() );
				
				DecimalFormat df = new DecimalFormat  ( "00.00" );  
				
				new GUIOverallCoverageDetails( co, "Overall polymorphic coverage: " + df.format( co.getOverallCovered() * 100 ) + "%", analyzer, GUIOverallCoverageDetails.PC );
			} catch ( IOException ioe ) {
				GUIMisc.ExceptionDialog( this, "IOException: ", ioe );
			}			
		}
	
		// === finegrained (for single ids) ===
		// "Analyzer/show scc" button selected
		if ( e.getSource() == buttonShowSCC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					CoverageDetails cod = analyzer.getSCC( s );

					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant conditions found! " );
					} else {
						new GUIDetailedConditionsView(cod, "Simple condition coverage for: (" + s.id + ") " + s.exp, false );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}
		// "Analyzer/show cdc" button selected
		if ( e.getSource() == buttonShowCDC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					CoverageDetails cod = analyzer.getCDC( s );

					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant conditions found! " );
					} else {
						new GUIDetailedConditionsView(cod, "Condition-/decition coverage for: (" + s.id + ") " + s.exp, false);
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}
		// "Analyzer/show mmcc" button selected
		if ( e.getSource() == buttonShowMMCC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					CoverageDetails cod = analyzer.getMMCC( s );

					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant conditions found! " );
					} else {
						new GUIDetailedConditionsView(cod, "Minimal multiple condition coverage for: (" + s.id + ") " + s.exp, false );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}	
		
		// "Analyzer/show mcdc" button selected
		if ( e.getSource() == buttonShowMCDC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					MCDCoverageDetails mcdcod = analyzer.getMCDC( s );

					if ( mcdcod == null ) {
						GUIMisc.InfoDialog( this, "No relevant conditions found! " );
					} else {
						new GUIMCDCDetailedView(mcdcod, "Modified condition-/decition coverage for: (" + s.id + ") " + s.exp, analyzer.getSymbolTable() );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}	
		
		// "Analyzer/show mcc" button selected
		if ( e.getSource() == buttonShowMCC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					MCCoverageDetails mmccod = analyzer.getMCC( s );

					if ( mmccod == null ) {
					GUIMisc.InfoDialog( this, "No relevant conditions found! " );
					} else {
						new GUIMCCDetailedView( mmccod, "Multiple condition coverage for: (" + s.id + ") " + s.exp, analyzer.getSymbolTable() );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}

		// "Analyzer/show sc" button selected
		if ( e.getSource() == buttonShowSC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					System.out.println( s );
					CoverageDetails cod = analyzer.getSC( s );
					
					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant cases found! " );
					} else  {
						new GUIDetailedConditionsView(cod, "Switch-case coverage for: (" + s.id + ") " + s.exp, true );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}
		// "Analyzer/show mc" button selected
		if ( e.getSource() == buttonShowMC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					CoverageDetails cod = analyzer.getMC( s );

					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant methods/constructors found! " );
					} else {
						new GUIDetailedConditionsView(cod, "Method coverage for: (" + s.id + ") " + s.exp, true );
					}
				} catch (Exception ex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ex );
				}
			}
		}
		
		// "Analyzer/show pc" button selected
		if ( e.getSource() == buttonShowPC ) {
			int sel = symbolTableTable.getSelectedRow(); 

			if ( sel >= 0 ) {
				try {
					Symbol s = ( Symbol ) modelSymbolTable.getElementAt( sel );
					CoverageDetails cod = analyzer.getPC( s );

					if ( cod == null ) {
						GUIMisc.InfoDialog( this, "No relevant classes/interfaces found! " );
					} else {
						new GUIDetailedConditionsView(cod, "Polymorphic coverage for: (" + s.id + ") " + s.exp, true );
					}
				} catch (IOException ioex) {
					GUIMisc.ExceptionDialog( this, "AnalyzerException: ", ioex );
				}
			}
		}
		
		
		// === Messages buttons ===
		// "Messages/clear messages" button or menu "Messages/clear messages" selected
		if (e.getSource() == buttonClearMessages || e.getSource() == menuClearMessages) {
			messagesTextArea.setText("");
		}
		// "Messages/save messages" button selected
		if (e.getSource() == buttonSaveMessages || e.getSource() == menuSaveMessages) {
			File f = GUIMisc.SaveDialog( this, "Save messages to ...", ".txt", "Textfile (*.txt)", "messages.txt" );
			// TODO: 
			if ( f != null ) {
				//messagesTextArea.getText().				
			}		
		}
		
		
		// menu help
		if ( e.getSource() == menuHelpAbout ) {
			GUIMisc.InfoDialog( this, getTitle() + " for Java " + Instrumenter.getSupportedJavaVersion() + "\n" +
								"Copyright  Dominik Schindler 2006\n\n" +
								"Instrumenter: Version " + Instrumenter.getMajorVersion() + "." + Instrumenter.getMinorVersion() + "\n" +
								"Analyzer: Version " + Analyzer.getMajorVersion() + "." + Analyzer.getMinorVersion() + "\n\n" +
								"This program is free software; you can redistribute it\n" + 
								"and/or modify it under the terms of the GNU General Public\n" + 
								"License as published by the Free Software Foundation, \n" + 
								"version 2 of the License.\n\n" +
								"JRE Version: " + System.getProperty( "java.specification.version" ) + ", Vendor: " + System.getProperty( "java.specification.vendor" )
			);
		}
		
	}
	
	// TODO: adjust column width
	private void updateSymbolTable() {
		modelSymbolTable = new GUISymbolTableTableModel( analyzer.getSymbolTable() );
		symbolTableTable.setModel( modelSymbolTable );
		//symbolTableTable.setAutoResizeMode( JTable.AUTO_RESIZE_OFF );

		TableColumnModel cm = symbolTableTable.getColumnModel(); 
		
		for ( int i = 0; i < cm.getColumnCount(); i++ ) {
			TableColumn column = cm.getColumn( i );
		    switch ( i ) {
		    	case 0: //column.setMinWidth( 50 );
		    			//column.setMaxWidth( 100 );
		    			column.setPreferredWidth( 50 );
		    	case 1: //column.setMinWidth( 50 );
		    			//column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 2: //column.setMinWidth( 50 );
		    			//column.setMaxWidth( 100 );
    					column.setPreferredWidth( 50 );
		    	case 3: //column.setMinWidth( 50 );
		    			//column.setMaxWidth( 50 );
						column.setPreferredWidth( 400 );
		    	case 4: //column.setMinWidth( 50 );
	    				//column.setMaxWidth( 50 );
						column.setPreferredWidth( 50 );
		    }
		}	
		
		if ( ( symbolTableTable.getModel().getRowCount() > 0 ) ) {
			buttonShowOverallSCC.setEnabled( true );
			buttonShowOverallCDC.setEnabled( true );
			buttonShowOverallMMCC.setEnabled( true );
			buttonShowOverallMCDC.setEnabled( true );
			buttonShowOverallMCC.setEnabled( true );
			buttonShowOverallMC.setEnabled( true );
			buttonShowOverallSC.setEnabled( true );		
			buttonShowOverallPC.setEnabled( true );
			
			menuAnalyzeShowOverallSCC.setEnabled( true );
			menuAnalyzeShowOverallCDC.setEnabled( true );
			menuAnalyzeShowOverallMMCC.setEnabled( true );
			menuAnalyzeShowOverallMCDC.setEnabled( true );
			menuAnalyzeShowOverallMCC.setEnabled( true );
			menuAnalyzeShowOverallMC.setEnabled( true );
			menuAnalyzeShowOverallSC.setEnabled( true );
			menuAnalyzeShowOverallPC.setEnabled( true );			
		}		
	}
	
	// program entry point
	public static void main ( String[] args ) {
		JFrame win = new GUIConditionCoverage( 700, 600, "JConCove - Java Condition Coverage Analyzer" );
	}
}

// item for the instrument list
class InstrItem {
	public static final int PACKAGE = 0;
	public static final int FILE = 1;

	public int type;
	public String className;
	public File file;
	public File rootPath;
	public String packageName;
	
	public InstrItem ( File file ) {
		this.file = file;
		this.type = FILE;
		this.packageName = "";
		this.rootPath = file.getAbsoluteFile();
		this.className = file.getName().substring(0, file.getName().length() - SystemUtils.JAVA_FILENAME_EXTENSION.length() );
	}

	public InstrItem ( File file, String packageName ) {
		this( file );
		this.type = PACKAGE;
		this.packageName = packageName;
		this.rootPath = new File ( file.getParent().substring( 0, file.getParent().length() - packageName.length() ) );
	}	
	
	public InstrItem ( File file, String packageName, File rootPath ) {
		this( file );
		this.type = PACKAGE;
		this.packageName = packageName;
		this.rootPath = rootPath;
	}	
	
	public String toString() {
		switch ( this.type ) {
			case PACKAGE: return packageName + "." + className + " - (" + file.getAbsolutePath() + ") ";
			case FILE: return className + " - (" + file.getAbsolutePath() + ") ";
		}
		return null;
	}
	
	public String getPackageAsPath() {
		return packageName.replace( SystemUtils.PACKAGE_SEPARATOR_CHAR, File.separatorChar );
	}
	
}
