 /*** 
 * 
 * @author Dominik Schindler 
 * 
 * GUICheckListRenderer.java - ListRenderer with renders a checkbox in a list.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.ColorUIResource;


public class GUICheckListRenderer extends JPanel implements ListCellRenderer {
	protected JCheckBox check;
	protected ListLabel label;
  
	public GUICheckListRenderer() {
		// no layout manager
		setLayout( null );
		add( check = new JCheckBox() );
		add( label = new ListLabel() );
		check.setBackground( UIManager.getColor( "List.textBackground" ) );
		label.setForeground( UIManager.getColor( "List.textForeground" ) );
	}

	public Component getListCellRendererComponent( JList list,
	         Object value,
	         int index,
	         boolean isSelected,
	         boolean cellHasFocus ) {

		LogfileItem lf = ( LogfileItem ) value;
		setEnabled( label.isEnabled() );
		check.setSelected( lf.isSelected() );
		label.setFont( list.getFont() );
		label.setText( lf.getFile().toString() );
		label.setSelected( isSelected );
		label.setFocus( cellHasFocus );
		return this;
	}
  
	public Dimension getPreferredSize() {
		Dimension d_check = check.getPreferredSize();
		Dimension d_label = label.getPreferredSize();
		return new Dimension(d_check.width + d_label.width,
				(d_check.height < d_label.height ?
	 			 d_label.height : d_check.height));
	}
  
	public void doLayout() {
		Dimension d_check = check.getPreferredSize();
		Dimension d_label = label.getPreferredSize();
		
		int y_check = 0;
		int y_label = 0;
		
		if ( d_check.height < d_label.height ) {
			y_check = ( d_label.height - d_check.height ) / 2;
		} else {
			y_label = ( d_check.height - d_label.height ) / 2;
		}
		
		check.setLocation( 0, y_check );
		check.setBounds( 0, y_check, d_check.width, d_check.height );
		label.setLocation( d_check.width, y_label);    
		label.setBounds( d_check.width, y_label, d_label.width, d_label.height );    
	}
   
	public void setBackground( Color color ) {
		if ( color instanceof ColorUIResource)
			color = null;
		super.setBackground( color );
	}
    
	// create own list label 
	public class ListLabel extends JLabel {
		boolean isSelected;
		boolean hasFocus;
		
		public ListLabel() {
		}
        
		public void setBackground( Color color ) {
			if( color instanceof ColorUIResource )
				color = null;
			super.setBackground( color );
		} 
         
		public void paint( Graphics g ) {
			String str;
			if ( ( str = getText() ) != null ) {
				if ( 0 < str.length() ) {
					if (isSelected) {
						g.setColor( UIManager.getColor( "Tree.selectionBackground" ) );
					} else {
						g.setColor( UIManager.getColor( "Tree.textBackground" ) );
					}
					Dimension d = getPreferredSize();
					
					g.fillRect(0, 0, d.width - 1 , d.height);
					
					if ( hasFocus ) {
						g.setColor( UIManager.getColor("Tree.selectionBorderColor") );
						g.drawRect( 0, 0, d.width -1 , d.height -1 );     
					}
				}
			}
			super.paint( g );
		}
  
		public Dimension getPreferredSize() {
			Dimension retDimension = super.getPreferredSize();
			if ( retDimension != null ) {
				retDimension = new Dimension( retDimension.width + 3,
						retDimension.height );
			}
			return retDimension;
		}
		
		public void setSelected( boolean isSelected ) {
			this.isSelected = isSelected;
		}
		
		public void setFocus( boolean hasFocus ) {
			this.hasFocus = hasFocus;
		}
	}
}    
