/*** 
 * 
 * @author Dominik Schindler 
 * 
 * ExtendedClass.java - Class which encapsulates a class with its subclasses.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;

public class ExtendedClass {
	private Class thisClass;
	private Vector subClasses = new Vector();
	private int dimensionOfVector = 0;
	private int minNumberOfRequiredInstances = 0;
	private boolean isRequired = false;

	public ExtendedClass( Class thisClass ) {
		this.thisClass = thisClass;
	}

	public Class getThisClass() {
		return thisClass;
	}

	public Vector getSubClasses() {
		return subClasses;
	}

	public void addSubClass( ExtendedClass subExtendedClass ) {
		subClasses.add( subExtendedClass );
	}

	public int getMinNumberOfRequiredInstances() {
		return minNumberOfRequiredInstances;
	}

	public void setMinNumberOfRequiredInstances( int minNumberOfRequiredInstances ) {
		this.minNumberOfRequiredInstances = Math.max(this.minNumberOfRequiredInstances, minNumberOfRequiredInstances);
	}

	public void setDimensionOfArray( int dimensionOfVector ) {
		this.dimensionOfVector = dimensionOfVector;
	}

	public int getDimensionOfVector() {
		return dimensionOfVector;
	}

	public void setRequired(boolean isRequired) {
		this.isRequired = isRequired;
	}

	public boolean isRequired() {
		return isRequired;
	}
	
	public String toString() {
		return thisClass.getName();
	}
}
