/*** 
 * 
 * @author Dominik Schindler 
 * 
 * CoverageDetails.java - Class which contains the datailed information returned by 
 * some coverage criterias.
 * 
 */

package de.fau.cs.swe.sa.conditionCoverage;

import java.util.*;

public class CoverageDetails {

	Vector coveredSymbols;			// symbol of the relevant expressions
	Vector trueOnlySymbols;         // ...
	Vector falseOnlySymbols;
	Vector neverCoveredSymbols;
	Vector unknownSymbols;

	public CoverageDetails() {
		coveredSymbols 	    = new Vector();			
		trueOnlySymbols 	= new Vector();      
		falseOnlySymbols  	= new Vector();
		neverCoveredSymbols = new Vector();
		unknownSymbols 		= new Vector();
	}
	
	public int getCovered() {
		return coveredSymbols.size();
	}
	
	public Vector getCoveredSymbols() {
		return coveredSymbols;
	}
	
	public int getTrueOnly() {
		return trueOnlySymbols.size();
	}

	public Vector getTrueOnlySymbols() {
		return trueOnlySymbols;
	}
	
	public int getFalseOnly() {
		return falseOnlySymbols.size();
	}
	
	public Vector getFalseOnlySymbols() {
		return falseOnlySymbols;
	}
	
	public int getNeverCovered() {
		return neverCoveredSymbols.size();
	}
	
	public Vector getNeverCoveredSymbols() {
		return neverCoveredSymbols;
	}
	
	public int getUnknwon() {
		return unknownSymbols.size();
	}
	
	public Vector getUnknownSymbols() {
		return unknownSymbols;
	}
	
	public long getCount() {
		return  coveredSymbols.size() + 		
				trueOnlySymbols.size() +
				falseOnlySymbols.size() +  	
				neverCoveredSymbols.size() + 
				unknownSymbols.size(); 	
	}
	
	// add symbols
	public void addCovered( Symbol s ) {
		coveredSymbols.add(s);		
	}

	public void addTrueOnly( Symbol s ) {
		trueOnlySymbols.add(s);		
	}
	
	public void addFalseOnly( Symbol s ) {
		falseOnlySymbols.add(s);		
	}
	
	public void addNever( Symbol s ) {
		neverCoveredSymbols.add(s);		
	}
	
	public void addUnknwon ( Symbol s ) {
		unknownSymbols.add(s);
	}
	
	public static void printCoverageDetails( CoverageDetails cod ) {
		System.out.println("Covered: " + cod.getCovered() + " TrueOnly: " + cod.getTrueOnly() + " FalseOnly: " + cod.getFalseOnly() + " Never: " + cod.getNeverCovered() + " Unknown: " + cod.getUnknwon() + " From " + cod.getCount());
		System.out.print("Covered: ");
		for (int i = 0; i < cod.getCovered(); i++) System.out.print(cod.getCoveredSymbols().get(i));
	}
	
}
