package de.fau.cs.swe.da.modelsimulator;
import org.eclipse.uml2.uml.*;

/**
 * Used to store the operation calls and signals in the event list.
 * 
 * @author root
 *
 */

public class MyEvent {
	/**
	 * Determines, of which type the event is.
	 */
	public static enum EventType { 
		/** Event is the sending of a signal */
		sendSignal, 
		/** Event is the call of an operation */
		callOperation  
	};
	private EventType eventType = null; 
	private Operation operation = null;
	private Signal signal = null;
	
	/**
	 * Overloaded constructor, which builds an event.
	 * 
	 * @param operation - Builds an event, which models a call of operation
	 */
	public MyEvent( Operation operation ) {
		this.operation = operation;
		this.signal = null;
		this.eventType = EventType.callOperation;
	}
	
	/**
	 * Overloaded constructor, which builds an event.
	 * 
	 * @param signal - Builds an event, which models the sending of signal
	 */	
	public MyEvent ( Signal signal ) {
		this.signal = signal;
		this.operation = null;
		this.eventType = EventType.sendSignal;
	}
	
	/**
	 * Copy constructor.
	 * 
	 * <b>Important:</b> If you wannt to add a operation with paramters to the
	 * active events list, you <b>must</b> use the call operation method, which 
	 * creates a new object with the associated operation, or clone a MyEvent 
	 * object with the copy constructor, as the MyEvent object is used as key of
	 * the parameteres hashtable, wich stores the values to a parameter. If you do
	 * not clone the object, you'll will have a problem if you want to add the 
	 * MyEvent object with the same operation/signal twice, as the second object
	 * would affect the value of the first object as the hash code is the same.
	 * 
	 * @param myEvent - The event to be cloned.
	 */
	public MyEvent ( MyEvent myEvent ) {
		this.signal = myEvent.signal;
		this.operation = myEvent.operation;
		this.eventType = myEvent.eventType;
	}
	
	/**
	 * Returns the type of the event.
	 * 
	 * @return The type of the event.
	 */
	public EventType getEventType() {
		return eventType;
	}
	/**
	 * Returns the associated operation, or null, if event is the sending of a signal. 
	 * 
	 * @return The associated operation
	 */
	public Operation getOperation() {
		return this.operation;
	}
	
	/**
	 * Retruns the associated signal, or null, if the event is the call of an operation
	 * 
	 * @return The associated signal
	 */
	public Signal getSignal() {
		return this.signal;
	}
	
	public MyEvent clone() throws CloneNotSupportedException {
		return ( MyEvent ) super.clone();
	}
	
	/**
	 * Returns the event as a string.
	 * 
	 * @return The string representing the event.
	 */
	public String toString() {
		if ( eventType == EventType.callOperation ) {
			return ( operation.getName() != null ) ? operation.getName() + "()" : "<unset>";
		} else if ( eventType == EventType.sendSignal ) {
			return ( signal.getName() != null ) ? signal.getName() : "<unset>";
		}
		return null;
	}
}
