package de.fau.cs.swe.da.modelsimulator;

import org.eclipse.uml2.uml.*;
import java.io.*;

/**
 * 
 * Loads the model with the CommonModelData project.
 * 
 * @author Dominik
 *
 */

public class ModelLoader {

	private Model model = null;
	
	/**
	 * Constructor, which loads and rebuilds the model of a UML2 XMI file.
	 * The loaded UML2 model can be retrieved by the getModel() methode. 
	 * 
	 * @param file - UML2 XMI file
	 */
	public ModelLoader( File file ) {
		model = de.united.common.model.ModelMgr.loadModelFile( file );
	}
	
	/**
	 * 
	 * Returns the model loaded.
	 * 
	 * @return Model - Loaded and rebuilt UML2 model.
	 */
	public Model getModel() {
		return model;
	}
}
