package de.fau.cs.swe.da.modelsimulator;

import java.util.*;

import org.eclipse.uml2.uml.*;

/**
 * 
 * Generic abstract class for simulateable state machines
 * 
 * @author Dominik Schindler
 *
 */

public abstract class AbstractSimulateableStateMachine {
	
	/**
	 * Retuns the refered state machine.
	 * 
	 * @return StateMachine
	 */	
	public abstract StateMachine getStateMachine( );
	
	/**
	 * 
	 * Uses by the expression parser to store variables and evaluate expressions.
	 * The retuned runtime Environement ist used by the simulator als initial
	 * environement. 
	 * 
	 * @return MyRuntimeEnvironment - Initial runtime environement used to simulate the state machine.
	 */
	public abstract MyRuntimeEnvironment initalRuntimeEnvironement( );
	
	/**
	 * 
	 * Returns all events, which can be received by the triggers of the 
	 * state machine.
	 * 
	 * @return ArrayList<MyEvent> - List of available events in the state machine.
	 */
	public abstract ArrayList<MyEvent> getAvailableEvents();
}
