package de.fau.cs.swe.da.gui.models;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import org.eclipse.uml2.uml.*;
import org.eclipse.emf.common.util.EList;

/**
 * 
 * Adapter for a JTree and the get(Next)ActiveStates() and the getVisitedVertices
 * method of the simulator.
 * 
 * @author Dominik Schindler
 * 
 */
public class VerticesTreeNode extends DefaultMutableTreeNode {

	private static final long serialVersionUID = 1L;
	
	/**
	 * Constructor, which builds the tree.
	 * 
	 * @param states - The list of states to be displayed.
	 */
	public VerticesTreeNode( ArrayList<Vertex> states ) {
		super( "States" );
		// if list not empty go through list an add the event to the tree 
		if ( states != null ) {
			for ( int i = 0; i < states.size(); i++ ) {
				Vertex state = states.get( i );
				DefaultMutableTreeNode node = new DefaultMutableTreeNode( state.getName() ) ;//( state.getName() != null ) ? state.getName() : "<none>"  );
				DefaultMutableTreeNode outgoing = new DefaultMutableTreeNode( "Outgoing" );
				node.add( outgoing );
				EList transitions = state.getOutgoings();
				for ( int j = 0; j < transitions.size(); j++ ) {
					Transition transition = ( Transition ) transitions.get( j );
					outgoing.add( new DefaultMutableTreeNode( ( transition.getName() != null ) ? transition.getName() : "<unset>" ) );
				}
				DefaultMutableTreeNode incomming = new DefaultMutableTreeNode( "Incoming" );
				node.add ( incomming );
				transitions = state.getIncomings();
				for ( int j = 0; j < transitions.size(); j++ ) {
					Transition transition = ( Transition ) transitions.get( j );
					incomming.add( new DefaultMutableTreeNode( ( transition.getName() != null ) ? transition.getName() : "<unset>" ) );
				}
				add( node );
			}	
		}
	}

}
