package de.fau.cs.swe.da.gui.models;

import javax.swing.table.AbstractTableModel;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * 
 * Adapter for a JTable and the getVariables()-method of the simulator.
 * 
 * @author Dominik Schindler
 * 
 */
public class VariablesTableModel extends AbstractTableModel {

	private Hashtable<String, Object> variableValues = null;
	private Hashtable<String, Class> variableTypes = null;
	
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor 
	 * 
	 * @param variableValues - A list of variable values.
	 * @param variableTypes - A list of variable types.
	 */
	public VariablesTableModel( Hashtable<String, Object> variableValues, Hashtable<String, Class> variableTypes ) {
		this.variableValues = variableValues;
		this.variableTypes  = variableTypes;
	}
	
	public int getColumnCount() {
		return 3;
	}
	
	@Override
	public String getColumnName( int col ) {
		switch( col ) {
			case 0: return "Name";
			case 1: return "Type";
			case 2: return "Value";
		}
		return null;
	}

	public int getRowCount() {
		return ( variableValues != null ) ? variableValues.size() : 0;
	}

	public Object getValueAt( int row, int col ) {
    	Enumeration enumeration = variableValues.keys();
		int i = 0;
        while ( enumeration.hasMoreElements() ) {
        	Object key = enumeration.nextElement();
        	if ( i == row ) {
        		switch ( col ) {
        			case 0: return key;
        			case 1: Class c = variableTypes.get( key );
        					String s = ( c != null ) ? c.toString() : "<unset>";
        					String u = s.substring( s.lastIndexOf( '.' ) + 1 );
        					return u;
        					// If value is a string, print surrounding braces.
        			case 2: return ( variableValues.get( key ) instanceof String ) ?  "\"" + variableValues.get( key ) + "\"" : variableValues.get( key );
        		}
        	}
        	i++;
        }
        return null;
	}
}
