package de.fau.cs.swe.da.gui.models;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import org.eclipse.uml2.uml.*;


/**
 * Adapter between a JTree and the getPassedTransitions() method of the state 
 * machine.
 * 
 * @author Dominik
 * 
 */
public class TransitionsTreeNode extends DefaultMutableTreeNode {

	private static final long serialVersionUID = 1L;
	
	/**
	 * Constrcutor which builds the tree. 
	 * 
	 * @param transitionsList - The list of transitions to be displayed.
	 */
	public TransitionsTreeNode( ArrayList<Transition> transitionsList ) {
		super( "Transitions" );
		// create two categories
		// if list not empty go through list an add the event to the tree 
		if ( transitionsList != null ) {
			for ( int i = 0; i < transitionsList.size(); i++ ) {
				Transition transition = transitionsList.get( i );
				DefaultMutableTreeNode node = new DefaultMutableTreeNode( ( transition.getName() != null ) ? transition.getName() : "<unset>" );
				DefaultMutableTreeNode sourceNode = new DefaultMutableTreeNode( "Source: " + ( ( transition.getSource().getName() != null ) ? transition.getSource().getName() : "<unset>" ) ); 
				DefaultMutableTreeNode targetNode = new DefaultMutableTreeNode( "Target " + ( ( transition.getTarget().getName() != null ) ? transition.getSource().getName() : "<unset>" ) ); 
				node.add( sourceNode );
				node.add( targetNode );
				add( node );
			}
		}
	}
	
}
