package de.fau.cs.swe.da.gui.models;

import javax.swing.table.AbstractTableModel;
import org.eclipse.uml2.uml.*;
import org.eclipse.emf.common.util.*;
import de.fau.cs.swe.da.modelsimulator.*;

/**
 * 
 * Adapter for a JTable and the getParameters() method of the simulator.
 * 
 * @author Dominik Schindler
 * 
 */
public class SetCallParametersTableModel extends AbstractTableModel {

	private EList parameters = null;
	private Simulator simulator = null;
	private MyEvent callEvent = null;
	
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor.
	 * 
	 * @param parameters - The list of parameters to be shown.
	 * @param callEvent - The associated event.
	 * @param simulator - The simulator where to set the values.
	 */
	public SetCallParametersTableModel( EList parameters, MyEvent callEvent, Simulator simulator ) {
		this.parameters = parameters;		
		this.simulator = simulator;
		this.callEvent = callEvent;
	}
	
	public int getColumnCount() {
		return 3;
	}

	@Override
	public String getColumnName( int col ) {
		switch( col ) {
			case 0: return "Name";
			case 1: return "Type";
			case 2: return "Value";
		}
		return null;
	}

	public boolean isCellEditable(int row, int column) {
		return column == 2;
	}
	
	public int getRowCount() {
		return ( parameters != null ) ? parameters.size() : 0;
	}

	public Object getValueAt( int row, int col ) {
   		Object object = parameters.get( row );
   		Parameter parameter = ( Parameter ) object;
		switch ( col ) {
   			case 0: return simulator.getParameterName( parameter );
   			case 1: return simulator.getParameterType( parameter );	
   			case 2: return simulator.getParameterValue( callEvent, parameter );
   		}
		return null;
 	}
	
	public void setValueAt(Object aValue, int rowIndex, int columnIndex)  {
  		Object object = parameters.get( rowIndex );
   		Parameter parameter = ( Parameter ) object;
   		String value = ( String ) aValue;
		if ( columnIndex == 2 ) simulator.setParameterValue( callEvent, parameter, value );
	}
}
