package de.fau.cs.swe.da.gui.models;

import java.util.Hashtable;
import javax.swing.AbstractListModel;
import org.eclipse.uml2.uml.StateMachine;
import java.util.Enumeration;


/**
 * 
 * Adapter between a JList and the getStateMachines() method. 
 * 
 * @author Dominik Schindler
 * 
 */
public class SelectStateMachineListModel extends AbstractListModel {

	private Hashtable<String, StateMachine> stateMachines = null;
	
	private static final long serialVersionUID = 1L;

	/**
	 * Initializes the dialog.
	 * 
	 * @param stateMachines - The list of statemachines to be shown.
	 */
	public SelectStateMachineListModel( Hashtable<String, StateMachine> stateMachines ) {
		this.stateMachines = stateMachines;
	}
	
	public Object getElementAt( int index ) {
    	Enumeration enumeration = stateMachines.keys();
		int i = 0;
        while ( enumeration.hasMoreElements() ) {
        	Object key = enumeration.nextElement();
        	if ( i == index ) return stateMachines.get( key );
        	i++;
        }
        return null;
	}

	public int getSize() {
		return ( stateMachines != null ) ? stateMachines.size(): 0;
	}

}
