package de.fau.cs.swe.da.gui.models;

/**
 * 
 * Adapter between a JTree and the getActiveRegion() method of the simulator.
 * 
 * @author Dominik
 * 
 */

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import org.eclipse.uml2.uml.*;

public class RegionTreeNode extends DefaultMutableTreeNode {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public RegionTreeNode( ArrayList<Region> regions ) {
		super( "Regions" );
		// if list not empty go through list an add the event to the tree 
		if ( regions != null ) {
			for ( int i = 0; i < regions.size(); i++ ) {
				Region region  = regions.get( i );
				DefaultMutableTreeNode node = new DefaultMutableTreeNode( ( region.getName() != null ) ? region.getName() : "<unset>" );
				add( node );
			}
		}
	}
}
