package de.fau.cs.swe.da.gui.models;

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import org.eclipse.uml2.uml.*;
import org.eclipse.emf.common.util.*;
import de.fau.cs.swe.da.modelsimulator.*;
import de.fau.cs.swe.da.modelsimulator.MyEvent.*;

/**
 * 
 * Adapter betwenn a JTree and the get(Active)Event() method of the state machine.
 * 
 * @author Dominik Schindler
 * 
 */
public class MyEventsTreeNode extends DefaultMutableTreeNode {
	
	private static final long serialVersionUID = 1L;	
	/**
	 * Constructor which builds the tree.
	 * 
	 * @param eventList - The list of events to build of the tree.
	 * @param simulator - The simulator where to retrieve the parameter values.
	 * @param showCategories - Should the categories (operations, signal) by displayed.
	 */
	public MyEventsTreeNode( ArrayList<MyEvent> eventList, Simulator simulator, boolean showCategories ) {
		super( "Events" );
		// create two categories
		DefaultMutableTreeNode operations = new DefaultMutableTreeNode( "Operations" );
		if ( showCategories ) add( operations );
		DefaultMutableTreeNode signals = new DefaultMutableTreeNode( "Signals" );
		if ( showCategories ) add( signals );
		// if list not empty go through list an add the event to the tree 
		if ( eventList != null ) {
			for ( int i = 0; i < eventList.size(); i++ ) {
				MyEvent event = eventList.get( i );
				//DefaultMutableTreeNode node = new DefaultMutableTreeNode( event );
				if ( event.getEventType() == EventType.callOperation  ) {
					Operation operation = event.getOperation();
					DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode( event );
					EList parameters = operation.getOwnedParameters();
					for ( int j = operation.getOwnedParameters().size() - 1; j > -1; j-- ) {
						Parameter parameter = ( Parameter ) parameters.get( j );
						// remove return parameter as they are not needed
						if ( parameter.getName() == null ) {
							parameters.remove( j );
						} else {
							String parameterName = simulator.getParameterName( parameter );
							String parameterType = simulator.getParameterType( parameter );
							String parameterValue = simulator.getParameterValue( event, parameter );
							DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode( parameterName + " : " + parameterType + " = " + parameterValue );
							operationNode.add( parameterNode );
						}
					}
					if ( showCategories ) {
						operations.add( operationNode );					
					} else {
						add( operationNode );
					}
				} else if ( event.getEventType() == EventType.sendSignal ) {
					DefaultMutableTreeNode signalNode = new DefaultMutableTreeNode( event );
					if ( showCategories ) {
						signals.add( signalNode );
					} else {
						add( signalNode );
					}
				} 
			}	
		}
	}
	
}
