package de.fau.cs.swe.da.gui.models;

/**
 * 
 * Adapter betwenn a JTree and the get(Active)Event() method of the state machine.
 * 
 * @author root
 * 
 */

import javax.swing.tree.DefaultMutableTreeNode;
import java.util.ArrayList;
import org.eclipse.uml2.uml.*;
import org.eclipse.emf.common.util.*;
import de.fau.cs.swe.da.modelsimulator.*;

public class EventsTreeNode extends DefaultMutableTreeNode {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public EventsTreeNode( ArrayList<Event> eventList, Simulator simulator, boolean categories ) {
		super( "Events" );
		// create two categories
		DefaultMutableTreeNode callEvents = new DefaultMutableTreeNode( "Call events" );
		if ( categories ) add( callEvents );
		DefaultMutableTreeNode signalEvents = new DefaultMutableTreeNode( "Signal events" );
		if ( categories ) add( signalEvents );
		DefaultMutableTreeNode timeEvents = new DefaultMutableTreeNode( "Timeout events" );
		if ( categories ) add( timeEvents );
		DefaultMutableTreeNode anyEvents = new DefaultMutableTreeNode( "Any events" );
		if ( categories ) add( anyEvents );
		// if list not empty go through list an add the event to the tree 
		if ( eventList != null ) {
			for ( int i = 0; i < eventList.size(); i++ ) {
				Event event = eventList.get( i );
				DefaultMutableTreeNode node = new DefaultMutableTreeNode( event );
				if ( event instanceof CallEvent ) {
					CallEvent callEvent = ( CallEvent ) event;
					Operation operation = callEvent.getOperation();
					DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode( 
							( operation.getName() != null ) ? operation.getName() : "<unset>"  );
					EList parameters = operation.getOwnedParameters();
					for ( int j = 0; j < operation.getOwnedParameters().size(); j++ ) {
						Parameter parameter = ( Parameter ) parameters.get( j );
						String parameterName = simulator.getParameterName( parameter );
						String parameterType = simulator.getParameterType( parameter );
						//String parameterValue = simulator.getParameterValue( callEvent, parameter );
						//DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode( parameterName + " : " + parameterType + " = " + parameterValue );
						//operationNode.add( parameterNode );
					}
					node.add( operationNode );					
					if ( categories ) {
						callEvents.add( node );
					} else {
						add( node );
					}
				} else if ( event instanceof SignalEvent ) {
					SignalEvent signalEvent = ( SignalEvent ) event;
					Signal signal = signalEvent.getSignal();
					DefaultMutableTreeNode signalNode = new DefaultMutableTreeNode( 
							( signal.getName() != null ) ? signal.getName() : "<unset>"  );
					node.add( signalNode );					
					if ( categories ) {
						signalEvents.add( node );
					} else {
						add( node );
					}
				} else if ( event instanceof TimeEvent ) {
					if ( categories ) {
						timeEvents.add ( node );
					} else {
						add ( node );
					}
				} else if ( event instanceof AnyReceiveEvent ) {
					if ( categories ) {
						anyEvents.add( node );
					} else {
						add( node );
					}
				}
			}	
		}
	}
	
}
