package de.fau.cs.swe.da.gui;

import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;

/**
 * Textarea, where the output of stdout will be displayed.
 * 
 * @author root
 *
 */

public class TextAreaOutputStream extends OutputStream {

	private JTextArea textArea = null;
	
	/**
	 * Determines the JTextArea, where the outputs should be displayed.
	 * 
	 * @param textArea - The JTextAre, where to redirect the output.
	 */
	public TextAreaOutputStream( JTextArea textArea ) {
		this.textArea = textArea;
	}
	
	@Override
	public void write( int b ) throws IOException {
		textArea.append( String.valueOf( ( char ) b ) );
		textArea.revalidate();
	}

}
