package de.fau.cs.swe.da.gui;

import de.fau.cs.swe.da.modelsimulator.*;
import de.fau.cs.swe.da.modelsimulator.Simulator.EventsQueueBehavior;
import de.fau.cs.swe.da.modelsimulator.Simulator.MultipleConcurrentBehavior;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.JLabel;
import java.awt.Font;

/**
 * Dialog, where the user can set several options of the simulator. 
 * 
 * @author Dominik Schindler
 *
 */

public class SimulationOptionsDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 1L;

	private JPanel jPanel = null;

	private JPanel jButtonPanel = null;

	private JButton jOKButton = null;

	private JButton jCancelButton = null;

	private JTabbedPane jTabbedPane = null;

	private JPanel jPanel1 = null;

	private JCheckBox jDeadlockCheckBox = null;

	private JCheckBox jNoMoreEventsCheckBox = null;

	private JCheckBox jNoMoreTransitionsCheckBox = null;

	private Simulator simulator = null;
	
	private JLabel jLabel = null;

	private JPanel jPanel7 = null;

	private JPanel jPanel6 = null;

	private JPanel jPanel8 = null;

	private JRadioButton jSequentialRadioButton = null;

	private JRadioButton jParallelRadioButton = null;

	private JRadioButton jDiscardRadioButton = null;

	private JRadioButton jReAddRadioButton = null;

	private JRadioButton jSkipRadioButton = null;

	private JLabel jLabel1 = null;

	private JLabel jLabel2 = null;

	/**
	 * Initializes the dialog.
	 * 
	 * @param owner - The parent window.
	 * @param sim - The simulator, where to set the options.
	 */
	public SimulationOptionsDialog(Frame owner, Simulator sim) {
		super(owner);
		this.simulator = sim;
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		this.setSize(600, 360);
		this.setContentPane(getJContentPane());
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.setTitle("Setup automatic simulation");
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize()  ;
		this.setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BorderLayout());
			jPanel.add(getJButtonPanel(), BorderLayout.SOUTH);
			jPanel.add(getJTabbedPane(), BorderLayout.CENTER);
		}
		return jPanel;
	}

	/**
	 * This method initializes jButtonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJButtonPanel() {
		if (jButtonPanel == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			gridLayout.setColumns(2);
			jButtonPanel = new JPanel();
			jButtonPanel.setLayout(gridLayout);
			jButtonPanel.setPreferredSize(new Dimension(0, 24));
			jButtonPanel.add(getJOKButton(), null);
			jButtonPanel.add(getJCancelButton(), null);
			
		}
		return jButtonPanel;
	}

	/**
	 * This method initializes jOKButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJOKButton() {
		if (jOKButton == null) {
			jOKButton = new JButton();
			jOKButton.setText("OK");
			jOKButton.addActionListener( this );
		}
		return jOKButton;
	}

	/**
	 * This method initializes jCancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJCancelButton() {
		if (jCancelButton == null) {
			jCancelButton = new JButton();
			jCancelButton.setText("Cancel");
			jCancelButton.addActionListener( this );
		}
		return jCancelButton;
	}

	/**
	 * This method initializes jTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJTabbedPane() {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.addTab("Stop options", null, getJPanel1(), null);
			jTabbedPane.addTab("Simulation behavior", null, getJPanel7(), null);
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jLabel = new JLabel();
			jLabel.setText("Automatic simulation stop reasons:");
			jLabel.setFont(new Font("Dialog", Font.BOLD, 14));
			GridLayout gridLayout1 = new GridLayout();
			gridLayout1.setRows(4);
			gridLayout1.setColumns(1);
			jPanel1 = new JPanel();
			jPanel1.setLayout(gridLayout1);
			jPanel1.add(jLabel, null);
			jPanel1.add(getJNoMoreTransitionsCheckBox(), null);
			jPanel1.add(getJNoMoreEventsCheckBox(), null);
			jPanel1.add(getJDeadlockCheckBox(), null);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jDeadlockCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJDeadlockCheckBox() {
		if (jDeadlockCheckBox == null) {
			jDeadlockCheckBox = new JCheckBox();
			jDeadlockCheckBox.setSelected(simulator.getStopIfPartialDeadlock());
			jDeadlockCheckBox.setFont(new Font("Dialog", Font.PLAIN, 12));
			jDeadlockCheckBox.setText("Deadlock (not yet implemented)");
		}
		return jDeadlockCheckBox;
	}

	/**
	 * This method initializes jNoMoreEventsCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJNoMoreEventsCheckBox() {
		if (jNoMoreEventsCheckBox == null) {
			jNoMoreEventsCheckBox = new JCheckBox();
			jNoMoreEventsCheckBox.setSelected(simulator.getStopIfNoMoreEvents());
			jNoMoreEventsCheckBox.setFont(new Font("Dialog", Font.PLAIN, 12));
			jNoMoreEventsCheckBox.setText("No more events");
		}
		return jNoMoreEventsCheckBox;
	}

	/**
	 * This method initializes jNoMoreTransitionsCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJNoMoreTransitionsCheckBox() {
		if (jNoMoreTransitionsCheckBox == null) {
			jNoMoreTransitionsCheckBox = new JCheckBox();
			jNoMoreTransitionsCheckBox.setSelected(simulator.getStopIfTotalDeadlock());
			jNoMoreTransitionsCheckBox.setFont(new Font("Dialog", Font.PLAIN, 12));
			jNoMoreTransitionsCheckBox.setText("No more outgoing transitions");
		}
		return jNoMoreTransitionsCheckBox;
	}

	public void actionPerformed(ActionEvent e) {
		if ( e.getSource() == jOKButton ) {
			simulator.setStopIfPartialDeadlock( jDeadlockCheckBox.isSelected());
			simulator.setStopIfNoMoreEvents( jNoMoreEventsCheckBox.isSelected() );
			simulator.setStopIfTotalDeadlock( jNoMoreTransitionsCheckBox.isSelected() );
			if ( jDiscardRadioButton.isSelected() ) simulator.setEventQueueBehavior( EventsQueueBehavior.discard );
			if ( jReAddRadioButton.isSelected() ) simulator.setEventQueueBehavior( EventsQueueBehavior.reAdd ) ;
			if ( jSkipRadioButton.isSelected() ) simulator.setEventQueueBehavior( EventsQueueBehavior.skip );
			if ( jSequentialRadioButton.isSelected() ) simulator.setMultipleConcurrentBehavior( MultipleConcurrentBehavior.sequential );
			if ( jParallelRadioButton.isSelected() ) simulator.setMultipleConcurrentBehavior( MultipleConcurrentBehavior.parallel );
			setVisible( false );
		}
		
		if ( e.getSource() == jCancelButton ) {
			setVisible( false );
		}		
	}
	
	/**
	 * Show the options dialog.
	 * 
	 * @param owner - The parent window.
	 * @param simulator - The simulator object, where to set the options.
	 */
	public static void showOptionsDialog( Frame owner, Simulator simulator ) {
		if ( simulator == null ) {
			MiscDialogs.ErrorDialog( owner, "You must load a model first!" );			
			return;
		}
		
		System.out.println( "HALLO");
		
		SimulationOptionsDialog dialog = new SimulationOptionsDialog( owner, simulator );
		dialog.setModal( true );
		dialog.setVisible( true );
		return;
	}

	/**
	 * This method initializes jPanel7	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel7() {
		if (jPanel7 == null) {
			GridLayout gridLayout3 = new GridLayout();
			gridLayout3.setRows(1);
			gridLayout3.setColumns(2);
			jPanel7 = new JPanel();
			jPanel7.setLayout(gridLayout3);
			jPanel7.add(getJPanel6(), null);
			jPanel7.add(getJPanel8(), null);
		}
		return jPanel7;
	}

	/**
	 * This method initializes jPanel6	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel6() {
		if (jPanel6 == null) {
			jLabel1 = new JLabel();
			jLabel1.setText("Events queue behavior:");
			jLabel1.setFont(new Font("Dialog", Font.BOLD, 14));
			GridLayout gridLayout4 = new GridLayout();
			gridLayout4.setRows(4);
			gridLayout4.setColumns(1);
			jPanel6 = new JPanel();
			jPanel6.setLayout(gridLayout4);
			ButtonGroup group = new ButtonGroup();
			JRadioButton rb1 = getJDiscardRadioButton();
			rb1.setFont(new Font("Dialog", Font.PLAIN, 12));
			JRadioButton rb2 = getJReAddRadioButton();
			rb2.setFont(new Font("Dialog", Font.PLAIN, 12));
			JRadioButton rb3 = getJSkipRadioButton();
			rb3.setFont(new Font("Dialog", Font.PLAIN, 12));
			jPanel6.add(jLabel1, null);
			group.add( rb1 );
			group.add( rb2 );
			group.add( rb3 );			
			jPanel6.add(rb1, null);
			jPanel6.add(rb2, null);
			jPanel6.add(rb3, null);
		}
		return jPanel6;
	}

	/**
	 * This method initializes jPanel8	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel8() {
		if (jPanel8 == null) {
			jLabel2 = new JLabel();
			jLabel2.setText("Multiple concurrent behavior:");
			jLabel2.setFont(new Font("Dialog", Font.BOLD, 14));
			GridLayout gridLayout5 = new GridLayout();
			gridLayout5.setRows(3);
			gridLayout5.setColumns(1);
			jPanel8 = new JPanel();
			jPanel8.setLayout(gridLayout5);
			ButtonGroup group = new ButtonGroup();
			JRadioButton rb1 = getJSequentialRadioButton();
			rb1.setFont(new Font("Dialog", Font.PLAIN, 12));
			JRadioButton rb2 = getJParallelRadioButton();
			rb2.setFont(new Font("Dialog", Font.PLAIN, 12));
			jPanel8.add(jLabel2, null);
			group.add( rb1 );
			group.add( rb2 );
			jPanel8.add(rb1, null);
			jPanel8.add(rb2, null);
		}
		return jPanel8;
	}

	/**
	 * This method initializes jSequentialRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJSequentialRadioButton() {
		if (jSequentialRadioButton == null) {
			jSequentialRadioButton = new JRadioButton();
			jSequentialRadioButton.setText("sequential");
			jSequentialRadioButton.setSelected( simulator.getMultipleConcurrentBehavior() == MultipleConcurrentBehavior.sequential );
		}
		return jSequentialRadioButton;
	}

	/**
	 * This method initializes jParallelRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJParallelRadioButton() {
		if (jParallelRadioButton == null) {
			jParallelRadioButton = new JRadioButton();
			jParallelRadioButton.setText("parallel");
			jParallelRadioButton.setSelected( simulator.getMultipleConcurrentBehavior() == MultipleConcurrentBehavior.parallel );
		}
		return jParallelRadioButton;
	}

	/**
	 * This method initializes jDiscardRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJDiscardRadioButton() {
		if (jDiscardRadioButton == null) {
			jDiscardRadioButton = new JRadioButton();
			jDiscardRadioButton.setText("discard event");
			jDiscardRadioButton.setSelected( simulator.getEventQueueBehavior() == EventsQueueBehavior.discard );
		}
		return jDiscardRadioButton;
	}

	/**
	 * This method initializes jReAddRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJReAddRadioButton() {
		if (jReAddRadioButton == null) {
			jReAddRadioButton = new JRadioButton();
			jReAddRadioButton.setText("readd at end of queue");
			jReAddRadioButton.setSelected( simulator.getEventQueueBehavior() == EventsQueueBehavior.reAdd );
		}
		return jReAddRadioButton;
	}

	/**
	 * This method initializes jSkipRadioButton	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJSkipRadioButton() {
		if (jSkipRadioButton == null) {
			jSkipRadioButton = new JRadioButton();
			jSkipRadioButton.setText("skip event");
			jSkipRadioButton.setSelected( simulator.getEventQueueBehavior() == EventsQueueBehavior.skip );
		}
		return jSkipRadioButton;
	}

}    //  @jve:decl-index=0:visual-constraint="10,10"