package de.fau.cs.swe.da.gui;

import javax.swing.JPanel;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.Toolkit;

import javax.swing.JDialog;

import de.fau.cs.swe.da.gui.models.SetCallParametersTableModel;
import de.fau.cs.swe.da.modelsimulator.*;
import java.awt.Dimension;
import javax.swing.JButton;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.WindowConstants;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import org.eclipse.emf.common.util.EList;

/**
 * Dialog to set the parameters of an operation and an event.
 * 
 * @author Dominik Schindler
 *
 */

public class SetCallEventParameters extends JDialog implements ActionListener {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JPanel jButtonPanel = null;

	private JPanel jPanel = null;

	private JButton jOKButton = null;

	private JScrollPane jParameterScrollPane = null;

	private JTable jParametersTable = null;
	
	private Simulator simulator = null;
	private EList parameters = null;
	private MyEvent callEvent = null;

	/**
	 * Initializes the dialog.
	 * 
	 * @param owner - The parent window.
	 * @param parameters - The parameters to be shwon in the table.
	 * @param callEvent - The associated event.
	 * @param simulator - The simualtor object to set the variable values.
	 */
	public SetCallEventParameters(Frame owner, EList parameters, MyEvent callEvent, Simulator simulator) {
		super(owner);
		this.simulator = simulator;
		this.parameters = parameters;
		this.callEvent = callEvent;
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		this.setSize(400, 400);
		this.setTitle("Set call event parameters");
		this.setContentPane(getJContentPane());
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize()  ;
		this.setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJButtonPanel(), BorderLayout.SOUTH);
			jContentPane.add(getJPanel(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jButtonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJButtonPanel() {
		if (jButtonPanel == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			gridLayout.setColumns(1);
			jButtonPanel = new JPanel();
			jButtonPanel.setLayout(gridLayout);
			jButtonPanel.setPreferredSize(new Dimension(0, 24));
			jButtonPanel.add(getJOKButton(), null);
		}
		return jButtonPanel;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.gridx = 0;
			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
			jPanel.add(getJParameterScrollPane(), gridBagConstraints);
		}
		return jPanel;
	}

	/**
	 * This method initializes jOKButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJOKButton() {
		if (jOKButton == null) {
			jOKButton = new JButton();
			jOKButton.setText("OK");
			jOKButton.addActionListener( this );
		}
		return jOKButton;
	}

	/**
	 * This method initializes jParameterScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJParameterScrollPane() {
		if (jParameterScrollPane == null) {
			jParameterScrollPane = new JScrollPane();
			jParameterScrollPane.setViewportView(getJParametersTable());
		}
		return jParameterScrollPane;
	}

	/**
	 * This method initializes jParametersTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJParametersTable() {
		if (jParametersTable == null) {
			jParametersTable = new JTable( new SetCallParametersTableModel ( parameters, callEvent, simulator ) );
		}
		return jParametersTable;
	}
	
	/**
	 * Shows the dialog, where to set the parameters.
	 * 
	 * @param owner - The parent window.
	 * @param parameters - The list if parametres to be shown in the table.
	 * @param callEvent - The associated event.
	 * @param simulator - The simualtor object to set the variable values.
	 */
	public static void setCallEventParameters( Frame owner, EList parameters, MyEvent callEvent, Simulator simulator ) {
		SetCallEventParameters dialog = new SetCallEventParameters( owner, parameters, callEvent, simulator );
		dialog.setModal( true );
		dialog.setVisible( true );
		return;		
	}

	public void actionPerformed(ActionEvent e) {
		if ( e.getSource() == jOKButton ) {
			setVisible( false );
		}
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
