package de.fau.cs.swe.da.gui;

import javax.swing.JPanel;
import java.awt.Frame;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JButton;
import java.awt.GridBagConstraints;
import javax.swing.WindowConstants;
import org.eclipse.uml2.uml.StateMachine;

import de.fau.cs.swe.da.gui.models.SelectStateMachineListModel;

import javax.swing.JList;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

/**
 * The dialog, where the user can select a statemachine from the model.
 *   
 * 
 * @author Dominik Schindler
 *
 */

public class SelectStateMachineDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JPanel jButtonsPanel = null;

	private JButton jSelectButton = null;

	private JButton jCancelButton = null;

	private JPanel jPanel = null;

	private JPanel jStateMachinesPanel = null;

	private StateMachine stateMachine = null;  //  @jve:decl-index=0:

	private JList jStateMachinesList = null;

	private Hashtable<String, StateMachine> stateMachines = null;
	
	/**
	 * Initilizes the dialog.
	 * 
	 * @param owner - The parent window.
	 * @param stateMachines - A list of state machine to be shown.
	 */	
	public SelectStateMachineDialog( Frame owner, Hashtable<String, StateMachine> stateMachines ) {
		super(owner, true);
		this.stateMachines = stateMachines;
		initialize();
		Dimension d = owner.getSize();
		this.setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
	}

	/**
	 * Initializes the components.
	 *
	 */
	private void initialize() {
		this.setSize(600, 400);
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		this.setTitle("Select statemachine to simulate...");
		this.setContentPane(getJContentPane());
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJButtonsPanel(), BorderLayout.SOUTH);
			jContentPane.add(getJPanel(), BorderLayout.EAST);
			jContentPane.add(getJStateMachinesPanel(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jButtonsPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJButtonsPanel() {
		if (jButtonsPanel == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			gridLayout.setColumns(2);
			jButtonsPanel = new JPanel();
			jButtonsPanel.setLayout(gridLayout);
			jButtonsPanel.setPreferredSize(new Dimension(0, 24));
			jButtonsPanel.add(getJSelectButton(), null);
			jButtonsPanel.add(getJCancelButton(), null);
		}
		return jButtonsPanel;
	}

	/**
	 * This method initializes jSelectButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJSelectButton() {
		if (jSelectButton == null) {
			jSelectButton = new JButton();
			jSelectButton.setText("Simulate");
			jSelectButton.addActionListener( this );
		}
		return jSelectButton;
	}

	/**
	 * This method initializes jCancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJCancelButton() {
		if (jCancelButton == null) {
			jCancelButton = new JButton();
			jCancelButton.setText("Cancel");
			jCancelButton.addActionListener( this );
		}
		return jCancelButton;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
		}
		return jPanel;
	}

	/**
	 * This method initializes jStateMachinesPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJStateMachinesPanel() {
		if (jStateMachinesPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.gridx = 0;
			jStateMachinesPanel = new JPanel();
			jStateMachinesPanel.setLayout(new GridBagLayout());
			jStateMachinesPanel.add(getJStateMachinesList(), gridBagConstraints1);
		}
		return jStateMachinesPanel;
	}

	/**
	 * Returns the selected statemachine.
	 * 
	 * @return The selected statemachine.
	 */
	
	public StateMachine getSelectedStateMachine() {
		return stateMachine;
	}

	/**
	 * This method initializes jStateMachinesList	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getJStateMachinesList() {
		if (jStateMachinesList == null) {
			jStateMachinesList = new JList( new SelectStateMachineListModel( stateMachines ) );
		}
		return jStateMachinesList;
	}

	/**
	 * Event handler for dialog.
	 */
	public void actionPerformed(ActionEvent e) {
		if ( e.getSource() == jSelectButton ) {
			int selected = jStateMachinesList.getSelectedIndex();
			if ( selected > -1 ) {
				stateMachine = ( StateMachine ) jStateMachinesList.getModel().getElementAt( selected ); 
				setVisible( false );
			}
		}
		
		
		if ( e.getSource() == jCancelButton ) {
			stateMachine = null;
			setVisible ( false );
		}
	}
	
	/**
	 * Show the select state machine dialog.
	 * 
	 * @param owner - The parent window.
	 * @param statemachines - A list of state machines.
	 * @return The selected state machine.
	 */	
	public static StateMachine select( Frame owner, Hashtable<String, StateMachine> statemachines ) {
		SelectStateMachineDialog dialog = new SelectStateMachineDialog( owner, statemachines );
		dialog.setModal( true );
		dialog.setVisible( true );
		return dialog.getSelectedStateMachine();
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
