package de.fau.cs.swe.da.gui;

import java.awt.*;
import javax.swing.*;

import de.cnc.expression.exceptions.ExpressionEvaluationException;
import de.cnc.expression.exceptions.ExpressionParseException;
import de.fau.cs.swe.da.exceptions.NoValidStateMachineException;
import de.fau.cs.swe.da.gui.models.*;
import de.fau.cs.swe.da.modelsimulator.*;
import de.fau.cs.swe.da.modelsimulator.MyEvent.EventType;

import java.awt.event.*;
import java.io.*;
import org.eclipse.uml2.uml.*;
import org.eclipse.emf.common.util.*;

import javax.swing.tree.*;
import javax.swing.JMenuItem;

/**
 * Main application of the GUI.
 * 
 * @author Dominik Schindler
 *
 */

public class MainFrame extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JMenuBar jJMenuBar = null;

	private JToolBar jJToolBarBar = null;

	private JButton jSimulateButton = null;

	private JButton jDoStepButton = null;

	private JSplitPane jMiddleRightSplitPane = null;

	private JSplitPane jLeftMiddleSplitPane = null;

	private JPanel jLeftPanel = null;

	private JPanel jRightPanel = null;

	private JPanel jMiddlePanel = null;

	private JTabbedPane jOutputTabbedPane = null;

	private JPanel jOutputPanel = null;

	private JTabbedPane jActiveEventsTabbedPane = null;

	private JPanel jActiveEventsPanel = null;

	private JTabbedPane jAllEventsTabbedPane = null;

	private JPanel jAllEventsPanel = null;

	private JTabbedPane jVariablesTabbedPane = null;

	private JPanel jVariablesPanel = null;

	private JScrollPane jVariablesScrollPane = null;

	private JTable jVariablesTable = null;

	private JTabbedPane jActiveStatesTabbedPane = null;

	private JPanel jActiveStatesPanel = null;

	private JScrollPane jActiveEventsScrollPane = null;

	private JScrollPane jAllEventsScrollPane = null;

	private JTree jAllEventsTree = null;

	private JScrollPane jActiveStatesScrollPane = null;

	private JMenu jFileMenu = null;

	private JMenu jSimulationMenu = null;

	private JMenu jHelpMenu = null;

	private JMenuItem jLoadModelMenuItem = null;

	private Simulator simulator = null;

	private JScrollPane jOutputScrollPane = null;

	private JTextArea jOutputTextArea = null;

	private JMenuItem jExitMenuItem = null;
	
	// models for the lists and trees
	private DefaultTreeModel allEventsTreeModel = new DefaultTreeModel( null );
	private DefaultTreeModel activeStatesTreeModel = new DefaultTreeModel( null );  //  @jve:decl-index=0:
	private DefaultTreeModel activeEventsListModel = new DefaultTreeModel( null );
	private VariablesTableModel variableTableModel = new VariablesTableModel( null, null );
	private DefaultTreeModel visitedVerticesModel = new DefaultTreeModel( null );
	private DefaultTreeModel passedTransitionsModel = new DefaultTreeModel( null );  //  @jve:decl-index=0:

	private JMenuItem jDoStepMenuItem = null;

	private JMenuItem jSimulateOptionsMenuItem = null;

	private JTree jActiveEventsTree = null;

	private JMenuItem jRestartMenuItem = null;

	private JScrollPane jScrollPane = null;

	private JTabbedPane jVisitedVerticesTabbedPane = null;

	private JTabbedPane jPassedTransitionsTabbedPane = null;

	private JPanel jVisitedVerticesPanel = null;

	private JPanel jPassedTransitionsPanel = null;

	private JTree jActiveStatesTree = null;

	private JScrollPane jPassedTransitionsScrollPane1 = null;

	private JScrollPane jVisitedVerticesScrollPane = null;

	private JTree jVisitedVerticesTree = null;

	private JTree jPassedTransitionsTree = null;

	private JMenuItem jSimulateMenuItem = null;

	private JMenuItem jAboutMenuItem = null;

	/**
	 * This is the default constructor
	 */
	public MainFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		try {
			UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
		} catch( Exception e ) { }

		this.setSize(800, 600);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setJMenuBar(getJJMenuBar());
		this.setContentPane(getJContentPane());
		this.setTitle("UML2 Statemachine Simulator Version 1.0");
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize()  ;
		this.setLocation( (d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2 );
		// redirect stdout
		System.setOut( new PrintStream ( new TextAreaOutputStream ( jOutputTextArea ) ) );
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJJToolBarBar(), BorderLayout.NORTH);
			jContentPane.add(getJMiddleRightSplitPane(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.setPreferredSize(new Dimension(0, 20));
			jJMenuBar.add(getJFileMenu());
			jJMenuBar.add(getJSimulationMenu());
			jJMenuBar.add(getJHelpMenu());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jJToolBarBar	
	 * 	
	 * @return javax.swing.JToolBar	
	 */
	private JToolBar getJJToolBarBar() {
		if (jJToolBarBar == null) {
			jJToolBarBar = new JToolBar();
			jJToolBarBar.setPreferredSize(new Dimension(46, 24));
			jJToolBarBar.add(getJSimulateButton());
			jJToolBarBar.add(getJDoStepButton());
		}
		return jJToolBarBar;
	}

	/**
	 * This method initializes jSimulateButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJSimulateButton() {
		if (jSimulateButton == null) {
			jSimulateButton = new JButton();
			jSimulateButton.setPreferredSize(new Dimension(16, 16));
			jSimulateButton.setText("Simulate");
			jSimulateButton.addActionListener(this);
			jSimulateButton.setToolTipText("");
		}
		return jSimulateButton;
	}

	/**
	 * This method initializes jDoStepButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJDoStepButton() {
		if (jDoStepButton == null) {
			jDoStepButton = new JButton();
			jDoStepButton.setText("Do Step");
			jDoStepButton.addActionListener(this);
		}
		return jDoStepButton;
	}

	/**
	 * This method initializes jMiddleRightSplitPane	
	 * 	
	 * @return javax.swing.JSplitPane	
	 */
	private JSplitPane getJMiddleRightSplitPane() {
		if (jMiddleRightSplitPane == null) {
			jMiddleRightSplitPane = new JSplitPane();
			jMiddleRightSplitPane.setDividerLocation(600);
			jMiddleRightSplitPane.setRightComponent(getJRightPanel());
			jMiddleRightSplitPane.setLeftComponent(getJLeftMiddleSplitPane());
		}
		return jMiddleRightSplitPane;
	}

	/**
	 * This method initializes jLeftMiddleSplitPane	
	 * 	
	 * @return javax.swing.JSplitPane	
	 */
	private JSplitPane getJLeftMiddleSplitPane() {
		if (jLeftMiddleSplitPane == null) {
			jLeftMiddleSplitPane = new JSplitPane();
			jLeftMiddleSplitPane.setDividerLocation(200);
			jLeftMiddleSplitPane.setRightComponent(getJMiddlePanel());
			jLeftMiddleSplitPane.setLeftComponent(getJLeftPanel());
		}
		return jLeftMiddleSplitPane;
	}

	/**
	 * This method initializes jLeftPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJLeftPanel() {
		if (jLeftPanel == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(3);
			gridLayout.setColumns(1);
			jLeftPanel = new JPanel();
			jLeftPanel.setLayout(gridLayout);
			jLeftPanel.add(getJActiveEventsTabbedPane(), null);
			jLeftPanel.add(getJAllEventsTabbedPane(), null);
			jLeftPanel.add(getJVariablesTabbedPane(), null);
		}
		return jLeftPanel;
	}

	/**
	 * This method initializes jRightPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJRightPanel() {
		if (jRightPanel == null) {
			GridLayout gridLayout1 = new GridLayout();
			gridLayout1.setRows(3);
			gridLayout1.setColumns(1);
			gridLayout1.setHgap(0);
			jRightPanel = new JPanel();
			jRightPanel.setLayout(gridLayout1);
			jRightPanel.add(getJActiveStatesTabbedPane(), null);
			jRightPanel.add(getJScrollPane(), null);
			jRightPanel.add(getJPassedTransitionsTabbedPane(), null);
		}
		return jRightPanel;
	}

	/**
	 * This method initializes jMiddlePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJMiddlePanel() {
		if (jMiddlePanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.gridx = 0;
			jMiddlePanel = new JPanel();
			jMiddlePanel.setLayout(new GridBagLayout());
			jMiddlePanel.add(getJOutputTabbedPane(), gridBagConstraints1);
		}
		return jMiddlePanel;
	}

	/**
	 * This method initializes jOutputTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJOutputTabbedPane() {
		if (jOutputTabbedPane == null) {
			jOutputTabbedPane = new JTabbedPane();
			jOutputTabbedPane.addTab("Simulation log", null, getJOutputPanel(), null);
		}
		return jOutputTabbedPane;
	}

	/**
	 * This method initializes jOutputPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJOutputPanel() {
		if (jOutputPanel == null) {
			GridLayout gridLayout2 = new GridLayout();
			gridLayout2.setRows(1);
			jOutputPanel = new JPanel();
			jOutputPanel.setLayout(gridLayout2);
			jOutputPanel.add(getJOutputScrollPane(), null);
		}
		return jOutputPanel;
	}

	/**
	 * This method initializes jActiveEventsTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJActiveEventsTabbedPane() {
		if (jActiveEventsTabbedPane == null) {
			jActiveEventsTabbedPane = new JTabbedPane();
			jActiveEventsTabbedPane.addTab("Active events", null, getJActiveEventsPanel(), null);
		}
		return jActiveEventsTabbedPane;
	}

	/**
	 * This method initializes jActiveEventsPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJActiveEventsPanel() {
		if (jActiveEventsPanel == null) {
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.fill = GridBagConstraints.BOTH;
			gridBagConstraints11.gridy = 0;
			gridBagConstraints11.weightx = 1.0;
			gridBagConstraints11.weighty = 1.0;
			gridBagConstraints11.gridx = 0;
			jActiveEventsPanel = new JPanel();
			jActiveEventsPanel.setLayout(new GridBagLayout());
			jActiveEventsPanel.add(getJActiveEventsScrollPane(), gridBagConstraints11);
		}
		return jActiveEventsPanel;
	}

	/**
	 * This method initializes jAllEventsTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJAllEventsTabbedPane() {
		if (jAllEventsTabbedPane == null) {
			jAllEventsTabbedPane = new JTabbedPane();
			jAllEventsTabbedPane.addTab("Available events", null, getJAllEventsPanel(), null);
		}
		return jAllEventsTabbedPane;
	}

	/**
	 * This method initializes jAllEventsPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJAllEventsPanel() {
		if (jAllEventsPanel == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.gridx = 0;
			jAllEventsPanel = new JPanel();
			jAllEventsPanel.setLayout(new GridBagLayout());
			jAllEventsPanel.add(getJAllEventsScrollPane(), gridBagConstraints);
		}
		return jAllEventsPanel;
	}

	/**
	 * This method initializes jVariablesTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJVariablesTabbedPane() {
		if (jVariablesTabbedPane == null) {
			jVariablesTabbedPane = new JTabbedPane();
			jVariablesTabbedPane.addTab("Variables", null, getJVariablesPanel(), null);
		}
		return jVariablesTabbedPane;
	}

	/**
	 * This method initializes jVariablesPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJVariablesPanel() {
		if (jVariablesPanel == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.gridy = 0;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.weighty = 1.0;
			gridBagConstraints3.gridx = 0;
			jVariablesPanel = new JPanel();
			jVariablesPanel.setLayout(new GridBagLayout());
			jVariablesPanel.add(getJVariablesScrollPane(), gridBagConstraints3);
		}
		return jVariablesPanel;
	}

	/**
	 * This method initializes jVariablesScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJVariablesScrollPane() {
		if (jVariablesScrollPane == null) {
			jVariablesScrollPane = new JScrollPane();
			jVariablesScrollPane.setViewportView(getJVariablesTable());
		}
		return jVariablesScrollPane;
	}

	/**
	 * This method initializes jVariablesTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJVariablesTable() {
		if (jVariablesTable == null) {
			jVariablesTable = new JTable( variableTableModel );
		}
		return jVariablesTable;
	}

	/**
	 * This method initializes jActiveStatesTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJActiveStatesTabbedPane() {
		if (jActiveStatesTabbedPane == null) {
			jActiveStatesTabbedPane = new JTabbedPane();
			jActiveStatesTabbedPane.addTab( "Active states", null, getJActiveStatesPanel(), null);
		}
		return jActiveStatesTabbedPane;
	}

	/**
	 * This method initializes jActiveStatesPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJActiveStatesPanel() {
		if (jActiveStatesPanel == null) {
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.gridy = 0;
			gridBagConstraints5.weightx = 1.0;
			gridBagConstraints5.weighty = 1.0;
			gridBagConstraints5.gridx = 0;
			jActiveStatesPanel = new JPanel();
			jActiveStatesPanel.setLayout(new GridBagLayout());
			jActiveStatesPanel.add(getJActiveStatesScrollPane(), gridBagConstraints5);
		}
		return jActiveStatesPanel;
	}

	/**
	 * This method initializes jActiveEventsScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJActiveEventsScrollPane() {
		if (jActiveEventsScrollPane == null) {
			jActiveEventsScrollPane = new JScrollPane();
			jActiveEventsScrollPane.setViewportView(getJActiveEventsTree());
		}
		return jActiveEventsScrollPane;
	}

	/**
	 * This method initializes jAllEventsScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJAllEventsScrollPane() {
		if (jAllEventsScrollPane == null) {
			jAllEventsScrollPane = new JScrollPane();
			jAllEventsScrollPane.setViewportView(getJAllEventsTree());
		}
		return jAllEventsScrollPane;
	}

	/**
	 * This method initializes jAllEventsTree	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJAllEventsTree() {
		if (jAllEventsTree == null) {
			jAllEventsTree = new JTree( allEventsTreeModel );
			jAllEventsTree.setRootVisible(false);
			MouseListener ml = new MouseAdapter() {
			     @Override
			     public void mousePressed( MouseEvent e ) {
			    	 if ( e.getButton() == MouseEvent.BUTTON1 ) {
			    		 int selRow = jAllEventsTree.getRowForLocation(e.getX(), e.getY());
				         TreePath selPath = jAllEventsTree.getPathForLocation(e.getX(), e.getY());
				         if( selRow != -1 ) {
				        	 if( e.getClickCount() == 2 ) {
				                 DefaultMutableTreeNode sel = ( DefaultMutableTreeNode ) selPath.getLastPathComponent();
				                 if ( !(sel.getUserObject() instanceof MyEvent ) ) {
				                	 	return;
				                 }
				                 MyEvent myEvent = ( MyEvent ) sel.getUserObject();
				                 MyEvent myEventClone = new MyEvent( myEvent );

				                 if ( myEvent.getEventType() == EventType.callOperation ) { 	 
				                	 Operation operation = myEvent.getOperation();
				                	 
				    
				                	 if ( operation != null  && operation.getOwnedParameters() != null ) {
				                		 	EList parameters = operation.getOwnedParameters();
				                			if ( parameters.size() > 0 ) {
				                				SetCallEventParameters.setCallEventParameters( null, operation.getOwnedParameters(), myEventClone, simulator );
				                			}
				                	 }
				                 }
		                		 simulator.addEvent( myEventClone );
		                		 activeEventsListModel.setRoot ( new MyEventsTreeNode( simulator.getActiveEvents(), simulator, false ) );
				        	 }
				         }
			    	 }
			     }
			 };		
			 jAllEventsTree.addMouseListener( ml );
		}
		return jAllEventsTree;
	}

	/**
	 * This method initializes jActiveStatesScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJActiveStatesScrollPane() {
		if (jActiveStatesScrollPane == null) {
			jActiveStatesScrollPane = new JScrollPane();
			jActiveStatesScrollPane.setViewportView(getJActiveStatesTree());
		}
		return jActiveStatesScrollPane;
	}

	/**
	 * This method initializes jFileMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJFileMenu() {
		if (jFileMenu == null) {
			jFileMenu = new JMenu();
			jFileMenu.setText("File");
			jFileMenu.add(getJLoadModelMenuItem());
			jFileMenu.addSeparator();
			jFileMenu.add(getJExitMenuItem());
		}
		return jFileMenu;
	}

	/**
	 * This method initializes jSimulationMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJSimulationMenu() {
		if (jSimulationMenu == null) {
			jSimulationMenu = new JMenu();
			jSimulationMenu.setText("Simulation");
			jSimulationMenu.add(getJRestartMenuItem());
			jSimulationMenu.addSeparator();
			jSimulationMenu.add(getJDoStepMenuItem());
			jSimulationMenu.addSeparator();
			jSimulationMenu.add(getJSimulateMenuItem());
			jSimulationMenu.addSeparator();
			jSimulationMenu.add(getJSimulateOptionsMenuItem());
		}
		return jSimulationMenu;
	}

	/**
	 * This method initializes jHelpMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJHelpMenu() {
		if (jHelpMenu == null) {
			jHelpMenu = new JMenu();
			jHelpMenu.setText("Help");
			jHelpMenu.add(getJAboutMenuItem());
		}
		return jHelpMenu;
	}

	/**
	 * This method initializes jLoadModelMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJLoadModelMenuItem() {
		if (jLoadModelMenuItem == null) {
			jLoadModelMenuItem = new JMenuItem();
			jLoadModelMenuItem.setText("Load model ...");
			jLoadModelMenuItem.addActionListener( this );
		}
		return jLoadModelMenuItem;
	}

	public void actionPerformed(ActionEvent e) {
		if ( e.getSource() == jLoadModelMenuItem ) {
			File[] file = MiscDialogs.OpenDialog( this, "Load model", "uml2", "UML2 EMF XMI files (*.uml2)", null, false);
			if ( file != null ) {
				ModelLoader modelLoader = new ModelLoader( file[0] );
				StateMachine stateMachine = SelectStateMachineDialog.select( this, SimulateableStateMachine.getStateMachines( modelLoader.getModel() ) );
				SimulateableStateMachine simStateMachine = null;
				try {
					simStateMachine = SimulateableStateMachine.getSimulateableStateMachine( modelLoader.getModel(), stateMachine );
				} catch ( ExpressionEvaluationException eve ) {
					MiscDialogs.ErrorDialog( this, "Expression evaluation ecxeption!\n\n " + eve );
				} 
				simulator = new Simulator( simStateMachine  );
				// setup simulation
				try {
					simulator.setupSimulation();
				} catch ( NoValidStateMachineException ex ) {
					MiscDialogs.ErrorDialog( this, "Selected statemachines is not valid!" );
					return;
				} catch ( ExpressionParseException epe ) {
					MiscDialogs.ErrorDialog( this, "Expression parse ecxeption!\n\n " + epe );
				} catch ( ExpressionEvaluationException eve ) {
					MiscDialogs.ErrorDialog( this, "Expression evaluation ecxeption!\n\n " + eve );
				} 
				allEventsTreeModel.setRoot( new MyEventsTreeNode( simulator.getSimulateableStateMachine().getAvailableEvents(), simulator, true ) );
				updateTreesAndLists();
			}
		}
		
		if ( e.getSource() == jExitMenuItem ) {
			System.exit( 0 );
		}

		// do a step
		if ( e.getSource() == jDoStepButton || e.getSource() == jDoStepMenuItem ) {
			if ( simulator == null ) {
				MiscDialogs.ErrorDialog( this, "You must load a model first!" );			
				return;
			}
			try {
				simulator.doStep();
				updateTreesAndLists();
			} catch ( NoValidStateMachineException nvse ) {
				MiscDialogs.ErrorDialog( this, "Not a valid state machine!\n\n" + nvse );
			} catch ( ExpressionParseException epe ) {
				MiscDialogs.ErrorDialog( this, "Expression parse ecxeption!\n\n " + epe );
			} catch ( ExpressionEvaluationException eve ) {
				MiscDialogs.ErrorDialog( this, "Expression evaluation ecxeption!\n\n " + eve );
			} 
		}
		
		if ( e.getSource() == jRestartMenuItem ) {
			if ( simulator == null ) {
				MiscDialogs.ErrorDialog( this, "You must load a model first!" );			
				return;
			}
			try {
				simulator.setupSimulation();
			} catch ( NoValidStateMachineException ex ) {
				MiscDialogs.ErrorDialog( this, "Selected statemachines is not valid!" );
				return;			
			} catch ( ExpressionParseException epe ) {
				MiscDialogs.ErrorDialog( this, "Expression parse ecxeption!\n\n " + epe );
			} catch ( ExpressionEvaluationException eve ) {
				MiscDialogs.ErrorDialog( this, "Expression evaluation ecxeption!\n\n " + eve );
			} 
			updateTreesAndLists();
		}
		
		if ( e.getSource() == jSimulateButton || e.getSource() == jSimulateMenuItem ) {
			if ( simulator == null ) {
				MiscDialogs.ErrorDialog( this, "You must load a model first!" );			
				return;
			}
			Simulator.StopReason stopReason = Simulator.StopReason.None; 
			try  {
				stopReason = simulator.simulate();
				MiscDialogs.InfoDialog( this, "Simulation stopped.\n\nReason: " + Simulator.StopReasonToString( stopReason ) );
			} catch ( NoValidStateMachineException ex ) {
				MiscDialogs.ExceptionDialog( this, "Selected statemachines is not valid!", ex );
				updateTreesAndLists();
			} catch ( ExpressionParseException epe ) {
				MiscDialogs.ExceptionDialog( this, "Expression parse ecxeption!\n\n ",  epe );
				updateTreesAndLists();
			} catch ( ExpressionEvaluationException eve ) {
				MiscDialogs.ExceptionDialog( this, "Expression evaluation ecxeption!\n\n ", eve );
				updateTreesAndLists();
			} 
			updateTreesAndLists();
		}
		
		if ( e.getSource() == jSimulateOptionsMenuItem )  {
			SimulationOptionsDialog.showOptionsDialog( this, simulator );
		}
		
		if ( e.getSource() == jAboutMenuItem ) {
			MiscDialogs.InfoDialog( this, getTitle() + "\nfor the Eclipse Modeling Framework Version 2.1\n\n" +
					"Copyright  Dominik Schindler 2007\n\n" +
					"This program is free software; you can redistribute it\n" + 
					"and/or modify it under the terms of the GNU General Public\n" + 
					"License as published by the Free Software Foundation, \n" + 
					"version 2 of the License.\n\n" +
					"JRE Version: " + System.getProperty( "java.specification.version" ) + ", Vendor: " + System.getProperty( "java.specification.vendor" ));
		}
		
	}

	/**
	 * This method initializes jOutputScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJOutputScrollPane() {
		if (jOutputScrollPane == null) {
			jOutputScrollPane = new JScrollPane();
			jOutputScrollPane.setViewportView(getJOutputTextArea());
		}
		return jOutputScrollPane;
	}

	/**
	 * This method initializes jOutputTextArea	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getJOutputTextArea() {
		if (jOutputTextArea == null) {
			jOutputTextArea = new JTextArea();
			jOutputTextArea.setEditable(false);
		}
		return jOutputTextArea;
	}

	/**
	 * This method initializes jExitMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJExitMenuItem() {
		if (jExitMenuItem == null) {
			jExitMenuItem = new JMenuItem();
			jExitMenuItem.setText( "Exit" );
			jExitMenuItem.addActionListener( this );
		}
		return jExitMenuItem;
	}

	/**
	 * This method initializes jDoStepMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJDoStepMenuItem() {
		if (jDoStepMenuItem == null) {
			jDoStepMenuItem = new JMenuItem();
			jDoStepMenuItem.setText( "Do step" );
			jDoStepMenuItem.addActionListener( this );
		}
		return jDoStepMenuItem;
	}

	/**
	 * This method initializes jSimulateOptionsMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJSimulateOptionsMenuItem() {
		if (jSimulateOptionsMenuItem == null) {
			jSimulateOptionsMenuItem = new JMenuItem();
			jSimulateOptionsMenuItem.setText( "Options ..." );
			jSimulateOptionsMenuItem.addActionListener( this );
		}
		return jSimulateOptionsMenuItem;
	}

	/**
	 * This method initializes jActiveEventsTree	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJActiveEventsTree() {
		if (jActiveEventsTree == null) {
			jActiveEventsTree = new JTree( activeEventsListModel );
			jActiveEventsTree.setRootVisible( false );
			KeyListener kl = new KeyAdapter() {
				@Override
				public void keyPressed( KeyEvent e ) {
					if ( e.getKeyCode() == KeyEvent.VK_DELETE ) {
				         TreePath selPath = jActiveEventsTree.getSelectionPath();
				         if( selPath.getLastPathComponent() != null  ) {
			                 DefaultMutableTreeNode sel = ( DefaultMutableTreeNode ) selPath.getLastPathComponent();
			                 MyEvent myEvent = ( MyEvent ) sel.getUserObject(); 
		                	 simulator.removeActiveEvent( myEvent );
			 				 activeEventsListModel.setRoot ( new MyEventsTreeNode( simulator.getActiveEvents(), simulator, false ) );
				         }
					}
				}
			};
			jActiveEventsTree.addKeyListener( kl );
		}
		return jActiveEventsTree;
	}

	/**
	 * This method initializes jRestartMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJRestartMenuItem() {
		if (jRestartMenuItem == null) {
			jRestartMenuItem = new JMenuItem();
			jRestartMenuItem.setText("Restart");
			jRestartMenuItem.addActionListener( this );
		}
		return jRestartMenuItem;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJVisitedVerticesTabbedPane());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jVisitedVerticesTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJVisitedVerticesTabbedPane() {
		if (jVisitedVerticesTabbedPane == null) {
			jVisitedVerticesTabbedPane = new JTabbedPane();
			jVisitedVerticesTabbedPane.addTab("Visited vertices", null, getJVisitedVerticesPanel(), null);
		}
		return jVisitedVerticesTabbedPane;
	}

	/**
	 * This method initializes jPassedTransitionsTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJPassedTransitionsTabbedPane() {
		if (jPassedTransitionsTabbedPane == null) {
			jPassedTransitionsTabbedPane = new JTabbedPane();
			jPassedTransitionsTabbedPane.addTab("Passed transitions", null, getJPassedTransitionsPanel(), null);
		}
		return jPassedTransitionsTabbedPane;
	}

	/**
	 * This method initializes jVisitedVerticesPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJVisitedVerticesPanel() {
		if (jVisitedVerticesPanel == null) {
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.gridy = 0;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.weighty = 1.0;
			gridBagConstraints2.gridx = 0;
			jVisitedVerticesPanel = new JPanel();
			jVisitedVerticesPanel.setLayout(new GridBagLayout());
			jVisitedVerticesPanel.setPreferredSize(new Dimension(0, 0));
			jVisitedVerticesPanel.add(getJVisitedVerticesScrollPane(), gridBagConstraints2);
		}
		return jVisitedVerticesPanel;
	}

	/**
	 * This method initializes jPassedTransitionsPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPassedTransitionsPanel() {
		if (jPassedTransitionsPanel == null) {
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.gridy = 0;
			gridBagConstraints4.weightx = 1.0;
			gridBagConstraints4.weighty = 1.0;
			gridBagConstraints4.gridx = 0;
			jPassedTransitionsPanel = new JPanel();
			jPassedTransitionsPanel.setLayout(new GridBagLayout());
			jPassedTransitionsPanel.add(getJPassedTransitionsScrollPane1(), gridBagConstraints4);
		}
		return jPassedTransitionsPanel;
	}

	private void updateTreesAndLists() {
		activeEventsListModel.setRoot( new MyEventsTreeNode ( simulator.getActiveEvents(), simulator, false ) );
		activeStatesTreeModel.setRoot( new VerticesTreeNode( simulator.getActiveStates() ) );
		jVariablesTable.setModel( new VariablesTableModel( simulator.getVariableValues(), simulator.getVariableTypes() ) );
		visitedVerticesModel.setRoot( new VerticesTreeNode ( simulator.getVisitedVertices()));
		passedTransitionsModel.setRoot ( new TransitionsTreeNode ( simulator.getPassedTransitions() ) );
		jVariablesTable.repaint();
	}

	/**
	 * This method initializes jActiveStatesTree	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJActiveStatesTree() {
		if (jActiveStatesTree == null) {
			jActiveStatesTree = new JTree( activeStatesTreeModel );
			jActiveStatesTree.setRootVisible(false);
		}
		return jActiveStatesTree;
	}

	/**
	 * This method initializes jPassedTransitionsScrollPane1	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJPassedTransitionsScrollPane1() {
		if (jPassedTransitionsScrollPane1 == null) {
			jPassedTransitionsScrollPane1 = new JScrollPane();
			jPassedTransitionsScrollPane1.setViewportView(getJPassedTransitionsTree());
		}
		return jPassedTransitionsScrollPane1;
	}

	/**
	 * This method initializes jVisitedVerticesScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJVisitedVerticesScrollPane() {
		if (jVisitedVerticesScrollPane == null) {
			jVisitedVerticesScrollPane = new JScrollPane(  );
			jVisitedVerticesScrollPane.setPreferredSize(new Dimension(3, 100));
			jVisitedVerticesScrollPane.setViewportView(getJVisitedVerticesTree());
		}
		return jVisitedVerticesScrollPane;
	}

	/**
	 * This method initializes jVisitedVerticesTree	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJVisitedVerticesTree() {
		if (jVisitedVerticesTree == null) {
			jVisitedVerticesTree = new JTree( visitedVerticesModel );
			jVisitedVerticesTree.setRootVisible( false );
		}
		return jVisitedVerticesTree;
	}

	/**
	 * This method initializes jPassedTransitionsTree	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getJPassedTransitionsTree() {
		if (jPassedTransitionsTree == null) {
			jPassedTransitionsTree = new JTree( passedTransitionsModel );
			jPassedTransitionsTree.setRootVisible( false );
		}
		return jPassedTransitionsTree;
	}

	/**
	 * This method initializes jSimulateMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJSimulateMenuItem() {
		if (jSimulateMenuItem == null) {
			jSimulateMenuItem = new JMenuItem("Simulate");
			jSimulateMenuItem.addActionListener( this );
		}
		return jSimulateMenuItem;
	}

	/**
	 * This method initializes jAboutMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJAboutMenuItem() {
		if (jAboutMenuItem == null) {
			jAboutMenuItem = new JMenuItem();
			jAboutMenuItem.setText( "About ..." );
			jAboutMenuItem.addActionListener( this );
		}
		return jAboutMenuItem;
	}

	/**
	 * Main program entry method.
	 * 
	 * @param args - The arguments from the command line.
	 */
	public static void main ( String[] args ) {
		JFrame frame = new MainFrame();
		frame.setVisible( true );
	}

	
}  //  @jve:decl-index=0:visual-constraint="15,64"
