unit unitMain;
{ NETIO Control Panel 1.0 }

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP, CoolTrayIcon, AppEvnts, ComCtrls, ExtCtrls, ShellApi,
  Menus;

const
  MSG_IconCallback = WM_APP + 100;

type
  TFormMain = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    txtHost: TEdit;
    Label1: TLabel;
    btnLogin: TButton;
    idHTTP: TIdHTTP;
    GroupBox3: TGroupBox;
    btnLogoff: TButton;
    memoMessages: TMemo;
    statusBar: TStatusBar;
    GroupBox4: TGroupBox;
    btnPort1On: TButton;
    btnPort1Off: TButton;
    GroupBox5: TGroupBox;
    btnPort2On: TButton;
    btnPort2Off: TButton;
    GroupBox6: TGroupBox;
    btnPort3Off: TButton;
    btnPort3On: TButton;
    GroupBox7: TGroupBox;
    btnPort4On: TButton;
    btnPort4Off: TButton;
    timer: TTimer;
    Label2: TLabel;
    Label3: TLabel;
    editUsername: TEdit;
    editPassword: TEdit;
    popupMenuOptions: TPopupMenu;
    miPort1: TMenuItem;
    miPort2: TMenuItem;
    miPort3: TMenuItem;
    miPort4: TMenuItem;
    N1: TMenuItem;
    miExit: TMenuItem;
    miShow: TMenuItem;
    procedure btnLoginClick(Sender: TObject);
    procedure btnLogoffClick(Sender: TObject);
    procedure timerTimer(Sender: TObject);
    procedure btnPortXClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure miExitClick(Sender: TObject);
    procedure miShowClick(Sender: TObject);
  private
    controlUrl: String;
    connected: Boolean;
    connectionTime: Word;
    function send(command: String): String;
    procedure getPorts();
    procedure WMIconCallback(var Msg: TMessage); message MSG_IconCallback;
    procedure WMSysCommand(var Message: TWMSysCommand); message WM_SysCommand;
    procedure ShowIcon (I: TIcon; Id: Integer; Hint: String);
    procedure HideIcon (Id: Integer);
  public
    { Public-Deklarationen }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.dfm}

procedure TFormMain.btnLoginClick(Sender: TObject);
var
  return: String;
  command: String;
begin
  controlUrl := 'http://' + txtHost.text + '/tgi/control.tgi?';

  command := 'login=p:' + editUsername.Text + ':' + editPassword.Text;

  try
    return := send(command);

    // check answer
    if ( Pos( '554 ALREADY LOGGED IN', return ) > 0 ) or
       ( Pos( '100 HELLO', return ) > 0 ) then begin

      btnLogin.Enabled  := false;
      btnLogoff.Enabled := true;
      connected         := true;

      // enable all menu items
      miPort1.Enabled := true;
      miPort2.Enabled := true;
      miPort3.Enabled := true;
      miPort4.Enabled := true;

      // initialize timer
      timer.OnTimer(nil);
      timer.Enabled := true;

      // get the state of the ports
      getPorts;
    end;
  finally
  end;

end;

function TFormMain.send(command: String): String;
var
  memoryStream: TMemoryStream;
  commandUrl: String;
begin
  commandUrl   := controlUrl + command;
  memoryStream := TMemoryStream.Create;

  try
    if not Assigned(idHTTP) then idHttp := TIdHTTP.Create(nil);
    try
      idHttp.Get(commandUrl, memoryStream);

      // convert result stream to string
      SetLength(result, memoryStream.Size);
      memoryStream.Position := 0;
      memoryStream.ReadBuffer(result[1], memoryStream.Size);

      // replace all returned HTML tags
      result := StringReplace(result, '<html>', '', [rfReplaceAll, rfIgnoreCase]);
      result := StringReplace(result, '</html>', '', [rfReplaceAll, rfIgnoreCase]);

      // add line to messages list box
      memoMessages.Lines.Add(Trim(result));
    finally                                              
    end;
  finally
    memoryStream.Free;
  end;
end;

procedure TFormMain.btnLogoffClick(Sender: TObject);
var
  result: String;
begin
  result := send('quit=quit');

  if Pos('110 BYE', result) > 0 then begin
    // enable login, disable logoff button, set connected
    // to false and refresh status bar text
    btnLogin.Enabled     := true;
    btnLogoff.Enabled    := false;
    connected            := false;
    timer.Enabled        := false;
    statusBar.SimpleText := 'Disconnected';

    // disable all port buttons
    btnPort1On.Enabled   := false;
    btnPort1Off.Enabled  := false;
    btnPort2On.Enabled   := false;
    btnPort1Off.Enabled  := false;
    btnPort3On.Enabled   := false;
    btnPort1Off.Enabled  := false;
    btnPort4On.Enabled   := false;
    btnPort1Off.Enabled  := false;

    // disable all menu items
    miPort1.Enabled := false;
    miPort2.Enabled := false;
    miPort3.Enabled := false;
    miPort4.Enabled := false;
  end;
end;

procedure TFormMain.getPorts();
var
  return: String;
begin
    if not Assigned(idHTTP) then Exit;

    return := send('port=list');

    // port 1
    if return[1] = '1' then begin
      btnPort1On.Enabled  := false;
      btnPort1Off.Enabled := true;
      miPort1.Checked     := true;
    end else begin
      btnPort1On.Enabled  := true;
      btnPort1Off.Enabled := false;
      miPort1.Checked     := false;
    end;

    // port 2
    if return[3] = '1' then begin
      btnPort2On.Enabled  := false;
      btnPort2Off.Enabled := true;
      miPort2.Checked     := true;
    end else begin
      btnPort2On.Enabled  := true;
      btnPort2Off.Enabled := false;
      miPort2.Checked     := false;
    end;

    // port 3
    if return[5] = '1' then begin
      btnPort3On.Enabled  := false;
      btnPort3Off.Enabled := true;
      miPort3.Checked     := true;
    end else begin
      btnPort3On.Enabled  := true;
      btnPort3Off.Enabled := false;
      miPort3.Checked     := false;
    end;

    // port 4
    if return[7] = '1' then begin
      btnPort4On.Enabled  := false;
      btnPort4Off.Enabled := true;
      miPort4.Checked     := true;
    end else begin
      btnPort4On.Enabled  := true;
      btnPort4Off.Enabled := false;
      miPort4.Checked     := false;
    end;
end;

procedure TFormMain.timerTimer(Sender: TObject);
begin
  if not Assigned(sender) then
    connectionTime := 0
  else
    connectionTime := connectionTime + 1;

  statusBar.SimpleText := 'Connected to ' + txtHost.Text + ' since ' +
                          IntToStr(connectionTime) + ' seconds ';
end;

procedure TFormMain.btnPortXClick(Sender: TObject);
var
  command: String;
  return: String;
  ports: String;
begin

  if Sender = btnPort1On then begin
    ports := '1uuu'
  end else if Sender = btnPort2On then begin
    ports := 'u1uu'
  end else if Sender = btnPort3On then begin
    ports := 'uu1u'
  end else if Sender = btnPort4On then begin
    ports := 'uuu1'
  end else if Sender = btnPort1Off then begin
    ports := '0uuu'
  end else if Sender = btnPort2Off then begin
    ports := 'u0uu'
  end else if Sender = btnPort3Off then begin
    ports := 'uu0u'
  end else if Sender = btnPort4Off then begin
    ports := 'uuu0'
  end else if Sender = miPort1 then begin
    miPort1.Checked := not miPort1.Checked;
    if miPort1.Checked then
      ports := '1uuu'
    else
      ports := '0uuu'
  end else if Sender = miPort2 then begin
    miPort2.Checked := not miPort2.Checked;
    if miPort2.Checked then
      ports := 'u1uu'
    else
      ports := 'u0uu'
  end else if Sender = miPort3 then begin
    miPort3.Checked := not miPort3.Checked;
    if miPort3.Checked then
      ports := 'uu1u'
    else
      ports := 'uu0u'
  end else if Sender = miPort4 then begin
    miPort4.Checked := not miPort4.Checked;
    if miPort4.Checked then
      ports := 'uuu1'
    else
      ports := 'uuu0'
  end;

  command := 'port=' + ports;

  // execute command
  return  := send(command);

  // refresh ports
  getPorts;
end;

procedure TFormMain.WMIconCallback(var Msg: TMessage);
var Point: TPoint;
begin
 case Msg.LParam of
    WM_LBUTTONDBLCLK:
      begin

      end;
    WM_LBUTTONUP:
      begin

      end;
    WM_RBUTTONUP:
      begin
        SetForegroundWindow(Handle);
        GetCursorPos(Point);
        popupMenuOptions.Popup(Point.x, Point.y);
      end;
 end;
end;

procedure TFormMain.WMSysCommand(var Message: TWMSysCommand);
begin
  if Message.CmdType and $FFF0 = SC_MINIMIZE then
    Hide
  else
    inherited;
end;

procedure TFormMain.ShowIcon(I: TIcon; Id: Integer; Hint: String);
var d: TNotifyIconData;
begin
  d.cbSize := SizeOf(d);
  d.Wnd := Handle;
  d.uID := Id;
  d.uCallbackMessage := MSG_IconCallback;
  d.hIcon := I.Handle;
  strcopy (d.szTip, PChar(Hint));
  d.uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
  Shell_NotifyIcon(NIM_ADD, @d);
end;

procedure TFormMain.HideIcon(Id: Integer);
var d: TNotifyIconData;
begin
  d.cbSize := SizeOf(d);
  d.Wnd := Handle;
  d.uID := Id;
  Shell_NotifyIcon(NIM_DELETE, @d);
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  ShowIcon (Application.Icon, 0, Application.Title);
  Caption := Application.Title;
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // log off if connected
  if connected then btnLogoff.Click;

  // hide icon
  HideIcon (0);  

  // free HTTP component
  if Assigned(idHTTP) then idHTTP.Free;
end;

procedure TFormMain.miExitClick(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.miShowClick(Sender: TObject);
begin
  Visible := not Visible;
  BringToFront;
  SetFocus;
end;

end.
