unit DelphiXUtils;

interface

uses DXDraws;

procedure PictureCollectionMoveItem(APC: TPictureCollection; AFrom, ATo: Integer);

implementation

{ ====================================================
  Code from Uwe Schnnewolfs DelphiX Image Library 1.x
  Thanks.
  ==================================================== }

procedure PictureCollectionMoveItem(APC: TPictureCollection; AFrom, ATo: Integer);
var
 PCI: TPictureCollectionItem;

 procedure ToFrom(ToPCI, FromPCI: TPictureCollectionItem);
 begin
  ToPCI.Assign(FromPCI);
  ToPCI.Picture.Assign(FromPCI.Picture);
  ToPCI.Name := FromPCI.Name;
  ToPCI.PatternWidth := FromPCI.PatternWidth;
  ToPCI.PatternHeight := FromPCI.PatternHeight;
  ToPCI.SkipWidth := FromPCI.SkipWidth;
  ToPCI.SkipHeight := FromPCI.SkipHeight;
  ToPCI.SystemMemory := FromPCI.SystemMemory;
  ToPCI.Transparent := FromPCI.Transparent;
  ToPCI.TransparentColor := FromPCI.TransparentColor;
 end;

begin
 if Assigned(APC) and (AFrom >= 0) and (AFrom < APC.Count) and (ATo >= 0) and (ATo < APC.Count) and (AFrom <> ATo) then
 begin
  PCI := TPictureCollectionItem(APC.Add);
  try
   ToFrom(PCI, APC.Items[ATo]);
   ToFrom(APC.Items[ATo], APC.Items[AFrom]);
   ToFrom(APC.Items[AFrom], PCI);
  finally
   PCI.Destroy;
  end;
 end;
end;
end.
 