unit UnitTileSetup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, DXDraws,
  { Selfmade }
  UnitSprites, Grids, ExtCtrls, Spin, GraphicUtils, ComCtrls;

type
  TFormTileSetup = class(TForm)
    BitBtnClose: TBitBtn;
    DrawGridMap: TDrawGrid;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    BitBtnUpdate: TBitBtn;
    BitBtn1: TBitBtn;
    procedure BitBtnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure BitBtnUpdateClick(Sender: TObject);
    procedure ComboBoxImagesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ComboBoxImagesChange(Sender: TObject);
    procedure SpinEditChange(Sender: TObject);
    procedure ListBoxPatsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure DrawGridMapMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DrawGridMapDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    FMapSprite: TMapSprite;
    FDXImageList: TDXImageList;
    procedure UpdateComboBox;
  public
    property MapSprite: TMapSprite read FMapSprite write FMapSprite;
    property DXImageList: TDXImageList read FDXImageList write FDXImageList;
    procedure SetChip(x, y, tox, toy, Index: Integer);
  end;

var
  FormTileSetup: TFormTileSetup;

implementation

uses UnitMain;

{$R *.dfm}

procedure TFormTileSetup.BitBtnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFormTileSetup.DrawGridMapDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var i: Integer;
    Pic: TPicture;
    NewRect: TRect;
    Index: Integer;
begin
   {Pic := TPicture.Create;
  i := ComboBoxImages.ItemIndex;
  if not Assigned(DXImageList.Items[i]) then Exit;
  Pic.Bitmap.Width := DXImageList.Items[i].Picture.Width;
  Pic.Bitmap.Height := DXImageList.Items[i].Picture.Height;
  with Pic.Bitmap.Canvas do begin
    Draw(0,0, DXImageList.Items[i].Picture.Graphic);
  end; }
  Index := MapSprite.Chips[ACol, ARow];
  SetChip(ACol, ARow, 1, 1, Index);
 {  with (Sender as TDrawGrid).Canvas do begin
    FillRect(Rect);
    if Index > -1 then CopyRect(Rect, Pic.Bitmap.Canvas, DXImageList.Items[i].PatternRects[Index]) else
      TextOut(Rect.Left, Rect.Top, 'empty');
  end;
  Pic.Free; }
end;

procedure TFormTileSetup.SetChip(x, y, tox, toy, Index: Integer);
var i: Integer;
    Pic: TPicture;
    NewRect: TRect;
begin
  NewRect := DrawGridMap.CellRect(x, y);
  MapSprite.Chips[x, y] := Index;

  Pic := TPicture.Create;
  i := ComboBoxImages.ItemIndex;
  if not Assigned(DXImageList.Items[i]) then Exit;
  Pic.Bitmap.Width := DXImageList.Items[i].Picture.Width;
  Pic.Bitmap.Height := DXImageList.Items[i].Picture.Height;
  with Pic.Bitmap.Canvas do begin
    Draw(0,0, DXImageList.Items[i].Picture.Graphic);
  end;
  with DrawGridMap.Canvas do begin
    FillRect(NewRect);
    CopyRect(NewRect, Pic.Bitmap.Canvas, DXImageList.Items[i].PatternRects[Index]);
  end;
  Pic.Free;
end;

procedure TFormTileSetup.FormCreate(Sender: TObject);
begin
  DoubleBuffered := true;
end;

end.
