unit DXCursor;

interface

uses DXDraws, DXSprite, Classes;

type
  TCursorSprite = class(TImageSprite)
    private
      FHitEvent, FNormalEvent: TNotifyEvent;
      FDXImageList: TDXImageList;
      FHit, FNormal, FName: String;
      Fx, Fy: Integer;
      FSprite: TSprite;
    public
      procedure SetHit (s: String);
      procedure SetNormal (s: String);
      property Name: String read FName write FName;
      property DXImageList: TDXImageList read FDXImagelist write FDXImageList;
      property HitEvent: TNotifyEvent read FHitEvent write FHitEvent;
      property NormalEvent: TNotifyEvent read FNormalEvent write FNormalEvent;
      procedure SetPos (sx, sy: Integer);
      procedure Hit;
      procedure Normal;
      procedure DoCollision(Sprite: TSprite; var Done: Boolean); override;
      procedure Reset (Engine: TSpriteEngine);
      property GetCollisionedSprite: TSprite read FSprite;
    end;

implementation

{ ========== TDXCursorSprite ========== }

procedure TCursorSprite.DoCollision(Sprite: TSprite; var Done: Boolean);
begin
  inherited;
  if (Sprite is TTextSprite) then
    begin
        if (x > Sprite.x) and (x < Sprite.X + Sprite.Width) and
        (y > Sprite.y) and (y < Sprite.Y + Sprite.Height) then
           begin
              TTextSprite(Sprite).Hit;
              if FHit <> '' then Hit;
              FSprite := Sprite;
           end;
    end
  else
    begin
      FSprite := nil;
    end;
end;

procedure TCursorSprite.Hit;
begin
  Image := DXImageList.Items.Find(FHit);
  Width := Image.Width;
  Height := Image.Height;
  if Assigned(FHitEvent) then FHitEvent(self);
end;

procedure TCursorSprite.Normal;
begin
  Image := DXImageList.Items.Find(FNormal);
  Width := Image.Width;
  Height := Image.Height;
  if Assigned(FNormalEvent) then FNormalEvent(self);
end;

procedure TCursorSprite.Reset(Engine: TSpriteEngine);
var i: integer;
    s: TSprite;
begin
  if FNormal <> '' then Normal;
  for i := 0 to Engine.AllCount - 1 do begin
    s := Engine.Items[i];
      if (s is TTextSprite) then TTextSprite(s).Normal;
  end;
  FSprite := nil;
end;

procedure TCursorSprite.SetHit(s: String);
begin
  FHit := s;
end;

procedure TCursorSprite.SetNormal(s: String);
begin
  FNormal := s;
  Image := DXImageList.Items.Find(FNormal);
  Width := Image.Width;
  Height := Image.Height;
end;

procedure TCursorSprite.SetPos(sx, sy: Integer);
begin
  x := sx;
  y := sy;
end;

end.
